/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.event;

import com.bbn.openmap.OMComponent;
import com.bbn.openmap.event.OMEvent;
import com.bbn.openmap.event.OMEventHandler;
import com.bbn.openmap.event.OMEventMacroFilter;
import java.util.Collection;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class OMEventHandlerAdapter
extends OMComponent
implements OMEventHandler {
    protected LinkedList<OMEvent> events = new LinkedList();
    protected List filterList = new LinkedList();
    protected List macroFilters = new LinkedList();
    protected Hashtable filterStates = new Hashtable();
    public static final String ShowEventsAtStartupProperty = "showEvents";

    public void addEvent(OMEvent me) {
        this.events.add(me);
    }

    public void removeEvent(OMEvent me) {
        this.events.remove(me);
    }

    public void clearEvents() {
        this.events.clear();
    }

    @Override
    public List<OMEvent> getEventList() {
        return this.getEventList(null);
    }

    @Override
    public List<OMEvent> getEventList(List filters) {
        return this.events;
    }

    public void addMacroFilter(OMEventMacroFilter mf) {
        this.macroFilters.add(mf);
    }

    public void removeMacroFilter(OMEventMacroFilter mf) {
        this.macroFilters.remove(mf);
    }

    public void clearMacroFilters() {
        this.macroFilters.clear();
    }

    @Override
    public List<OMEvent> getMacroFilteredList(Collection eventCollection) {
        List<OMEvent> ret = new LinkedList<OMEvent>();
        ret.addAll(eventCollection);
        if (this.macroFilters != null) {
            for (OMEventMacroFilter mf : this.macroFilters) {
                ret = mf.getMacroFilteredList(ret);
            }
        }
        return ret;
    }

    @Override
    public void findAndInit(Object someObj) {
        if (someObj instanceof OMEventMacroFilter) {
            this.addMacroFilter((OMEventMacroFilter)someObj);
        }
    }

    @Override
    public void findAndUndo(Object someObj) {
        if (someObj instanceof OMEventMacroFilter) {
            this.removeMacroFilter((OMEventMacroFilter)someObj);
        }
    }

    @Override
    public List getFilters() {
        return this.filterList;
    }

    @Override
    public Boolean getFilterState(String filterName) {
        return (Boolean)this.filterStates.get(filterName);
    }

    @Override
    public void setFilterState(String filterName, Boolean state) {
        if (this.filterStates.get(filterName) != null) {
            this.filterStates.put(filterName, state);
        }
    }
}

