/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.event;

import com.bbn.openmap.MapBean;
import com.bbn.openmap.dataAccess.shape.EsriGraphicList;
import com.bbn.openmap.event.PaintListener;
import com.bbn.openmap.omGraphics.DrawingAttributes;
import com.bbn.openmap.omGraphics.OMGraphicList;
import com.bbn.openmap.omGraphics.OMLine;
import com.bbn.openmap.proj.Proj;
import com.bbn.openmap.proj.Projection;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.net.URL;

public abstract class AzimuthPanner
implements PaintListener {
    OMGraphicList omGraphics;
    int oX;
    int oY;
    MapBean mapBean;
    DrawingAttributes azDrawing;

    private AzimuthPanner(MapBean mb, int oX, int oY, DrawingAttributes azDrawing) {
        this.oX = oX;
        this.oY = oY;
        this.mapBean = mb;
        this.azDrawing = azDrawing;
    }

    public abstract void handlePan(MouseEvent var1);

    public abstract void handleUnpan(MouseEvent var1);

    public DrawingAttributes getAzDrawing() {
        return this.azDrawing;
    }

    public void setAzDrawing(DrawingAttributes azDrawing) {
        this.azDrawing = azDrawing;
    }

    public void listenerPaint(Graphics graphics) {
        if (this.omGraphics != null) {
            this.omGraphics.render(graphics);
        }
    }

    public static class Shapefile
    extends Standard {
        EsriGraphicList list = null;

        public Shapefile(MapBean mb, int oX, int oY, DrawingAttributes azDrawing, URL shapefile) {
            super(mb, oX, oY, azDrawing);
            this.list = EsriGraphicList.getEsriGraphicList(shapefile, this.getAzDrawing(), null);
        }

        public void handlePan(MouseEvent me) {
            Projection proj = this.mapBean.getProjection();
            Object center = proj.getCenter();
            Point2D centerXY = proj.forward((Point2D)center);
            Point2D pnt = this.mapBean.getNonRotatedLocation(me);
            int x = (int)centerXY.getX() - (int)pnt.getX() + this.oX;
            int y = (int)centerXY.getY() - (int)pnt.getY() + this.oY;
            Object llp = proj.inverse(x, y);
            Proj newProj = (Proj)proj.makeClone();
            newProj.setCenter((Point2D)llp);
            if (llp != null && !((Point2D)llp).equals(center) && this.list != null) {
                this.omGraphics = this.list;
                this.list.generate(newProj);
                this.mapBean.addPaintListener(this);
                this.mapBean.repaint();
            }
        }
    }

    public static class Standard
    extends AzimuthPanner {
        public Standard(MapBean mb, int oX, int oY, DrawingAttributes azDrawing) {
            super(mb, oX, oY, azDrawing);
        }

        public void handlePan(MouseEvent me) {
            int y;
            Projection proj = this.mapBean.getProjection();
            Object center = proj.getCenter();
            Point2D centerXY = proj.forward((Point2D)center);
            Point2D pnt = this.mapBean.getNonRotatedLocation(me);
            int x = (int)centerXY.getX() - (int)pnt.getX() + this.oX;
            Object llp = proj.inverse(x, y = (int)centerXY.getY() - (int)pnt.getY() + this.oY);
            if (llp != null && !((Point2D)llp).equals(center)) {
                OMLine line3;
                OMGraphicList list = new OMGraphicList();
                OMLine line1 = new OMLine(90.0, ((Point2D)llp).getX(), ((Point2D)llp).getY(), ((Point2D)llp).getX(), 3);
                OMLine line2 = new OMLine(((Point2D)llp).getY(), ((Point2D)llp).getX(), -90.0, ((Point2D)llp).getX(), 3);
                list.add(line1);
                list.add(line2);
                if (((Point2D)llp).getX() < 0.0) {
                    line3 = new OMLine(((Point2D)llp).getY(), -180.0, ((Point2D)llp).getY(), ((Point2D)llp).getX(), 2);
                    OMLine line4 = new OMLine(((Point2D)llp).getY(), ((Point2D)llp).getX(), ((Point2D)llp).getY(), 0.0, 2);
                    OMLine line5 = new OMLine(((Point2D)llp).getY(), 0.0, ((Point2D)llp).getY(), 179.9, 2);
                    list.add(line3);
                    list.add(line4);
                    list.add(line5);
                } else {
                    line3 = new OMLine(((Point2D)llp).getY(), 0.0, ((Point2D)llp).getY(), ((Point2D)llp).getX(), 2);
                    OMLine line4 = new OMLine(((Point2D)llp).getY(), ((Point2D)llp).getX(), ((Point2D)llp).getY(), 180.0, 2);
                    OMLine line5 = new OMLine(((Point2D)llp).getY(), -179.0, ((Point2D)llp).getY(), 0.0, 2);
                    list.add(line3);
                    list.add(line4);
                    list.add(line5);
                }
                OMLine line6 = new OMLine(((Point2D)center).getY(), ((Point2D)center).getX(), ((Point2D)llp).getY(), ((Point2D)llp).getX(), 3);
                line6.addArrowHead(true);
                list.add(line6);
                this.getAzDrawing().setTo(list);
                this.omGraphics = list;
                list.generate(this.mapBean.getProjection());
                this.mapBean.addPaintListener(this);
                this.mapBean.repaint();
            }
        }

        public void handleUnpan(MouseEvent me) {
            if (this.mapBean != null) {
                this.mapBean.removePaintListener(this);
                this.omGraphics = null;
            }
        }
    }
}

