/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.dataAccess.mapTile;

import com.bbn.openmap.dataAccess.mapTile.AbstractMapTileCoordinateTransform;
import com.bbn.openmap.proj.coords.GeoCoordTransformation;
import com.bbn.openmap.proj.coords.LatLonPoint;
import com.bbn.openmap.proj.coords.MercatorUVGCT;
import java.awt.geom.Point2D;

public class OSMMapTileCoordinateTransform
extends AbstractMapTileCoordinateTransform {
    public Point2D latLonToTileUV(Point2D latlon, int zoom, Point2D ret) {
        if (ret == null) {
            ret = new Point2D.Double();
        }
        ret.setLocation((latlon.getX() + 180.0) / 360.0 * Math.pow(2.0, zoom), (1.0 - Math.log(Math.tan(latlon.getY() * Math.PI / 180.0) + 1.0 / Math.cos(latlon.getY() * Math.PI / 180.0)) / Math.PI) / 2.0 * Math.pow(2.0, zoom));
        return ret;
    }

    public LatLonPoint tileUVToLatLon(Point2D tileUV, int zoom, LatLonPoint ret) {
        if (ret == null) {
            ret = new LatLonPoint.Double();
        }
        ret.setLocation(360.0 / Math.pow(2.0, zoom) * tileUV.getX() - 180.0, -90.0 + 114.59155902616465 * Math.atan(Math.exp(Math.PI * -2 * tileUV.getY() / Math.pow(2.0, zoom) + Math.PI)));
        return ret;
    }

    public int[] getTileBoundsForProjection(Point2D upperLeft, Point2D lowerRight, int zoomLevel) {
        Point2D uvul = this.latLonToTileUV(upperLeft, zoomLevel);
        Point2D uvlr = this.latLonToTileUV(lowerRight, zoomLevel);
        int[] ret = new int[4];
        int uvleft = (int)Math.floor(uvul.getX());
        int uvright = (int)Math.ceil(uvlr.getX());
        int uvup = (int)Math.floor(uvul.getY());
        if (uvup < 0) {
            uvup = 0;
        }
        int uvbottom = (int)Math.ceil(uvlr.getY());
        ret[0] = uvup;
        ret[1] = uvleft;
        ret[2] = uvbottom;
        ret[3] = uvright;
        return ret;
    }

    public boolean isYDirectionUp() {
        return false;
    }

    public GeoCoordTransformation getTransform(int zoomLevel) {
        return new MercatorUVGCT.OSM(zoomLevel);
    }
}

