/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.dataAccess.image;

import com.bbn.openmap.dataAccess.image.ImageReader;
import com.bbn.openmap.omGraphics.OMColor;
import com.bbn.openmap.omGraphics.OMScalingRaster;
import com.bbn.openmap.proj.ProjMath;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.util.cacheHandler.CacheHandler;
import com.bbn.openmap.util.cacheHandler.CacheObject;
import java.awt.Color;
import java.awt.Image;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.io.Serializable;

public class ImageTile
extends OMScalingRaster
implements Serializable {
    protected ImageReader imageDecoder;
    protected CacheHandler cache;
    protected Boolean realSelection = null;
    public static Color DEFAULT_NON_CLEAR_FILL_PAINT = new Color(200, 200, 200, 100);

    public ImageTile() {
    }

    public ImageTile(double ullat, double ullon, double lrlat, double lrlon, ImageReader imageDecoder, CacheHandler cache) {
        this.setRenderType(1);
        this.setColorModel(2);
        this.lat = ullat;
        this.lon = ullon;
        this.lat2 = lrlat;
        this.lon2 = lrlon;
        this.imageDecoder = imageDecoder;
        this.cache = cache;
    }

    public ImageTile(double ullat, double ullon, double lrlat, double lrlon, BufferedImage image) {
        super(ullat, ullon, lrlat, lrlon, (Image)image);
    }

    public void setSelected(boolean setting) {
        if (this.realSelection != null) {
            this.realSelection = setting;
            this.displayPaint = setting ? this.getSelectPaint() : this.getLinePaint();
        } else {
            super.setSelected(setting);
        }
    }

    protected boolean shouldFetchForProjection(Projection proj) {
        Point2D.Double anchor1 = new Point2D.Double(this.lat, this.lon);
        Point2D.Double anchor2 = new Point2D.Double(this.lat2, this.lon2);
        float imageScale = ProjMath.getScale(anchor1, anchor2, proj);
        float scaleRatio = 5.0f;
        if (this.cache instanceof Cache) {
            scaleRatio = ((Cache)this.cache).getCutoffScaleRatio();
        }
        return imageScale * scaleRatio <= proj.getScale();
    }

    protected boolean updateImageForProjection(Projection proj) {
        this.position(proj);
        if (this.imageDecoder != null) {
            if (!this.isOnMap(proj)) {
                this.bitmap = null;
                this.sourceImage = null;
                this.setNeedToRegenerate(true);
                return false;
            }
            if (this.shouldFetchForProjection(proj)) {
                this.bitmap = null;
                if (this.realSelection == null) {
                    if (this.getFillPaint() == OMColor.clear) {
                        this.setFillPaint(DEFAULT_NON_CLEAR_FILL_PAINT);
                    }
                    this.realSelection = this.selected;
                }
                this.selected = true;
                this.setShape();
                this.setNeedToRegenerate(false);
                return false;
            }
            if (this.realSelection != null) {
                if (this.getFillPaint() == DEFAULT_NON_CLEAR_FILL_PAINT) {
                    this.setFillPaint(OMColor.clear);
                }
                this.setFillPaint(OMColor.clear);
                this.selected = this.realSelection;
                this.realSelection = null;
            }
            if (this.sourceImage == null) {
                if (this.cache != null) {
                    this.setImage((Image)this.cache.get(this.imageDecoder));
                } else {
                    this.setImage(this.imageDecoder.getBufferedImage());
                }
            }
        }
        return true;
    }

    public boolean regenerate(Projection p) {
        return this.generate(p);
    }

    public ImageReader getImageDecoder() {
        return this.imageDecoder;
    }

    public void setImageDecoder(ImageReader imageDecoder) {
        this.imageDecoder = imageDecoder;
    }

    public static class Cache
    extends CacheHandler {
        public static final float DEFAULT_SCALE_RATIO = 5.0f;
        protected float cutoffScaleRatio = 5.0f;

        public Cache() {
            super(10);
        }

        public Cache(int maxSize) {
            super(maxSize);
        }

        public void setCutoffScaleRatio(float scale) {
            this.cutoffScaleRatio = scale;
        }

        public float getCutoffScaleRatio() {
            return this.cutoffScaleRatio;
        }

        public CacheObject load(Object key) {
            try {
                if (key instanceof ImageReader) {
                    BufferedImage fileImage = ((ImageReader)key).getBufferedImage();
                    return new CacheObject(key, fileImage);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return null;
        }
    }
}

