/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.util;

import com.bbn.openmap.util.ISwingWorker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SwingWorker<T>
implements ISwingWorker<T> {
    private Object value;
    private boolean interrupted = false;
    private ThreadVar threadVar;

    protected synchronized Object getValue() {
        return this.value;
    }

    private synchronized void setValue(Object x) {
        this.value = x;
    }

    @Override
    public abstract T construct();

    @Override
    public void finished() {
    }

    @Override
    public void interrupt() {
        Thread t = this.threadVar.get();
        if (t != null) {
            t.interrupt();
        }
        this.threadVar.clear();
        this.interrupted = true;
    }

    @Override
    public boolean isInterrupted() {
        return this.interrupted;
    }

    @Override
    public T get() {
        Thread t;
        while ((t = this.threadVar.get()) != null) {
            try {
                t.join();
            }
            catch (InterruptedException e) {
                t.interrupt();
                this.interrupted = true;
                return null;
            }
        }
        return (T)this.getValue();
    }

    public SwingWorker() {
        final Runnable doFinished = new Runnable(){

            public void run() {
                SwingWorker.this.finished();
            }
        };
        Runnable doConstruct = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Object value = null;
                try {
                    value = SwingWorker.this.construct();
                }
                finally {
                    if (!Thread.currentThread().isInterrupted()) {
                        SwingWorker.this.setValue(value);
                    } else {
                        SwingWorker.this.setValue(null);
                    }
                    Thread fT = new Thread(doFinished);
                    fT.start();
                    SwingWorker.this.threadVar.clear();
                }
            }
        };
        Thread t = new Thread(doConstruct);
        this.threadVar = new ThreadVar(t);
    }

    @Override
    public void start() {
        Thread t = this.threadVar.get();
        if (t != null) {
            t.start();
        }
    }

    @Override
    public void execute() {
        this.start();
    }

    private static class ThreadVar {
        private Thread thread;

        ThreadVar(Thread t) {
            this.thread = t;
        }

        synchronized Thread get() {
            return this.thread;
        }

        synchronized void clear() {
            this.thread = null;
        }
    }
}

