/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.tools.roads;

import com.bbn.openmap.omGraphics.OMGraphicList;
import com.bbn.openmap.proj.coords.LatLonPoint;
import com.bbn.openmap.tools.roads.Road;
import com.bbn.openmap.tools.roads.RoadGraphic;
import com.bbn.openmap.tools.roads.RoadLayer;
import com.bbn.openmap.tools.roads.RoadObject;
import com.bbn.openmap.tools.roads.Waypoint;
import java.awt.Color;
import java.util.Enumeration;
import java.util.Vector;

public class Intersection
extends Waypoint
implements RoadObject {
    Vector roads = new Vector(4);
    private String name;
    private boolean displayAsTerminal = false;
    public static int GRID = 100000;

    public Intersection(LatLonPoint loc, RoadLayer layer) {
        this(loc, Intersection.getLatLonPointName(loc), layer);
    }

    public Intersection(LatLonPoint loc, String name, RoadLayer layer) {
        super(loc, layer);
        this.name = name;
    }

    public static Class getGraphicClass() {
        return Graphic.class;
    }

    public static String getLatLonPointName(LatLonPoint loc) {
        StringBuffer buf = new StringBuffer(24);
        buf.append((int)(loc.getY() * (double)GRID));
        buf.append(",");
        buf.append((int)(loc.getX() * (double)GRID));
        return new String(buf.toString());
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void addRoad(Road road) {
        this.roads.addElement(road);
    }

    public void removeRoad(Road road) {
        this.roads.removeElement(road);
    }

    public int getRoadCount() {
        return this.roads.size();
    }

    public void merge(Intersection other) {
        Enumeration e = other.getRoads();
        while (e.hasMoreElements()) {
            Road road = (Road)e.nextElement();
            road.changeIntersection(other, this);
            this.addRoad(road);
        }
        other.clear();
        this.setModified(true);
    }

    public void clear() {
        this.roads.setSize(0);
    }

    public Enumeration getRoads() {
        return this.roads.elements();
    }

    public Road getRoad(int ix) {
        return (Road)this.roads.elementAt(ix);
    }

    public void setTerminalStatus(boolean yes) {
        this.displayAsTerminal = yes;
        this.update();
    }

    public boolean getTerminalStatus() {
        return this.displayAsTerminal;
    }

    public void render(OMGraphicList gl, boolean forceNew) {
        RoadGraphic visual = this.getVisual();
        if (visual == null || forceNew) {
            visual = new Graphic(this.displayAsTerminal);
            this.setVisual(visual);
        }
        gl.add((Graphic)visual);
    }

    public void renderRoads(OMGraphicList gl, boolean forceNew) {
        Enumeration e = this.roads.elements();
        while (e.hasMoreElements()) {
            Road road = (Road)e.nextElement();
            if (road.getFirstIntersection() != this) continue;
            road.render(gl, forceNew);
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Intersection other = (Intersection)obj;
        return other.getLocation().equals(this.getLocation());
    }

    public int hashCode() {
        LatLonPoint llp = this.getLocation();
        int hc1 = Float.floatToIntBits(llp.getLatitude());
        int hc2 = Float.floatToIntBits(llp.getLongitude());
        return hc1 ^ hc2 << 5 ^ hc2 >>> 27;
    }

    public Intersection startMove(boolean shifted) {
        if (shifted) {
            RoadLayer layer = this.getRoadLayer();
            Road road = layer.createRoad(this);
            return road.getOtherIntersection(this);
        }
        return this;
    }

    public void update() {
        super.update();
        Enumeration e = this.roads.elements();
        while (e.hasMoreElements()) {
            ((Road)e.nextElement()).updateLines();
        }
    }

    public String toString() {
        return super.toString() + "[" + this.getName() + "," + this.getLocation().toString() + "] " + this.getRoadCount() + " roads";
    }

    public class Graphic
    extends Waypoint.Graphic
    implements RoadGraphic {
        Graphic(boolean displayAsTerminal) {
            super(Intersection.this, displayAsTerminal ? 5 : 3);
            if (displayAsTerminal) {
                this.setLinePaint(Color.red);
            }
        }

        public RoadObject getRoadObject() {
            return Intersection.this;
        }

        public Intersection getIntersection() {
            return Intersection.this;
        }

        public String toString() {
            return super.toString() + "[" + Intersection.this.toString() + "]";
        }
    }
}

