/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.proj;

import com.bbn.openmap.proj.Cylindrical;
import com.bbn.openmap.proj.EqualArc;
import com.bbn.openmap.proj.ProjMath;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.proj.coords.LatLonPoint;
import com.bbn.openmap.util.Debug;
import java.awt.Point;
import java.awt.geom.Point2D;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CADRG
extends Cylindrical
implements EqualArc {
    private static final long serialVersionUID = 1L;
    public static final transient String CADRGName = "CADRG";
    public static final transient double epsilon = 1.0E-4;
    private static final double NORTH_LIMIT = ProjMath.degToRad(80.0f);
    private static final double SOUTH_LIMIT = -NORTH_LIMIT;
    private double spps_x;
    private double spps_y;
    private static final int[] CADRG_ARC_A = new int[]{369664, 302592, 245760, 199168, 163328, 137216, 110080, 82432};
    private static final double CADRG_SCALE_LIMIT = 2000.0;
    private static final int[] CADRG_get_zone_old_extents = new int[]{32, 48, 56, 64, 68, 72, 76, 80, 90};
    private int oy;
    private double x_pix_constant;
    private double y_pix_constant;
    private Point ul;
    private double[] lower_zone_extents;
    private double[] upper_zone_extents;
    private int zone;

    public CADRG(LatLonPoint center, float scale, int width, int height) {
        super(center, scale, width, height);
        this.minscale = 500.0;
    }

    @Override
    public double normalizeLatitude(double lat) {
        if (lat > NORTH_LIMIT) {
            lat = NORTH_LIMIT;
        } else if (lat < SOUTH_LIMIT) {
            lat = SOUTH_LIMIT;
        }
        return lat;
    }

    @Override
    public String toString() {
        return "CADRG[ spps_x=" + this.spps_x + " spps_y=" + this.spps_y + " x_pix=" + this.x_pix_constant + " y_pix=" + this.y_pix_constant + " oy=" + this.oy + " ul(" + this.ul.x + "," + this.ul.y + ")" + super.toString();
    }

    public int getZone() {
        return this.zone;
    }

    public static int getProjZone(char asciiZone) {
        int z = asciiZone;
        if (z == 74) {
            --z;
        }
        z = z > 64 ? (z -= 64) : (z -= 48);
        return z;
    }

    @Override
    public double getPlanetPixelCircumference() {
        return 1000000.0 * (double)CADRG_ARC_A[this.zone - 1] / 1.5;
    }

    protected int getZone(double lat, double y_pix_constant) {
        int NOT_SET;
        int ret = NOT_SET = -1;
        double ppd = y_pix_constant / 90.0;
        if (this.upper_zone_extents == null) {
            this.upper_zone_extents = new double[CADRG_get_zone_old_extents.length];
        }
        if (this.lower_zone_extents == null) {
            this.lower_zone_extents = new double[CADRG_get_zone_old_extents.length + 1];
        }
        double delta = y_pix_constant == 0.0 ? 0.0 : (double)this.height / 2.0 * 90.0 / y_pix_constant;
        Debug.message("proj", "height = " + this.height);
        double upper_lat = Math.abs(Math.abs(lat) + delta);
        double lower_lat = Math.abs(Math.abs(lat) - delta);
        Debug.message("proj", "upper_lat = " + upper_lat);
        Debug.message("proj", "lower_lat = " + lower_lat);
        this.lower_zone_extents[0] = 0.0;
        this.lower_zone_extents[8] = 80.0;
        this.upper_zone_extents[8] = 90.0;
        for (int x = 0; x < CADRG_get_zone_old_extents.length - 1; ++x) {
            double pivot = ppd * (double)CADRG_get_zone_old_extents[x] / 1536.0;
            pivot = Math.floor(pivot);
            Debug.message("proj", "pivot = " + pivot);
            this.lower_zone_extents[x + 1] = (float)(pivot * 1536.0 / ppd);
            this.upper_zone_extents[x] = (float)((pivot += 1.0) * 1536.0 / ppd);
            Debug.message("proj", "lower_zone_extents[" + x + "] = " + this.lower_zone_extents[x]);
            Debug.message("proj", "upper_zone_extents[" + x + "] = " + this.upper_zone_extents[x]);
            if (!(lower_lat <= this.upper_zone_extents[x]) || !(upper_lat <= this.upper_zone_extents[x]) || ret != NOT_SET) continue;
            ret = x + 1;
        }
        if (ret == NOT_SET) {
            ret = CADRG_get_zone_old_extents.length - 1;
        }
        return ret;
    }

    @Override
    public double getXPixConstant() {
        return this.x_pix_constant;
    }

    @Override
    public double getYPixConstant() {
        return this.y_pix_constant;
    }

    public double getUpperZoneExtent(int zone) {
        if (zone < 1) {
            zone = 1;
        }
        if (zone > 8) {
            zone = 9;
        }
        return this.upper_zone_extents[zone - 1];
    }

    public double getLowerZoneExtent(int zone) {
        if (zone < 1) {
            zone = 1;
        }
        if (zone > 8) {
            zone = 9;
        }
        return this.lower_zone_extents[zone - 1];
    }

    public int numHorizontalFrames() {
        return (int)Math.ceil(this.x_pix_constant / 1536.0);
    }

    public int numVerticalFrames() {
        return (int)Math.round((this.upper_zone_extents[this.zone - 1] - this.lower_zone_extents[this.zone - 1]) * (this.y_pix_constant / 90.0) / 1536.0);
    }

    private double CADRG_x_pix_constant(double adrgscale, int zone) {
        double x_pix = adrgscale * (double)CADRG_ARC_A[zone - 1] / 512.0;
        x_pix = Math.ceil(x_pix);
        x_pix *= 1.33333;
        x_pix = Math.round(x_pix);
        return x_pix * 256.0;
    }

    private float CADRG_calc_maxscale() {
        return (float)Math.floor(1000000.0f * (float)CADRG_ARC_A[0] / ((float)this.width * 1.5f));
    }

    private double CADRG_y_pix_constant(double adrgscale) {
        int CADRG_ARC_B = 400384;
        double y_pix = adrgscale * 400384.0 / 512.0;
        y_pix = Math.ceil(y_pix);
        y_pix *= 0.33333;
        y_pix = Math.round(y_pix);
        return y_pix * 256.0;
    }

    @Override
    public boolean isPlotable(double lat, double lon) {
        return (lat = ProjMath.degToRad(lat)) < NORTH_LIMIT && lat > SOUTH_LIMIT;
    }

    @Override
    public Point2D forward(double lat, double lon, Point2D ret_val, boolean isRadians) {
        if (!isRadians) {
            lon = Math.toRadians(lon);
            lat = Math.toRadians(lat);
        }
        double lon_ = CADRG.wrapLongitude(lon - this.centerX);
        double lat_ = this.normalizeLatitude(lat);
        int x = (int)ProjMath.roundAdjust(this.spps_x * lon_) - this.ul.x;
        int y = (int)ProjMath.roundAdjust(-this.spps_y * lat_) + this.ul.y + this.oy;
        ret_val.setLocation(x, y);
        return ret_val;
    }

    @Override
    public <T extends Point2D> T inverse(double x, double y, T ret_val) {
        if (ret_val == null) {
            ret_val = new LatLonPoint.Double();
        }
        double px = x + (double)this.ul.x;
        double py = -y + (double)this.ul.y + (double)this.oy;
        if (px > ProjMath.roundAdjust((double)this.world.x / 2.0)) {
            px = ProjMath.roundAdjust((double)this.world.x / 2.0);
        } else if (px < ProjMath.roundAdjust((double)(-this.world.x) / 2.0)) {
            px = ProjMath.roundAdjust((double)(-this.world.x) / 2.0);
        }
        if (py > ProjMath.roundAdjust((double)this.world.y / 2.0)) {
            py = ProjMath.roundAdjust((double)this.world.y / 2.0);
        } else if (py < ProjMath.roundAdjust((double)(-this.world.y) / 2.0)) {
            py = ProjMath.roundAdjust((double)(-this.world.y) / 2.0);
        }
        double lat_ = this.normalizeLatitude(py / this.spps_y);
        double lon_ = CADRG.wrapLongitude(px / this.spps_x + this.centerX);
        ((Point2D)ret_val).setLocation(Math.toDegrees(lon_), Math.toDegrees(lat_));
        return (T)ret_val;
    }

    @Override
    protected synchronized void computeParameters() {
        int h;
        int w;
        double adrgscale;
        if (this.ul == null) {
            this.ul = new Point(0, 0);
        }
        this.maxscale = this.CADRG_calc_maxscale();
        if (this.scale > this.maxscale) {
            this.scale = this.maxscale;
        }
        if ((adrgscale = 1000000.0 / this.scale) > 2000.0) {
            Debug.message("proj", "CADRG: adrgscale > CADRG_SCALE_LIMIT");
            adrgscale = 2000.0;
        }
        this.y_pix_constant = this.CADRG_y_pix_constant(adrgscale);
        if (Debug.debugging("proj")) {
            Debug.output("Y pix constant = " + this.y_pix_constant);
        }
        this.zone = this.scale > 6.0E7 ? this.getZone(0.0, this.y_pix_constant) : this.getZone(ProjMath.radToDeg(this.centerY), this.y_pix_constant);
        if (Debug.debugging("proj")) {
            Debug.output("Zone = " + this.zone);
        }
        this.x_pix_constant = this.CADRG_x_pix_constant(adrgscale, this.zone);
        if ((double)this.width >= this.x_pix_constant) {
            this.x_pix_constant = this.width + 1;
        }
        if (Debug.debugging("proj")) {
            Debug.output("x_pix_constant = " + this.x_pix_constant);
        }
        if (this.world == null) {
            this.world = new Point(0, 0);
        }
        this.world.x = (int)ProjMath.roundAdjust(this.x_pix_constant);
        this.world.y = (int)ProjMath.roundAdjust(this.y_pix_constant * 4.0 / 2.0);
        Debug.message("proj", "world = " + this.world.x + "," + this.world.y);
        this.spps_x = this.x_pix_constant / 6.2831854820251465;
        this.spps_y = this.y_pix_constant / 1.5707963705062866;
        Debug.message("proj", "spps = " + this.spps_x + "," + this.spps_y);
        if (this.width > this.world.x) {
            Debug.message("proj", "CADRG: fixing small world");
            w = this.world.x;
        } else {
            w = this.width;
        }
        if (this.height > this.world.y) {
            h = this.world.y;
            this.oy = (int)ProjMath.roundAdjust((double)(this.height - h) / 2.0);
        } else {
            h = this.height;
            this.oy = 0;
        }
        long temp = (long)ProjMath.roundAdjust(this.spps_y * this.centerY);
        if (Debug.debugging("proj")) {
            Debug.output("CADRG.temp = " + temp);
        }
        if (this.ul == null) {
            this.ul = new Point(0, 0);
        }
        this.ul.x = (int)ProjMath.roundAdjust((double)(-w) / 2.0);
        this.ul.y = temp != 0L && this.oy != 0 ? (int)ProjMath.roundAdjust((double)h / 2.0) : (int)temp + (int)ProjMath.roundAdjust((double)h / 2.0);
        if (Debug.debugging("proj")) {
            Debug.output("CADRG: ul = " + this.ul.x + "," + this.ul.y);
            Debug.output(" oy = " + this.oy);
        }
        this.half_world = this.world.x / 2;
        if (this.scale > this.maxscale) {
            this.scale = this.maxscale;
        }
        Debug.message("proj", "CADRG.computeParameters(): maxscale: " + this.maxscale);
    }

    @Override
    public String getName() {
        return CADRGName;
    }

    public float getScale(LatLonPoint ll1, LatLonPoint ll2, Point2D point1, Point2D point2) {
        return this.getScale(ll1, ll2, point1, point2, 0);
    }

    private float getScale(LatLonPoint ll1, LatLonPoint ll2, Point2D point1, Point2D point2, int recursiveCount) {
        try {
            double pixPerDegree;
            int deltaPix;
            double deltaDegrees;
            double dx = Math.abs(point2.getX() - point1.getX());
            double dy = Math.abs(point2.getY() - point1.getY());
            double nCenterLat = Math.min(ll1.getY(), ll2.getY()) + Math.abs(ll1.getY() - ll2.getY()) / 2.0;
            double nCenterLon = Math.min(ll1.getX(), ll2.getX()) + Math.abs(ll1.getX() - ll2.getX()) / 2.0;
            if (dx < dy) {
                double dlat;
                deltaDegrees = dlat = (double)Math.abs(ll1.getLatitude() - ll2.getLatitude());
                deltaPix = this.getHeight();
                pixPerDegree = (double)this.getScale() * this.getYPixConstant() / 90.0;
            } else {
                double lon2;
                double lon1;
                if (point1.getX() > point2.getX()) {
                    double lat1 = ll1.getLatitude();
                    lon1 = ll1.getLongitude();
                    ll1.setLatLon(ll2);
                    ll2.setLatLon(lat1, lon1);
                }
                double dlon = (lon1 = (double)ll1.getLongitude()) > (lon2 = (double)ll2.getLongitude()) ? 180.0 - lon1 + (180.0 + lon2) : lon2 - lon1;
                deltaDegrees = dlon;
                deltaPix = this.getWidth();
                pixPerDegree = this.getPlanetPixelCircumference() / 360.0;
            }
            double ret = pixPerDegree / ((double)deltaPix / deltaDegrees);
            CADRG newcadrg = new CADRG(new LatLonPoint.Double(nCenterLat, nCenterLon), (float)ret, this.getWidth(), this.getHeight());
            if (newcadrg.getZone() != this.zone && recursiveCount < 2) {
                ret = newcadrg.getScale(ll1, ll2, newcadrg.forward(ll1), newcadrg.forward(ll2), recursiveCount + 1);
            }
            return (float)ret;
        }
        catch (NullPointerException npe) {
            Debug.error("ProjMath.getScale(): caught null pointer exception.");
            return Float.MAX_VALUE;
        }
    }

    public static CADRG convertProjection(Projection proj) {
        if (proj instanceof CADRG) {
            return (CADRG)proj;
        }
        CADRG cadrg = new CADRG(proj.getCenter(new LatLonPoint.Float()), proj.getScale(), proj.getWidth(), proj.getHeight());
        Point2D ulp = cadrg.forward((Point2D)proj.getUpperLeft());
        Point2D lrp = cadrg.forward((Point2D)proj.getLowerRight());
        int w = (int)Math.abs(lrp.getX() - ulp.getX());
        int h = (int)Math.abs(lrp.getY() - ulp.getY());
        return new CADRG(proj.getCenter(new LatLonPoint.Float()), proj.getScale(), w, h);
    }
}

