/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.plugin;

import com.bbn.openmap.event.MapMouseListener;
import com.bbn.openmap.layer.OMGraphicHandlerLayer;
import com.bbn.openmap.layer.policy.ListResetPCPolicy;
import com.bbn.openmap.omGraphics.OMGraphicList;
import com.bbn.openmap.omGraphics.OMList;
import com.bbn.openmap.plugin.AbstractPlugIn;
import com.bbn.openmap.plugin.PlugIn;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.util.ComponentFactory;
import com.bbn.openmap.util.Debug;
import com.bbn.openmap.util.PropUtils;
import java.awt.Component;
import java.awt.Container;
import java.beans.PropertyVetoException;
import java.beans.beancontext.BeanContext;
import java.beans.beancontext.BeanContextChild;
import java.beans.beancontext.BeanContextMembershipListener;
import java.util.Properties;

public class PlugInLayer
extends OMGraphicHandlerLayer {
    public static final String PlugInProperty = "plugin";
    protected transient PlugIn plugin = null;
    protected MapMouseListener mml;
    protected String plugInClass = null;

    public PlugInLayer() {
        this.setName("PlugInLayer");
        this.setProjectionChangePolicy(new ListResetPCPolicy(this));
    }

    public void removed(Container container) {
        PlugIn pi = this.getPlugIn();
        if (pi != null) {
            pi.removed();
        }
    }

    public void setProperties(String prefix, Properties props) {
        super.setProperties(prefix, props);
        String realPrefix = PropUtils.getScopedPropertyPrefix(prefix);
        this.plugInClass = props.getProperty(realPrefix + PlugInProperty);
        if (this.plugInClass != null) {
            String plugInPrefix = PlugInProperty;
            plugInPrefix = realPrefix + PlugInProperty;
            this.setPlugIn((PlugIn)ComponentFactory.create(this.plugInClass, plugInPrefix, props));
        } else {
            PlugIn pi = this.getPlugIn();
            if (pi != null) {
                pi.setProperties(prefix, props);
            }
        }
    }

    public Properties getProperties(Properties props) {
        props = super.getProperties(props);
        PlugIn pi = this.getPlugIn();
        if (pi != null) {
            if (this.plugInClass != null) {
                String prefix = PropUtils.getScopedPropertyPrefix(this);
                props.put(prefix + PlugInProperty, pi.getClass().getName());
            } else {
                String prefix = PropUtils.getScopedPropertyPrefix(pi);
                props.put(prefix + "class", pi.getClass().getName());
                props.put(prefix + "prettyName", this.getName());
            }
            pi.getProperties(props);
        }
        return props;
    }

    public Properties getPropertyInfo(Properties props) {
        PlugIn pi = this.getPlugIn();
        props = super.getPropertyInfo(props);
        if (this.plugInClass != null || pi == null) {
            props.put(PlugInProperty, "Class name of PlugIn");
            props.put("plugin.editor", "com.bbn.openmap.util.propertyEditor.NonEditablePropertyEditor");
        } else {
            props.put("class", "Class name of PlugIn");
            props.put("class.editor", "com.bbn.openmap.util.propertyEditor.NonEditablePropertyEditor");
            props.put("prettyName", this.getName());
            props.put("prettyName.editor", "com.bbn.openmap.util.propertyEditor.NonEditablePropertyEditor");
        }
        if (pi != null) {
            pi.getPropertyInfo(props);
        }
        return props;
    }

    public void setPropertyPrefix(String prefix) {
        super.setPropertyPrefix(prefix);
        PlugIn pi = this.getPlugIn();
        if (pi != null) {
            if (this.plugInClass != null) {
                pi.setPropertyPrefix(PropUtils.getScopedPropertyPrefix(prefix) + PlugInProperty);
            } else {
                this.plugin.setPropertyPrefix(prefix);
            }
        }
    }

    public void dispose() {
        if (this.plugin != null) {
            this.plugin.setComponent(null);
        }
        this.removePlugInFromBeanContext(this.plugin);
        this.plugin = null;
    }

    public synchronized void setGraphicList(OMGraphicList aList) {
        this.setList(aList);
    }

    public synchronized OMGraphicList getGraphicList() {
        return this.getList();
    }

    public PlugIn getPlugIn() {
        return this.plugin;
    }

    public void setPlugIn(PlugIn aPlugIn) {
        if (this.plugin != null) {
            this.removePlugInFromBeanContext(this.plugin);
        }
        this.plugin = aPlugIn;
        if (aPlugIn != null) {
            this.plugin.setComponent(this);
            this.setMapMouseListener(this.plugin.getMapMouseListener());
            this.addPlugInToBeanContext(this.plugin);
        } else if (Debug.debugging(PlugInProperty)) {
            Debug.output("PlugInLayer: null PlugIn set!");
        }
    }

    public MapMouseListener getMapMouseListener() {
        return this.mml;
    }

    public synchronized void setMapMouseListener(MapMouseListener mmlIn) {
        this.mml = mmlIn;
    }

    public synchronized OMGraphicList prepare() {
        Debug.message(PlugInProperty, this.getName() + "|PlugInLayer.prepare()");
        if (this.isCancelled()) {
            Debug.message(PlugInProperty, this.getName() + "|PlugInLayer.prepare(): aborted.");
            return null;
        }
        if (this.plugin == null) {
            System.out.println(this.getName() + "|PlugInLayer.prepare(): No plugin in layer.");
            return null;
        }
        Debug.message("basic", this.getName() + "|PlugInLayer.prepare(): doing it");
        Projection proj = this.getProjection();
        if (Debug.debugging(PlugInProperty) && proj != null) {
            System.out.println(this.getName() + "|PlugInLayer.prepare(): " + "calling getRectangle " + " with projection: " + proj + " ul = " + proj.getUpperLeft() + " lr = " + proj.getLowerRight());
        }
        OMList omGraphicList = null;
        if (this.plugin != null && proj != null) {
            omGraphicList = this.plugin.getRectangle(proj);
        }
        int size = 0;
        if (omGraphicList != null) {
            size = omGraphicList.size();
            if (Debug.debugging("basic")) {
                Debug.output(this.getName() + "|PlugInLayer.prepare(): finished with " + size + " graphics");
            }
        } else {
            if (Debug.debugging("basic")) {
                Debug.output(this.getName() + "|PlugInLayer.prepare(): finished with null graphics list");
            }
            omGraphicList = new OMGraphicList();
        }
        return omGraphicList;
    }

    public Component getGUI() {
        if (this.plugin != null) {
            return this.plugin.getGUI();
        }
        return null;
    }

    public boolean getAddToBeanContext() {
        boolean ret = false;
        ret = this.plugin != null && (this.plugin instanceof BeanContextChild || this.plugin instanceof BeanContextMembershipListener) ? (this.plugin instanceof AbstractPlugIn ? ((AbstractPlugIn)this.plugin).getAddToBeanContext() : true) : super.getAddToBeanContext();
        if (Debug.debugging(PlugInProperty)) {
            Debug.output(this.getName() + ".addToBeanContext is " + ret);
        }
        return ret;
    }

    public void setBeanContext(BeanContext in_bc) throws PropertyVetoException {
        super.setBeanContext(in_bc);
        this.addPlugInToBeanContext(this.getPlugIn());
    }

    public void addPlugInToBeanContext(PlugIn pi) {
        BeanContext bc = this.getBeanContext();
        if (bc != null && pi != null && (pi instanceof BeanContextChild || pi instanceof AbstractPlugIn && ((AbstractPlugIn)pi).getAddToBeanContext())) {
            bc.add(pi);
        }
    }

    public void removePlugInFromBeanContext(PlugIn pi) {
        BeanContext bc = this.getBeanContext();
        if (bc != null && pi != null && (pi instanceof BeanContextChild || pi instanceof AbstractPlugIn && ((AbstractPlugIn)pi).getAddToBeanContext())) {
            bc.remove(pi);
        }
    }
}

