/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.omGraphics;

import com.bbn.openmap.layer.util.stateMachine.State;
import com.bbn.openmap.omGraphics.EditableOMGraphic;
import com.bbn.openmap.omGraphics.GrabPoint;
import com.bbn.openmap.omGraphics.GraphicAttributes;
import com.bbn.openmap.omGraphics.OMGraphic;
import com.bbn.openmap.omGraphics.OMRect;
import com.bbn.openmap.omGraphics.OffsetGrabPoint;
import com.bbn.openmap.omGraphics.editable.GraphicEditState;
import com.bbn.openmap.omGraphics.editable.GraphicSelectedState;
import com.bbn.openmap.omGraphics.editable.GraphicSetOffsetState;
import com.bbn.openmap.omGraphics.editable.RectStateMachine;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.proj.coords.LatLonPoint;
import com.bbn.openmap.util.Debug;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;

public class EditableOMRect
extends EditableOMGraphic {
    protected GrabPoint gpnw;
    protected GrabPoint gpne;
    protected GrabPoint gpsw;
    protected GrabPoint gpse;
    protected OffsetGrabPoint gpc;
    protected OffsetGrabPoint gpo;
    protected OMRect rect;
    public static final String OffsetResetCmd = "OffsetResetCmd";
    public static final int CENTER_POINT_INDEX = 0;
    public static final int NW_POINT_INDEX = 1;
    public static final int NE_POINT_INDEX = 2;
    public static final int SW_POINT_INDEX = 3;
    public static final int SE_POINT_INDEX = 4;
    public static final int OFFSET_POINT_INDEX = 5;
    double diffx;
    double diffy;
    protected int lastRenderType = -1;

    public EditableOMRect() {
        this.createGraphic(null);
    }

    public EditableOMRect(GraphicAttributes ga) {
        this.createGraphic(ga);
    }

    public EditableOMRect(OMRect omc) {
        this.setGraphic(omc);
    }

    public void init() {
        Debug.message("eomg", "EditableOMRect.init()");
        this.setCanGrabGraphic(false);
        this.setStateMachine(new RectStateMachine(this));
        this.gPoints = new GrabPoint[6];
    }

    public void setGraphic(OMGraphic graphic) {
        this.init();
        if (graphic instanceof OMRect) {
            this.rect = (OMRect)graphic;
            this.stateMachine.setSelected();
            this.setGrabPoints(this.rect);
        } else {
            this.createGraphic(null);
        }
    }

    public void createGraphic(GraphicAttributes ga) {
        this.init();
        this.stateMachine.setUndefined();
        int renderType = 0;
        int lineType = 3;
        if (ga != null) {
            renderType = ga.getRenderType();
            lineType = ga.getLineType();
        }
        if (Debug.debugging("eomg")) {
            Debug.output("EditableOMRect.createGraphic(): rendertype = " + renderType);
            Debug.output("EditableOMRect.createGraphic(): linetype = " + lineType);
        }
        switch (renderType) {
            case 1: {
                if (lineType == 0) {
                    lineType = 3;
                    if (ga != null) {
                        ga.setLineType(3);
                    }
                }
                this.rect = new OMRect(90.0, -180.0, 90.0, -180.0, lineType);
                break;
            }
            case 3: {
                this.rect = new OMRect(90.0, -180.0, -1, -1, 1, 1);
                break;
            }
            default: {
                this.rect = new OMRect(-1, -1, -1, -1);
            }
        }
        if (ga != null) {
            ga.setTo(this.rect, true);
        }
        this.assertGrabPoints();
    }

    public OMGraphic getGraphic() {
        return this.rect;
    }

    public void attachToMovingGrabPoint(OffsetGrabPoint gp) {
        gp.addGrabPoint(this.gpo);
    }

    public void detachFromMovingGrabPoint(OffsetGrabPoint gp) {
        gp.removeGrabPoint(this.gpo);
    }

    public void initRectSize() {
        this.diffx = Math.abs(this.rect.getEastLon() - this.rect.getWestLon()) / 2.0;
        this.diffy = Math.abs(this.rect.getNorthLat() - this.rect.getSouthLat()) / 2.0;
    }

    public void assertGrabPoints() {
        int rt = this.getGraphic().getRenderType();
        if (rt != this.lastRenderType) {
            this.clearGrabPoints();
            this.lastRenderType = rt;
        }
        if (this.gpnw == null) {
            this.gPoints[1] = this.gpnw = new GrabPoint(-1, -1);
        }
        if (this.gpne == null) {
            this.gPoints[2] = this.gpne = new GrabPoint(-1, -1);
        }
        if (this.gpsw == null) {
            this.gPoints[3] = this.gpsw = new GrabPoint(-1, -1);
        }
        if (this.gpse == null) {
            this.gPoints[4] = this.gpse = new GrabPoint(-1, -1);
        }
        if (this.gpc == null) {
            this.gpc = new OffsetGrabPoint(-1, -1);
            this.gPoints[0] = this.gpc;
            if (this.getGraphic().getRenderType() != 1) {
                this.gpc.addGrabPoint(this.gpnw);
                this.gpc.addGrabPoint(this.gpne);
                this.gpc.addGrabPoint(this.gpsw);
                this.gpc.addGrabPoint(this.gpse);
            }
        }
        if (this.gpo == null) {
            this.gpo = new OffsetGrabPoint(-1, -1);
            this.gPoints[5] = this.gpo;
            this.gpo.addGrabPoint(this.gpc);
        }
    }

    protected void clearGrabPoints() {
        this.gpc = null;
        this.gpnw = null;
        this.gpne = null;
        this.gpsw = null;
        this.gpse = null;
        this.gpo = null;
        this.gPoints[0] = this.gpc;
        this.gPoints[1] = this.gpnw;
        this.gPoints[2] = this.gpne;
        this.gPoints[3] = this.gpsw;
        this.gPoints[4] = this.gpse;
        this.gPoints[5] = this.gpo;
    }

    public void setGrabPoints(OMGraphic graphic) {
        Debug.message("eomg", "EditableOMRect.setGrabPoints(graphic)");
        if (!(graphic instanceof OMRect)) {
            return;
        }
        this.assertGrabPoints();
        OMRect rect = (OMRect)graphic;
        boolean ntr = rect.getNeedToRegenerate();
        int renderType = rect.getRenderType();
        int top = 0;
        int bottom = 0;
        int left = 0;
        int right = 0;
        int latoffset = 0;
        int lonoffset = 0;
        boolean doStraight = true;
        if (!ntr) {
            if ((renderType == 1 || renderType == 3) && this.projection != null) {
                double wlon = rect.getWestLon();
                double nlat = rect.getNorthLat();
                double elon = rect.getEastLon();
                double slat = rect.getSouthLat();
                LatLonPoint.Double llp = new LatLonPoint.Double(nlat, wlon);
                Point2D p = this.projection.forward(llp);
                if (renderType == 1) {
                    doStraight = false;
                    top = (int)p.getY();
                    left = (int)p.getX();
                    this.gpnw.set((int)p.getX(), (int)p.getY());
                    p = this.projection.forward(slat, elon);
                    this.gpse.set((int)p.getX(), (int)p.getY());
                    p = this.projection.forward(nlat, elon);
                    this.gpne.set((int)p.getX(), (int)p.getY());
                    p = this.projection.forward(slat, wlon);
                    this.gpsw.set((int)p.getX(), (int)p.getY());
                    p = this.projection.forward(nlat - (nlat - slat) / 2.0, wlon + (elon - wlon) / 2.0);
                    this.gpc.set((int)p.getX(), (int)p.getY());
                } else {
                    latoffset = (int)p.getY();
                    lonoffset = (int)p.getX();
                    this.gpo.set(lonoffset, latoffset);
                }
            }
            if (doStraight) {
                Debug.message("eomg", "EditableOMRect: drawing straight line rectangle");
                top = rect.getTop() + latoffset;
                bottom = rect.getBottom() + latoffset;
                right = rect.getRight() + lonoffset;
                left = rect.getLeft() + lonoffset;
                if (this.movingPoint == this.gpc || this.movingPoint == this.gpo || this.movingPoint == null) {
                    this.gpne.set(right, top);
                    this.gpnw.set(left, top);
                    this.gpse.set(right, bottom);
                    this.gpsw.set(left, bottom);
                } else if (this.movingPoint == this.gpnw) {
                    this.gpne.set(this.gpse.getX(), this.gpnw.getY());
                    this.gpsw.set(this.gpnw.getX(), this.gpse.getY());
                } else if (this.movingPoint == this.gpse) {
                    this.gpne.set(this.gpse.getX(), this.gpnw.getY());
                    this.gpsw.set(this.gpnw.getX(), this.gpse.getY());
                } else if (this.movingPoint == this.gpsw) {
                    this.gpnw.set(this.gpsw.getX(), this.gpne.getY());
                    this.gpse.set(this.gpne.getX(), this.gpsw.getY());
                } else if (this.movingPoint == this.gpne) {
                    this.gpnw.set(this.gpsw.getX(), this.gpne.getY());
                    this.gpse.set(this.gpne.getX(), this.gpsw.getY());
                }
                int middlex = (right - left) / 2;
                int middley = (bottom - top) / 2;
                this.gpc.set(left + middlex, top + middley);
                this.gpc.updateOffsets();
            }
            if (renderType == 3) {
                this.gpo.updateOffsets();
            }
        } else {
            Debug.message("eomg", "EditableOMRect.setGrabPoints: graphic needs to be regenerated");
        }
    }

    public void setGrabPoints() {
        int halfwidth;
        int halfheight;
        boolean settingOffset;
        LatLonPoint llp1;
        int renderType = this.rect.getRenderType();
        Debug.message("eomg", "EditableOMRect.setGrabPoints()");
        if (renderType == 1 && this.projection != null) {
            if (this.movingPoint == this.gpne) {
                llp1 = this.projection.inverse(this.gpne.getX(), this.gpne.getY(), new LatLonPoint.Double());
                this.rect.lat1 = llp1.getY();
                this.rect.lon2 = llp1.getX();
            } else if (this.movingPoint == this.gpnw) {
                llp1 = this.projection.inverse(this.gpnw.getX(), this.gpnw.getY(), new LatLonPoint.Double());
                this.rect.lat1 = llp1.getY();
                this.rect.lon1 = llp1.getX();
            } else if (this.movingPoint == this.gpsw) {
                llp1 = this.projection.inverse(this.gpsw.getX(), this.gpsw.getY(), new LatLonPoint.Double());
                this.rect.lat2 = llp1.getY();
                this.rect.lon1 = llp1.getX();
            } else if (this.movingPoint == this.gpse) {
                llp1 = this.projection.inverse(this.gpse.getX(), this.gpse.getY(), new LatLonPoint.Double());
                LatLonPoint llp2 = this.projection.inverse(this.gpnw.getX(), this.gpnw.getY(), new LatLonPoint.Double());
                this.rect.lat1 = llp2.getY();
                this.rect.lon1 = llp2.getX();
                this.rect.lat2 = llp1.getY();
                this.rect.lon2 = llp1.getX();
            } else {
                llp1 = this.projection.inverse(this.gpc.getX(), this.gpc.getY(), new LatLonPoint.Double());
                this.rect.lat1 = llp1.getY() + this.diffy;
                this.rect.lon1 = llp1.getX() - this.diffx;
                this.rect.lat2 = llp1.getY() - this.diffy;
                this.rect.lon2 = llp1.getX() + this.diffx;
            }
            this.rect.setNeedToRegenerate(true);
        }
        boolean bl = settingOffset = this.getStateMachine().getState() instanceof GraphicSetOffsetState && this.movingPoint == this.gpo;
        if (renderType == 3) {
            llp1 = this.projection.inverse(this.gpo.getX(), this.gpo.getY(), new LatLonPoint.Double());
            this.rect.lat1 = llp1.getY();
            this.rect.lon1 = llp1.getX();
            if (settingOffset || this.movingPoint == this.gpc) {
                halfheight = (this.gpse.getY() - this.gpnw.getY()) / 2;
                halfwidth = (this.gpse.getX() - this.gpnw.getX()) / 2;
                this.rect.x1 = this.gpc.getX() - halfwidth - this.gpo.getX();
                this.rect.y1 = this.gpc.getY() - halfheight - this.gpo.getY();
                this.rect.x2 = this.gpc.getX() + halfwidth - this.gpo.getX();
                this.rect.y2 = this.gpc.getY() + halfheight - this.gpo.getY();
            }
            if (!settingOffset) {
                Debug.message("eomg", "EditableOMRect: updating offset rect");
                if (this.movingPoint == this.gpnw || this.movingPoint == this.gpse) {
                    this.rect.setLocation(this.gpnw.getX() - this.gpo.getX(), this.gpnw.getY() - this.gpo.getY(), this.gpse.getX() - this.gpo.getX(), this.gpse.getY() - this.gpo.getY());
                } else if (this.movingPoint == this.gpne || this.movingPoint == this.gpsw) {
                    this.rect.x1 = this.gpsw.getX() - this.gpo.getX();
                    this.rect.setLocation(this.rect.x1, this.gpne.getY() - this.gpo.getY(), this.gpne.getX() - this.gpo.getX(), this.gpsw.getY() - this.gpo.getY());
                }
                this.rect.setNeedToRegenerate(true);
            }
            this.rect.setRenderType(3);
        }
        if (renderType == 2) {
            Debug.message("eomg", "EditableOMRect: updating x/y rect");
            if (this.movingPoint == this.gpc) {
                halfheight = (this.gpse.getY() - this.gpnw.getY()) / 2;
                halfwidth = (this.gpse.getX() - this.gpnw.getX()) / 2;
                this.rect.setLocation(this.gpc.getX() - halfwidth, this.gpc.getY() - halfheight, this.gpc.getX() + halfwidth, this.gpc.getY() + halfheight);
            } else if (this.movingPoint == this.gpnw || this.movingPoint == this.gpse) {
                this.rect.setLocation(this.gpnw.getX(), this.gpnw.getY(), this.gpse.getX(), this.gpse.getY());
            } else if (this.movingPoint == this.gpne || this.movingPoint == this.gpsw) {
                this.rect.setLocation(this.gpsw.getX(), this.gpne.getY(), this.gpne.getX(), this.gpsw.getY());
            }
        }
        if (this.projection != null) {
            this.regenerate(this.projection);
        }
    }

    public void move(MouseEvent e) {
    }

    public boolean generate(Projection proj) {
        Debug.message("eomgdetail", "EditableOMRect.generate()");
        if (this.rect != null) {
            this.rect.generate(proj);
        }
        for (int i = 0; i < this.gPoints.length; ++i) {
            GrabPoint gp = this.gPoints[i];
            if (gp == null) continue;
            gp.generate(proj);
        }
        return true;
    }

    public void regenerate(Projection proj) {
        Debug.message("eomg", "EditableOMRect.regenerate()");
        if (this.rect != null) {
            this.rect.regenerate(proj);
        }
        this.setGrabPoints(this.rect);
        this.generate(proj);
    }

    public void render(Graphics graphics) {
        Debug.message("eomgdetail", "EditableOMRect.render()");
        State state = this.getStateMachine().getState();
        if (this.rect != null) {
            this.rect.setVisible(true);
            this.rect.render(graphics);
            this.rect.setVisible(false);
        } else {
            Debug.message("eomg", "EditableOMRect.render: null rect.");
        }
        int renderType = this.rect.getRenderType();
        if (state instanceof GraphicSelectedState || state instanceof GraphicEditState) {
            for (int i = 0; i < this.gPoints.length; ++i) {
                GrabPoint gp = this.gPoints[i];
                if (gp == null || (i != 5 || renderType != 3 || this.movingPoint != this.gpo) && (!(state instanceof GraphicSelectedState) || (i == 5 || renderType == 3) && renderType != 3)) continue;
                gp.setVisible(true);
                gp.render(graphics);
                gp.setVisible(false);
            }
        }
    }
}

