/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.vpf;

import com.bbn.openmap.MoreMath;
import com.bbn.openmap.dataAccess.shape.EsriShapeExport;
import com.bbn.openmap.io.FormatException;
import com.bbn.openmap.layer.shape.ShapeFile;
import com.bbn.openmap.layer.vpf.LayerGraphicWarehouseSupport;
import com.bbn.openmap.layer.vpf.LibrarySelectionTable;
import com.bbn.openmap.layer.vpf.VPFLayer;
import com.bbn.openmap.layer.vpf.VPFLayerDCWWarehouse;
import com.bbn.openmap.layer.vpf.VPFLayerGraphicWarehouse;
import com.bbn.openmap.omGraphics.OMGraphic;
import com.bbn.openmap.omGraphics.OMGraphicList;
import com.bbn.openmap.omGraphics.OMPoly;
import com.bbn.openmap.omGraphics.SinkGraphic;
import com.bbn.openmap.proj.DrawUtil;
import com.bbn.openmap.proj.ProjMath;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.proj.coords.LatLonPoint;
import com.bbn.openmap.util.Debug;
import com.bbn.openmap.util.PropUtils;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;

public class VMAP2Shape {
    protected static final String DEF_VMAP_TYPE = "bnd";
    protected static final String DEF_PROPS_FILE_NAME = System.getProperty("user.home") + System.getProperty("file.separator") + "openmap.properties";
    protected static final String DEF_PREFIX = "vmapref";
    protected static final boolean DEF_DO_THINNING = false;
    protected static final float DEF_FAN_EPS = 0.1f;
    protected static final float DEF_ZERO_EPS = 1.0E-4f;
    protected static final float DEF_THRESHOLD = 0.5f;
    protected String vmaptype = "bnd";
    protected String propsFileName = DEF_PROPS_FILE_NAME;
    protected String prefix = "vmapref";
    protected boolean doThinning = false;
    protected float fan_eps = 0.1f;
    protected float zero_eps = 1.0E-4f;
    protected float threshold = 0.5f;
    protected LibrarySelectionTable lst;
    protected transient LayerGraphicWarehouseSupport warehouse;
    protected boolean joinPolylines = false;

    public void writeShapeFile(String shapeFileName) {
        this.setProperties(this.prefix, this.loadProperties());
        this.writeShapeFile(shapeFileName, this.getRectangle());
    }

    public void writeShapeFile(String shapeFileName, OMGraphicList graphics) {
        try {
            OMGraphic omg;
            ShapeFile s = new ShapeFile(shapeFileName);
            int nGraphics = graphics.size();
            if (nGraphics > 0 && (omg = graphics.get(0)) instanceof OMPoly && omg.getRenderType() == 1) {
                int shapeType = ((OMPoly)omg).isPolygon() ? 5 : 3;
                System.out.println("shapeType=" + shapeType);
                s.setShapeType(shapeType);
            }
            System.out.println(nGraphics + " candidates.");
            if (this.doThinning) {
                OMGraphicList saveGraphics = new OMGraphicList();
                for (int i = 0; i < nGraphics; ++i) {
                    OMGraphic omg2 = graphics.get(i);
                    if (omg2 instanceof OMPoly && omg2.getRenderType() == 1) {
                        OMPoly poly = (OMPoly)omg2;
                        if (this.maybeThrowAwayPoly(poly)) continue;
                        saveGraphics.add(poly);
                        continue;
                    }
                    System.out.println("Skipping candidate: " + omg2.getClass().toString() + ", " + omg2.getRenderType());
                }
                graphics = saveGraphics;
                if (this.joinPolylines) {
                    nGraphics = graphics.size();
                    System.out.println("Joining " + nGraphics + " polyline candidates.");
                    graphics = VMAP2Shape.joinCommonLines(graphics, this.zero_eps);
                }
            }
            EsriShapeExport ese = new EsriShapeExport(graphics, (Projection)null, shapeFileName);
            ese.export();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected static OMGraphicList joinCommonLines(OMGraphicList list, float zero_eps) {
        int i;
        OMGraphic obj;
        int size = list.size();
        OMGraphicList newGraphics = new OMGraphicList();
        OMGraphicList plineGraphics = new OMGraphicList();
        System.out.println("finding polylines...");
        for (int i2 = 0; i2 < size; ++i2) {
            obj = list.getOMGraphicAt(i2);
            if (obj instanceof OMPoly && !((OMPoly)obj).isPolygon()) {
                plineGraphics.add(obj);
                continue;
            }
            newGraphics.add(obj);
        }
        size = plineGraphics.size();
        System.out.println("maybe joining " + size + " polylines...");
        for (i = 0; i < size; ++i) {
            if (i % 500 == 0) {
                System.out.println("checking pline i=" + i);
            }
            for (int j = 0; j < size; ++j) {
                if (i == j || (obj = plineGraphics.getOMGraphicAt(i)) instanceof SinkGraphic) continue;
                OMPoly poly1 = (OMPoly)obj;
                double[] rads1 = poly1.getLatLonArray();
                int len1 = rads1.length;
                double lat1 = ProjMath.radToDeg(rads1[len1 - 2]);
                double lon1 = ProjMath.radToDeg(rads1[len1 - 1]);
                obj = plineGraphics.getOMGraphicAt(j);
                if (obj instanceof SinkGraphic) continue;
                OMPoly poly2 = (OMPoly)obj;
                double[] rads2 = poly2.getLatLonArray();
                int len2 = rads2.length;
                double lat2 = ProjMath.radToDeg(rads2[0]);
                double lon2 = ProjMath.radToDeg(rads2[1]);
                if (!MoreMath.approximately_equal(lat1, lat2, (double)zero_eps) || !MoreMath.approximately_equal(lon1, lon2, (double)zero_eps)) continue;
                double[] radians = new double[len1 + len2 - 2];
                System.arraycopy(rads1, 0, radians, 0, len1);
                System.arraycopy(rads2, 0, radians, len1 - 2, len2);
                poly1.setLocation(radians, 1);
                plineGraphics.setOMGraphicAt(SinkGraphic.getSharedInstance(), j);
                j = -1;
            }
        }
        size = plineGraphics.size();
        for (i = 0; i < size; ++i) {
            obj = plineGraphics.getOMGraphicAt(i);
            if (!(obj instanceof OMPoly)) continue;
            newGraphics.add(obj);
        }
        return newGraphics;
    }

    public static double[] coalesce_points(double[] radians, double eps, boolean ispolyg) {
        int write = 2;
        int len = radians.length;
        int i = write - 2;
        for (int j = write; j < len; j += 2) {
            double lat1 = ProjMath.radToDeg(radians[i]);
            double lon1 = ProjMath.radToDeg(radians[i + 1]);
            double lat2 = ProjMath.radToDeg(radians[j]);
            double lon2 = ProjMath.radToDeg(radians[j + 1]);
            if (MoreMath.approximately_equal(lat1, lat2, eps) && MoreMath.approximately_equal(lon1, lon2, eps)) continue;
            i = write;
            radians[write++] = radians[j];
            radians[write++] = radians[j + 1];
        }
        if (ispolyg && write == 6 && MoreMath.approximately_equal(radians[0], radians[4], eps) && MoreMath.approximately_equal(radians[1], radians[5], eps)) {
            write -= 2;
        }
        double[] newrads = new double[write];
        System.arraycopy(radians, 0, newrads, 0, write);
        return newrads;
    }

    protected boolean maybeThrowAwayPoly(OMPoly poly) {
        double[] radians = poly.getLatLonArray();
        double thresh = ProjMath.degToRad(this.threshold);
        radians = VMAP2Shape.coalesce_points(radians, 1.0E-4f, poly.isPolygon());
        poly.setLocation(radians, 1);
        if (radians.length < 4) {
            return true;
        }
        if (poly.isPolygon() && radians.length < 6) {
            return true;
        }
        int len = radians.length;
        for (int i = 0; i < len; i += 2) {
            double lat = ProjMath.radToDeg(radians[i]);
            double lon = ProjMath.radToDeg(radians[i + 1]);
            if (MoreMath.approximately_equal(lat, (double)Math.round(lat), (double)this.zero_eps)) {
                return false;
            }
            if (MoreMath.approximately_equal(lon, (double)Math.round(lon), (double)this.zero_eps)) {
                return false;
            }
            for (int j = i + 2; j < radians.length; j += 2) {
                double d = DrawUtil.distance(radians[i], radians[i + 1], radians[j], radians[j + 1]);
                if (MoreMath.approximately_equal(d, 0.0, thresh)) continue;
                return false;
            }
        }
        if (poly.isPolygon()) {
            return true;
        }
        return MoreMath.approximately_equal(ProjMath.radToDeg(radians[0]), ProjMath.radToDeg(radians[radians.length - 2]), (double)this.zero_eps) && MoreMath.approximately_equal(ProjMath.radToDeg(radians[1]), ProjMath.radToDeg(radians[radians.length - 1]), (double)this.zero_eps);
    }

    protected Properties loadProperties() {
        Properties props = new Properties();
        try {
            props.load(new FileInputStream(this.propsFileName));
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(1);
        }
        return props;
    }

    protected void setProperties(String prefix, Properties props) {
        String coverage;
        String realPrefix = PropUtils.getScopedPropertyPrefix(prefix);
        String[] paths = PropUtils.initPathsFromProperties(props, realPrefix + "vpfPath");
        String defaultProperty = props.getProperty(realPrefix + "defaultLayer");
        if (defaultProperty != null) {
            System.out.println("defaultProperty=" + defaultProperty);
            realPrefix = defaultProperty + ".";
            props = VPFLayer.getDefaultProperties();
        }
        if ((coverage = props.getProperty(realPrefix + "coverageType")) != null) {
            this.vmaptype = coverage;
            System.out.println("vmaptype=" + this.vmaptype);
        }
        this.initLST(paths);
        if (this.lst.getDatabaseName().equals("DCW")) {
            System.out.println("creating VPFLayerDCWWarehouse");
            this.warehouse = new VPFLayerDCWWarehouse();
        } else {
            System.out.println("creating VPFLayerGraphicWarehouse");
            this.warehouse = new VPFLayerGraphicWarehouse();
        }
        LayerGraphicWarehouseSupport.setDoThinning(this.doThinning);
        LayerGraphicWarehouseSupport.setFanEpsilon(this.fan_eps);
        this.warehouse.setProperties(realPrefix, props);
    }

    protected void initLST(String[] paths) {
        try {
            if (this.lst == null) {
                this.lst = new LibrarySelectionTable(paths);
            }
        }
        catch (FormatException f) {
            throw new IllegalArgumentException(f.getMessage());
        }
    }

    public OMGraphicList getRectangle() {
        int scale = 30000000;
        int width = 640;
        int height = 480;
        LatLonPoint.Double upperLeft = new LatLonPoint.Double(90.0, -180.0);
        LatLonPoint.Double lowerRight = new LatLonPoint.Double(-90.0, 180.0);
        this.warehouse.clear();
        System.out.println("VMAP2Shape.getRectangle(): calling drawTile with boundaries: " + upperLeft + lowerRight);
        long start = System.currentTimeMillis();
        this.lst.drawTile(scale, width, height, this.vmaptype, this.warehouse, upperLeft, lowerRight);
        long stop = System.currentTimeMillis();
        System.out.println("VMAP2Shape.getRectangle(): read time: " + (double)(stop - start) / 1000.0 + " seconds");
        return this.warehouse.getGraphics();
    }

    public boolean isDoThinning() {
        return this.doThinning;
    }

    public void setDoThinning(boolean doThinning) {
        this.doThinning = doThinning;
    }

    public float getFan_eps() {
        return this.fan_eps;
    }

    public void setFan_eps(float fan_eps) {
        this.fan_eps = fan_eps;
    }

    public LibrarySelectionTable getLst() {
        return this.lst;
    }

    public void setLst(LibrarySelectionTable lst) {
        this.lst = lst;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public String getPropsFileName() {
        return this.propsFileName;
    }

    public void setPropsFileName(String propsFileName) {
        this.propsFileName = propsFileName;
    }

    public float getThreshold() {
        return this.threshold;
    }

    public void setThreshold(float threshold) {
        this.threshold = threshold;
    }

    public String getVmaptype() {
        return this.vmaptype;
    }

    public void setVmaptype(String vmaptype) {
        this.vmaptype = vmaptype;
    }

    public LayerGraphicWarehouseSupport getWarehouse() {
        return this.warehouse;
    }

    public void setWarehouse(LayerGraphicWarehouseSupport warehouse) {
        this.warehouse = warehouse;
    }

    public float getZero_eps() {
        return this.zero_eps;
    }

    public void setZero_eps(float zero_eps) {
        this.zero_eps = zero_eps;
    }

    public static void usage() {
        System.out.println("Usage: java VMAP2Shape [args] <outfile.shp>");
        System.out.println("Arguments:");
        System.out.println("\t-props <path>             path to properties file");
        System.out.println("                            default: " + DEF_PROPS_FILE_NAME);
        System.out.println("\t-prefix <identifier>      vmap properties prefix");
        System.out.println("                            default: vmapref");
        System.out.println("\t-thin <eps> <thresh>      do thinning");
        System.out.println("                            default eps=0.1 thresh=0.5");
        System.exit(1);
    }

    public static void main(String[] args) {
        if (args.length == 0 || args.length == 1 && args[0].startsWith("-")) {
            VMAP2Shape.usage();
        }
        Debug.init(System.getProperties());
        VMAP2Shape c = new VMAP2Shape();
        for (int i = 0; i < args.length - 1; ++i) {
            if (args[i].equalsIgnoreCase("-props")) {
                c.setPropsFileName(args[++i]);
                continue;
            }
            if (args[i].equalsIgnoreCase("-prefix")) {
                c.setPrefix(args[++i]);
                continue;
            }
            if (args[i].equalsIgnoreCase("-thin")) {
                c.setDoThinning(true);
                c.setFan_eps(Float.valueOf(args[++i]).floatValue());
                c.setThreshold(Float.valueOf(args[++i]).floatValue());
                continue;
            }
            VMAP2Shape.usage();
        }
        c.writeShapeFile(args[args.length - 1]);
    }
}

