/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.policy;

import com.bbn.openmap.event.ProjectionEvent;
import com.bbn.openmap.layer.OMGraphicHandlerLayer;
import com.bbn.openmap.layer.policy.ProjectionChangePolicy;
import com.bbn.openmap.omGraphics.OMGraphicList;
import com.bbn.openmap.proj.Projection;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ListResetPCPolicy
implements ProjectionChangePolicy {
    protected Logger logger = Logger.getLogger("com.bbn.openmap.layer.policy.ProjectionChangePolicy");
    protected OMGraphicHandlerLayer layer;

    public ListResetPCPolicy() {
    }

    public ListResetPCPolicy(OMGraphicHandlerLayer layer) {
        this.layer = layer;
    }

    public void setLayer(OMGraphicHandlerLayer l) {
        this.layer = l;
    }

    public OMGraphicHandlerLayer getLayer() {
        return this.layer;
    }

    public void projectionChanged(ProjectionEvent pe) {
        if (this.layer != null) {
            Projection proj = this.layer.setProjection(pe);
            if (proj != null) {
                if (this.logger.isLoggable(Level.FINE)) {
                    this.logger.fine(this.getLayer().getName() + ": projectionChanged with NEW projection, resetting list.");
                }
                this.layer.setList(null);
                if (this.layer.isProjectionOK(proj)) {
                    this.layer.doPrepare();
                }
            } else {
                if (this.logger.isLoggable(Level.FINE)) {
                    this.logger.fine(this.getLayer().getName() + ": projectionChanged with OLD projection, repainting.");
                }
                if (!this.layer.isWorking()) {
                    this.layer.repaint();
                    this.layer.fireStatusUpdate(8359);
                }
            }
        } else {
            this.logger.warning("NULL layer, can't do anything.");
        }
    }

    public void workerComplete(OMGraphicList aList) {
        if (this.layer != null) {
            this.layer.setList(aList);
        }
    }
}

