/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.graphicLoader;

import com.bbn.openmap.dataAccess.dted.DTEDFrameCache;
import com.bbn.openmap.graphicLoader.GLPoint;
import com.bbn.openmap.graphicLoader.MMLGraphicLoader;
import com.bbn.openmap.graphicLoader.PathGLPoint;
import com.bbn.openmap.omGraphics.BasicStrokeEditor;
import com.bbn.openmap.omGraphics.GraphicAttributes;
import com.bbn.openmap.omGraphics.OMAction;
import com.bbn.openmap.omGraphics.OMGraphic;
import com.bbn.openmap.omGraphics.OMGraphicHandler;
import com.bbn.openmap.omGraphics.OMGraphicList;
import com.bbn.openmap.omGraphics.OMLine;
import com.bbn.openmap.omGraphics.OMPoint;
import com.bbn.openmap.omGraphics.OMPoly;
import com.bbn.openmap.proj.DrawUtil;
import com.bbn.openmap.proj.coords.LatLonPoint;
import com.bbn.openmap.tools.drawing.DrawingToolRequestor;
import com.bbn.openmap.tools.drawing.OMDrawingTool;
import com.bbn.openmap.tools.terrain.LOSGenerator;
import com.bbn.openmap.util.Debug;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Point2D;
import java.util.HashMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;

public class LOSGraphicLoader
extends MMLGraphicLoader
implements ActionListener,
DrawingToolRequestor {
    protected DTEDFrameCache dfc = null;
    protected LOSGenerator los;
    protected OMDrawingTool dt = null;
    public static final String AddNodeCmd = "AddNodeCommand";
    public static final String AddPathCmd = "AddPathCommand";
    HashMap points = new HashMap();
    protected int updateInterval = 3000;
    JCheckBox timerButton = null;
    JButton addNodeButton = null;
    JButton addPathButton = null;
    public static int pointCount = 1;

    public LOSGraphicLoader() {
        this.setName("LOS Demo");
    }

    public LOSGraphicLoader(OMGraphicHandler receiver) {
        this.setReceiver(receiver);
    }

    public LOSGraphicLoader(DTEDFrameCache dfc, OMGraphicHandler receiver) {
        this(receiver);
        this.setDTEDFrameCache(dfc);
        this.manageGraphics();
    }

    public void manageGraphics() {
        OMGraphicList list = new OMGraphicList();
        for (GLPoint mp : this.points.values()) {
            mp.move(40.0f);
            mp.resetConnected();
            list.add(mp);
        }
        for (String mpName : this.points.keySet()) {
            GLPoint mp;
            mp = (GLPoint)this.points.get(mpName);
            for (GLPoint mp2 : this.points.values()) {
                if (mp2 == mp) continue;
                this.isLOS(mp, mp2, list);
            }
        }
        if (this.receiver != null) {
            Debug.message("graphicloader", "LOSGraphicLoader.manageGraphics: Updating graphics.");
            this.receiver.setList(list);
        } else {
            Debug.message("graphicloader", "LOSGraphicLoader.manageGraphics: no receiver to notify.");
        }
    }

    public boolean isLOS(GLPoint pt1, GLPoint pt2, OMGraphicList list) {
        boolean ret = false;
        if (this.los != null) {
            boolean isLOS;
            int numPoints = 2;
            if (this.proj != null) {
                Point2D p1 = this.proj.forward(pt1.getLat(), pt1.getLon());
                Point2D p2 = this.proj.forward(pt2.getLat(), pt2.getLon());
                numPoints = (int)DrawUtil.distance(p1.getX(), p1.getY(), p2.getX(), p2.getY()) / 2;
            }
            if (isLOS = this.los.isLOS(new LatLonPoint.Double(pt1.getLat(), pt1.getLon()), pt1.getHeight(), new LatLonPoint.Double(pt2.getLat(), pt2.getLon()), pt2.getHeight(), numPoints)) {
                OMLine line = new OMLine(pt1.getLat(), pt1.getLon(), pt2.getLat(), pt2.getLon(), 3);
                line.setLinePaint(GLPoint.CONNECTED_COLOR);
                list.add(line);
                ret = isLOS;
            }
        } else {
            Debug.message("graphicloader", "LOSGraphicLoader doesn't have a LOSGenerator");
        }
        pt1.connected(ret);
        pt2.connected(ret);
        return ret;
    }

    public void actionPerformed(ActionEvent ae) {
        String cmd = ae.getActionCommand();
        if (cmd == "TimerCommand") {
            JCheckBox check = (JCheckBox)ae.getSource();
            if (check.isSelected()) {
                this.timer.restart();
            } else {
                this.timer.stop();
            }
        } else if (cmd == AddNodeCmd) {
            if (this.dt != null) {
                GraphicAttributes ga = new GraphicAttributes();
                ga.setRenderType(1);
                OMPoint pt = (OMPoint)this.dt.create("com.bbn.openmap.omGraphics.OMPoint", ga, this, false);
                if (pt != null) {
                    this.getTimer().stop();
                    pt.setRadius(5);
                    pt.setOval(true);
                    pt.setFillPaint(Color.red);
                    this.addNodeButton.setEnabled(false);
                    this.addPathButton.setEnabled(false);
                }
            }
        } else if (cmd == AddPathCmd) {
            if (this.dt != null) {
                GraphicAttributes ga = new GraphicAttributes();
                ga.setRenderType(1);
                ga.setLineType(3);
                OMPoly poly = (OMPoly)this.dt.create("com.bbn.openmap.omGraphics.OMPoly", ga, this, true);
                if (poly != null) {
                    this.getTimer().stop();
                    BasicStrokeEditor bse = new BasicStrokeEditor();
                    bse.setDash(new float[]{5.0f, 5.0f});
                    ga.setStroke(bse.getBasicStroke());
                    ga.setLinePaint(Color.yellow);
                    this.addNodeButton.setEnabled(false);
                    this.addPathButton.setEnabled(false);
                }
            }
        } else {
            this.manageGraphics();
        }
    }

    public void setDrawingTool(OMDrawingTool drawingTool) {
        this.dt = drawingTool;
        if (this.addNodeButton != null) {
            this.addNodeButton.setEnabled(drawingTool != null);
        }
        if (this.addPathButton != null) {
            this.addPathButton.setEnabled(drawingTool != null);
        }
    }

    public OMDrawingTool getDrawingTool() {
        return this.dt;
    }

    public void setDTEDFrameCache(DTEDFrameCache cache) {
        this.dfc = cache;
        if (cache != null) {
            this.getTimer().start();
            Debug.message("graphicloader", "LOSGraphicLoader starting timer");
            if (this.los == null) {
                this.los = new LOSGenerator(this.dfc);
            } else {
                this.los.setDtedCache(this.dfc);
            }
        }
    }

    public DTEDFrameCache getDTEDFrameCache() {
        return this.dfc;
    }

    public Component getGUI() {
        JPanel panel = new JPanel(new GridLayout(0, 1));
        if (this.addNodeButton == null) {
            this.addNodeButton = new JButton("Add Node...");
            this.addNodeButton.addActionListener(this);
            this.addNodeButton.setActionCommand(AddNodeCmd);
        }
        this.addNodeButton.setEnabled(this.getDrawingTool() != null);
        if (this.addPathButton == null) {
            this.addPathButton = new JButton("Add Path for Node...");
            this.addPathButton.addActionListener(this);
            this.addPathButton.setActionCommand(AddPathCmd);
        }
        this.addPathButton.setEnabled(this.getDrawingTool() != null);
        panel.add(this.addNodeButton);
        panel.add(this.addPathButton);
        if (this.timerButton == null && this.getTimer() != null) {
            this.timerButton = new JCheckBox("Run Timer", this.getTimer().isRunning());
            this.timerButton.addActionListener(this);
            this.timerButton.setActionCommand("TimerCommand");
        }
        panel.add(this.timerButton);
        return panel;
    }

    public void drawingComplete(OMGraphic omg, OMAction action) {
        if (this.timerButton.isSelected()) {
            this.timer.restart();
        }
        if (omg instanceof OMPoint) {
            OMPoint p = (OMPoint)omg;
            GLPoint mp = new GLPoint(p.getLat(), p.getLon(), p.getRadius(), true);
            mp.setName("Added Node " + pointCount++);
            mp.setStationary(true);
            mp.showPalette();
            this.points.put(mp.getName(), mp);
            this.manageGraphics();
        } else if (omg instanceof OMPoly) {
            OMPoly poly = (OMPoly)omg;
            PathGLPoint pmp = new PathGLPoint(poly, 5, true);
            pmp.setName("Added Node " + pointCount++);
            pmp.showPalette();
            this.points.put(pmp.getName(), pmp);
            this.manageGraphics();
        }
        this.addNodeButton.setEnabled(true);
        this.addPathButton.setEnabled(true);
    }

    public void findAndInit(Object obj) {
        if (obj instanceof DTEDFrameCache) {
            Debug.message("graphicloader", "LOSGraphicLoader: found DTEDFrameCache");
            this.setDTEDFrameCache((DTEDFrameCache)obj);
        }
        if (obj instanceof OMDrawingTool) {
            Debug.message("graphicloader", "LOSGraphicLoader: found OMDrawingTool");
            this.setDrawingTool((OMDrawingTool)obj);
        }
    }

    public void findAndUndo(Object obj) {
        if (obj instanceof DTEDFrameCache) {
            Debug.message("graphicloader", "LOSGraphicLoader: removing DTEDFrameCache");
            DTEDFrameCache dfc = this.getDTEDFrameCache();
            if (dfc == obj) {
                this.setDTEDFrameCache(null);
            }
        }
        if (obj instanceof OMDrawingTool) {
            Debug.message("graphicloader", "LOSGraphicLoader: removing OMDrawingTool");
            OMDrawingTool odt = this.getDrawingTool();
            if (odt == obj) {
                this.setDrawingTool(null);
            }
        }
    }
}

