/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.examples.crew;

import com.bbn.openmap.Layer;
import com.bbn.openmap.LayerHandler;
import com.bbn.openmap.MapBean;
import com.bbn.openmap.MapHandler;
import com.bbn.openmap.MouseDelegator;
import com.bbn.openmap.MultipleSoloMapComponentException;
import com.bbn.openmap.event.SelectMouseMode;
import com.bbn.openmap.examples.crew.RouteLayer;
import com.bbn.openmap.gui.LayersPanel;
import com.bbn.openmap.gui.OMToolSet;
import com.bbn.openmap.gui.ToolPanel;
import com.bbn.openmap.layer.shape.ShapeLayer;
import com.bbn.openmap.proj.coords.LatLonPoint;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import javax.swing.JFrame;

public class Crew
extends JFrame {
    public static String crewResources = "Crew.properties";
    private Properties properties;

    public Crew() throws MultipleSoloMapComponentException {
        this(new Properties());
    }

    public Crew(Properties props) throws MultipleSoloMapComponentException {
        super("Crew Example");
        this.getContentPane().setLayout(new BorderLayout());
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                Crew.this.quit();
            }
        });
        this.properties = props;
        MapHandler mapHandler = new MapHandler();
        MapBean map = new MapBean();
        map.setCenter(new LatLonPoint.Double(43.0, -95.0));
        mapHandler.add(map);
        this.getContentPane().add((Component)map, "Center");
        mapHandler.add(new MouseDelegator());
        mapHandler.add(new SelectMouseMode());
        mapHandler.add(new LayerHandler());
        Layer layer = this.createPoliticalLayer();
        if (layer != null) {
            mapHandler.add(layer);
        }
        if ((layer = this.createRouteLayer()) != null) {
            layer.setName("Routes");
            mapHandler.add(layer);
        }
        ToolPanel toolPanel = new ToolPanel();
        mapHandler.add(toolPanel);
        mapHandler.add(new OMToolSet());
        this.getContentPane().add((Component)toolPanel, "North");
        mapHandler.add(new LayersPanel());
    }

    protected Layer createPoliticalLayer() {
        Boolean showPolitical = new Boolean(this.properties.getProperty("showPolitical", "true"));
        if (!showPolitical.booleanValue()) {
            return null;
        }
        ShapeLayer politicalLayer = new ShapeLayer();
        politicalLayer.setProperties("political", this.properties);
        return politicalLayer;
    }

    protected Layer createRouteLayer() {
        return new RouteLayer();
    }

    protected void quit() {
        System.exit(0);
    }

    public static void main(String[] args) {
        Properties crewProps = new Properties();
        InputStream propsIn = Crew.class.getResourceAsStream(crewResources);
        if (propsIn == null) {
            System.err.println("Unable to locate resources: " + crewResources);
            System.err.println("Using default resources.");
        } else {
            try {
                crewProps.load(propsIn);
            }
            catch (IOException e) {
                System.err.println("Caught IOException loading resources: " + crewResources);
                System.err.println("Using default resources.");
            }
        }
        try {
            Crew crew = new Crew(crewProps);
            crew.setSize(700, 500);
            crew.pack();
            crew.setVisible(true);
        }
        catch (MultipleSoloMapComponentException msmce) {
            // empty catch block
        }
    }
}

