/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.event;

import com.bbn.openmap.MapBean;
import com.bbn.openmap.OMComponent;
import com.bbn.openmap.event.MapMouseListener;
import com.bbn.openmap.event.MapMouseMode;
import com.bbn.openmap.event.MapMouseSupport;
import com.bbn.openmap.event.ZoomEvent;
import com.bbn.openmap.util.PropUtils;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.Timer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractMouseMode
extends OMComponent
implements MapMouseMode,
Serializable {
    private static final long serialVersionUID = 1L;
    protected static Logger logger = Logger.getLogger("com.bbn.openmap.event.MapMouseMode");
    protected String ID = null;
    protected MapMouseSupport mouseSupport;
    protected Cursor cursor = Cursor.getDefaultCursor();
    protected transient Icon guiIcon = null;
    protected transient boolean visible = true;
    protected boolean mouseWheelListener = true;
    protected boolean noMouseWheelListenerTimer = false;
    protected String prettyName;
    protected String iconName;
    protected boolean zoomWhenMouseWheelUp = true;
    protected PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    public static final boolean ZOOM_IN = true;
    public static final boolean ZOOM_OUT = false;
    public static final String IDProperty = "id";
    public static final String PrettyNameProperty = "prettyName";
    public static final String CursorIDProperty = "cursorID";
    public static final String IconProperty = "icon";
    public static final String MouseWheelZoomProperty = "mouseWheelUp";
    public static final String MouseWheelListenerProperty = "mouseWheelListener";
    public static final String NoMouseWheelListenerTimerProperty = "noMouseWheelListenerTimer";
    public static final String MouseWheelTimerIntervalProperty = "mouseWheelTimerInterval";
    protected int mouseWheelTimerInterval = 60;
    protected Timer mouseTimer = null;
    protected MouseWheelTimerListener mouseWheelTimerListener = new MouseWheelTimerListener();

    public AbstractMouseMode() {
        this("Unnamed Mode", true);
    }

    public AbstractMouseMode(String name, boolean shouldConsumeEvents) {
        this.mouseSupport = new MapMouseSupport(this, shouldConsumeEvents);
        this.ID = name;
        this.setIconName(name + ".gif");
    }

    protected Class<?> getClassToUseForIconRetrieval() {
        return this.getClass();
    }

    public void setIconName(String iName) {
        this.iconName = iName;
        URL url = null;
        try {
            url = PropUtils.getResourceOrFileOrURL(iName);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        if (url == null) {
            url = this.getClassToUseForIconRetrieval().getResource(this.iconName);
        }
        if (url != null) {
            this.guiIcon = new ImageIcon(url);
        }
    }

    public String getIconName() {
        return this.iconName;
    }

    @Override
    public String getID() {
        return this.ID;
    }

    public void setID(String id) {
        this.ID = id;
    }

    public void setPrettyName(String pn) {
        this.prettyName = pn;
    }

    @Override
    public String getPrettyName() {
        if (this.prettyName == null) {
            return this.i18n.get(this.getClass(), PrettyNameProperty, this.ID);
        }
        return this.prettyName;
    }

    @Override
    public Cursor getModeCursor() {
        return this.cursor;
    }

    public void setModeCursor(Cursor curs) {
        this.cursor = curs;
    }

    public void setModeCursor(String cursorID) {
        if (cursorID != null) {
            try {
                int cid = Cursor.class.getField(cursorID).getInt(null);
                this.setModeCursor(Cursor.getPredefinedCursor(cid));
            }
            catch (NoSuchFieldException nsfe) {
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
    }

    @Override
    public Icon getGUIIcon() {
        return this.guiIcon;
    }

    public void setGUIIcon(Icon icon) {
        this.guiIcon = icon;
    }

    public void setConsumeEvents(boolean value) {
        this.mouseSupport.setConsumeEvents(value);
    }

    public boolean isConsumeEvents() {
        return this.mouseSupport.isConsumeEvents();
    }

    public boolean isZoomWhenMouseWheelUp() {
        return this.zoomWhenMouseWheelUp;
    }

    public void setZoomWhenMouseWheelUp(boolean zoomWhenMouseWheelUp) {
        this.zoomWhenMouseWheelUp = zoomWhenMouseWheelUp;
    }

    @Override
    public void addMapMouseListener(MapMouseListener l) {
        this.mouseSupport.add(l);
    }

    @Override
    public void removeMapMouseListener(MapMouseListener l) {
        this.mouseSupport.remove(l);
    }

    @Override
    public void removeAllMapMouseListeners() {
        this.mouseSupport.clear();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        this.mouseSupport.fireMapMouseClicked(e);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        e.getComponent().requestFocus();
        this.mouseSupport.fireMapMousePressed(e);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.mouseSupport.fireMapMouseReleased(e);
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.mouseSupport.fireMapMouseEntered(e);
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.mouseSupport.fireMapMouseExited(e);
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.mouseSupport.fireMapMouseDragged(e);
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.mouseSupport.fireMapMouseMoved(e);
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        if (this.mouseWheelListener) {
            int rot = e.getWheelRotation();
            if (e.getSource() instanceof MapBean) {
                MapBean mb = (MapBean)e.getSource();
                boolean direction = this.isZoomWhenMouseWheelUp();
                float zoomIn = 1.1f;
                float zoomOut = 0.9f;
                float amount = zoomIn;
                if (direction && rot < 0 || !direction && rot > 0) {
                    amount = zoomOut;
                }
                if (this.noMouseWheelListenerTimer) {
                    this.updateMouseWheelMoved(mb, mb.getScale() * amount);
                } else {
                    if (this.mouseTimer == null) {
                        this.mouseTimer = new Timer(this.mouseWheelTimerInterval, this.mouseWheelTimerListener);
                        this.mouseTimer.setRepeats(false);
                    }
                    this.mouseWheelTimerListener.addAmount(mb, amount);
                    this.mouseTimer.restart();
                }
            }
        }
    }

    public void updateMouseWheelMoved(MapBean mb, float value) {
        if (mb != null) {
            mb.zoom(new ZoomEvent(mb, 302, value));
        }
    }

    public boolean isMouseWheelListener() {
        return this.mouseWheelListener;
    }

    public void setMouseWheelListener(boolean mouseWheelListener) {
        this.mouseWheelListener = mouseWheelListener;
    }

    @Override
    public void setActive(boolean active) {
    }

    public void setMouseSupport(MapMouseSupport support) {
        this.mouseSupport = support;
    }

    public MapMouseSupport getMouseSupport() {
        return this.mouseSupport;
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean value) {
        this.visible = value;
    }

    @Override
    public boolean actAsProxyFor(MapMouseMode mmm) {
        return this.actAsProxyFor(mmm, 0);
    }

    @Override
    public boolean actAsProxyFor(MapMouseMode mmm, int pdm) {
        MapMouseMode omm = this.mouseSupport.getProxied();
        boolean ret = false;
        if (!(omm == null && mmm == null || mmm == null || mmm.equals(omm))) {
            ret = this.mouseSupport.setProxyFor(mmm, pdm);
            this.propertyChangeSupport.firePropertyChange("MouseModeProxy", omm, mmm);
        }
        return ret;
    }

    @Override
    public boolean isProxyFor(MapMouseMode mmm) {
        return this.mouseSupport.isProxyFor(mmm);
    }

    @Override
    public void releaseProxy() {
        MapMouseMode mmm = this.mouseSupport.getProxied();
        if (mmm != null) {
            this.mouseSupport.releaseProxy();
            this.propertyChangeSupport.firePropertyChange("MouseModeProxy", mmm, null);
        }
    }

    @Override
    public void setProxyDistributionMask(int mask) {
        this.mouseSupport.setProxyDistributionMask(mask);
    }

    @Override
    public MapMouseMode getProxied() {
        return this.mouseSupport.getProxied();
    }

    @Override
    public int getProxyDistributionMask() {
        return this.mouseSupport.getProxyDistributionMask();
    }

    @Override
    public void setProperties(String prefix, Properties props) {
        String idString;
        super.setProperties(prefix, props);
        prefix = PropUtils.getScopedPropertyPrefix(prefix);
        String prettyNameString = props.getProperty(prefix + PrettyNameProperty);
        if (prettyNameString != null) {
            this.setPrettyName(prettyNameString);
        }
        if ((idString = props.getProperty(prefix + IDProperty)) != null) {
            this.setID(idString);
        }
        this.setModeCursor(props.getProperty(prefix + CursorIDProperty));
        String iconString = props.getProperty(prefix + IconProperty);
        if (iconString != null) {
            this.setIconName(iconString);
        }
        this.mouseWheelListener = PropUtils.booleanFromProperties(props, prefix + MouseWheelListenerProperty, this.mouseWheelListener);
        this.zoomWhenMouseWheelUp = PropUtils.booleanFromProperties(props, prefix + MouseWheelZoomProperty, this.zoomWhenMouseWheelUp);
        String zwmwu = props.getProperty(prefix + MouseWheelZoomProperty);
        if (zwmwu != null) {
            try {
                boolean zSetting = this.getClass().getField(zwmwu).getBoolean(null);
                this.setZoomWhenMouseWheelUp(zSetting);
            }
            catch (NoSuchFieldException nsfe) {
            }
            catch (IllegalAccessException iae) {
                // empty catch block
            }
        }
        this.noMouseWheelListenerTimer = PropUtils.booleanFromProperties(props, prefix + NoMouseWheelListenerTimerProperty, this.noMouseWheelListenerTimer);
        this.mouseWheelTimerInterval = PropUtils.intFromProperties(props, prefix + MouseWheelTimerIntervalProperty, this.mouseWheelTimerInterval);
    }

    @Override
    public Properties getProperties(Properties props) {
        props = super.getProperties(props);
        String prefix = PropUtils.getScopedPropertyPrefix(this);
        if (this.prettyName != null) {
            props.put(prefix + PrettyNameProperty, this.prettyName);
        }
        props.put(prefix + IDProperty, this.getID());
        int cursorType = this.getModeCursor().getType();
        Field[] cFields = Cursor.class.getFields();
        for (int i = 0; i < cFields.length; ++i) {
            Field f = cFields[i];
            String name = f.getName();
            if (!name.endsWith("_CURSOR")) continue;
            try {
                int testType = f.getInt(null);
                if (testType != cursorType) continue;
                props.put(prefix + CursorIDProperty, name);
                break;
            }
            catch (IllegalArgumentException e) {
                continue;
            }
            catch (IllegalAccessException e) {
                // empty catch block
            }
        }
        if (this.zoomWhenMouseWheelUp) {
            props.put(prefix + MouseWheelZoomProperty, "ZOOM_IN");
        } else {
            props.put(prefix + MouseWheelZoomProperty, "ZOOM_OUT");
        }
        props.put(prefix + MouseWheelListenerProperty, Boolean.toString(this.mouseWheelListener));
        props.put(prefix + IconProperty, PropUtils.unnull(this.getIconName()));
        props.put(prefix + NoMouseWheelListenerTimerProperty, Boolean.toString(this.noMouseWheelListenerTimer));
        props.put(prefix + MouseWheelTimerIntervalProperty, Integer.toString(this.mouseWheelTimerInterval));
        return props;
    }

    @Override
    public Properties getPropertyInfo(Properties props) {
        props = super.getPropertyInfo(props);
        Class<?> thisClass = this.getClass();
        String internString = this.i18n.get(thisClass, PrettyNameProperty, 3, "Presentable name for Mouse Mode.");
        props.put("addToBeanContext", internString);
        internString = this.i18n.get(thisClass, PrettyNameProperty, "Name");
        props.put("prettyName.label", internString);
        internString = this.i18n.get(thisClass, IDProperty, 3, "Internal ID for Mouse Mode, used by Layers.");
        props.put("addToBeanContext", internString);
        internString = this.i18n.get(thisClass, IDProperty, "ID");
        props.put("id.label", internString);
        PropUtils.setI18NPropertyInfo(this.i18n, props, thisClass, IconProperty, "Icon", "Icon to use for mouse mode.", null);
        PropUtils.setI18NPropertyInfo(this.i18n, props, thisClass, MouseWheelZoomProperty, "Mouse Wheel Zoom Direction", "Action to take when the mouse wheel is rolled up.", "com.bbn.openmap.util.propertyEditor.ComboBoxPropertyEditor");
        props.put("mouseWheelUp.options", "zoomin  zoomout");
        props.put("mouseWheelUp.zoomin", "ZOOM_IN");
        props.put("mouseWheelUp.zoomout", "ZOOM_OUT");
        PropUtils.setI18NPropertyInfo(this.i18n, props, thisClass, MouseWheelListenerProperty, "Mouse Wheel Zoom", "Setting for whether mouse wheel controls map zoom", "com.bbn.openmap.util.propertyEditor.YesNoPropertyEditor");
        PropUtils.setI18NPropertyInfo(this.i18n, props, thisClass, CursorIDProperty, "Cursor", "Cursor to use for this mouse mode.", "com.bbn.openmap.util.propertyEditor.ComboBoxPropertyEditor");
        PropUtils.setI18NPropertyInfo(this.i18n, props, thisClass, NoMouseWheelListenerTimerProperty, "No Mouse Wheel Listener Timer", "Setting for whether a timer is used with the mouse wheel controller", "com.bbn.openmap.util.propertyEditor.YesNoPropertyEditor");
        PropUtils.setI18NPropertyInfo(this.i18n, props, thisClass, MouseWheelTimerIntervalProperty, "Mouse Wheel Timer Interval", "Setting for the wait interval for the mouse wheel timer", null);
        StringBuffer cOptions = new StringBuffer();
        Field[] cFields = Cursor.class.getFields();
        for (int i = 0; i < cFields.length; ++i) {
            Field f = cFields[i];
            String name = f.getName();
            if (!name.endsWith("_CURSOR")) continue;
            String cName = f.getName();
            props.put("cursorID." + cName, cName);
            cOptions.append(" ").append(cName);
        }
        props.put("cursorID.options", cOptions.toString().trim());
        return props;
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    @Override
    public void listenerPaint(Graphics g) {
    }

    public void setNoMouseWheelListener(boolean val) {
        this.noMouseWheelListenerTimer = val;
    }

    public boolean getNoMouseWheelListener() {
        return this.noMouseWheelListenerTimer;
    }

    public void setMouseWheelTimerInterval(int interval) {
        this.mouseWheelTimerInterval = interval;
        if (this.mouseTimer != null) {
            this.mouseTimer.setInitialDelay(this.mouseWheelTimerInterval);
        }
    }

    public int getMouseWheelTimerInterval() {
        return this.mouseWheelTimerInterval;
    }

    public boolean isNoMouseWheelListenerTimer() {
        return this.noMouseWheelListenerTimer;
    }

    public void setNoMouseWheelListenerTimer(boolean noMouseWheelListenerTimer) {
        this.noMouseWheelListenerTimer = noMouseWheelListenerTimer;
    }

    protected class MouseWheelTimerListener
    implements ActionListener {
        float newScale = 0.0f;
        MapBean mapBean;

        protected MouseWheelTimerListener() {
        }

        public synchronized void addAmount(MapBean map, float amount) {
            this.mapBean = map;
            this.newScale = this.newScale == 0.0f ? map.getScale() * amount : (this.newScale *= amount);
        }

        public synchronized void actionPerformed(ActionEvent ae) {
            if (this.newScale != 0.0f) {
                AbstractMouseMode.this.updateMouseWheelMoved(this.mapBean, this.newScale);
                this.newScale = 0.0f;
            }
        }
    }
}

