/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.util.quadtree;

import com.bbn.openmap.util.quadtree.MutableDistance;
import com.bbn.openmap.util.quadtree.QuadTreeLeaf;
import com.bbn.openmap.util.quadtree.QuadTreeRect;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;

public class QuadTreeNode
implements Serializable {
    static final long serialVersionUID = -6111633198469889444L;
    public static final int NORTHWEST = 0;
    public static final int NORTHEAST = 1;
    public static final int SOUTHEAST = 2;
    public static final int SOUTHWEST = 3;
    public static final float NO_MIN_SIZE = -1.0f;
    public static final float DEFAULT_MIN_SIZE = 5.0f;
    protected Vector items;
    protected QuadTreeNode[] children;
    protected int maxItems;
    protected float minSize;
    public QuadTreeRect bounds;
    protected boolean allTheSamePoint;
    protected float firstLat;
    protected float firstLon;

    public QuadTreeNode(float north, float west, float south, float east, int maximumItems) {
        this(north, west, south, east, maximumItems, -1.0f);
    }

    public QuadTreeNode(float north, float west, float south, float east, int maximumItems, float minimumSize) {
        this.bounds = new QuadTreeRect(north, west, south, east);
        this.maxItems = maximumItems;
        this.minSize = minimumSize;
        this.items = new Vector();
    }

    public boolean hasChildren() {
        return this.children != null;
    }

    protected void split() {
        if (this.minSize != -1.0f && Math.abs(this.bounds.north - this.bounds.south) < this.minSize && Math.abs(this.bounds.east - this.bounds.west) < this.minSize) {
            return;
        }
        float nsHalf = (float)((double)this.bounds.north - (double)(this.bounds.north - this.bounds.south) / 2.0);
        float ewHalf = (float)((double)this.bounds.east - (double)(this.bounds.east - this.bounds.west) / 2.0);
        this.children = new QuadTreeNode[4];
        this.children[0] = new QuadTreeNode(this.bounds.north, this.bounds.west, nsHalf, ewHalf, this.maxItems);
        this.children[1] = new QuadTreeNode(this.bounds.north, ewHalf, nsHalf, this.bounds.east, this.maxItems);
        this.children[2] = new QuadTreeNode(nsHalf, ewHalf, this.bounds.south, this.bounds.east, this.maxItems);
        this.children[3] = new QuadTreeNode(nsHalf, this.bounds.west, this.bounds.south, ewHalf, this.maxItems);
        Vector temp = (Vector)this.items.clone();
        this.items.removeAllElements();
        Enumeration things = temp.elements();
        while (things.hasMoreElements()) {
            this.put((QuadTreeLeaf)things.nextElement());
        }
    }

    protected QuadTreeNode getChild(float lat, float lon) {
        if (this.bounds.pointWithinBounds(lat, lon)) {
            if (this.children != null) {
                for (int i = 0; i < this.children.length; ++i) {
                    if (!this.children[i].bounds.pointWithinBounds(lat, lon)) continue;
                    return this.children[i].getChild(lat, lon);
                }
            } else {
                return this;
            }
        }
        return null;
    }

    public boolean put(float lat, float lon, Object obj) {
        return this.put(new QuadTreeLeaf(lat, lon, obj));
    }

    public boolean put(QuadTreeLeaf leaf) {
        if (this.children == null) {
            this.items.addElement(leaf);
            if (this.items.size() == 1) {
                this.allTheSamePoint = true;
                this.firstLat = leaf.latitude;
                this.firstLon = leaf.longitude;
            } else if (this.firstLat != leaf.latitude || this.firstLon != leaf.longitude) {
                this.allTheSamePoint = false;
            }
            if (this.items.size() > this.maxItems && !this.allTheSamePoint) {
                this.split();
            }
            return true;
        }
        QuadTreeNode node = this.getChild(leaf.latitude, leaf.longitude);
        if (node != null) {
            return node.put(leaf);
        }
        return false;
    }

    public Object remove(float lat, float lon, Object obj) {
        return this.remove(new QuadTreeLeaf(lat, lon, obj));
    }

    public Object remove(QuadTreeLeaf leaf) {
        if (this.children == null) {
            for (int i = 0; i < this.items.size(); ++i) {
                QuadTreeLeaf qtl = (QuadTreeLeaf)this.items.elementAt(i);
                if (leaf.object != qtl.object) continue;
                this.items.removeElementAt(i);
                return qtl.object;
            }
        } else {
            QuadTreeNode node = this.getChild(leaf.latitude, leaf.longitude);
            if (node != null) {
                return node.remove(leaf);
            }
        }
        return null;
    }

    public void clear() {
        this.items.removeAllElements();
        if (this.children != null) {
            for (int i = 0; i < this.children.length; ++i) {
                this.children[i].clear();
            }
            this.children = null;
        }
    }

    public Object get(float lat, float lon) {
        return this.get(lat, lon, Double.POSITIVE_INFINITY);
    }

    public Object get(float lat, float lon, double withinDistance) {
        return this.get(lat, lon, new MutableDistance(withinDistance));
    }

    public Object get(float lat, float lon, MutableDistance bestDistance) {
        Object closest = null;
        if (this.children == null) {
            Enumeration things = this.items.elements();
            while (things.hasMoreElements()) {
                QuadTreeLeaf qtl = (QuadTreeLeaf)things.nextElement();
                double distance = Math.sqrt(Math.pow(Math.abs(lat - qtl.latitude), 2.0) + Math.pow(Math.abs(lon - qtl.longitude), 2.0));
                if (!(distance < bestDistance.value)) continue;
                bestDistance.value = distance;
                closest = qtl.object;
            }
            return closest;
        }
        for (int i = 0; i < this.children.length; ++i) {
            Object test;
            double childDistance = this.children[i].bounds.borderDistance(lat, lon);
            if (!(childDistance < bestDistance.value) || (test = this.children[i].get(lat, lon, bestDistance)) == null) continue;
            closest = test;
        }
        return closest;
    }

    public Vector get(float north, float west, float south, float east) {
        return this.get(new QuadTreeRect(north, west, south, east), new Vector());
    }

    public Vector get(float north, float west, float south, float east, Vector vector) {
        return this.get(new QuadTreeRect(north, west, south, east), vector);
    }

    public Vector get(QuadTreeRect rect, Vector vector) {
        if (this.children == null) {
            Enumeration things = this.items.elements();
            while (things.hasMoreElements()) {
                QuadTreeLeaf qtl = (QuadTreeLeaf)things.nextElement();
                if (!rect.pointWithinBounds(qtl.latitude, qtl.longitude)) continue;
                vector.addElement(qtl.object);
            }
        } else {
            for (int i = 0; i < this.children.length; ++i) {
                if (!this.children[i].bounds.within(rect)) continue;
                this.children[i].get(rect, vector);
            }
        }
        return vector;
    }
}

