/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.util.coordFormatter;

import com.bbn.openmap.OMComponent;
import com.bbn.openmap.util.ComponentFactory;
import com.bbn.openmap.util.PropUtils;
import com.bbn.openmap.util.coordFormatter.CoordInfoFormatter;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Vector;

public class CoordInfoFormatterHandler
extends OMComponent {
    protected List formatters = new ArrayList();
    protected CoordInfoFormatter activeFormatter = null;
    public static final String FORMATTER_PROPERTY = "formatters";

    public void setProperties(String prefix, Properties props) {
        super.setProperties(prefix, props);
        String realPrefix = PropUtils.getScopedPropertyPrefix(prefix);
        String markerList = props.getProperty(realPrefix + FORMATTER_PROPERTY);
        if (markerList != null) {
            Vector formatterV = PropUtils.parseSpacedMarkers(markerList);
            Vector formatters = ComponentFactory.create(formatterV, prefix, props);
            Iterator it = formatters.iterator();
            while (it.hasNext()) {
                Object obj = it.next();
                CoordInfoFormatter cif = (CoordInfoFormatter)obj;
                if (this.activeFormatter == null) {
                    this.activeFormatter = cif;
                }
                this.formatters.add(cif);
            }
        }
    }

    public Properties getProperties(Properties props) {
        props = super.getProperties(props);
        String prefix = PropUtils.getScopedPropertyPrefix(this);
        StringBuffer markerList = new StringBuffer();
        Iterator it = this.formatters.iterator();
        while (it.hasNext()) {
            CoordInfoFormatter cif = (CoordInfoFormatter)it.next();
            cif.getProperties(props);
            markerList.append(cif.getPropertyPrefix() + " ");
            props.put(PropUtils.getScopedPropertyPrefix(cif), cif.getClass().getName());
        }
        props.put(prefix + FORMATTER_PROPERTY, markerList.toString().trim());
        return props;
    }

    public Properties getPropertyInfo(Properties props) {
        props = super.getPropertyInfo(props);
        return props;
    }

    public void setActiveFormatter(CoordInfoFormatter formatter) {
        CoordInfoFormatter oldFormatter = this.activeFormatter;
        if (oldFormatter == formatter) {
            return;
        }
        this.activeFormatter = formatter;
        this.firePropertyChange(FORMATTER_PROPERTY, oldFormatter, this.activeFormatter);
    }

    public void addPropertyChangeListener(String property, PropertyChangeListener pcl) {
        super.addPropertyChangeListener(property, pcl);
        pcl.propertyChange(new PropertyChangeEvent(this, FORMATTER_PROPERTY, null, this.activeFormatter));
    }
}

