/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.util;

import com.bbn.openmap.Layer;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.InternalFrameListener;

public class PaletteHelper {
    private PaletteHelper() {
    }

    public static JPanel createCheckbox(String boxlabel, String[] buttons, boolean[] checked, ActionListener al) {
        JPanel jp = PaletteHelper.createPaletteJPanel(boxlabel);
        for (int j = 0; j < buttons.length; ++j) {
            JCheckBox jcb = new JCheckBox(buttons[j]);
            jcb.setActionCommand(Integer.toString(j));
            if (al != null) {
                jcb.addActionListener(al);
            }
            jcb.setSelected(checked[j]);
            jp.add(jcb);
        }
        return jp;
    }

    public static JPanel createRadiobox(String boxlabel, String[] buttons, int initiallySelected, ActionListener al) {
        JPanel jp = PaletteHelper.createPaletteJPanel(boxlabel);
        ButtonGroup buttongroup = new ButtonGroup();
        for (int j = 0; j < buttons.length; ++j) {
            JRadioButton jrb = new JRadioButton(buttons[j]);
            jrb.setActionCommand("" + j);
            jp.add(jrb);
            buttongroup.add(jrb);
            if (al != null) {
                jrb.addActionListener(al);
            }
            if (j == initiallySelected) {
                jrb.setSelected(true);
                continue;
            }
            jrb.setSelected(false);
        }
        return jp;
    }

    public static JPanel createHorizontalPanel(String title) {
        JPanel panel = new JPanel();
        panel.setLayout(new GridLayout(1, 0));
        if (title != null) {
            panel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), title));
        } else {
            panel.setBorder(BorderFactory.createEtchedBorder());
        }
        return panel;
    }

    public static JPanel createVerticalPanel(String title) {
        JPanel panel = new JPanel();
        panel.setLayout(new GridLayout(0, 1));
        if (title != null) {
            panel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), title));
        } else {
            panel.setBorder(BorderFactory.createEtchedBorder());
        }
        return panel;
    }

    public static JPanel createPaletteJPanel(String title) {
        JPanel panel = new JPanel();
        if (title != null) {
            panel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), title));
        } else {
            panel.setBorder(BorderFactory.createEtchedBorder());
        }
        panel.setLayout(new GridLayout(0, 1));
        return panel;
    }

    public static JTextField createTextEntry(String title, String entry, JComponent parent) {
        JPanel pal = PaletteHelper.createHorizontalPanel(null);
        JLabel label = new JLabel(title);
        label.setHorizontalTextPosition(4);
        JTextField tf = new JTextField(entry);
        label.setLabelFor(tf);
        pal.add(label);
        pal.add(tf);
        parent.add(pal);
        return tf;
    }

    public static JTextArea createTextArea(String title, String entry, JComponent parent, int rows, int cols) {
        JPanel pal = PaletteHelper.createHorizontalPanel(null);
        JLabel label = new JLabel(title);
        label.setHorizontalTextPosition(4);
        JTextArea ta = new JTextArea(entry, rows, cols);
        JScrollPane jsp = new JScrollPane(ta);
        label.setLabelFor(jsp);
        pal.add(label);
        pal.add(jsp);
        parent.add(pal);
        return ta;
    }

    public static JInternalFrame getPaletteInternalWindow(Layer layer, InternalFrameListener ifl) {
        return PaletteHelper.getPaletteInternalWindow(layer.getGUI(), layer.getName() + " Palette", ifl);
    }

    public static JFrame getPaletteWindow(Layer layer, ComponentListener cl) {
        Component layerGUI = PaletteHelper.getLayerGUIComponent(layer);
        JPanel dismissBox = new JPanel();
        dismissBox.setLayout(new BoxLayout(dismissBox, 0));
        dismissBox.setAlignmentX(0.0f);
        dismissBox.setAlignmentY(1.0f);
        dismissBox.add(Box.createHorizontalGlue());
        JButton dismiss = new JButton("Close");
        dismissBox.add(dismiss);
        dismissBox.add(Box.createHorizontalGlue());
        JPanel pane = new JPanel();
        pane.setLayout(new BoxLayout(pane, 1));
        pane.setAlignmentX(0.5f);
        pane.setAlignmentY(1.0f);
        pane.add(layerGUI);
        pane.add(dismissBox);
        final JFrame frame = PaletteHelper.getPaletteWindow(pane, layer.getName() + " Palette", cl);
        dismiss.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                frame.setVisible(false);
            }
        });
        return frame;
    }

    public static Component getLayerGUIComponent(Layer layer) {
        Component pal = layer.getGUI();
        if (pal == null) {
            pal = new JLabel("No Palette");
        }
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 1));
        p.setAlignmentX(0.0f);
        p.setAlignmentY(1.0f);
        p.add(pal);
        return p;
    }

    public static JInternalFrame getPaletteInternalWindow(Component gui, String windowName, InternalFrameListener ifl) {
        JScrollPane scrollPane = new JScrollPane(gui, 20, 30);
        scrollPane.setAlignmentX(0.0f);
        scrollPane.setAlignmentY(0.0f);
        JInternalFrame paletteWindow = new JInternalFrame(windowName, true, true, false, true);
        paletteWindow.addInternalFrameListener(ifl);
        paletteWindow.getContentPane().add(scrollPane);
        paletteWindow.setOpaque(true);
        paletteWindow.pack();
        return paletteWindow;
    }

    public static JFrame getPaletteWindow(Component gui, String windowName, ComponentListener cl) {
        JScrollPane scrollPane = new JScrollPane(gui, 20, 30);
        scrollPane.setAlignmentX(0.0f);
        scrollPane.setAlignmentY(0.0f);
        JFrame paletteWindow = new JFrame(windowName);
        paletteWindow.addComponentListener(cl);
        paletteWindow.getContentPane().add(scrollPane);
        paletteWindow.pack();
        return paletteWindow;
    }

    public static JFrame getNoScrollPaletteWindow(Component gui, String windowName, ComponentListener cl) {
        JPanel pane = new JPanel();
        pane.setLayout(new BoxLayout(pane, 1));
        pane.setAlignmentX(0.5f);
        pane.setAlignmentY(1.0f);
        pane.add(gui);
        JFrame paletteWindow = new JFrame(windowName);
        paletteWindow.addComponentListener(cl);
        paletteWindow.getContentPane().add(pane);
        paletteWindow.pack();
        return paletteWindow;
    }
}

