/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.util;

import com.bbn.openmap.PropertyConsumer;
import com.bbn.openmap.event.ProgressSupport;
import com.bbn.openmap.util.Debug;
import com.bbn.openmap.util.PropUtils;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Properties;
import java.util.Vector;

public class ComponentFactory {
    public static final String ClassNameProperty = ".class";
    private static ComponentFactory singleton;

    protected ComponentFactory() {
    }

    protected static ComponentFactory getInstance() {
        if (singleton == null) {
            singleton = new ComponentFactory();
        }
        return singleton;
    }

    protected static void setInstance(ComponentFactory cf) {
        singleton = cf;
    }

    public static Vector create(Vector markerNames, Properties properties) {
        return ComponentFactory.getInstance()._create(markerNames, null, properties, null, false);
    }

    public static Vector create(Vector markerNames, String prefix, Properties properties) {
        return ComponentFactory.getInstance()._create(markerNames, prefix, properties, null, false);
    }

    public static Vector create(Vector markerNames, String prefix, Properties properties, ProgressSupport progressSupport) {
        return ComponentFactory.getInstance()._create(markerNames, prefix, properties, progressSupport, false);
    }

    public static Vector create(Vector markerNames, Properties properties, ProgressSupport progressSupport) {
        return ComponentFactory.getInstance()._create(markerNames, null, properties, progressSupport, false);
    }

    public static Vector create(Vector markerNames, Properties properties, ProgressSupport progressSupport, boolean matchInOutVectorSize) {
        return ComponentFactory.getInstance()._create(markerNames, null, properties, progressSupport, matchInOutVectorSize);
    }

    public static Vector create(Vector markerNames, String prefix, Properties properties, ProgressSupport progressSupport, boolean matchInOutVectorSize) {
        return ComponentFactory.getInstance()._create(markerNames, prefix, properties, progressSupport, matchInOutVectorSize);
    }

    protected Vector _create(Vector markerNames, String prefix, Properties properties, ProgressSupport progressSupport, boolean matchInOutVectorSize) {
        int size = markerNames.size();
        Vector<Object> vector = new Vector<Object>(size);
        if (progressSupport != null) {
            progressSupport.fireUpdate(1, "Creating Components", 100.0f, 0.0f);
        }
        for (int i = 0; i < size; ++i) {
            Object component;
            String componentName = PropUtils.getScopedPropertyPrefix(prefix) + (String)markerNames.elementAt(i);
            String classProperty = componentName + ClassNameProperty;
            String className = properties.getProperty(classProperty);
            if (className == null) {
                Debug.error("ComponentFactory.create: Failed to locate property \"" + componentName + "\" with class \"" + classProperty + "\"\n  Skipping component \"" + componentName + "\"");
                if (!matchInOutVectorSize) continue;
                vector.add(componentName);
                continue;
            }
            if (progressSupport != null) {
                progressSupport.fireUpdate(1, "Creating Components", size, i);
            }
            if ((component = ComponentFactory.create(className, componentName, properties)) != null) {
                vector.add(component);
                if (!Debug.debugging("componentfactory")) continue;
                Debug.output("ComponentFactory: [" + className + "(" + i + ")] created");
                continue;
            }
            if (matchInOutVectorSize) {
                vector.add(componentName);
            }
            Debug.output("ComponentFactory: [" + componentName + " : " + className + "(" + i + ")] NOT created. -- " + "Set 'componentfactory' debug flag for details.");
        }
        if (progressSupport != null) {
            progressSupport.fireUpdate(1, "Configuring...", size, size);
        }
        return vector;
    }

    public static Object create(String className) {
        return ComponentFactory.create(className, (Object[])null, null, null);
    }

    public static Object create(String className, Properties properties) {
        return ComponentFactory.create(className, (Object[])null, null, properties);
    }

    public static Object create(String className, String prefix, Properties properties) {
        return ComponentFactory.create(className, (Object[])null, prefix, properties);
    }

    public static Object create(String className, Object[] constructorArgs) {
        return ComponentFactory.create(className, constructorArgs, null, null, null);
    }

    public static Object create(String className, Object[] constructorArgs, Class[] argClasses) {
        return ComponentFactory.create(className, constructorArgs, argClasses, null, null);
    }

    public static Object create(String className, Object[] constructorArgs, String prefix, Properties properties) {
        return ComponentFactory.create(className, constructorArgs, null, prefix, properties);
    }

    public static Object create(String className, Object[] constructorArgs, Class[] argClasses, String prefix, Properties properties) {
        return ComponentFactory.getInstance()._create(className, constructorArgs, argClasses, prefix, properties);
    }

    protected Object _create(String className, Object[] constructorArgs, Class[] argClasses, String prefix, Properties properties) {
        String errorMessage = null;
        boolean DEBUG = false;
        try {
            Object obj;
            block30: {
                ClassLoader cl;
                if (Debug.debugging("componentfactorydetail")) {
                    DEBUG = true;
                    Debug.output("ComponentFactory.create: " + className);
                }
                if ((cl = Thread.currentThread().getContextClassLoader()) == null) {
                    cl = this.getClass().getClassLoader();
                }
                Class<?> newObjClass = Class.forName(className.trim(), true, cl);
                if (DEBUG) {
                    Debug.output(" - got class for " + className);
                }
                if (argClasses == null) {
                    if (constructorArgs != null && constructorArgs.length > 0) {
                        argClasses = new Class[constructorArgs.length];
                        for (int i = 0; i < argClasses.length; ++i) {
                            argClasses[i] = constructorArgs[i].getClass();
                        }
                    } else {
                        constructorArgs = null;
                    }
                }
                if (DEBUG) {
                    StringBuffer sb = new StringBuffer();
                    if (constructorArgs == null) {
                        sb.append("null");
                    } else {
                        for (int i = 0; i < constructorArgs.length; ++i) {
                            sb.append(constructorArgs[i].getClass().getName());
                            if (i >= constructorArgs.length - 1) continue;
                            sb.append(", ");
                        }
                    }
                    Debug.output(" - created class arguments [" + sb.toString() + "]");
                }
                Constructor<?> constructor = null;
                obj = null;
                try {
                    constructor = newObjClass.getConstructor(argClasses);
                    if (DEBUG) {
                        Debug.output(" - got constructor");
                    }
                    obj = constructor.newInstance(constructorArgs);
                    if (DEBUG) {
                        Debug.output(" - got object");
                    }
                }
                catch (NoSuchMethodException nsmei) {
                    obj = this.createWithSubclassConstructorArgs(newObjClass, argClasses, constructorArgs);
                    if (!DEBUG || obj == null) break block30;
                    Debug.output(" - got object on try #2");
                }
            }
            if (obj instanceof PropertyConsumer && properties != null) {
                if (DEBUG) {
                    Debug.output("  setting properties with prefix \"" + prefix + "\"");
                }
                ((PropertyConsumer)obj).setProperties(prefix, properties);
                if (Debug.debugging("i18n.create")) {
                    ((PropertyConsumer)obj).getPropertyInfo(null);
                }
                if (DEBUG) {
                    Debug.output(" - set properties");
                }
            }
            return obj;
        }
        catch (NoSuchMethodException nsme) {
            errorMessage = "NoSuchMethodException: " + nsme.getMessage();
        }
        catch (InstantiationException ie) {
            errorMessage = "InstantiationException: " + ie.getMessage() + " - Might be trying to create an abstract class";
        }
        catch (IllegalAccessException iae) {
            if (DEBUG) {
                iae.printStackTrace();
            }
            errorMessage = "IllegalAccessException: " + iae.getMessage();
        }
        catch (IllegalArgumentException iae2) {
            if (DEBUG) {
                iae2.printStackTrace();
            }
            errorMessage = "IllegalArgumentException: " + iae2.getMessage();
        }
        catch (InvocationTargetException ite) {
            if (DEBUG) {
                ite.printStackTrace();
            }
            errorMessage = "InvocationTargetException: " + ite.getMessage();
        }
        catch (ClassNotFoundException cnfe) {
            errorMessage = "ClassNotFoundException: " + cnfe.getMessage();
        }
        if (Debug.debugging("componentfactory")) {
            Debug.error("ComponentFactory.create: Failed to create \"" + className + (prefix != null ? "\" using component marker name \"" + prefix + "\"" : "") + " - error message: " + errorMessage);
        }
        return null;
    }

    protected Object createWithSubclassConstructorArgs(Class newObjClass, Class[] argClasses, Object[] constructorArgs) throws NoSuchMethodException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        boolean DEBUG = Debug.debugging("componentfactorydetail");
        int numArgClasses = 0;
        if (argClasses != null) {
            numArgClasses = argClasses.length;
        }
        Constructor<?>[] constructors = newObjClass.getConstructors();
        int numConstructors = constructors.length;
        if (DEBUG) {
            Debug.output(" - searching " + numConstructors + " possible constructor" + (numConstructors == 1 ? "" : "s"));
        }
        for (int i = 0; i < numConstructors; ++i) {
            Constructor<?> constructor = constructors[i];
            Class<?>[] arguments = constructor.getParameterTypes();
            int numArgs = arguments.length;
            if (numArgs != numArgClasses) {
                if (!DEBUG) continue;
                Debug.output(" - constructor " + i + " with " + numArgs + " arguments not a match");
                continue;
            }
            if (numArgs == 0) {
                if (DEBUG) {
                    Debug.output(" - constructor " + i + " with no arguments is a match");
                }
                return constructor;
            }
            boolean good = false;
            for (int j = 0; j < numArgs; ++j) {
                if (arguments[j] == argClasses[j]) {
                    if (DEBUG) {
                        Debug.output(" - direct arg class match, arg " + j);
                    }
                    good = true;
                    continue;
                }
                if (arguments[j].isAssignableFrom(argClasses[j])) {
                    argClasses[j] = argClasses[j].getSuperclass();
                    if (DEBUG) {
                        Debug.output(" - superclass arg class match, arg " + j + " reassigning to " + argClasses[j].toString());
                    }
                    good = true;
                    continue;
                }
                if (DEBUG) {
                    Debug.output(" - arg class mismatch on arg " + j + ", bailing (" + arguments[j].getName() + " vs. " + argClasses[j].getName() + ")");
                }
                good = false;
                break;
            }
            if (!good) continue;
            if (DEBUG) {
                Debug.debugging(" - creating object");
            }
            Object obj = constructor.newInstance(constructorArgs);
            if (DEBUG) {
                Debug.debugging(" - created object");
            }
            return obj;
        }
        return null;
    }
}

