/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.tools.roads;

import com.bbn.openmap.LatLonPoint;
import com.bbn.openmap.omGraphics.OMGraphicList;
import com.bbn.openmap.omGraphics.OMLine;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.tools.roads.Road;
import com.bbn.openmap.tools.roads.RoadGraphic;
import com.bbn.openmap.tools.roads.RoadLayer;
import com.bbn.openmap.tools.roads.RoadObject;
import com.bbn.openmap.tools.roads.RoadPoint;
import com.bbn.openmap.tools.roads.Visual;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;

public class RoadLine
extends Visual
implements RoadObject {
    private Road road;
    private int index;

    public RoadLine(Road road, int index) {
        this.road = road;
        this.index = index;
    }

    public static Class getGraphicClass() {
        return Graphic.class;
    }

    public void moveTo(Point loc) {
    }

    public RoadPoint addRoadPoint(int x, int y) {
        RoadLayer layer = this.road.getRoadLayer();
        Projection p = layer.getProjection();
        RoadPoint rp = new RoadPoint(this.road, p.inverse(x, y), layer);
        this.road.insertRoadPointAt(rp, this.index + 1);
        return rp;
    }

    public Road getRoad() {
        return this.road;
    }

    public synchronized void render(OMGraphicList gl, boolean forceNew) {
        RoadGraphic visual = this.getVisual();
        if (visual == null || forceNew) {
            LatLonPoint p1 = this.road.getWaypoint(this.index).getLocation();
            LatLonPoint p2 = this.road.getWaypoint(this.index + 1).getLocation();
            visual = new Graphic(p1, p2);
            this.setVisual(visual);
        }
        gl.addOMGraphic((Graphic)visual);
    }

    public class Graphic
    extends OMLine
    implements RoadGraphic {
        Graphic(LatLonPoint p1, LatLonPoint p2) {
            super(p1.getLatitude(), p1.getLongitude(), p2.getLatitude(), p2.getLongitude(), 1);
            if (RoadLine.this.road.isBlocked()) {
                this.setLinePaint(Color.white);
            } else {
                this.setLinePaint(RoadLine.this.road.getRoadClass().getColor());
            }
        }

        public void blink(boolean newState) {
            RoadLine.this.blinkState = newState;
        }

        public void render(Graphics g) {
            if (RoadLine.this.blinkState) {
                return;
            }
            super.render(g);
        }

        public RoadObject getRoadObject() {
            return RoadLine.this;
        }

        public RoadLine getRoadLine() {
            return RoadLine.this;
        }
    }
}

