/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.tools.icon;

import com.bbn.openmap.tools.icon.BasicIconPart;
import com.bbn.openmap.tools.icon.IconPartCollection;
import com.bbn.openmap.tools.icon.IconPartCollectionEntry;
import java.awt.Polygon;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;

public class OpenMapAppPartCollection
extends IconPartCollection {
    static OpenMapAppPartCollection omparts;
    public static final OpenMapAppPart BIG_BOX;
    public static final OpenMapAppPart SMALL_BOX;
    public static final OpenMapAppPart FILL_BOX;
    public static final OpenMapAppPart UL_TRI;
    public static final OpenMapAppPart LR_TRI;
    public static final OpenMapAppPart LL_UR_LINE;
    public static final OpenMapAppPart UL_LR_LINE;

    protected OpenMapAppPartCollection() {
        super("OpenMap", "Common parts used in OpenMap Application Icons");
        this.init();
    }

    public static synchronized OpenMapAppPartCollection getInstance() {
        if (omparts == null) {
            omparts = new OpenMapAppPartCollection();
        }
        return omparts;
    }

    protected void init() {
        this.add(BIG_BOX);
        this.add(SMALL_BOX);
        this.add(FILL_BOX);
        this.add(UL_TRI);
        this.add(LR_TRI);
        this.add(LL_UR_LINE);
        this.add(UL_LR_LINE);
    }

    static {
        BIG_BOX = new OpenMapAppPart.Poly("BIG_BOX", "BIG_BOX", new int[]{10, 10, 90, 90, 10}, new int[]{10, 90, 90, 10, 10});
        SMALL_BOX = new OpenMapAppPart.Poly("SMALL_BOX", "SMALL_BOX", new int[]{30, 30, 70, 70, 30}, new int[]{30, 70, 70, 30, 30});
        FILL_BOX = new OpenMapAppPart.Poly("FILL_BOX", "FILL_BOX", new int[]{10, 10, 50, 50, 30, 30, 70, 70, 50, 50, 90, 90, 10}, new int[]{10, 90, 90, 70, 70, 30, 30, 70, 70, 90, 90, 10, 10});
        UL_TRI = new OpenMapAppPart.Poly("UL_TRI", "UL_TRI", new int[]{10, 10, 75, 10}, new int[]{10, 75, 10, 10});
        LR_TRI = new OpenMapAppPart.Poly("LR_TRI", "LR_TRI", new int[]{25, 90, 90, 25}, new int[]{90, 90, 25, 90});
        LL_UR_LINE = new OpenMapAppPart.Poly("LL_UR_LINE", "LL_UR_LINE", new int[]{10, 90}, new int[]{90, 10});
        UL_LR_LINE = new OpenMapAppPart.Poly("UL_LR_LINE", "UL_LR_LINE", new int[]{10, 90}, new int[]{10, 90});
    }

    public static class OpenMapAppPart
    extends IconPartCollectionEntry {
        public OpenMapAppPart(String n, String d, Shape shape) {
            this(n, d, shape, null);
        }

        public OpenMapAppPart(String n, String d, Shape shape, AffineTransform affTrans) {
            super(n, d, new BasicIconPart(shape, affTrans));
        }

        public static class Circle
        extends OpenMapAppPart {
            public Circle(String n, String d, double x, double y, double radius) {
                this(n, d, x, y, radius, null);
            }

            public Circle(String n, String d, double x, double y, double radius, AffineTransform af) {
                super(n, d, new Ellipse2D.Double(x - radius / 2.0, y - radius / 2.0, radius * 2.0, radius * 2.0), af);
            }
        }

        public static class Poly
        extends OpenMapAppPart {
            public Poly(String n, String d, int[] xp, int[] yp) {
                this(n, d, xp, yp, null);
            }

            public Poly(String n, String d, int[] xp, int[] yp, AffineTransform af) {
                super(n, d, new Polygon(xp, yp, xp.length), af);
            }
        }
    }
}

