/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.proj.coords;

import com.bbn.openmap.LatLonPoint;
import com.bbn.openmap.proj.Ellipsoid;
import com.bbn.openmap.proj.coords.AbstractGCT;
import com.bbn.openmap.proj.coords.GeoCoordTransformation;
import com.bbn.openmap.proj.coords.UTMPoint;
import com.bbn.openmap.util.PropUtils;
import java.awt.geom.Point2D;
import java.util.Properties;

public class UTMGCT
extends AbstractGCT
implements GeoCoordTransformation {
    public static final String ZoneProperty = "zone";
    public static final String HemiProperty = "hemi";
    public static final String ElliposoidProperty = "ellipsoid";
    protected Ellipsoid ellipsoid = Ellipsoid.WGS_84;
    protected LatLonPoint tmpLL = new LatLonPoint();
    protected UTMPoint tmpUTM = new UTMPoint();
    protected int zone_number;
    protected char zone_letter;

    public UTMGCT() {
    }

    public UTMGCT(int zone_number, char zone_letter) {
        this.zone_number = zone_number;
        this.zone_letter = zone_letter;
    }

    public synchronized Point2D forward(double lat, double lon, Point2D ret) {
        this.tmpLL.setLatLon((float)lat, (float)lon);
        UTMPoint.LLtoUTM(this.tmpLL, this.ellipsoid, this.tmpUTM, this.zone_number, this.zone_letter == 'N');
        ret.setLocation(this.tmpUTM.easting, this.tmpUTM.northing);
        return ret;
    }

    public LatLonPoint inverse(double x, double y, LatLonPoint ret) {
        UTMPoint.UTMtoLL(this.ellipsoid, (float)y, (float)x, this.zone_number, this.zone_letter, ret);
        return ret;
    }

    public void setProperties(String propertyPrefix, Properties props) {
        super.setProperties(propertyPrefix, props);
        propertyPrefix = PropUtils.getScopedPropertyPrefix(propertyPrefix);
        this.zone_number = PropUtils.intFromProperties(props, propertyPrefix + ZoneProperty, 0);
        String hString = props.getProperty(propertyPrefix + HemiProperty, "N");
        this.zone_letter = hString.charAt(0);
        String eName = props.getProperty(propertyPrefix + ElliposoidProperty, "WGS_84");
        this.ellipsoid = Ellipsoid.getByName(eName);
    }

    public Properties getProperties(Properties props) {
        props = super.getProperties(props);
        String prefix = PropUtils.getScopedPropertyPrefix(this);
        props.put(prefix + ZoneProperty, Integer.toString(this.zone_number));
        props.put(prefix + HemiProperty, Character.toString(this.zone_letter));
        props.put(prefix + ElliposoidProperty, this.ellipsoid.name.toUpperCase().replace(' ', '_'));
        return props;
    }

    public Properties getPropertyInfo(Properties props) {
        props = super.getPropertyInfo(props);
        return props;
    }

    public Ellipsoid getEllipsoid() {
        return this.ellipsoid;
    }

    public void setEllipsoid(Ellipsoid ellipsoid) {
        this.ellipsoid = ellipsoid;
    }
}

