/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.proj.coords;

import com.bbn.openmap.LatLonPoint;
import com.bbn.openmap.proj.coords.AbstractGCT;
import com.bbn.openmap.proj.coords.GeoCoordTransformation;
import java.awt.geom.Point2D;

public class MercatorMeterGCT
extends AbstractGCT
implements GeoCoordTransformation {
    public static final MercatorMeterGCT INSTANCE = new MercatorMeterGCT();
    private double latfac;
    private double lonfac;

    public MercatorMeterGCT() {
        this.latfac = 6356752.3142;
        this.lonfac = 6356752.3142;
    }

    public MercatorMeterGCT(double latfac, double lonfac) {
        this.latfac = latfac;
        this.lonfac = lonfac;
    }

    public Point2D forward(double lat, double lon, Point2D ret) {
        if (!(lat >= -90.0) || !(lat <= 90.0)) {
            lat = LatLonPoint.normalize_latitude((float)lat);
        }
        if (!(lon >= -180.0) || !(lon <= 180.0)) {
            lon = LatLonPoint.wrap_longitude((float)lon);
        }
        double latrad = Math.toRadians(lat);
        double lonrad = Math.toRadians(lon);
        double lat_m = this.latfac * Math.log(Math.tan((latrad + 1.5707963267948966) / 2.0));
        double lon_m = this.lonfac * lonrad;
        ret.setLocation(lon_m, lat_m);
        return ret;
    }

    public LatLonPoint inverse(double lon_m, double lat_m, LatLonPoint ret) {
        double latrad = 2.0 * Math.atan(Math.exp(lat_m / this.latfac)) - 1.5707963267948966;
        double lonrad = lon_m / this.lonfac;
        float lat = (float)Math.toDegrees(latrad);
        float lon = (float)Math.toDegrees(lonrad);
        if (!((double)lat >= -90.0) || !((double)lat <= 90.0)) {
            lat = LatLonPoint.normalize_latitude(lat);
        }
        if (!((double)lon >= -180.0) || !((double)lon <= 180.0)) {
            lon = LatLonPoint.wrap_longitude(lon);
        }
        ret.setLatLon(lat, lon);
        return ret;
    }
}

