/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.proj.coords;

import com.bbn.openmap.LatLonPoint;
import com.bbn.openmap.proj.Ellipsoid;
import com.bbn.openmap.proj.LLXYLoader;
import com.bbn.openmap.proj.LambertConformalLoader;
import com.bbn.openmap.proj.MercatorLoader;
import com.bbn.openmap.proj.Proj;
import com.bbn.openmap.proj.ProjectionLoader;
import com.bbn.openmap.proj.UTMProjectionLoader;
import com.bbn.openmap.proj.coords.AbstractGCT;
import com.bbn.openmap.proj.coords.BoundingBox;
import com.bbn.openmap.proj.coords.DatumShiftGCT;
import com.bbn.openmap.proj.coords.GeoCoordTransformation;
import com.bbn.openmap.proj.coords.LambertConformalGCT;
import com.bbn.openmap.proj.coords.LatLonGCT;
import com.bbn.openmap.proj.coords.MercatorMeterGCT;
import com.bbn.openmap.proj.coords.MultiGCT;
import com.bbn.openmap.proj.coords.UTMGCT;
import java.awt.geom.Point2D;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;

public class CoordinateReferenceSystem {
    private String code;
    private GeoCoordTransformation coordTransform;
    private ProjectionLoader projLoader;
    private BoundingBox boundingBox;
    private String projLoaderClassName;
    private Ellipsoid ellipsoid = Ellipsoid.WGS_84;
    private Properties defaultProjectionParameters;
    protected static final Map crss = Collections.synchronizedMap(new TreeMap());

    private static void addLcc(String code, Ellipsoid ellps, double sp1, double sp2, double refLat, double centMeri, double falseEast, double falseNorth, BoundingBox bbox) {
        Properties props = new Properties();
        props.put("standardParallel1", Double.toString(sp1));
        props.put("standardParallel2", Double.toString(sp2));
        props.put("referenceLatitude", Double.toString(refLat));
        props.put("centralMeridian", Double.toString(centMeri));
        props.put("falseEasting", Double.toString(falseEast));
        props.put("faleNorthing", Double.toString(falseNorth));
        props.put("DATUM", ellps);
        props.put("CENTER", new LatLonPoint(refLat, centMeri));
        CoordinateReferenceSystem.addCrs(new CoordinateReferenceSystem(code, new LambertConformalGCT(props), LambertConformalLoader.class, ellps, props, bbox));
    }

    private static void addCrs(CoordinateReferenceSystem crs) {
        crss.put(crs.getCode(), crs);
    }

    private static void addUtms() {
        for (int zone = 1; zone <= 60; ++zone) {
            String zoneCode = String.valueOf(zone);
            while (zoneCode.length() < 2) {
                zoneCode = "0" + zoneCode;
            }
            CoordinateReferenceSystem.addUtm("EPSG:326" + zoneCode, zone, 'N', Ellipsoid.WGS_84);
            CoordinateReferenceSystem.addUtm("EPSG:327" + zoneCode, zone, 'S', Ellipsoid.WGS_84);
            if (zone < 28 || zone > 38) continue;
            CoordinateReferenceSystem.addUtm("EPSG:230" + zoneCode, zone, 'N', Ellipsoid.INTERNATIONAL);
        }
    }

    private static void addUtm(String epsg, int zone_number, char zone_letter, Ellipsoid ellps) {
        Properties projProps = new Properties();
        projProps.put("ZONE_NUMBER", Integer.toString(zone_number));
        projProps.put("ZONE_LETTER", Character.toString(zone_letter));
        UTMGCT utmgct = new UTMGCT(zone_number, zone_letter);
        utmgct.setEllipsoid(ellps);
        AbstractGCT gct = utmgct;
        if (ellps != Ellipsoid.WGS_84 && ellps != Ellipsoid.GRS_1980) {
            DatumShiftGCT egct = new DatumShiftGCT(ellps);
            gct = new MultiGCT(new GeoCoordTransformation[]{egct, utmgct});
        }
        CoordinateReferenceSystem.addCrs(new CoordinateReferenceSystem(epsg, gct, UTMProjectionLoader.class, ellps, projProps));
    }

    public CoordinateReferenceSystem(String code, GeoCoordTransformation coordConverter, Class projLoaderClass, Ellipsoid ellipsoid) {
        this.code = code;
        this.coordTransform = coordConverter;
        this.projLoaderClassName = projLoaderClass.getName();
        this.ellipsoid = ellipsoid;
        this.defaultProjectionParameters = new Properties();
        this.defaultProjectionParameters.put("DATUM", ellipsoid);
    }

    public CoordinateReferenceSystem(String code, GeoCoordTransformation coordConverter, Class projLoaderClass, Ellipsoid ellipsoid, Properties projectionParameters) {
        this(code, coordConverter, projLoaderClass, ellipsoid, projectionParameters, null);
    }

    public CoordinateReferenceSystem(String code, GeoCoordTransformation coordConverter, Class projLoaderClass, Ellipsoid ellipsoid, Properties projectionParameters, BoundingBox boundingBox) {
        this(code, coordConverter, projLoaderClass, ellipsoid);
        this.defaultProjectionParameters.putAll((Map<?, ?>)projectionParameters);
        this.boundingBox = boundingBox;
    }

    public static CoordinateReferenceSystem getForCode(String code) {
        CoordinateReferenceSystem crs = (CoordinateReferenceSystem)crss.get(code);
        return crs;
    }

    public static Collection getCodes() {
        return crss.keySet();
    }

    protected ProjectionLoader projectionLoader() {
        if (this.projLoader != null) {
            return this.projLoader;
        }
        try {
            Class<?> cl = Class.forName(this.projLoaderClassName);
            Object o = cl.newInstance();
            this.projLoader = (ProjectionLoader)o;
            return this.projLoader;
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException(e.getMessage());
        }
        catch (InstantiationException e) {
            throw new IllegalStateException(e.getMessage());
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e.getMessage());
        }
    }

    public Proj createProjection(Properties overrideProjectionParameters) {
        Properties projectionParameters = new Properties();
        projectionParameters.putAll((Map<?, ?>)this.defaultProjectionParameters);
        projectionParameters.putAll((Map<?, ?>)overrideProjectionParameters);
        return (Proj)this.projectionLoader().create(projectionParameters);
    }

    public String getCode() {
        return this.code;
    }

    public BoundingBox getBoundingBox() {
        return this.boundingBox;
    }

    public void prepareProjection(Proj proj) {
        proj.setPlanetRadius((float)this.ellipsoid.radius);
    }

    public LatLonPoint inverse(double x, double y) {
        return this.coordTransform.inverse(x, y);
    }

    public Point2D forward(double lat, double lon) {
        return this.coordTransform.forward(lat, lon);
    }

    public int hashCode() {
        return this.getCode().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof CoordinateReferenceSystem) {
            CoordinateReferenceSystem o = (CoordinateReferenceSystem)obj;
            return this.getCode().equals(o.getCode());
        }
        return false;
    }

    static {
        CoordinateReferenceSystem.addCrs(new CoordinateReferenceSystem("EPSG:4326", LatLonGCT.INSTANCE, LLXYLoader.class, Ellipsoid.WGS_84));
        CoordinateReferenceSystem.addCrs(new CoordinateReferenceSystem("CRS:84", LatLonGCT.INSTANCE, LLXYLoader.class, Ellipsoid.WGS_84));
        CoordinateReferenceSystem.addCrs(new CoordinateReferenceSystem("EPSG:4230", new DatumShiftGCT(Ellipsoid.INTERNATIONAL), LLXYLoader.class, Ellipsoid.INTERNATIONAL));
        CoordinateReferenceSystem.addCrs(new CoordinateReferenceSystem("EPSG:900913", new MercatorMeterGCT(6378137.0, 6378137.0), MercatorLoader.class, Ellipsoid.WGS_84));
        CoordinateReferenceSystem.addUtms();
        CoordinateReferenceSystem.addLcc("EPSG:3301", Ellipsoid.GRS_1980, 59.33333333333334, 58.0, 57.51755393055556, 24.0, 500000.0, 6375000.0, new BoundingBox(300000.0, 6300000.0, 800000.0, 6700000.0));
    }
}

