/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.proj;

import com.bbn.openmap.LatLonPoint;
import com.bbn.openmap.MoreMath;
import com.bbn.openmap.proj.Azimuth;
import com.bbn.openmap.proj.GreatCircle;
import com.bbn.openmap.proj.ProjMath;
import com.bbn.openmap.util.Debug;
import java.awt.Point;

public class Orthographic
extends Azimuth {
    public static final transient String OrthographicName = "Orthographic";
    public static final transient int OrthographicType = 7;
    protected int hy;
    protected int wx;
    protected float cosCtrLat;
    protected float sinCtrLat;
    public static final transient float epsilon = 1.0E-4f;
    protected static final transient float NORTH_BOUNDARY = 1.5706964f;
    protected static final transient float SOUTH_BOUNDARY = -1.5706964f;

    public Orthographic(LatLonPoint center, float scale, int width, int height) {
        super(center, scale, width, height, 7);
        this.setMinScale(1000.0f);
    }

    public Orthographic(LatLonPoint center, float scale, int width, int height, int type) {
        super(center, scale, width, height, type);
        this.setMinScale(1000.0f);
    }

    public String toString() {
        return "Orthographic[" + super.toString();
    }

    protected void computeParameters() {
        Debug.message("proj", "Orthographic.computeParameters()");
        super.computeParameters();
        this.cosCtrLat = (float)Math.cos(this.ctrLat);
        this.sinCtrLat = (float)Math.sin(this.ctrLat);
        this.hy = this.height / 2;
        this.wx = this.width / 2;
    }

    public float normalize_latitude(float lat) {
        if (lat > 1.5706964f) {
            return 1.5706964f;
        }
        if (lat < -1.5706964f) {
            return -1.5706964f;
        }
        return lat;
    }

    public static final boolean hemisphere_clip(float phi1, float lambda0, float phi, float lambda) {
        return GreatCircle.spherical_distance(phi1, lambda0, phi, lambda) <= 1.5707964f;
    }

    private Point edge_point(Point p, float current_azimuth) {
        LatLonPoint tmpll = GreatCircle.spherical_between(this.ctrLat, this.ctrLon, 1.5707964f, current_azimuth);
        float phi = tmpll.radlat_;
        float lambda = tmpll.radlon_;
        float cosPhi = (float)Math.cos(phi);
        float lambdaMinusCtrLon = lambda - this.ctrLon;
        p.x = (int)(this.scaled_radius * cosPhi * (float)Math.sin(lambdaMinusCtrLon)) + this.wx;
        p.y = this.hy - (int)(this.scaled_radius * (this.cosCtrLat * (float)Math.sin(phi) - this.sinCtrLat * cosPhi * (float)Math.cos(lambdaMinusCtrLon)));
        return p;
    }

    public boolean isPlotable(float lat, float lon) {
        lat = this.normalize_latitude(ProjMath.degToRad(lat));
        lon = Orthographic.wrap_longitude(ProjMath.degToRad(lon));
        return Orthographic.hemisphere_clip(this.ctrLat, this.ctrLon, lat, lon);
    }

    protected Point _forward(float phi, float lambda, Point p, Azimuth.AzimuthVar azVar) {
        float cosPhi = (float)Math.cos(phi);
        float lambdaMinusCtrLon = lambda - this.ctrLon;
        if (!Orthographic.hemisphere_clip(this.ctrLat, this.ctrLon, phi, lambda)) {
            float az = GreatCircle.spherical_azimuth(this.ctrLat, this.ctrLon, phi, lambda);
            if (azVar != null) {
                azVar.invalid_forward = true;
                azVar.current_azimuth = az;
            }
            return this.edge_point(p, az);
        }
        p.x = (int)(this.scaled_radius * cosPhi * (float)Math.sin(lambdaMinusCtrLon)) + this.wx;
        p.y = this.hy - (int)(this.scaled_radius * (this.cosCtrLat * (float)Math.sin(phi) - this.sinCtrLat * cosPhi * (float)Math.cos(lambdaMinusCtrLon)));
        return p;
    }

    public LatLonPoint inverse(int x, int y, LatLonPoint llp) {
        float rho;
        if ((rho = (float)Math.sqrt((x -= this.wx) * x + (y = this.hy - y) * y)) == 0.0f) {
            Debug.message("proj", "Orthographic.inverse: center!");
            llp.setLatLon(ProjMath.radToDeg(this.ctrLat), ProjMath.radToDeg(this.ctrLon));
            return llp;
        }
        float sinC = rho / this.scaled_radius;
        float cosC = (float)Math.sqrt(1.0f - sinC * sinC);
        float lat = (float)Math.asin(cosC * this.sinCtrLat + (float)y * sinC * (this.cosCtrLat / rho));
        float lon = this.ctrLat == 1.5707964f ? this.ctrLon + (float)Math.atan2(x, -y) : (this.ctrLat == -1.5707964f ? this.ctrLon + (float)Math.atan2(x, y) : this.ctrLon + (float)Math.atan2((float)x * sinC, rho * this.cosCtrLat * cosC - (float)y * this.sinCtrLat * sinC));
        if (Float.isNaN(lat) || Float.isNaN(lon)) {
            lat = this.ctrLat;
            lon = this.ctrLon;
        }
        llp.setLatLon(ProjMath.radToDeg(lat), ProjMath.radToDeg(lon));
        return llp;
    }

    public LatLonPoint inverse(Point pt, LatLonPoint llp) {
        return this.inverse(pt.x, pt.y, llp);
    }

    public LatLonPoint getUpperLeft() {
        float lon;
        float lat;
        LatLonPoint tmp = new LatLonPoint();
        if (this.overNorthPole()) {
            lat = 1.5707964f;
            lon = (float)(-Math.PI);
        } else if (this.overSouthPole()) {
            lon = (float)(-Math.PI);
            tmp = this.inverse(0, 0, tmp);
            lat = MoreMath.approximately_equal(tmp.radlon_, this.ctrLon, 1.0E-4f) ? this.ctrLat + 1.5707964f : tmp.radlat_;
        } else if (this.ctrLat >= 0.0f) {
            tmp = this.inverse(0, 0, tmp);
            if (MoreMath.approximately_equal(tmp.radlon_, this.ctrLon, 1.0E-4f)) {
                lat = this.inverse((int)(this.width / 2), (int)0, (LatLonPoint)tmp).radlat_;
                lon = (float)(-Math.PI);
            } else {
                lon = tmp.radlon_;
                lat = this.inverse((int)(this.width / 2), (int)0, (LatLonPoint)tmp).radlat_;
            }
        } else {
            tmp = this.inverse(0, 0, tmp);
            if (MoreMath.approximately_equal(tmp.radlon_, this.ctrLon, 1.0E-4f)) {
                lat = this.ctrLat + 1.5707964f;
                lon = (float)(-Math.PI);
            } else {
                lat = tmp.radlat_;
                lon = this.inverse((int)0, (int)(this.height - 1), (LatLonPoint)tmp).radlon_;
            }
        }
        tmp.setLatLon(lat, lon, true);
        return tmp;
    }

    public LatLonPoint getLowerRight() {
        float lat;
        float lon;
        LatLonPoint tmp = new LatLonPoint();
        if (this.overNorthPole()) {
            lon = (float)Math.PI;
            tmp = this.inverse(this.width - 1, this.height - 1, tmp);
            lat = MoreMath.approximately_equal(tmp.radlon_, this.ctrLon, 1.0E-4f) ? this.ctrLat - 1.5707964f : tmp.radlat_;
        } else if (this.overSouthPole()) {
            lat = -1.5707964f;
            lon = (float)Math.PI;
        } else if (this.ctrLat >= 0.0f) {
            tmp = this.inverse(this.width - 1, this.height - 1, tmp);
            if (MoreMath.approximately_equal(tmp.radlon_, this.ctrLon, 1.0E-4f)) {
                lat = this.ctrLat - 1.5707964f;
                lon = (float)Math.PI;
            } else {
                lat = tmp.radlat_;
                lon = this.inverse((int)(this.width - 1), (int)0, (LatLonPoint)tmp).radlon_;
            }
        } else {
            tmp = this.inverse(this.width - 1, this.height - 1, tmp);
            if (MoreMath.approximately_equal(tmp.radlon_, this.ctrLon, 1.0E-4f)) {
                lat = this.inverse((int)(this.width / 2), (int)(this.height - 1), (LatLonPoint)tmp).radlat_;
                lon = (float)Math.PI;
            } else {
                lon = tmp.radlon_;
                lat = this.inverse((int)(this.width / 2), (int)(this.height - 1), (LatLonPoint)tmp).radlat_;
            }
        }
        tmp.setLatLon(lat, lon, true);
        return tmp;
    }

    public String getName() {
        return OrthographicName;
    }
}

