/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.proj;

import com.bbn.openmap.LatLonPoint;
import com.bbn.openmap.MoreMath;
import com.bbn.openmap.proj.Cylindrical;
import com.bbn.openmap.proj.DrawUtil;
import com.bbn.openmap.proj.ProjMath;
import com.bbn.openmap.util.Debug;
import java.awt.Point;

public class Mercator
extends Cylindrical {
    public static final transient String MercatorName = "Mercator";
    public static final transient int MercatorType = 2;
    protected static int MAX_RHUMB_SEGS = 512;
    protected static float epsilon = 0.01f;
    protected int hy;
    protected int wx;
    protected float tanCtrLat;
    protected float asinh_of_tanCtrLat;

    public Mercator(LatLonPoint center, float scale, int width, int height) {
        super(center, scale, width, height, 2);
    }

    public Mercator(LatLonPoint center, float scale, int width, int height, int type) {
        super(center, scale, width, height, type);
    }

    public String toString() {
        return "Mercator[" + super.toString();
    }

    protected void computeParameters() {
        Debug.message("mercator", "Mercator.computeParameters()");
        super.computeParameters();
        this.tanCtrLat = (float)Math.tan(this.ctrLat);
        this.asinh_of_tanCtrLat = MoreMath.asinh(this.tanCtrLat);
        this.hy = this.height / 2;
        this.wx = this.width / 2;
    }

    public float normalize_latitude(float lat) {
        if (lat > 1.5707964f - epsilon) {
            return 1.5707964f - epsilon;
        }
        if (lat < -1.5707964f + epsilon) {
            return -1.5707964f + epsilon;
        }
        return lat;
    }

    public boolean isPlotable(float lat, float lon) {
        return true;
    }

    public Point forward(LatLonPoint pt, Point p) {
        float phi = this.normalize_latitude(pt.radlat_);
        float lambda = pt.radlon_;
        p.x = Math.round(this.scaled_radius * Mercator.wrap_longitude(lambda - this.ctrLon)) + this.wx;
        p.y = this.hy - Math.round(this.scaled_radius * (MoreMath.asinh((float)Math.tan(phi)) - this.asinh_of_tanCtrLat));
        return p;
    }

    public Point forward(float lat, float lon, Point p) {
        float phi = this.normalize_latitude(ProjMath.degToRad(lat));
        float lambda = Mercator.wrap_longitude(ProjMath.degToRad(lon));
        p.x = Math.round(this.scaled_radius * Mercator.wrap_longitude(lambda - this.ctrLon)) + this.wx;
        p.y = this.hy - Math.round(this.scaled_radius * (MoreMath.asinh((float)Math.tan(phi)) - this.asinh_of_tanCtrLat));
        return p;
    }

    public Point forward(float lat, float lon, Point p, boolean isRadian) {
        float phi = this.normalize_latitude(lat);
        float lambda = Mercator.wrap_longitude(lon);
        p.x = Math.round(this.scaled_radius * Mercator.wrap_longitude(lambda - this.ctrLon)) + this.wx;
        p.y = this.hy - Math.round(this.scaled_radius * (MoreMath.asinh((float)Math.tan(phi)) - this.asinh_of_tanCtrLat));
        return p;
    }

    public LatLonPoint inverse(Point pt, LatLonPoint llp) {
        int x = pt.x - this.wx;
        int y = this.hy - pt.y;
        float wc = this.asinh_of_tanCtrLat * this.scaled_radius;
        llp.setLatitude(ProjMath.radToDeg((float)Math.atan(MoreMath.sinh(((float)y + wc) / this.scaled_radius))));
        llp.setLongitude(ProjMath.radToDeg((float)x / this.scaled_radius + this.ctrLon));
        return llp;
    }

    public LatLonPoint inverse(int x, int y, LatLonPoint llp) {
        y = this.hy - y;
        float wc = this.asinh_of_tanCtrLat * this.scaled_radius;
        llp.setLatitude(ProjMath.radToDeg((float)Math.atan(MoreMath.sinh(((float)y + wc) / this.scaled_radius))));
        llp.setLongitude(ProjMath.radToDeg((float)(x -= this.wx) / this.scaled_radius + this.ctrLon));
        return llp;
    }

    protected static final int rhumbStep(Point pt1, Point pt2) {
        int step = (int)DrawUtil.distance(pt1.x, pt1.y, pt2.x, pt2.y);
        step = step > 8192 ? 512 : (step >>= 3);
        return step == 0 ? 1 : step;
    }

    protected float[] rhumbProject(Point from, Point to, boolean include_last, int nsegs) {
        if (nsegs < 1) {
            nsegs = DrawUtil.pixel_distance(from.x, from.y, to.x, to.y) >> 3;
            if (nsegs == 0) {
                nsegs = 1;
            } else if (nsegs > MAX_RHUMB_SEGS) {
                nsegs = MAX_RHUMB_SEGS;
            }
        }
        LatLonPoint llp = this.inverse(from.x, from.y, new LatLonPoint());
        int[] xypts = DrawUtil.lineSegments(from.x, from.y, to.x, to.y, nsegs, include_last, new int[nsegs << 1]);
        float[] llpts = new float[xypts.length];
        for (int i = 0; i < llpts.length; i += 2) {
            this.inverse(xypts[i], xypts[i + 1], llp);
            llpts[i] = llp.radlat_;
            llpts[i + 1] = llp.radlon_;
        }
        return llpts;
    }

    public String getName() {
        return MercatorName;
    }
}

