/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.proj;

import com.bbn.openmap.LatLonPoint;
import com.bbn.openmap.MoreMath;
import com.bbn.openmap.proj.Ellipsoid;
import com.bbn.openmap.proj.Proj;
import com.bbn.openmap.proj.ProjMath;
import com.bbn.openmap.util.Debug;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.geom.Point2D;
import java.util.ArrayList;

public class LambertConformal
extends Proj {
    public static final transient String LambertConformalName = "Lambert Conformal";
    public static final transient int LambertConformalType = 4200;
    private static final int MODE_2SP = 1;
    private static final int MODE_BELGIUM = 2;
    private int mode = 1;
    private double lambert_sp_one;
    private double lambert_sp_two;
    private double centralMeridian;
    double locationCenterXPixel = 0.0;
    double locationCenterYPixel = 0.0;
    double locationCenterXLambert = 0.0;
    double locationCenterYLambert = 0.0;
    double locationPixelsPerLambert = 0.0;
    double locationOriginX = 0.0;
    double locationOriginY = 0.0;
    double referenceLatitude = 0.0;
    double falseEasting = 0.0;
    double falseNorthing = 0.0;
    double n = 0.0;
    double F = 0.0;
    double rf = 0.0;
    double lamdaf = 0.0;
    double alpha = 0.0;
    private Ellipsoid ellps = Ellipsoid.WGS_84;
    protected Point plotablePoint = new Point();

    protected LambertConformal(LatLonPoint center, float scale, int width, int height) {
        super(center, scale, width, height, 4200);
    }

    protected LambertConformal(LatLonPoint center, float scale, int width, int height, float centralMeridian, float sp_one, float sp_two, Ellipsoid ellps) {
        this(center, scale, width, height, centralMeridian, sp_one, sp_two, 0.0, 0.0, 0.0, ellps);
    }

    public LambertConformal(LatLonPoint center, float scale, int width, int height, double centralMeridian, double sp_one, double sp_two, double reference_latitude, double falseEasting, double falseNorthing, Ellipsoid ellps) {
        super(center, scale, width, height, 4200);
        this.centralMeridian = centralMeridian;
        this.lambert_sp_one = sp_one;
        this.lambert_sp_two = sp_two;
        this.referenceLatitude = reference_latitude;
        this.falseEasting = falseEasting;
        this.falseNorthing = falseNorthing;
        this.ellps = ellps;
        this.computeParameters();
    }

    public void computeParameters() {
        if (this.ellps == null) {
            this.ellps = Ellipsoid.WGS_84;
        }
        this.alpha = this.mode == 2 ? 1.4204E-4 : 0.0;
        double phi1 = this.lambert_sp_one / 180.0 * Math.PI;
        double phi2 = this.lambert_sp_two / 180.0 * Math.PI;
        double phif = this.referenceLatitude / 180.0 * Math.PI;
        double e = this.ellps.ecc;
        double m1 = Math.cos(phi1) / Math.pow(1.0 - Math.pow(e * Math.sin(phi1), 2.0), 0.5);
        double m2 = Math.cos(phi2) / Math.pow(1.0 - Math.pow(e * Math.sin(phi2), 2.0), 0.5);
        double t1 = Math.tan(0.7853981633974483 - phi1 / 2.0) / Math.pow((1.0 - e * Math.sin(phi1)) / (1.0 + e * Math.sin(phi1)), e / 2.0);
        double t2 = Math.tan(0.7853981633974483 - phi2 / 2.0) / Math.pow((1.0 - e * Math.sin(phi2)) / (1.0 + e * Math.sin(phi2)), e / 2.0);
        double tf = Math.tan(0.7853981633974483 - phif / 2.0) / Math.pow((1.0 - e * Math.sin(phif)) / (1.0 + e * Math.sin(phif)), e / 2.0);
        this.n = (Math.log(m1) - Math.log(m2)) / (Math.log(t1) - Math.log(t2));
        this.F = m1 / (this.n * Math.pow(t1, this.n));
        this.rf = this.ellps.radius * this.F * Math.pow(tf, this.n);
        this.lamdaf = this.centralMeridian / 180.0 * Math.PI;
        this.locationCenterXPixel = (double)this.getWidth() / 2.0;
        this.locationCenterYPixel = (double)this.getHeight() / 2.0;
        this.locationPixelsPerLambert = (double)this.getPPM() / (double)this.getScale();
        Point2D.Double lp = new Point2D.Double();
        LatLonPoint origin = new LatLonPoint(this.referenceLatitude, this.centralMeridian);
        this.LLToWorld(origin.getLatitude(), origin.getLongitude(), lp);
        this.locationOriginX = ((Point2D)lp).getX();
        this.locationOriginY = ((Point2D)lp).getY();
        LatLonPoint center = this.getCenter();
        this.LLToWorld(center.getLatitude(), center.getLongitude(), lp);
        this.locationCenterXLambert = ((Point2D)lp).getX();
        this.locationCenterYLambert = ((Point2D)lp).getY();
        if (Debug.debugging("Lambert")) {
            Debug.output("Creating LambertConformal: center x = " + this.locationCenterXLambert + ", center y = " + this.locationCenterYLambert);
            Debug.output("Creating LambertConformal: origin x = " + this.locationOriginX + ", origin y = " + this.locationOriginY);
        }
    }

    public float normalize_latitude(float lat) {
        if (lat > 1.5707964f) {
            return 1.5707964f;
        }
        if (lat < -1.5707964f) {
            return -1.5707964f;
        }
        return lat;
    }

    public void pan(float Az) {
        if (MoreMath.approximately_equal(Math.abs(Az), 180.0f, 0.01f)) {
            this.setCenter(this.inverse(this.width / 2, this.height));
        } else if (MoreMath.approximately_equal(Az, -135.0f, 0.01f)) {
            this.setCenter(this.inverse(0, this.height));
        } else if (MoreMath.approximately_equal(Az, -90.0f, 0.01f)) {
            this.setCenter(this.inverse(0, this.height / 2));
        } else if (MoreMath.approximately_equal(Az, -45.0f, 0.01f)) {
            this.setCenter(this.inverse(0, 0));
        } else if (MoreMath.approximately_equal(Az, 0.0f, 0.01f)) {
            this.setCenter(this.inverse(this.width / 2, 0));
        } else if (MoreMath.approximately_equal(Az, 45.0f, 0.01f)) {
            this.setCenter(this.inverse(this.width, 0));
        } else if (MoreMath.approximately_equal(Az, 90.0f, 0.01f)) {
            this.setCenter(this.inverse(this.width, this.height / 2));
        } else if (MoreMath.approximately_equal(Az, 135.0f, 0.01f)) {
            this.setCenter(this.inverse(this.width, this.height));
        } else {
            super.pan(Az);
        }
    }

    public Point2D LLToWorld(double lat, double lon, Point2D lp) {
        double phi_deg = lat;
        double phi = phi_deg / 180.0 * Math.PI;
        double lamba_deg = lon;
        double lamba = lamba_deg / 180.0 * Math.PI;
        double e = this.ellps.ecc;
        double t = Math.tan(0.7853981633974483 - phi / 2.0) / Math.pow((1.0 - e * Math.sin(phi)) / (1.0 + e * Math.sin(phi)), e / 2.0);
        double r = this.ellps.radius * this.F * Math.pow(t, this.n);
        double theta = this.n * (lamba - this.lamdaf);
        double easting = this.falseEasting + r * Math.sin(theta - this.alpha);
        double northing = this.falseNorthing + this.rf - r * Math.cos(theta - this.alpha);
        lp.setLocation(easting, northing);
        return lp;
    }

    public Point LLToPixel(double lat, double lon, Point p) {
        Point2D.Double lp = new Point2D.Double();
        this.LLToWorld(lat, lon, lp);
        double xrel = ((Point2D)lp).getX() - this.locationCenterXLambert;
        double yrel = ((Point2D)lp).getY() - this.locationCenterYLambert;
        xrel *= this.locationPixelsPerLambert;
        yrel *= this.locationPixelsPerLambert;
        xrel = this.locationCenterXPixel + xrel;
        yrel = this.locationCenterYPixel - yrel;
        if (p == null) {
            p = new Point();
        }
        p.x = (int)xrel;
        p.y = (int)yrel;
        return p;
    }

    public LatLonPoint worldToLL(double x, double y, LatLonPoint llp) {
        double thetaR = Math.atan((x - this.falseEasting) / (this.rf - (y - this.falseNorthing)));
        double rR = Math.sqrt(Math.pow(x - this.falseEasting, 2.0) + Math.pow(this.rf - (y - this.falseNorthing), 2.0));
        double tR = Math.pow(rR / (this.ellps.radius * this.F), 1.0 / this.n);
        double lamda = (thetaR + this.alpha) / this.n + this.lamdaf;
        double e = this.ellps.ecc;
        double phiT1 = 0.0;
        double phiT2 = 1.5707963267948966 - 2.0 * Math.atan(tR);
        double significance = 1.0E-8;
        while (Math.abs((phiT2 = 1.5707963267948966 - 2.0 * Math.atan(tR * Math.pow((1.0 - e * Math.sin(phiT1 = phiT2)) / (1.0 + e * Math.sin(phiT1)), e / 2.0))) - phiT1) > significance) {
        }
        double lamda_deg = lamda * 180.0 / Math.PI;
        double phi_deg = phiT2 * 180.0 / Math.PI;
        llp.setLatLon((float)phi_deg, (float)lamda_deg);
        return llp;
    }

    public LatLonPoint pixelToLL(int xabs, int yabs, LatLonPoint llp) {
        double x = this.locationCenterXLambert + ((double)xabs - this.locationCenterXPixel) / this.locationPixelsPerLambert;
        double y = this.locationCenterYLambert + (this.locationCenterYPixel - (double)yabs) / this.locationPixelsPerLambert;
        this.worldToLL(x, y, llp);
        return llp;
    }

    public boolean isPlotable(float lat, float lon) {
        if (lat < -55.0f) {
            return false;
        }
        this.forward(lat, lon, this.plotablePoint);
        return this.plotablePoint.x >= 0 && this.plotablePoint.x < this.width && this.plotablePoint.y >= 0 && this.plotablePoint.y < this.height;
    }

    public boolean isPlotable(LatLonPoint llpoint) {
        return this.isPlotable(llpoint.getLatitude(), llpoint.getLongitude());
    }

    public Point forward(LatLonPoint pt, Point p) {
        return this.forward(pt.radlat_, pt.radlon_, p, true);
    }

    public Point forward(float lat, float lon, Point p) {
        return this.forward(lat, lon, p, false);
    }

    public Point forward(float lat, float lon, Point p, boolean isRadian) {
        if (isRadian) {
            this.LLToPixel(ProjMath.radToDeg(lat), ProjMath.radToDeg(lon), p);
        } else {
            this.LLToPixel(lat, lon, p);
        }
        return p;
    }

    public LatLonPoint inverse(int x, int y, LatLonPoint llp) {
        if (llp == null) {
            llp = new LatLonPoint();
        }
        this.pixelToLL(x, y, llp);
        return llp;
    }

    public LatLonPoint inverse(Point pt, LatLonPoint llp) {
        return this.inverse(pt.x, pt.y, llp);
    }

    public LatLonPoint getUpperLeft() {
        return new LatLonPoint(90.0, -180.0);
    }

    public LatLonPoint getLowerRight() {
        return new LatLonPoint(-90.0, 180.0);
    }

    public String getName() {
        return LambertConformalName;
    }

    public boolean forwardRaw(float[] rawllpts, int rawoff, int[] xcoords, int[] ycoords, boolean[] visible, int copyoff, int copylen) {
        boolean visibleTotal = false;
        Point temp = new Point();
        int end = copylen + copyoff;
        int i = copyoff;
        int j = rawoff;
        while (i < end) {
            this.forward(rawllpts[j], rawllpts[j + 1], temp, true);
            xcoords[i] = temp.x;
            ycoords[i] = temp.y;
            boolean bl = visible[i] = 0 <= temp.x && temp.x <= this.width && 0 <= temp.y && temp.y <= this.height;
            if (visible[i] && !visibleTotal) {
                visibleTotal = true;
            }
            ++i;
            j += 2;
        }
        return visibleTotal;
    }

    protected ArrayList _forwardPoly(float[] rawllpts, int ltype, int nsegs, boolean isFilled) {
        int len = rawllpts.length >> 1;
        if (len < 2) {
            return new ArrayList(0);
        }
        float minlat = ProjMath.degToRad(-60.0f);
        boolean allBelowMinLat = true;
        int i = 0;
        int j = 0;
        while (i < len) {
            float l = rawllpts[j + 1];
            while (l < 0.0f) {
                l = (float)((double)l + Math.PI * 2);
            }
            if (rawllpts[j] > minlat) {
                allBelowMinLat = false;
            }
            ++i;
            j += 2;
        }
        if (allBelowMinLat) {
            return new ArrayList(0);
        }
        if (this.isComplicatedLineType(ltype)) {
            return this.doPolyDispatch(rawllpts, ltype, nsegs, isFilled);
        }
        Point temp = new Point();
        int[] xs = new int[len];
        int[] ys = new int[len];
        i = 0;
        j = 0;
        while (i < len) {
            temp = this.forward(rawllpts[j], rawllpts[j + 1], temp, true);
            xs[i] = temp.x;
            ys[i] = temp.y;
            ++i;
            j += 2;
        }
        ArrayList<int[]> ret_val = new ArrayList<int[]>(2);
        ret_val.add(xs);
        ret_val.add(ys);
        return ret_val;
    }

    public float getScale(LatLonPoint ll1, LatLonPoint ll2, Point point1, Point point2) {
        double widthPX = point2.x - point1.x;
        double heightPX = point2.y - point1.y;
        Point2D xx1 = this.LLToWorld(ll1.getLatitude(), ll1.getLongitude(), new Point2D.Double());
        Point2D xx2 = this.LLToWorld(ll2.getLatitude(), ll2.getLongitude(), new Point2D.Double());
        double widthMap = xx2.getX() - xx1.getX();
        double widthScale = (double)this.getPPM() * (widthMap / widthPX);
        double heightMap = xx2.getY() - xx1.getY();
        double heightScale = (double)this.getPPM() * (heightMap / heightPX);
        return (float)widthScale;
    }

    public void drawBackground(Graphics2D g, Paint paint) {
        g.setPaint(paint);
        this.drawBackground(g);
    }

    public void drawBackground(Graphics g) {
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
    }

    public static void main(String[] argv) {
        Debug.init();
        Debug.put("Lambert");
        LambertConformal proj = null;
        proj = new LambertConformal(new LatLonPoint(50.679573f, 5.80737f), 100000.0f, 620, 480, 4.356939315795898, 49.83333206176758, 51.16666793823242, 90.0, 150000.015625, 5400088.5, Ellipsoid.WGS_84);
        Debug.message("Lambert", "(1)" + proj.inverse(310, 240));
        LatLonPoint llp = new LatLonPoint(0.0f, 0.0f);
        Debug.message("Lambert", "(2)" + proj.worldToLL(251763.203125, 153034.125, llp));
        Point2D.Double lp = new Point2D.Double();
        LatLonPoint pt = new LatLonPoint(50.679573f, 5.80737f);
        Debug.message("Lambert", "(3)" + proj.LLToWorld(pt.getLatitude(), pt.getLongitude(), lp));
    }
}

