/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.proj;

import com.bbn.openmap.LatLonPoint;
import com.bbn.openmap.proj.Proj;
import com.bbn.openmap.proj.coords.DatumShiftGCT;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.geom.Point2D;
import java.util.ArrayList;

public class DatumShiftProjection
extends Proj {
    private Proj wrappedProjection;
    private DatumShiftGCT datum;

    public DatumShiftProjection(Proj proj, DatumShiftGCT datum) {
        super(proj.getCenter(), proj.getScale(), proj.getWidth(), proj.getHeight(), 299);
        this.datum = datum;
        this.wrappedProjection = proj;
        this.setCenter(proj.getCenter());
    }

    public void setCenter(float lat, float lon) {
        super.setCenter(lat, lon);
        Point2D centerInDifferentDatum = this.datum.forward(lat, lon, new Point2D.Double());
        this.wrappedProjection.setCenter((float)centerInDifferentDatum.getY(), (float)centerInDifferentDatum.getX());
    }

    protected ArrayList _forwardPoly(float[] rawllpts, int ltype, int nsegs, boolean isFilled) {
        float[] rawllptsInDifferentDatum = new float[rawllpts.length];
        Point2D tmpll = new Point2D.Double();
        for (int i = 0; i < rawllpts.length; i += 2) {
            tmpll = this.datum.forward(Math.toDegrees(rawllpts[i]), Math.toDegrees(rawllpts[i + 1]), tmpll);
            rawllptsInDifferentDatum[i] = (float)Math.toRadians(tmpll.getY());
            rawllptsInDifferentDatum[i + 1] = (float)Math.toRadians(tmpll.getX());
        }
        return this.wrappedProjection._forwardPoly(rawllptsInDifferentDatum, ltype, nsegs, isFilled);
    }

    protected void computeParameters() {
        if (this.wrappedProjection != null) {
            this.wrappedProjection.width = this.width;
            this.wrappedProjection.height = this.height;
            this.wrappedProjection.scale = this.scale;
            this.wrappedProjection.computeParameters();
        }
    }

    public void drawBackground(Graphics2D g, Paint p) {
        this.wrappedProjection.drawBackground(g, p);
    }

    public void drawBackground(Graphics g) {
        this.wrappedProjection.drawBackground(g);
    }

    public float normalize_latitude(float lat) {
        if (lat > 1.5707964f) {
            return 1.5707964f;
        }
        if (lat < -1.5707964f) {
            return -1.5707964f;
        }
        return lat;
    }

    public Point forward(LatLonPoint llp, Point pt) {
        return this.forward(llp.getLatitude(), llp.getLongitude(), pt);
    }

    public Point forward(float lat, float lon, Point pt) {
        return this.forward(lat, lon, pt, false);
    }

    public Point forward(float lat, float lon, Point pt, boolean isRadian) {
        Point2D t = isRadian ? this.datum.forward(Math.toDegrees(lat), Math.toDegrees(lon)) : this.datum.forward(lat, lon);
        return this.wrappedProjection.forward((float)t.getY(), (float)t.getX(), pt);
    }

    public boolean forwardRaw(float[] rawllpts, int rawoff, int[] xcoords, int[] ycoords, boolean[] visible, int copyoff, int copylen) {
        float[] rawllptsInDifferentDatum = new float[rawllpts.length];
        Point2D tmpll = new Point2D.Double();
        int end = copylen + copyoff;
        int i = copyoff;
        int j = rawoff;
        while (i < end) {
            tmpll = this.datum.forward(Math.toDegrees(rawllpts[j]), Math.toDegrees(rawllpts[j + 1]), tmpll);
            rawllptsInDifferentDatum[j] = (float)Math.toRadians(tmpll.getY());
            rawllptsInDifferentDatum[j + 1] = (float)Math.toRadians(tmpll.getX());
            ++i;
            j += 2;
        }
        return this.wrappedProjection.forwardRaw(rawllptsInDifferentDatum, rawoff, xcoords, ycoords, visible, copyoff, copylen);
    }

    public LatLonPoint getLowerRight() {
        LatLonPoint llp = this.wrappedProjection.getLowerRight();
        return this.datum.inverse(llp.getLongitude(), llp.getLatitude());
    }

    public LatLonPoint getUpperLeft() {
        LatLonPoint llp = this.wrappedProjection.getUpperLeft();
        return this.datum.inverse(llp.getLongitude(), llp.getLatitude());
    }

    public LatLonPoint inverse(Point point, LatLonPoint llpt) {
        return this.inverse(point.x, point.y, llpt);
    }

    public LatLonPoint inverse(int x, int y, LatLonPoint llpt) {
        llpt = this.wrappedProjection.inverse(x, y, llpt);
        return this.datum.inverse(llpt.getLongitude(), llpt.getLatitude(), llpt);
    }

    public boolean isPlotable(float lat, float lon) {
        Point2D t = this.datum.forward(lat, lon);
        return this.wrappedProjection.isPlotable((float)t.getY(), (float)t.getX());
    }

    public float getScale(LatLonPoint ll1, LatLonPoint ll2, Point point1, Point point2) {
        return this.wrappedProjection.getScale(ll1, ll2, point1, point2);
    }
}

