/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.proj;

import com.bbn.openmap.LatLonPoint;
import com.bbn.openmap.proj.Proj;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.util.ArrayList;

public class AspectRatioProjection
extends Proj {
    private Proj wrappedProjection;
    private float xFactor;
    private float yFactor;
    private float halfWidth;
    private float halfWrappedWidth;
    private float halfHeight;
    private float halfWrappedHeight;
    private boolean xHasFactor;
    private boolean yHasFactor;

    public AspectRatioProjection(Proj proj, int w, int h) {
        super(proj.getCenter(), proj.getScale(), w, h, 199);
        this.wrappedProjection = proj;
        this.xHasFactor = proj.getWidth() != w;
        this.yHasFactor = proj.getHeight() != h;
        this.computeParameters();
    }

    private Point fromWrapped(Point pt) {
        pt.x = this.xFromWrapped(pt.x);
        pt.y = this.yFromWrapped(pt.y);
        return pt;
    }

    private int xFromWrapped(int x) {
        if (!this.xHasFactor) {
            return x;
        }
        return (int)(((float)x - this.halfWrappedWidth) * this.xFactor + this.halfWidth);
    }

    private int yFromWrapped(int y) {
        if (!this.yHasFactor) {
            return y;
        }
        return (int)(((float)y - this.halfWrappedHeight) * this.yFactor + this.halfHeight);
    }

    private int xToWrapped(int x) {
        if (!this.xHasFactor) {
            return x;
        }
        return (int)(((float)x - this.halfWidth) / this.xFactor + this.halfWrappedWidth);
    }

    private int yToWrapped(int y) {
        if (!this.yHasFactor) {
            return y;
        }
        return (int)(((float)y - this.halfHeight) / this.yFactor + this.halfWrappedHeight);
    }

    protected ArrayList _forwardPoly(float[] rawllpts, int ltype, int nsegs, boolean isFilled) {
        ArrayList stuff = this.wrappedProjection._forwardPoly(rawllpts, ltype, nsegs, isFilled);
        int size = stuff.size();
        for (int i = 0; i < size; i += 2) {
            int[] xpts = (int[])stuff.get(i);
            if (this.xHasFactor) {
                for (int j = 0; j < xpts.length; ++j) {
                    xpts[j] = this.xFromWrapped(xpts[j]);
                }
            }
            if (!this.yHasFactor) continue;
            int[] ypts = (int[])stuff.get(i + 1);
            for (int j = 0; j < ypts.length; ++j) {
                ypts[j] = this.yFromWrapped(ypts[j]);
            }
        }
        return stuff;
    }

    protected void computeParameters() {
        if (this.wrappedProjection != null) {
            this.wrappedProjection.computeParameters();
            this.xFactor = (float)((double)this.getWidth() / (double)this.wrappedProjection.getWidth());
            this.yFactor = (float)((double)this.getHeight() / (double)this.wrappedProjection.getHeight());
            this.halfWidth = (float)this.getWidth() / 2.0f;
            this.halfHeight = (float)this.getHeight() / 2.0f;
            this.halfWrappedWidth = (float)this.wrappedProjection.getWidth() / 2.0f;
            this.halfWrappedHeight = (float)this.wrappedProjection.getHeight() / 2.0f;
        }
    }

    public void drawBackground(Graphics2D g, Paint p) {
        this.wrappedProjection.drawBackground(g, p);
    }

    public void drawBackground(Graphics g) {
        this.wrappedProjection.drawBackground(g);
    }

    public float normalize_latitude(float lat) {
        if (this.wrappedProjection == null) {
            if (lat > 1.5707964f) {
                return 1.5707964f;
            }
            if (lat < -1.5707964f) {
                return -1.5707964f;
            }
            return lat;
        }
        return this.wrappedProjection.normalize_latitude(lat);
    }

    public Point forward(LatLonPoint llp, Point pt) {
        return this.fromWrapped(this.wrappedProjection.forward(llp, pt));
    }

    public Point forward(float lat, float lon, Point pt) {
        return this.fromWrapped(this.wrappedProjection.forward(lat, lon, pt));
    }

    public Point forward(float lat, float lon, Point pt, boolean isRadian) {
        return this.fromWrapped(this.wrappedProjection.forward(lat, lon, pt, isRadian));
    }

    public boolean forwardRaw(float[] rawllpts, int rawoff, int[] xcoords, int[] ycoords, boolean[] visible, int copyoff, int copylen) {
        boolean r = this.wrappedProjection.forwardRaw(rawllpts, rawoff, xcoords, ycoords, visible, copyoff, copylen);
        int end = copylen + copyoff;
        for (int i = copyoff; i < end; ++i) {
            if (this.xHasFactor) {
                xcoords[i] = this.xFromWrapped(xcoords[i]);
            }
            if (!this.yHasFactor) continue;
            ycoords[i] = this.yFromWrapped(ycoords[i]);
        }
        return r;
    }

    public LatLonPoint getLowerRight() {
        return this.wrappedProjection.getLowerRight();
    }

    public LatLonPoint getUpperLeft() {
        return this.wrappedProjection.getUpperLeft();
    }

    public LatLonPoint inverse(Point point, LatLonPoint llpt) {
        return this.inverse(point.x, point.y, llpt);
    }

    public LatLonPoint inverse(int x, int y, LatLonPoint llpt) {
        return this.wrappedProjection.inverse(this.xToWrapped(x), this.yToWrapped(y), llpt);
    }

    public boolean isPlotable(float lat, float lon) {
        return this.wrappedProjection.isPlotable(lat, lon);
    }
}

