/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.omGraphics.util;

import com.bbn.openmap.omGraphics.OMColor;
import com.bbn.openmap.omGraphics.OMGraphicList;
import com.bbn.openmap.omGraphics.OMLine;
import com.bbn.openmap.omGraphics.OMRect;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.util.Debug;
import java.awt.Graphics;
import java.awt.Point;
import java.io.Serializable;

public class ArcCalc
implements Serializable {
    protected transient OMGraphicList arcGraphics = null;
    protected transient int[] xpoints;
    protected transient int[] ypoints;
    protected double arcAngle = 0.0;
    protected boolean arcUp = true;
    protected boolean reversed = false;

    public ArcCalc(double aa, boolean putArcUp) {
        this.arcAngle = aa;
        this.arcUp = putArcUp;
        if (aa < 0.0) {
            this.arcAngle *= -1.0;
            boolean bl = this.arcUp = !this.arcUp;
        }
        if (this.arcAngle > Math.PI) {
            this.arcAngle = Math.PI;
        }
    }

    public double getArcAngle() {
        return this.arcAngle;
    }

    public boolean isArcUp() {
        return this.arcUp;
    }

    public void generate(int x1, int y1, int x2, int y2) {
        double tmpSlope;
        double largeSlope;
        double endSlope;
        double arccos;
        Point midPoint = new Point();
        Point arcCenter = new Point();
        Point peakPoint = new Point();
        double distance = Math.sqrt(Math.pow(Math.abs(y2 - y1), 2.0) + Math.pow(Math.abs(x2 - x1), 2.0));
        double straightLineSlope = Math.atan((double)(y2 - y1) / (double)(x2 - x1));
        double inverseSlope = straightLineSlope - 1.5707963267948966;
        if (Debug.debugging("arc")) {
            Debug.output("ArcCalc.generate: Slope is " + straightLineSlope * 180.0 / Math.PI + " degrees, distance = " + distance + " pixels.");
        }
        midPoint.x = x1 + (x2 - x1) / 2;
        midPoint.y = y1 + (y2 - y1) / 2;
        if (Debug.debugging("arc")) {
            Debug.output("ArcCalc.generate: Center point for (" + x1 + ", " + y1 + ") to (" + x2 + ", " + y2 + ") is (" + midPoint.x + ", " + midPoint.y + ")");
        }
        double arcRadius = (arccos = Math.cos(this.arcAngle)) != 1.0 ? distance / Math.sqrt(2.0 * (1.0 - Math.cos(this.arcAngle))) : distance / Math.sqrt(2.0);
        if (Debug.debugging("arc")) {
            Debug.output("ArcCalc.generate: radius of arc = " + arcRadius);
        }
        double x = arcRadius - arcRadius * Math.cos(this.arcAngle);
        double rPrime = distance / 2.0 * Math.sqrt(1.0 - Math.pow(x / distance, 2.0)) / Math.sin(this.arcAngle / 2.0);
        if (Debug.debugging("arc")) {
            Debug.output("ArcCalc.generate: rPrime = " + rPrime);
        }
        int direction = 1;
        if (this.arcUp) {
            direction = -1;
        }
        arcCenter.x = midPoint.x + direction * (int)(rPrime * Math.cos(inverseSlope));
        arcCenter.y = midPoint.y + direction * (int)(rPrime * Math.sin(inverseSlope));
        if (Debug.debugging("arc")) {
            Debug.output("ArcCalc.generateArc: creating supplimental graphics list");
            this.arcGraphics = new OMGraphicList();
            double dist1 = Math.sqrt(Math.pow(arcCenter.x - x1, 2.0) + Math.pow(arcCenter.y - y1, 2.0));
            double dist2 = Math.sqrt(Math.pow(arcCenter.x - x2, 2.0) + Math.pow(arcCenter.y - y2, 2.0));
            Debug.output("ArcCalc.generate: Center focus for arc is (" + arcCenter.x + ", " + arcCenter.y + ") along slope line of " + inverseSlope * 180.0 / Math.PI + " degrees).");
            Debug.output("ArcCalc.generate: Distance to point 1 from arc focus = " + dist1 + "\n                    Distance to point 2 from arc focus = " + dist2);
            OMRect point1 = new OMRect(x1 - 1, y1 - 1, x1 + 1, y1 + 1);
            OMRect point2 = new OMRect(x2 - 1, y2 - 1, x2 + 1, y2 + 1);
            OMRect arcPoint = new OMRect(arcCenter.x - 1, arcCenter.y - 1, arcCenter.x + 1, arcCenter.y + 1);
            point1.setLinePaint(OMColor.red);
            point2.setLinePaint(OMColor.red);
            arcPoint.setLinePaint(OMColor.blue);
            this.arcGraphics.add(point1);
            this.arcGraphics.add(point2);
            this.arcGraphics.add(arcPoint);
            OMLine line1 = new OMLine(x1, y1, x2, y2);
            OMLine line2 = new OMLine(midPoint.x, midPoint.y, arcCenter.x, arcCenter.y);
            this.arcGraphics.add(line1);
            this.arcGraphics.add(line2);
        }
        int realCount = 0;
        double startSlope = this.getRealAngle(arcCenter.x, arcCenter.y, x1, y1);
        double smallSlope = startSlope > (endSlope = this.getRealAngle(arcCenter.x, arcCenter.y, x2, y2)) ? endSlope : startSlope;
        double d = largeSlope = smallSlope == startSlope ? endSlope : startSlope;
        while (Math.abs(smallSlope - largeSlope) > Math.PI && !(Math.abs(largeSlope - smallSlope - Math.PI) < 0.001)) {
            Debug.message("arc", "ArcCalc.generate: Modifying the starting slope.");
            tmpSlope = smallSlope + 6.2831854820251465;
            smallSlope = largeSlope;
            largeSlope = tmpSlope;
        }
        if (this.arcAngle == Math.PI && this.arcUp) {
            Debug.message("arc", "ArcCalc.generate: Modifying 180 angle points.");
            tmpSlope = smallSlope + 6.2831854820251465;
            smallSlope = largeSlope;
            largeSlope = tmpSlope;
        }
        double angleIncrement = Math.abs(y2 - y1) < Math.abs(x2 - x1) ? Math.PI / (double)Math.abs(x2 - x1) : Math.PI / (double)Math.abs(y2 - y1);
        int numPoints = (int)(Math.abs(smallSlope - largeSlope) / angleIncrement + 2.0);
        int[] xPoints = new int[numPoints];
        int[] yPoints = new int[numPoints];
        if (Debug.debugging("arc")) {
            Debug.output("ArcCalc.generate: angle to x1, y1 is " + startSlope + " (" + startSlope * 180.0 / Math.PI + " degrees), angle to x2, y2 is " + endSlope + " (" + endSlope * 180.0 / Math.PI + " degrees)");
            Debug.output("ArcCalc.generate: Starting angle is " + smallSlope + "(" + smallSlope * 180.0 / Math.PI + " degrees), end angle is " + largeSlope + " (" + largeSlope * 180.0 / Math.PI + " degrees), incrementing by " + angleIncrement + " (" + angleIncrement * 180.0 / Math.PI + " degrees)");
        }
        this.reversed = false;
        while (smallSlope < largeSlope && realCount < numPoints) {
            xPoints[realCount] = arcCenter.x + (int)(arcRadius * Math.cos(smallSlope));
            yPoints[realCount] = arcCenter.y + (int)(arcRadius * Math.sin(smallSlope));
            if (realCount == 0 && xPoints[realCount] == x2) {
                Debug.message("arc", "ArcCalc: line reversed");
                this.reversed = true;
            }
            if (Debug.debugging("arc") && realCount == 0) {
                OMLine startLine = new OMLine(arcCenter.x, arcCenter.y, xPoints[0], yPoints[0]);
                startLine.setLinePaint(OMColor.white);
                this.arcGraphics.add(startLine);
            } else if (Debug.debugging("arcdetail")) {
                Debug.output("  angle " + smallSlope + " (" + smallSlope * 180.0 / Math.PI + " degrees)  = " + xPoints[realCount] + ", " + yPoints[realCount]);
            }
            if (Math.abs(largeSlope - smallSlope - this.arcAngle / 2.0) < angleIncrement) {
                peakPoint.x = xPoints[realCount];
                peakPoint.y = yPoints[realCount];
                Debug.message("arc", "ArcCalc: Found a midpoint.");
            }
            smallSlope += angleIncrement;
            ++realCount;
        }
        this.xpoints = new int[realCount];
        this.ypoints = new int[realCount];
        System.arraycopy(xPoints, 0, this.xpoints, 0, realCount);
        System.arraycopy(yPoints, 0, this.ypoints, 0, realCount);
    }

    protected double getRealAngle(int x1, int y1, int x2, int y2) {
        double angle = 0.0;
        double horDiff = x2 - x1;
        double vertDiff = y2 - y1;
        if (horDiff == 0.0) {
            if (vertDiff > 0.0) {
                angle = 1.5707963705062866;
            } else if (vertDiff < 0.0) {
                angle = -1.5707963705062866;
            }
        } else {
            angle = Math.atan(vertDiff / horDiff);
            if (horDiff < 0.0) {
                angle += Math.PI;
            }
        }
        while (angle < 0.0) {
            angle += 6.2831854820251465;
        }
        return angle;
    }

    public int[] getXPoints() {
        return this.xpoints;
    }

    public int[] getYPoints() {
        return this.ypoints;
    }

    public void generate(Projection proj) {
        if (proj != null && this.arcGraphics != null) {
            this.arcGraphics.generate(proj);
        }
    }

    public void render(Graphics g) {
        if (this.arcGraphics != null) {
            Debug.output("OMLine rendering " + this.arcGraphics.size() + " arcGraphics.");
            this.arcGraphics.render(g);
        }
    }

    public OMGraphicList getArcGraphics() {
        if (this.arcGraphics == null) {
            return new OMGraphicList();
        }
        return this.arcGraphics;
    }

    public boolean getReversed() {
        return this.reversed;
    }
}

