/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.omGraphics.editable;

import com.bbn.openmap.layer.util.stateMachine.State;
import com.bbn.openmap.omGraphics.EditableOMGraphic;
import com.bbn.openmap.omGraphics.GrabPoint;
import com.bbn.openmap.omGraphics.editable.EOMGCursors;
import com.bbn.openmap.omGraphics.editable.EOMGDefinedState;
import com.bbn.openmap.util.Debug;
import java.awt.event.MouseEvent;

public class GraphicUnselectedState
extends State
implements EOMGDefinedState {
    protected EditableOMGraphic graphic;

    public GraphicUnselectedState(EditableOMGraphic eomg) {
        this.graphic = eomg;
    }

    public boolean mousePressed(MouseEvent e) {
        Debug.message("eomg", "GraphicStateMachine|unselected state|mousePressed");
        GrabPoint mp = this.graphic.getMovingPoint(e);
        if (mp == null) {
            if (this.graphic.getGraphic().distance(e.getX(), e.getY()) < 2.0f) {
                if (this.graphic.getCanGrabGraphic()) {
                    Debug.message("eomg", "GraphicStateMachine|unselected state|mousePressed - graphic held");
                    this.graphic.getStateMachine().setEdit();
                    this.graphic.fireEvent(EOMGCursors.EDIT, "");
                    this.graphic.move(e);
                } else {
                    this.graphic.getStateMachine().setSelected();
                    this.graphic.fireEvent(EOMGCursors.DEFAULT, "");
                }
                this.graphic.redraw(e, true);
            }
        } else {
            this.graphic.getStateMachine().setEdit();
            this.graphic.fireEvent(EOMGCursors.EDIT, "");
            this.graphic.redraw(e, true);
        }
        return this.getMapMouseListenerResponse();
    }

    public boolean mouseReleased(MouseEvent e) {
        Debug.message("eomg", "GraphicStateMachine|unselected state|mouseReleased");
        GrabPoint mp = this.graphic.getMovingPoint(e);
        if (mp == null) {
            if (this.graphic.getGraphic().distance(e.getX(), e.getY()) < 2.0f) {
                this.graphic.getStateMachine().setSelected();
                this.graphic.fireEvent(EOMGCursors.EDIT, "");
            } else {
                this.graphic.setMovingPoint(new GrabPoint(e.getX(), e.getY()));
                this.graphic.fireEvent(EOMGCursors.DEFAULT, "", e);
                this.graphic.setMovingPoint(null);
            }
            this.graphic.redraw(e, true);
        } else {
            this.graphic.setMovingPoint(null);
        }
        return this.getMapMouseListenerResponse();
    }

    public boolean mouseMoved(MouseEvent e) {
        Debug.message("eomgdetail", "GraphicStateMachine|unselected state|mouseMoved");
        if (this.graphic.getGraphic().distance(e.getX(), e.getY()) < 2.0f) {
            this.graphic.fireEvent(EOMGCursors.EDIT, this.i18n.get(GraphicUnselectedState.class, "Click_to_select_the_graphic.", "Click to select the graphic."));
        } else {
            this.graphic.fireEvent(EOMGCursors.DEFAULT, "");
        }
        return false;
    }
}

