/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.omGraphics;

import com.bbn.openmap.omGraphics.FontSizer;
import com.bbn.openmap.omGraphics.OMGraphic;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.util.Debug;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class OMText
extends OMGraphic
implements Serializable {
    public static final transient int JUSTIFY_LEFT = 0;
    public static final transient int JUSTIFY_CENTER = 1;
    public static final transient int JUSTIFY_RIGHT = 2;
    public static final transient int HEIGHT = 0;
    public static final transient int ASCENT_DESCENT = 1;
    public static final transient int ASCENT_LEADING = 2;
    public static final transient int ASCENT = 3;
    public static final transient int BASELINE_BOTTOM = 0;
    public static final transient int BASELINE_MIDDLE = 1;
    public static final transient int BASELINE_TOP = 2;
    public static final Font DEFAULT_FONT = new Font("SansSerif", 0, 12);
    public static final Stroke DEFAULT_TEXT_MATTE_STROKE = new BasicStroke(2.0f);
    protected Point pt;
    protected Point point;
    protected Font f;
    protected FontSizer fontSizer = null;
    protected float lat = 0.0f;
    protected float lon = 0.0f;
    protected String data = null;
    protected int justify = 0;
    protected int baseline = 0;
    protected int fmHeight = 0;
    protected boolean useMaxWidthForBounds = false;
    protected double rotationAngle = 0.0;
    protected Color textMatteColor;
    protected Stroke textMatteStroke = DEFAULT_TEXT_MATTE_STROKE;
    protected transient Polygon polyBounds;
    protected transient FontMetrics fm;
    protected transient String[] parsedData;
    protected transient int[] widths;
    protected Projection hackProj = null;

    public OMText() {
        super(0, 0, 0);
        this.point = new Point(0, 0);
        this.setData("");
        this.f = DEFAULT_FONT;
    }

    public OMText(float lt, float ln, String stuff, int just) {
        this(lt, ln, stuff, DEFAULT_FONT, just);
    }

    public OMText(float lt, float ln, String stuff, Font font, int just) {
        super(1, 0, 0);
        this.lat = lt;
        this.lon = ln;
        this.setData(stuff);
        this.f = font;
        this.justify = just;
    }

    public OMText(int px1, int py1, String stuff, int just) {
        this(px1, py1, stuff, DEFAULT_FONT, just);
    }

    public OMText(int px1, int py1, String stuff, Font font, int just) {
        super(2, 0, 0);
        this.point = new Point(px1, py1);
        this.setData(stuff);
        this.f = font;
        this.justify = just;
    }

    public OMText(float lt, float ln, int offX, int offY, String aString, int just) {
        this(lt, ln, offX, offY, aString, DEFAULT_FONT, just);
    }

    public OMText(float lt, float ln, int offX, int offY, String aString, Font font, int just) {
        super(3, 0, 0);
        this.lat = lt;
        this.lon = ln;
        this.point = new Point(offX, offY);
        this.setData(aString);
        this.f = font;
        this.justify = just;
    }

    public Font getFont() {
        if (this.f == null) {
            this.f = DEFAULT_FONT;
        }
        return this.f;
    }

    public void setFont(Font aFont) {
        if (this.fontSizer != null) {
            this.fontSizer.setFont(aFont);
            this.setScaledFont(this.fontSizer.getScaledFont());
        } else {
            this.setScaledFont(aFont);
        }
    }

    protected void setScaledFont(Font aFont) {
        this.f = aFont;
        this.fm = null;
        this.widths = null;
        this.polyBounds = null;
    }

    public void setFont(float scale) {
        if (this.fontSizer != null) {
            this.setScaledFont(this.fontSizer.getFont(scale));
        }
    }

    public void setFontSizer(FontSizer fs) {
        Font bf = this.getFont();
        if (fs != null) {
            bf = fs.getFont();
        }
        this.fontSizer = fs;
        this.setFont(bf);
    }

    public FontSizer getFontSizer() {
        return this.fontSizer;
    }

    public int getX() {
        if (this.point != null) {
            return this.point.x;
        }
        return 0;
    }

    public void setX(int newX) {
        if (this.point == null && this.getRenderType() == 1) {
            this.point = new Point();
            this.setRenderType(3);
        }
        this.point.x = newX;
        this.setNeedToRegenerate(true);
    }

    public int getY() {
        if (this.point != null) {
            return this.point.y;
        }
        return 0;
    }

    public void setY(int newY) {
        if (this.point == null && this.getRenderType() == 1) {
            this.point = new Point();
            this.setRenderType(3);
        }
        this.point.y = newY;
        this.setNeedToRegenerate(true);
    }

    public float getLat() {
        return this.lat;
    }

    public void setLat(float l) {
        this.lat = l;
        this.setNeedToRegenerate(true);
    }

    public float getLon() {
        return this.lon;
    }

    public void setLon(float l) {
        this.lon = l;
        this.setNeedToRegenerate(true);
    }

    public Point getMapLocation() {
        return this.pt;
    }

    public void setMapLocation(Point point) {
        this.pt = point;
        this.polyBounds = null;
    }

    public Color getTextMatteColor() {
        return this.textMatteColor;
    }

    public void setTextMatteColor(Color textMatteColor) {
        this.textMatteColor = textMatteColor;
    }

    public Stroke getTextMatteStroke() {
        return this.textMatteStroke;
    }

    public void setTextMatteStroke(Stroke textMatteStroke) {
        this.textMatteStroke = textMatteStroke;
    }

    public String getData() {
        return this.data;
    }

    public synchronized void setData(String d) {
        this.data = d;
        this.parsedData = null;
        this.widths = null;
        this.polyBounds = null;
    }

    public int getJustify() {
        return this.justify;
    }

    public void setJustify(int j) {
        this.justify = j;
        this.polyBounds = null;
    }

    public int getBaseline() {
        return this.baseline;
    }

    public void setBaseline(int b) {
        this.baseline = b;
        this.polyBounds = null;
    }

    public boolean getShowBounds() {
        return this.isMatted();
    }

    public void setShowBounds(boolean show) {
        this.setMatted(show);
    }

    public void setUseMaxWidthForBounds(boolean value) {
        this.useMaxWidthForBounds = value;
    }

    public boolean getUseMaxWidthForBounds() {
        return this.useMaxWidthForBounds;
    }

    public Polygon getPolyBounds() {
        if (this.polyBounds == null) {
            this.computeBounds();
        }
        return this.polyBounds;
    }

    public void setFMHeight(int fmh) {
        this.fmHeight = fmh;
    }

    public int getFMHeight() {
        return this.fmHeight;
    }

    public void setTheta(double theta) {
        this.setRotationAngle(theta);
        this.setNeedToRegenerate(true);
    }

    public double getTheta() {
        return this.getRotationAngle();
    }

    public void setRotationAngle(double angle) {
        this.rotationAngle = angle;
        this.setNeedToRegenerate(true);
    }

    public double getRotationAngle() {
        return this.rotationAngle;
    }

    public synchronized boolean generate(Projection proj) {
        if (proj == null) {
            Debug.message("omgraphic", "OMText: null projection in generate!");
            return false;
        }
        this.polyBounds = null;
        switch (this.renderType) {
            case 2: {
                this.pt = this.point;
                break;
            }
            case 3: {
                if (!proj.isPlotable(this.lat, this.lon)) {
                    if (Debug.debugging("omgraphic")) {
                        System.err.println("OMText.generate(): offset point is not plotable!");
                    }
                    this.setNeedToRegenerate(true);
                    return false;
                }
                this.pt = proj.forward(this.lat, this.lon);
                this.pt.translate(this.point.x, this.point.y);
                break;
            }
            case 1: {
                if (!proj.isPlotable(this.lat, this.lon)) {
                    if (Debug.debugging("omgraphic")) {
                        System.err.println("OMText.generate(): llpoint is not plotable!");
                    }
                    this.setNeedToRegenerate(true);
                    return false;
                }
                this.pt = proj.forward(this.lat, this.lon);
                break;
            }
            case 0: {
                System.err.println("OMText.render.generate(): invalid RenderType");
                return false;
            }
        }
        this.setFont(proj.getScale());
        this.computeBounds();
        this.setNeedToRegenerate(false);
        return true;
    }

    public static Font rebuildFont(String fontString) {
        String tmpFontSize;
        if (fontString.equals("")) {
            return DEFAULT_FONT;
        }
        int fontStyle = 0;
        int fontSize = 12;
        int start = fontString.indexOf("-", 1) + 1;
        int end = fontString.indexOf("-", start + 1);
        String name = fontString.substring(start, end);
        if (fontString.indexOf("-bold-") >= 0) {
            fontStyle = 1;
        }
        if (fontString.indexOf("-i-") >= 0) {
            fontStyle += 2;
        }
        if ((tmpFontSize = fontString.substring(start = fontString.indexOf("--") + 2, end = fontString.indexOf("-", start + 1))).indexOf("*") < 0) {
            fontSize = Integer.parseInt(tmpFontSize);
        }
        return new Font(name, fontStyle, fontSize);
    }

    public static String fontToXFont(Font font) {
        StringBuffer ret = new StringBuffer("-*");
        ret.append("-" + font.getName());
        if (font.isBold()) {
            ret.append("-bold");
        } else {
            ret.append("-normal");
        }
        if (font.isItalic()) {
            ret.append("-i");
        } else {
            ret.append("-o");
        }
        ret.append("-normal");
        ret.append("--" + font.getSize());
        ret.append("-*");
        ret.append("-*");
        ret.append("-*");
        ret.append("-*");
        ret.append("-*");
        ret.append("-*");
        return ret.toString();
    }

    protected int countChar(String str, int ch) {
        int fromIndex = 0;
        int count = 0;
        while ((fromIndex = str.indexOf(ch, fromIndex)) != -1) {
            ++count;
            ++fromIndex;
        }
        return count;
    }

    protected void parseData() {
        if (this.parsedData == null) {
            int nLines;
            if (this.data == null) {
                this.data = "";
            }
            if ((nLines = this.countChar(this.data, 10) + 1) <= 1) {
                this.parsedData = new String[1];
                this.parsedData[0] = this.data;
            } else {
                int i = 0;
                int fromIndex = 0;
                int toIndex = 0;
                this.parsedData = new String[nLines];
                while ((toIndex = this.data.indexOf(10, fromIndex)) != -1) {
                    this.parsedData[i] = this.data.substring(fromIndex, toIndex);
                    fromIndex = toIndex + 1;
                    ++i;
                }
                this.parsedData[nLines - 1] = this.data.substring(fromIndex, this.data.length());
            }
        }
    }

    protected void computeStringWidths(FontMetrics fm) {
        if (this.widths == null && fm != null) {
            int nLines = this.parsedData.length;
            this.widths = new int[nLines];
            for (int i = 0; i < nLines; ++i) {
                this.widths[i] = fm.stringWidth(this.parsedData[i]);
            }
        }
    }

    public synchronized void prepareForRender(Graphics g) {
        this.parseData();
        g.setFont(this.getFont());
        if (this.fm == null) {
            this.fm = g.getFontMetrics();
        }
        this.computeBounds();
    }

    public synchronized void render(Graphics g) {
        g = g.create();
        if (this.getNeedToRegenerate() || this.pt == null || !this.isVisible()) {
            return;
        }
        g.setFont(this.getFont());
        this.setGraphicsForEdge(g);
        if (this.fm == null) {
            this.fm = g.getFontMetrics();
        }
        this.computeBounds();
        if (this.shouldRenderFill()) {
            this.setGraphicsForFill(g);
            this.fill(g);
            if (this.textureMask != null && this.textureMask != this.fillPaint) {
                this.setGraphicsColor(g, this.textureMask);
                this.fill(g);
            }
        }
        if (this.isMatted()) {
            if (this.isSelected()) {
                this.setGraphicsColor(g, this.getSelectPaint());
            } else {
                this.setGraphicsColor(g, this.getMattingPaint());
            }
            this.draw(g);
        }
        double rx = 0.0;
        double rw = 0.0;
        double woffset = 0.0;
        if (g instanceof Graphics2D && this.rotationAngle != 0.0) {
            Rectangle rect = this.polyBounds.getBounds();
            rx = rect.getX();
            rw = rect.getWidth();
            woffset = 0.0;
            switch (this.justify) {
                case 0: {
                    break;
                }
                case 1: {
                    woffset = rw / 2.0;
                    break;
                }
                case 2: {
                    woffset = rw;
                }
            }
            ((Graphics2D)g).rotate(this.rotationAngle, rx + woffset, this.pt.y);
        }
        this.setGraphicsForEdge(g);
        int height = this.fmHeight == 0 ? this.fm.getHeight() : (this.fmHeight == 2 ? this.fm.getHeight() - this.fm.getDescent() : (this.fmHeight == 1 ? this.fm.getAscent() + this.fm.getDescent() : this.fm.getAscent()));
        int baselineLocation = this.pt.y;
        if (this.baseline == 1) {
            baselineLocation += (this.fm.getAscent() - this.fm.getDescent()) / 2;
        } else if (this.baseline == 2) {
            baselineLocation += this.fm.getAscent() - this.fm.getDescent();
        }
        switch (this.justify) {
            case 0: {
                for (int i = 0; i < this.parsedData.length; ++i) {
                    this.renderString(g, this.parsedData[i], this.pt.x, baselineLocation + height * i);
                }
                break;
            }
            case 1: {
                this.computeStringWidths(this.fm);
                for (int i = 0; i < this.parsedData.length; ++i) {
                    this.renderString(g, this.parsedData[i], this.pt.x - this.widths[i] / 2, baselineLocation + height * i);
                }
                break;
            }
            case 2: {
                this.computeStringWidths(this.fm);
                for (int i = 0; i < this.parsedData.length; ++i) {
                    this.renderString(g, this.parsedData[i], this.pt.x - this.widths[i], baselineLocation + height * i);
                }
                break;
            }
        }
    }

    protected void renderString(Graphics g, String string, int x, int y) {
        if (g instanceof Graphics2D) {
            Graphics2D g2 = (Graphics2D)g;
            if (this.getTextMatteColor() != null) {
                FontRenderContext context = g2.getFontRenderContext();
                GlyphVector glyphVector = g2.getFont().createGlyphVector(context, string);
                Shape outline = glyphVector.getOutline();
                g2.translate(x, y);
                g2.setStroke(this.getTextMatteStroke());
                g2.setColor(this.getTextMatteColor());
                g2.draw(outline);
                g2.translate(-x, -y);
                g2.setColor(this.getLineColor());
            }
        }
        g.drawString(string, x, y);
    }

    protected void computeBounds() {
        if (this.parsedData == null) {
            this.parseData();
        }
        if (this.polyBounds == null && this.pt != null && this.fm != null) {
            int i;
            int descent;
            int height;
            int xoffset = 0;
            if (this.fmHeight == 0) {
                height = this.fm.getHeight();
                descent = this.fm.getDescent();
            } else if (this.fmHeight == 1) {
                height = this.fm.getAscent();
                descent = this.fm.getDescent();
            } else if (this.fmHeight == 2) {
                height = this.fm.getHeight() - this.fm.getDescent();
                descent = 0;
            } else {
                height = this.fm.getAscent();
                descent = 0;
            }
            int nLines = this.parsedData.length;
            this.polyBounds = new Polygon();
            this.computeStringWidths(this.fm);
            int baselineOffset = 0;
            if (this.baseline == 1) {
                baselineOffset = descent / 2;
            } else if (this.baseline == 2) {
                baselineOffset = descent;
            }
            int currenty = this.pt.y + descent - height - baselineOffset;
            for (i = 0; i < nLines; ++i) {
                switch (this.justify) {
                    case 0: {
                        xoffset = this.widths[i];
                        break;
                    }
                    case 1: {
                        xoffset = this.widths[i] / 2;
                        break;
                    }
                    case 2: {
                        xoffset = 0;
                    }
                }
                this.polyBounds.addPoint(this.pt.x + xoffset, currenty);
                this.polyBounds.addPoint(this.pt.x + xoffset, currenty += height);
            }
            for (i = nLines - 1; i >= 0; --i) {
                switch (this.justify) {
                    case 0: {
                        xoffset = 0;
                        break;
                    }
                    case 1: {
                        xoffset = -this.widths[i] / 2;
                        break;
                    }
                    case 2: {
                        xoffset = -this.widths[i];
                    }
                }
                this.polyBounds.addPoint(this.pt.x + xoffset, currenty);
                this.polyBounds.addPoint(this.pt.x + xoffset, currenty -= height);
            }
            if (this.polyBounds != null) {
                if (this.useMaxWidthForBounds) {
                    this.setShape(new GeneralPath(this.polyBounds.getBounds()));
                } else {
                    this.setShape(new GeneralPath(this.polyBounds));
                }
                if (this.rotationAngle != 0.0) {
                    Rectangle rect = this.polyBounds.getBounds();
                    double rx = rect.getX();
                    double rw = rect.getWidth();
                    double woffset = 0.0;
                    switch (this.justify) {
                        case 0: {
                            break;
                        }
                        case 1: {
                            woffset = rw / 2.0;
                            break;
                        }
                        case 2: {
                            woffset = rw;
                        }
                    }
                    AffineTransform at = new AffineTransform();
                    at.rotate(this.rotationAngle, rx + woffset, this.pt.y);
                    PathIterator pi = this.shape.getPathIterator(at);
                    GeneralPath gp = new GeneralPath();
                    gp.append(pi, false);
                    this.shape = gp;
                }
            }
        } else if (Debug.debugging("omtext")) {
            Debug.output("OMText.computeBounds() didn't compute because polybounds = " + this.polyBounds + " or  pt = " + this.pt + " or fm = " + this.fm + ", (only polybounds should be null)");
        }
    }

    public float distance(int x, int y) {
        return this._distance(x, y);
    }

    protected boolean hasLineTypeChoice() {
        return false;
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        oos.defaultWriteObject();
        boolean writeFont = this.f != DEFAULT_FONT;
        oos.writeBoolean(writeFont);
        if (writeFont) {
            oos.writeObject(this.f.getName());
            oos.writeInt(this.f.getSize());
            oos.writeInt(this.f.getStyle());
        }
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        ois.defaultReadObject();
        boolean hasFont = ois.readBoolean();
        if (hasFont) {
            String name = (String)ois.readObject();
            int size = ois.readInt();
            int style = ois.readInt();
            this.f = new Font(name, style, size);
        } else {
            this.f = DEFAULT_FONT;
        }
    }
}

