/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.omGraphics;

import com.bbn.openmap.omGraphics.OMGraphic;
import com.bbn.openmap.omGraphics.OMGraphicList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class OMGraphicHash
extends OMGraphicList
implements Map {
    private HashMap graphicHash = new HashMap();
    private boolean cloningInProgress;

    public OMGraphicHash() {
    }

    public OMGraphicHash(int initialCapacity) {
        super(initialCapacity);
    }

    public Object get(Object obj) {
        return this.graphicHash.get(obj);
    }

    public boolean containsKey(Object obj) {
        return this.graphicHash.containsKey(obj);
    }

    public boolean containsValue(Object obj) {
        return this.graphicHash.containsValue(obj);
    }

    public Set entrySet() {
        return this.graphicHash.entrySet();
    }

    public Set keySet() {
        return this.graphicHash.keySet();
    }

    public Object put(Object key, Object graphic) {
        if (!(graphic instanceof OMGraphic)) {
            throw new ClassCastException("Value is not an OMGraphic");
        }
        if (this.graphicHash.containsValue(graphic)) {
            ArrayList keysToRemove = new ArrayList();
            Iterator it = this.graphicHash.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                if (!entry.getValue().equals(graphic)) continue;
                keysToRemove.add(entry.getKey());
            }
            it = keysToRemove.iterator();
            while (it.hasNext()) {
                this.graphicHash.remove(it.next());
            }
            super.remove((OMGraphic)graphic);
        }
        if (this.graphicHash.containsKey(key)) {
            super.remove((OMGraphic)graphic);
        }
        OMGraphic previous = (OMGraphic)this.graphicHash.put(key, graphic);
        super.add((OMGraphic)graphic);
        return previous;
    }

    public void putAll(Map map) {
        this.graphicHash.putAll(map);
    }

    public Object remove(Object obj) {
        OMGraphic graphic = (OMGraphic)this.graphicHash.get(obj);
        super.remove(graphic);
        return this.graphicHash.remove(obj);
    }

    public Collection values() {
        return this.graphicHash.values();
    }

    public synchronized Object clone() {
        this.cloningInProgress = true;
        OMGraphicHash omgl = (OMGraphicHash)super.clone();
        omgl.graphicHash = (HashMap)this.graphicHash.clone();
        this.cloningInProgress = false;
        return omgl;
    }

    public void addOMGraphic(OMGraphic g) {
        if (this.cloningInProgress) {
            super.addOMGraphic(g);
            return;
        }
        throw new RuntimeException("addOMGraphic() not permitted for OMGraphicHash(). Use put(key, OMGraphic) instead.");
    }

    public void add(OMGraphic g) {
        if (this.cloningInProgress) {
            super.add(g);
            return;
        }
        throw new RuntimeException("addOMGraphic() not permitted for OMGraphicHash(). Use put(key, OMGraphic) instead.");
    }

    public void removeOMGraphicAt(int location) {
        throw new RuntimeException("removeOMGraphicAt() not permitted for OMGraphicHash(). Use remove(key) instead.");
    }

    public boolean remove(OMGraphic graphic) {
        throw new RuntimeException("remove(OMGRaphic) not permitted for OMGraphicHash(). Use remove(key) instead.");
    }

    public void clear() {
        super.clear();
        this.graphicHash.clear();
    }
}

