/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.omGraphics;

import com.bbn.openmap.omGraphics.Cubic;
import java.awt.Polygon;

public class NatCubicSpline {
    private int steps = 12;

    Cubic[] calcNaturalCubic(int n, int[] x) {
        int i;
        float[] gamma = new float[n + 1];
        float[] delta = new float[n + 1];
        float[] D = new float[n + 1];
        gamma[0] = 0.5f;
        for (i = 1; i < n; ++i) {
            gamma[i] = 1.0f / (4.0f - gamma[i - 1]);
        }
        gamma[n] = 1.0f / (2.0f - gamma[n - 1]);
        delta[0] = (float)(3 * (x[1] - x[0])) * gamma[0];
        for (i = 1; i < n; ++i) {
            delta[i] = ((float)(3 * (x[i + 1] - x[i - 1])) - delta[i - 1]) * gamma[i];
        }
        delta[n] = ((float)(3 * (x[n] - x[n - 1])) - delta[n - 1]) * gamma[n];
        D[n] = delta[n];
        for (i = n - 1; i >= 0; --i) {
            D[i] = delta[i] - gamma[i] * D[i + 1];
        }
        Cubic[] C = new Cubic[n];
        for (i = 0; i < n; ++i) {
            C[i] = new Cubic(x[i], D[i], (float)(3 * (x[i + 1] - x[i])) - 2.0f * D[i] - D[i + 1], (float)(2 * (x[i] - x[i + 1])) + D[i] + D[i + 1]);
        }
        return C;
    }

    public int[][] calc(int[] xpoints, int[] ypoints) {
        int[][] res = new int[2][0];
        if (xpoints.length > 2) {
            Cubic[] X = this.calcNaturalCubic(xpoints.length - 1, xpoints);
            Cubic[] Y = this.calcNaturalCubic(ypoints.length - 1, ypoints);
            Polygon p = new Polygon();
            p.addPoint(Math.round(X[0].eval(0.0f)), Math.round(Y[0].eval(0.0f)));
            for (int i = 0; i < X.length; ++i) {
                for (int j = 1; j <= this.steps; ++j) {
                    float u = (float)j / (float)this.steps;
                    p.addPoint(Math.round(X[i].eval(u)), Math.round(Y[i].eval(u)));
                }
            }
            res[0] = new int[p.npoints];
            System.arraycopy(p.xpoints, 0, res[0], 0, p.npoints);
            res[1] = new int[p.npoints];
            System.arraycopy(p.ypoints, 0, res[1], 0, p.npoints);
            p = null;
        } else {
            res[0] = xpoints;
            res[1] = ypoints;
        }
        return res;
    }

    public float[] calc(float[] llpoints, float precision) {
        float[] res;
        if (llpoints.length > 4) {
            int j;
            int i;
            int[] xpoints = new int[llpoints.length / 2];
            int[] ypoints = new int[xpoints.length];
            int i2 = 0;
            int j2 = 0;
            while (i2 < llpoints.length) {
                xpoints[j2] = (int)(llpoints[i2] / precision);
                ypoints[j2] = (int)(llpoints[i2 + 1] / precision);
                i2 += 2;
                ++j2;
            }
            Cubic[] X = this.calcNaturalCubic(xpoints.length - 1, xpoints);
            Cubic[] Y = this.calcNaturalCubic(ypoints.length - 1, ypoints);
            Polygon p = new Polygon();
            p.addPoint(Math.round(X[0].eval(0.0f)), Math.round(Y[0].eval(0.0f)));
            for (i = 0; i < X.length; ++i) {
                for (j = 1; j <= this.steps; ++j) {
                    float u = (float)j / (float)this.steps;
                    p.addPoint(Math.round(X[i].eval(u)), Math.round(Y[i].eval(u)));
                }
            }
            res = new float[p.npoints * 2];
            i = 0;
            j = 0;
            while (i < p.npoints) {
                res[j] = (float)p.xpoints[i] * precision;
                res[j + 1] = (float)p.ypoints[i] * precision;
                ++i;
                j += 2;
            }
            p = null;
        } else {
            res = llpoints;
        }
        return res;
    }

    public int getSteps() {
        return this.steps;
    }

    public void setSteps(int steps) {
        this.steps = steps > 0 ? steps : 12;
    }
}

