/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.omGraphics;

import com.bbn.openmap.Environment;
import com.bbn.openmap.I18n;
import com.bbn.openmap.gui.GridBagToolBar;
import com.bbn.openmap.omGraphics.EditableOMCircle;
import com.bbn.openmap.omGraphics.GraphicAttributes;
import com.bbn.openmap.omGraphics.OMRangeRings;
import com.bbn.openmap.proj.Length;
import com.bbn.openmap.util.Debug;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.text.DecimalFormat;
import java.text.ParseException;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.border.EmptyBorder;

public class EditableOMRangeRings
extends EditableOMCircle {
    protected static int lastInterval;
    protected static Length lastUnit;
    protected static boolean snapToInterval;
    protected JTextField intervalField = null;
    protected JToolBar rrToolBar = null;
    protected transient DecimalFormat df = new DecimalFormat();
    protected I18n i18n = Environment.getI18n();
    protected boolean drawLabelsHolder = true;

    public EditableOMRangeRings() {
        this.createGraphic(null);
    }

    public EditableOMRangeRings(GraphicAttributes ga) {
        this.createGraphic(ga);
    }

    public EditableOMRangeRings(OMRangeRings omc) {
        this.setGraphic(omc);
    }

    public void createGraphic(GraphicAttributes ga) {
        this.init();
        this.stateMachine.setUndefined();
        int renderType = 1;
        if (ga != null) {
            renderType = ga.getRenderType();
        }
        if (Debug.debugging("eomc")) {
            Debug.output("EditableOMRangeRings.createGraphic(): rendertype = " + renderType);
        }
        this.circle = new OMRangeRings(90.0f, -180.0f, 0.0f);
        if (ga != null) {
            ga.setTo(this.circle, true);
        }
    }

    public Component getGUI(GraphicAttributes graphicAttributes) {
        Debug.message("eomg", "EditableOMRangeRings.getGUI");
        if (graphicAttributes != null) {
            JPanel panel = graphicAttributes.getColorAndLineGUI();
            panel.add(this.getRangeRingGUI());
            return panel;
        }
        return this.getRangeRingGUI();
    }

    public void updateInterval(int val) {
        ((OMRangeRings)this.circle).setInterval(val);
        lastInterval = val;
        if (this.intervalField != null) {
            this.intervalField.setText(Integer.toString(val));
        }
        if (snapToInterval) {
            this.setRadius(this.circle.getRadius());
        }
        this.redraw(null, true);
    }

    public void updateInterval(String intervalStr) {
        int oldValue = ((OMRangeRings)this.circle).getInterval();
        int value = this.interpretValue(intervalStr);
        if (value <= 0) {
            value = oldValue;
        }
        this.updateInterval(value);
    }

    public int interpretValue(String intervalStr) {
        int value = -1;
        try {
            if (intervalStr.toLowerCase().endsWith("m")) {
                intervalStr = intervalStr.substring(0, intervalStr.length() - 1);
                value = this.df.parse(intervalStr).intValue() * 1000000;
            } else if (intervalStr.toLowerCase().endsWith("k")) {
                intervalStr = intervalStr.substring(0, intervalStr.length() - 1);
                value = this.df.parse(intervalStr).intValue() * 1000;
            } else if (!intervalStr.trim().equals("")) {
                value = this.df.parse(intervalStr).intValue();
            }
        }
        catch (ParseException e) {
            Debug.error("RangeRing interval value not valid: " + intervalStr);
        }
        catch (NumberFormatException e) {
            Debug.error("RangeRing interval value not valid: " + intervalStr);
        }
        return value;
    }

    protected JToolBar getRangeRingGUI() {
        if (this.rrToolBar == null) {
            this.rrToolBar = new GridBagToolBar();
            this.rrToolBar.setFloatable(false);
            this.rrToolBar.setMargin(new Insets(0, 1, 0, 1));
            this.configureRangeRings();
            this.intervalField = this.makeIntervalField();
            this.rrToolBar.add(this.intervalField);
            this.rrToolBar.add(this.makeUnitsCombo());
            this.rrToolBar.add(this.makeSnapCheckBox());
        }
        return this.rrToolBar;
    }

    private void configureRangeRings() {
        ((OMRangeRings)this.circle).setInterval(this.getInterval());
        ((OMRangeRings)this.circle).setIntervalUnits(this.getUnits());
    }

    private int getInterval() {
        return !this.isNewRing() ? ((OMRangeRings)this.circle).getInterval() : (this.haveUserSpecifiedValue() ? lastInterval : 4);
    }

    private Length getUnits() {
        return !this.isNewRing() ? ((OMRangeRings)this.circle).getIntervalUnits() : (this.haveUserSpecifiedValue() ? lastUnit : null);
    }

    private boolean isNewRing() {
        return ((OMRangeRings)this.circle).getIntervalUnits() == null;
    }

    private boolean haveUserSpecifiedValue() {
        return lastUnit != null;
    }

    private JTextField makeIntervalField() {
        JTextField field = new JTextField(Integer.toString(((OMRangeRings)this.circle).getInterval()), 5);
        field.setMargin(new Insets(0, 1, 0, 1));
        field.setMinimumSize(new Dimension(40, 18));
        field.setHorizontalAlignment(4);
        field.setToolTipText(this.i18n.get(this, "intervalField.tooltip", "Value for interval between rings."));
        field.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                EditableOMRangeRings.this.updateInterval(((JTextField)ae.getSource()).getText());
            }
        });
        field.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent event) {
                if (!event.isTemporary()) {
                    EditableOMRangeRings.this.updateInterval(((JTextField)event.getSource()).getText());
                }
            }
        });
        return field;
    }

    private JComboBox makeUnitsCombo() {
        Length[] available = Length.getAvailable();
        String[] unitStrings = new String[available.length + 1];
        String current = null;
        Length l = ((OMRangeRings)this.circle).getIntervalUnits();
        if (l != null) {
            current = l.toString();
        }
        int currentIndex = unitStrings.length - 1;
        for (int i = 0; i < available.length; ++i) {
            unitStrings[i] = available[i].toString();
            if (current == null || !unitStrings[i].equals(current)) continue;
            currentIndex = i;
        }
        unitStrings[unitStrings.length - 1] = this.i18n.get(this, "unitStrings.concentric", "concentric");
        JComboBox<String> combo = new JComboBox<String>(unitStrings);
        combo.setBorder(new EmptyBorder(0, 1, 0, 1));
        combo.setSelectedIndex(currentIndex);
        combo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JComboBox jcb = (JComboBox)e.getSource();
                OMRangeRings rr = (OMRangeRings)EditableOMRangeRings.this.circle;
                Length newLength = Length.get((String)jcb.getSelectedItem());
                Length oldLength = rr.getIntervalUnits();
                int value = EditableOMRangeRings.this.interpretValue(EditableOMRangeRings.this.intervalField.getText());
                if (value <= 0) {
                    value = 4;
                }
                if (newLength != null && oldLength != null) {
                    value = (int)newLength.fromRadians(oldLength.toRadians(value));
                } else {
                    int numSubCircles = rr.subCircles == null || rr.subCircles.length == 0 ? 1 : rr.subCircles.length;
                    if (newLength == null) {
                        value = numSubCircles;
                    } else if (oldLength == null) {
                        value = (int)Math.ceil(newLength.fromRadians(Length.DECIMAL_DEGREE.toRadians(rr.getRadius())) / (float)numSubCircles);
                    }
                }
                ((OMRangeRings)EditableOMRangeRings.this.circle).setIntervalUnits(newLength);
                lastUnit = newLength;
                EditableOMRangeRings.this.updateInterval(value);
            }
        });
        return combo;
    }

    private JCheckBox makeSnapCheckBox() {
        String snapText = this.i18n.get(this, "snapToInterval", "Snap");
        JCheckBox snapBox = new JCheckBox(snapText, this.isSnapToInterval());
        snapText = this.i18n.get((Object)this, "snapToInterval", 3, "Round radius to nearest interval value.");
        snapBox.setToolTipText(snapText);
        snapBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                EditableOMRangeRings.this.setSnapToInterval(((JCheckBox)ae.getSource()).isSelected());
                if (snapToInterval) {
                    EditableOMRangeRings.this.setRadius(EditableOMRangeRings.this.circle.getRadius());
                }
                EditableOMRangeRings.this.redraw(null, true);
            }
        });
        return snapBox;
    }

    protected void modifyOMGraphicForEditRender() {
        OMRangeRings omrr = (OMRangeRings)this.getGraphic();
        this.drawLabelsHolder = omrr.getDrawLabels();
        omrr.setDrawLabels(false);
    }

    protected void resetOMGraphicAfterEditRender() {
        ((OMRangeRings)this.getGraphic()).setDrawLabels(this.drawLabelsHolder);
    }

    public boolean isSnapToInterval() {
        return snapToInterval;
    }

    public void setSnapToInterval(boolean sti) {
        snapToInterval = sti;
    }

    protected void setRadius(float radius) {
        if (this.circle != null) {
            OMRangeRings rr;
            Length units;
            if (snapToInterval && (units = (rr = (OMRangeRings)this.circle).getIntervalUnits()) != null) {
                float rds = units.fromRadians(Length.DECIMAL_DEGREE.toRadians(radius));
                radius = Math.round(rds / (float)rr.getInterval()) * rr.getInterval();
                radius = Length.DECIMAL_DEGREE.fromRadians(units.toRadians(radius));
            }
            this.circle.setRadius(radius);
        }
    }

    static {
        snapToInterval = false;
    }
}

