/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.test;

import com.bbn.openmap.event.MapMouseListener;
import com.bbn.openmap.event.SelectMouseMode;
import com.bbn.openmap.layer.OMGraphicHandlerLayer;
import com.bbn.openmap.omGraphics.OMCircle;
import com.bbn.openmap.omGraphics.OMGraphic;
import com.bbn.openmap.omGraphics.OMGraphicList;
import com.bbn.openmap.omGraphics.OMLine;
import com.bbn.openmap.omGraphics.OMPoly;
import com.bbn.openmap.omGraphics.OMRect;
import com.bbn.openmap.omGraphics.OMText;
import com.bbn.openmap.proj.Length;
import com.bbn.openmap.util.Debug;
import com.bbn.openmap.util.PaletteHelper;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseEvent;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class TestLayer
extends OMGraphicHandlerLayer
implements MapMouseListener {
    public static final transient String LineVisibleProperty = ".line.visible";
    public static final transient String CircVisibleProperty = ".circ.visible";
    public static final transient String RectVisibleProperty = ".rect.visible";
    public static final transient String TextVisibleProperty = ".text.visible";
    public static final transient String PolyVisibleProperty = ".poly.visible";
    public static final transient String PolyVertsProperty = ".poly.vertices";
    protected static final transient String[] colorNames = new String[]{"white", "lightGray", "gray", "darkGray", "black", "red", "pink", "orange", "yellow", "green", "magenta", "cyan", "blue", "clear"};
    protected static final transient Color[] colors = new Color[]{Color.white, Color.lightGray, Color.gray, Color.darkGray, Color.black, Color.red, Color.pink, Color.orange, Color.yellow, Color.green, Color.magenta, Color.cyan, Color.blue, OMGraphic.clear};
    protected static final transient int NCOLORS = colors.length;
    protected OMCircle omcircle = new OMCircle();
    protected Circle circle = new Circle();
    protected OMLine omline = new OMLine();
    protected Line line = new Line();
    protected OMRect omrect = new OMRect();
    protected Rect rect = new Rect();
    protected OMText omtext = new OMText();
    protected Text text = new Text();
    protected OMPoly ompoly = new OMPoly();
    protected Poly poly = new Poly();
    protected JPanel gui = null;

    public void setProperties(String prefix, Properties properties) {
        super.setProperties(prefix, properties);
        this.line.visible = Boolean.valueOf(properties.getProperty(prefix + LineVisibleProperty, "true"));
        this.circle.visible = Boolean.valueOf(properties.getProperty(prefix + CircVisibleProperty, "true"));
        this.rect.visible = Boolean.valueOf(properties.getProperty(prefix + RectVisibleProperty, "true"));
        this.text.visible = Boolean.valueOf(properties.getProperty(prefix + TextVisibleProperty, "true"));
        this.poly.visible = Boolean.valueOf(properties.getProperty(prefix + PolyVisibleProperty, "true"));
        String verts = properties.getProperty(prefix + PolyVertsProperty);
        if (verts != null) {
            this.poly.setVertices(verts);
        }
    }

    public synchronized OMGraphicList prepare() {
        if (this.getList() == null) {
            this.setList(this.generateGraphics());
        }
        return super.prepare();
    }

    protected OMGraphicList generateGraphics() {
        OMGraphicList graphics = new OMGraphicList();
        switch (this.line.rt) {
            case 1: {
                this.omline = new OMLine(this.line.llpts[0], this.line.llpts[1], this.line.llpts[2], this.line.llpts[3], this.line.type, this.line.nsegs);
                break;
            }
            case 2: {
                this.omline = new OMLine(this.line.xypts[0], this.line.xypts[1], this.line.xypts[2], this.line.xypts[3]);
                break;
            }
            case 3: {
                this.omline = new OMLine(this.line.llpts[0], this.line.llpts[1], this.line.xypts[0], this.line.xypts[1], this.line.xypts[2], this.line.xypts[3]);
                break;
            }
            default: {
                System.err.println("ARRRR!");
            }
        }
        if (this.line.arrowhead) {
            this.omline.addArrowHead(this.line.arrowtype);
        }
        switch (this.circle.rt) {
            case 1: {
                this.omcircle = new OMCircle(this.circle.llpts[0], this.circle.llpts[1], this.circle.radius, Length.KM, this.circle.nsegs);
                this.omcircle.setPolarCorrection(true);
                break;
            }
            case 2: {
                this.omcircle = new OMCircle(this.circle.xypts[0], this.circle.xypts[1], this.circle.width, this.circle.height);
                break;
            }
            case 3: {
                this.omcircle = new OMCircle(this.circle.llpts[0], this.circle.llpts[1], this.circle.xypts[0], this.circle.xypts[1], this.circle.width, this.circle.height);
                break;
            }
            default: {
                System.err.println("ARRRR!");
            }
        }
        switch (this.rect.rt) {
            case 1: {
                this.omrect = new OMRect(this.rect.llpts[0], this.rect.llpts[1], this.rect.llpts[2], this.rect.llpts[3], this.rect.type, this.rect.nsegs);
                break;
            }
            case 2: {
                this.omrect = new OMRect(this.rect.xypts[0], this.rect.xypts[1], this.rect.xypts[2], this.rect.xypts[3]);
                break;
            }
            case 3: {
                this.omrect = new OMRect(this.rect.llpts[0], this.rect.llpts[1], this.rect.xypts[0], this.rect.xypts[1], this.rect.xypts[2], this.rect.xypts[3]);
                break;
            }
            default: {
                System.err.println("ARRRR!");
            }
        }
        switch (this.text.rt) {
            case 1: {
                this.omtext = new OMText(this.text.llpts[0], this.text.llpts[1], this.text.data, Font.decode(this.text.font), this.text.just);
                break;
            }
            case 2: {
                this.omtext = new OMText(this.text.xypts[0], this.text.xypts[1], this.text.data, Font.decode(this.text.font), this.text.just);
                break;
            }
            case 3: {
                this.omtext = new OMText(this.text.llpts[0], this.text.llpts[1], this.text.xypts[0], this.text.xypts[1], this.text.data, Font.decode(this.text.font), this.text.just);
                break;
            }
            default: {
                System.err.println("ARRRR!");
            }
        }
        switch (this.poly.rt) {
            case 1: {
                int len = this.poly.llpts.length;
                float[] llpts = new float[len];
                System.arraycopy(this.poly.llpts, 0, llpts, 0, len);
                this.ompoly = new OMPoly(llpts, 0, this.poly.type, this.poly.nsegs);
                break;
            }
            case 2: {
                this.ompoly = new OMPoly(this.poly.xypts);
                break;
            }
            case 3: {
                this.ompoly = new OMPoly(this.poly.lat, this.poly.lon, this.poly.xypts, this.poly.cMode);
                break;
            }
            default: {
                System.err.println("ARRRR!");
            }
        }
        this.omline.setVisible(this.line.visible);
        this.omline.setLinePaint(colors[this.line.lineColor]);
        this.omcircle.setVisible(this.circle.visible);
        this.omcircle.setLinePaint(colors[this.circle.lineColor]);
        this.omrect.setVisible(this.rect.visible);
        this.omrect.setLinePaint(colors[this.rect.lineColor]);
        this.ompoly.setVisible(this.poly.visible);
        this.ompoly.setLinePaint(colors[this.poly.lineColor]);
        this.omtext.setVisible(this.text.visible);
        this.omtext.setLinePaint(colors[this.text.lineColor]);
        if (this.circle.isFilled) {
            this.omcircle.setFillPaint(colors[this.circle.fillColor]);
        }
        if (this.rect.isFilled) {
            this.omrect.setFillPaint(colors[this.rect.fillColor]);
        }
        if (this.poly.isFilled) {
            this.ompoly.setFillPaint(colors[this.poly.fillColor]);
        }
        graphics.add(this.omline);
        graphics.add(this.omcircle);
        graphics.add(this.omrect);
        graphics.add(this.omtext);
        graphics.add(this.ompoly);
        graphics.generate(this.getProjection());
        return graphics;
    }

    public Component getGUI() {
        if (this.gui == null) {
            this.gui = PaletteHelper.createPaletteJPanel("Test");
            GridBagLayout gridbag = new GridBagLayout();
            GridBagConstraints constraints = new GridBagConstraints();
            this.gui.setLayout(gridbag);
            constraints.fill = 2;
            constraints.gridwidth = 0;
            constraints.anchor = 13;
            ActionListener al = new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    int index = Integer.parseInt(e.getActionCommand(), 10);
                    switch (index) {
                        case 0: {
                            TestLayer.this.line.visible = !TestLayer.this.line.visible;
                            TestLayer.this.omline.setVisible(TestLayer.this.line.visible);
                            TestLayer.this.repaint();
                            break;
                        }
                        case 1: {
                            TestLayer.this.circle.visible = !TestLayer.this.circle.visible;
                            TestLayer.this.omcircle.setVisible(TestLayer.this.circle.visible);
                            TestLayer.this.repaint();
                            break;
                        }
                        case 2: {
                            TestLayer.this.rect.visible = !TestLayer.this.rect.visible;
                            TestLayer.this.omrect.setVisible(TestLayer.this.rect.visible);
                            TestLayer.this.repaint();
                            break;
                        }
                        case 3: {
                            TestLayer.this.text.visible = !TestLayer.this.text.visible;
                            TestLayer.this.omtext.setVisible(TestLayer.this.text.visible);
                            TestLayer.this.repaint();
                            break;
                        }
                        case 4: {
                            TestLayer.this.poly.visible = !TestLayer.this.poly.visible;
                            TestLayer.this.ompoly.setVisible(TestLayer.this.poly.visible);
                            TestLayer.this.repaint();
                            break;
                        }
                        default: {
                            System.out.println("TestLayer: Unimplemented...");
                        }
                    }
                }
            };
            JPanel pal = PaletteHelper.createCheckbox("Graphics", new String[]{"Line", "Circle", "Rect", "Text", "Poly"}, new boolean[]{this.line.visible, this.circle.visible, this.rect.visible, this.text.visible, this.poly.visible}, al);
            gridbag.setConstraints(pal, constraints);
            this.gui.add(pal);
            pal = this.getGraphicPalette(this.line, "Line");
            gridbag.setConstraints(pal, constraints);
            this.gui.add(pal);
            pal = this.getGraphicPalette(this.circle, "Circle");
            gridbag.setConstraints(pal, constraints);
            this.gui.add(pal);
            pal = this.getGraphicPalette(this.rect, "Rect");
            gridbag.setConstraints(pal, constraints);
            this.gui.add(pal);
            pal = this.getGraphicPalette(this.text, "Text");
            gridbag.setConstraints(pal, constraints);
            this.gui.add(pal);
            pal = this.getGraphicPalette(this.poly, "Poly");
            gridbag.setConstraints(pal, constraints);
            this.gui.add(pal);
        }
        return this.gui;
    }

    protected JPanel getGraphicPalette(final GraphicBase obj, final String title) {
        JPanel parent = PaletteHelper.createVerticalPanel(title);
        final JFrame jframe = new JFrame();
        final JRootPane main = jframe.getRootPane();
        final JComboBox<String> jcb = new JComboBox<String>();
        jcb.addItem("LatLon");
        jcb.addItem("XY");
        jcb.addItem("Offset");
        jcb.setSelectedIndex(obj.rt - 1);
        jcb.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                obj.setRender(jcb);
                switch (obj.rt) {
                    case 1: {
                        jframe.setTitle(title + " - LatLon");
                        main.getContentPane().removeAll();
                        main.getContentPane().add(obj.getGUI());
                        jframe.pack();
                        jframe.setVisible(true);
                        break;
                    }
                    case 2: {
                        jframe.setTitle(title + " - XY");
                        main.getContentPane().removeAll();
                        main.getContentPane().add(obj.getGUI());
                        jframe.pack();
                        jframe.setVisible(true);
                        break;
                    }
                    case 3: {
                        jframe.setTitle(title + " - XY Offset");
                        main.getContentPane().removeAll();
                        main.getContentPane().add(obj.getGUI());
                        jframe.pack();
                        jframe.setVisible(true);
                        break;
                    }
                    default: {
                        System.err.println("ARRRR!");
                    }
                }
            }
        });
        parent.add(jcb);
        return parent;
    }

    public MapMouseListener getMapMouseListener() {
        return this;
    }

    public String[] getMouseModeServiceList() {
        return new String[]{SelectMouseMode.modeID};
    }

    public boolean mousePressed(MouseEvent e) {
        if (Debug.debugging("TestLayer")) {
            System.out.println("TestLayer.mousePressed()");
        }
        return true;
    }

    public boolean mouseReleased(MouseEvent e) {
        if (Debug.debugging("TestLayer")) {
            System.out.println("TestLayer.mouseReleased()");
        }
        return true;
    }

    public boolean mouseClicked(MouseEvent e) {
        if (Debug.debugging("TestLayer")) {
            System.out.println("TestLayer.mouseClicked()");
        }
        return true;
    }

    public void mouseEntered(MouseEvent e) {
        if (Debug.debugging("TestLayer")) {
            System.out.println("TestLayer.mouseEntered()");
        }
    }

    public void mouseExited(MouseEvent e) {
        if (Debug.debugging("TestLayer")) {
            System.out.println("TestLayer.mouseExited()");
        }
    }

    public boolean mouseDragged(MouseEvent e) {
        if (Debug.debugging("TestLayer")) {
            System.out.println("TestLayer.mouseDragged()");
        }
        return true;
    }

    public boolean mouseMoved(MouseEvent e) {
        if (Debug.debugging("TestLayer")) {
            System.out.println("TestLayer.mouseMoved()");
        }
        return true;
    }

    public void mouseMoved() {
        if (Debug.debugging("TestLayer")) {
            System.out.println("TestLayer.mouseMoved()[alt]");
        }
    }

    protected class Text
    extends GraphicBase {
        protected String data;
        protected String font;
        protected int just;

        public Text() {
            this.font = "SansSerif-Bold-18";
            this.just = 1;
            this.llpts[0] = 42.35f;
            this.llpts[1] = -70.5f;
            this.xypts[0] = 20;
            this.xypts[1] = 10;
            this.lineColor = 10;
            this.data = "Boston";
        }

        public JPanel getGUI() {
            TestLayer.this.requestFocus();
            JPanel pop = PaletteHelper.createVerticalPanel(null);
            JTextField tf = PaletteHelper.createTextEntry("text", this.data, pop);
            tf.addFocusListener(new FocusAdapter(){

                public void focusLost(FocusEvent e) {
                    Text.this.data = ((JTextField)e.getSource()).getText().trim();
                }
            });
            tf = PaletteHelper.createTextEntry("font", this.font, pop);
            tf.addFocusListener(new FocusAdapter(){

                public void focusLost(FocusEvent e) {
                    Text.this.font = ((JTextField)e.getSource()).getText().trim();
                }
            });
            JPanel pal = PaletteHelper.createVerticalPanel(null);
            final JComboBox<String> jcb = new JComboBox<String>();
            jcb.addItem("right");
            jcb.addItem("center");
            jcb.addItem("left");
            jcb.setSelectedIndex(this.just);
            jcb.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    Text.this.just = jcb.getSelectedIndex();
                    TestLayer.this.setList(TestLayer.this.generateGraphics());
                    TestLayer.this.repaint();
                }
            });
            pal.add(jcb);
            pop.add(pal);
            if (this.rt != 2) {
                tf = PaletteHelper.createTextEntry("lat", "" + this.llpts[0], pop);
                tf.addFocusListener(new FocusAdapter(){

                    public void focusLost(FocusEvent e) {
                        Text.this.setLLCoordinate((JTextField)e.getSource(), 0);
                    }
                });
                tf = PaletteHelper.createTextEntry("lon", "" + this.llpts[1], pop);
                tf.addFocusListener(new FocusAdapter(){

                    public void focusLost(FocusEvent e) {
                        Text.this.setLLCoordinate((JTextField)e.getSource(), 1);
                    }
                });
            }
            if (this.rt != 1) {
                tf = PaletteHelper.createTextEntry("off_x", "" + this.xypts[0], pop);
                tf.addFocusListener(new FocusAdapter(){

                    public void focusLost(FocusEvent e) {
                        Text.this.setXYCoordinate((JTextField)e.getSource(), 0);
                    }
                });
                tf = PaletteHelper.createTextEntry("off_y", "" + this.xypts[1], pop);
                tf.addFocusListener(new FocusAdapter(){

                    public void focusLost(FocusEvent e) {
                        Text.this.setXYCoordinate((JTextField)e.getSource(), 1);
                    }
                });
            }
            this.makeColorBox(pop, "text", false);
            pop.add(this.getOKButton());
            return pop;
        }
    }

    protected class Poly
    extends GraphicBase {
        protected float lat;
        protected float lon;
        protected int cMode;

        public Poly() {
            this.lat = 0.0f;
            this.lon = 0.0f;
            this.cMode = 0;
            this.llpts = new float[8];
            this.xypts = new int[6];
            this.llpts[0] = 10.0f;
            this.llpts[1] = -20.0f;
            this.llpts[2] = 45.0f;
            this.llpts[3] = -70.0f;
            this.llpts[4] = 0.0f;
            this.llpts[5] = -90.0f;
            this.llpts[6] = -15.0f;
            this.llpts[7] = -40.0f;
            this.xypts[0] = 145;
            this.xypts[1] = 190;
            this.xypts[2] = 160;
            this.xypts[3] = 210;
            this.xypts[2] = 135;
            this.xypts[3] = 215;
            this.lineColor = 4;
            this.fillColor = 9;
            this.type = 3;
        }

        protected void setVertices(String verts) {
            try {
                String str;
                StringTokenizer tok = new StringTokenizer(verts, "\n\r");
                verts = "";
                while (tok.hasMoreTokens()) {
                    str = tok.nextToken().trim();
                    if (str.charAt(0) == '#') continue;
                    verts = verts + str + " ";
                }
                tok = new StringTokenizer(verts);
                int size = tok.countTokens();
                System.out.println("ll size=" + size);
                this.llpts = new float[size];
                for (int i = 0; i < size; i += 2) {
                    str = tok.nextToken();
                    System.out.print("lat=" + str);
                    this.llpts[i] = Float.valueOf(str).floatValue();
                    str = tok.nextToken();
                    System.out.println(" lon=" + str);
                    this.llpts[i + 1] = Float.valueOf(str).floatValue();
                }
            }
            catch (NumberFormatException ex) {
                return;
            }
        }

        protected void setXY(JTextArea jta) {
        }

        protected void setLL(JTextArea jta) {
            this.setVertices(jta.getText().trim());
        }

        protected void setLLCoordinate(JTextField jtf, int i) {
            try {
                if (i == 0) {
                    this.lat = Float.valueOf(jtf.getText().trim()).floatValue();
                } else {
                    this.lon = Float.valueOf(jtf.getText().trim()).floatValue();
                }
            }
            catch (NumberFormatException ex) {
                return;
            }
        }

        public JPanel getGUI() {
            TestLayer.this.requestFocus();
            JPanel pop = PaletteHelper.createVerticalPanel(null);
            if (this.rt == 1) {
                JPanel pal = PaletteHelper.createVerticalPanel(null);
                JComboBox<String> jcb = new JComboBox<String>();
                jcb.addItem("Straight");
                jcb.addItem("Rhumb");
                jcb.addItem("Great Circle");
                jcb.setSelectedIndex(this.type - 1);
                jcb.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        Poly.this.setType((JComboBox)e.getSource());
                    }
                });
                pal.add(jcb);
                pop.add(pal);
                JTextField tf = PaletteHelper.createTextEntry("nsegs", "" + this.nsegs, pop);
                tf.addFocusListener(new FocusAdapter(){

                    public void focusLost(FocusEvent e) {
                        Poly.this.setSegs((JTextField)e.getSource());
                    }
                });
                String entry = "";
                for (int i = 0; i < this.llpts.length; i += 2) {
                    entry = entry + this.llpts[i] + " " + this.llpts[i + 1] + "\n";
                }
                JTextArea ta = PaletteHelper.createTextArea("llpts", entry, pop, 5, 8);
                ta.addFocusListener(new FocusAdapter(){

                    public void focusLost(FocusEvent e) {
                        Poly.this.setLL((JTextArea)e.getSource());
                    }
                });
            } else {
                if (this.rt == 3) {
                    JTextField tf = PaletteHelper.createTextEntry("lat", "" + this.llpts[0], pop);
                    tf.addFocusListener(new FocusAdapter(){

                        public void focusLost(FocusEvent e) {
                            Poly.this.setLLCoordinate((JTextField)e.getSource(), 0);
                        }
                    });
                    tf = PaletteHelper.createTextEntry("lon", "" + this.llpts[1], pop);
                    tf.addFocusListener(new FocusAdapter(){

                        public void focusLost(FocusEvent e) {
                            Poly.this.setLLCoordinate((JTextField)e.getSource(), 1);
                        }
                    });
                }
                String entry = "";
                for (int i = 0; i < this.xypts.length; i += 2) {
                    entry = entry + this.xypts[i] + " " + this.xypts[i + 1] + "\n";
                }
                JTextArea ta = PaletteHelper.createTextArea("xypts", entry, pop, 0, 0);
                ta.addFocusListener(new FocusAdapter(){

                    public void focusLost(FocusEvent e) {
                        Poly.this.setXY((JTextArea)e.getSource());
                    }
                });
            }
            this.makeColorBox(pop, "line", false);
            this.makeColorBox(pop, "fill", true);
            this.makeFillCheckBox(pop);
            pop.add(this.getOKButton());
            return pop;
        }
    }

    protected class Circle
    extends GraphicBase {
        public Circle() {
            this.xypts[0] = 10;
            this.xypts[1] = 20;
            this.width = 10;
            this.height = 20;
            this.fillColor = 0;
        }

        public JPanel getGUI() {
            JTextField tf;
            TestLayer.this.requestFocus();
            JPanel pop = PaletteHelper.createVerticalPanel(null);
            if (this.rt != 2) {
                tf = PaletteHelper.createTextEntry("lat", "" + this.llpts[0], pop);
                tf.addFocusListener(new FocusAdapter(){

                    public void focusLost(FocusEvent e) {
                        Circle.this.setLLCoordinate((JTextField)e.getSource(), 0);
                    }
                });
                tf = PaletteHelper.createTextEntry("lon", "" + this.llpts[1], pop);
                tf.addFocusListener(new FocusAdapter(){

                    public void focusLost(FocusEvent e) {
                        Circle.this.setLLCoordinate((JTextField)e.getSource(), 1);
                    }
                });
            } else {
                tf = PaletteHelper.createTextEntry("x", "" + this.xypts[0], pop);
                tf.addFocusListener(new FocusAdapter(){

                    public void focusLost(FocusEvent e) {
                        Circle.this.setXYCoordinate((JTextField)e.getSource(), 0);
                    }
                });
                tf = PaletteHelper.createTextEntry("y", "" + this.xypts[1], pop);
                tf.addFocusListener(new FocusAdapter(){

                    public void focusLost(FocusEvent e) {
                        Circle.this.setXYCoordinate((JTextField)e.getSource(), 1);
                    }
                });
            }
            if (this.rt == 3) {
                tf = PaletteHelper.createTextEntry("off_x", "" + this.xypts[0], pop);
                tf.addFocusListener(new FocusAdapter(){

                    public void focusLost(FocusEvent e) {
                        Circle.this.setXYCoordinate((JTextField)e.getSource(), 0);
                    }
                });
                tf = PaletteHelper.createTextEntry("off_y", "" + this.xypts[1], pop);
                tf.addFocusListener(new FocusAdapter(){

                    public void focusLost(FocusEvent e) {
                        Circle.this.setXYCoordinate((JTextField)e.getSource(), 1);
                    }
                });
            } else if (this.rt == 1) {
                tf = PaletteHelper.createTextEntry("R (km)", "" + this.radius, pop);
                tf.addFocusListener(new FocusAdapter(){

                    public void focusLost(FocusEvent e) {
                        JTextField jtf = (JTextField)e.getSource();
                        float f = Circle.this.radius;
                        try {
                            f = Float.valueOf(jtf.getText().trim()).floatValue();
                        }
                        catch (NumberFormatException ex) {
                            return;
                        }
                        Circle.this.radius = f;
                        System.out.println("TestLayer: radius=" + Circle.this.radius);
                    }
                });
                tf = PaletteHelper.createTextEntry("nverts", "" + this.nsegs, pop);
                tf.addFocusListener(new FocusAdapter(){

                    public void focusLost(FocusEvent e) {
                        Circle.this.setSegs((JTextField)e.getSource());
                    }
                });
            }
            if (this.rt != 1) {
                tf = PaletteHelper.createTextEntry("width", "" + this.width, pop);
                tf.addFocusListener(new FocusAdapter(){

                    public void focusLost(FocusEvent e) {
                        JTextField jtf = (JTextField)e.getSource();
                        try {
                            Circle.this.width = Integer.parseInt(jtf.getText().trim());
                        }
                        catch (NumberFormatException ex) {
                            return;
                        }
                    }
                });
                tf = PaletteHelper.createTextEntry("height", "" + this.height, pop);
                tf.addFocusListener(new FocusAdapter(){

                    public void focusLost(FocusEvent e) {
                        JTextField jtf = (JTextField)e.getSource();
                        try {
                            Circle.this.height = Integer.parseInt(jtf.getText().trim());
                        }
                        catch (NumberFormatException ex) {
                            return;
                        }
                    }
                });
            }
            this.makeColorBox(pop, "line", false);
            this.makeColorBox(pop, "fill", true);
            this.makeFillCheckBox(pop);
            pop.add(this.getOKButton());
            return pop;
        }
    }

    protected class Rect
    extends Line {
        public Rect() {
            this.llpts[0] = -80.0f;
            this.llpts[1] = 0.0f;
            this.llpts[2] = 10.0f;
            this.llpts[3] = 45.0f;
            this.xypts[0] = 250;
            this.xypts[1] = 100;
            this.xypts[2] = 150;
            this.xypts[3] = 380;
            this.lineColor = 0;
            this.fillColor = 9;
            this.type = 2;
        }
    }

    protected class Line
    extends GraphicBase {
        protected int arrowtype;
        protected boolean arrowhead;

        public Line() {
            this.arrowtype = -1;
            this.arrowhead = false;
            this.llpts[0] = 45.0f;
            this.llpts[1] = -90.0f;
            this.llpts[2] = 0.0f;
            this.llpts[3] = -180.0f;
            this.xypts[0] = 45;
            this.xypts[1] = 90;
            this.xypts[2] = 0;
            this.xypts[3] = 180;
            this.lineColor = 5;
        }

        protected void makeArrowHeadGUI(JComponent parent) {
            JPanel pal = PaletteHelper.createVerticalPanel(null);
            final JComboBox<String> jcb = new JComboBox<String>();
            jcb.addItem("None");
            jcb.addItem("Arrow Forward");
            jcb.addItem("Arrow Back");
            jcb.addItem("Arrow Both");
            jcb.setSelectedIndex(this.arrowtype + 1);
            jcb.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    switch (jcb.getSelectedIndex()) {
                        case 0: {
                            System.out.println("TestLayer: no arrows");
                            ((Line)Line.this).TestLayer.this.omline.addArrowHead(false);
                            Line.this.arrowhead = false;
                            Line.this.arrowtype = -1;
                            break;
                        }
                        case 1: {
                            System.out.println("TestLayer: arrows forward");
                            Line.this.arrowhead = true;
                            Line.this.arrowtype = 0;
                            break;
                        }
                        case 2: {
                            System.out.println("TestLayer: arrows backward");
                            Line.this.arrowhead = true;
                            Line.this.arrowtype = 1;
                            break;
                        }
                        case 3: {
                            System.out.println("TestLayer: arrows both");
                            Line.this.arrowhead = true;
                            Line.this.arrowtype = 2;
                        }
                    }
                    TestLayer.this.setList(TestLayer.this.generateGraphics());
                    TestLayer.this.repaint();
                }
            });
            pal.add(jcb);
            parent.add(pal);
        }

        public JPanel getGUI() {
            JTextField tf;
            TestLayer.this.requestFocus();
            JPanel pop = PaletteHelper.createVerticalPanel(null);
            if (!(this instanceof Rect)) {
                this.makeArrowHeadGUI(pop);
            }
            if (this.rt == 1) {
                JPanel pal = PaletteHelper.createVerticalPanel(null);
                JComboBox<String> jcb = new JComboBox<String>();
                jcb.addItem("Straight");
                jcb.addItem("Rhumb");
                jcb.addItem("Great Circle");
                jcb.setSelectedIndex(this.type - 1);
                jcb.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        Line.this.setType((JComboBox)e.getSource());
                    }
                });
                pal.add(jcb);
                pop.add(pal);
                tf = PaletteHelper.createTextEntry("nsegs", "" + this.nsegs, pop);
                tf.addFocusListener(new FocusAdapter(){

                    public void focusLost(FocusEvent e) {
                        Line.this.setSegs((JTextField)e.getSource());
                    }
                });
            }
            if (this.rt != 2) {
                tf = PaletteHelper.createTextEntry("lat1", "" + this.llpts[0], pop);
                tf.addFocusListener(new FocusAdapter(){

                    public void focusLost(FocusEvent e) {
                        Line.this.setLLCoordinate((JTextField)e.getSource(), 0);
                    }
                });
                tf = PaletteHelper.createTextEntry("lon1", "" + this.llpts[1], pop);
                tf.addFocusListener(new FocusAdapter(){

                    public void focusLost(FocusEvent e) {
                        Line.this.setLLCoordinate((JTextField)e.getSource(), 1);
                    }
                });
            }
            if (this.rt == 1) {
                tf = PaletteHelper.createTextEntry("lat2", "" + this.llpts[2], pop);
                tf.addFocusListener(new FocusAdapter(){

                    public void focusLost(FocusEvent e) {
                        Line.this.setLLCoordinate((JTextField)e.getSource(), 2);
                    }
                });
                tf = PaletteHelper.createTextEntry("lon2", "" + this.llpts[3], pop);
                tf.addFocusListener(new FocusAdapter(){

                    public void focusLost(FocusEvent e) {
                        Line.this.setLLCoordinate((JTextField)e.getSource(), 3);
                    }
                });
            } else {
                tf = PaletteHelper.createTextEntry("x1", "" + this.xypts[0], pop);
                tf.addFocusListener(new FocusAdapter(){

                    public void focusLost(FocusEvent e) {
                        Line.this.setXYCoordinate((JTextField)e.getSource(), 0);
                    }
                });
                tf = PaletteHelper.createTextEntry("y1", "" + this.xypts[1], pop);
                tf.addFocusListener(new FocusAdapter(){

                    public void focusLost(FocusEvent e) {
                        Line.this.setXYCoordinate((JTextField)e.getSource(), 1);
                    }
                });
                tf = PaletteHelper.createTextEntry("x2", "" + this.xypts[2], pop);
                tf.addFocusListener(new FocusAdapter(){

                    public void focusLost(FocusEvent e) {
                        Line.this.setXYCoordinate((JTextField)e.getSource(), 2);
                    }
                });
                tf = PaletteHelper.createTextEntry("y2", "" + this.xypts[3], pop);
                tf.addFocusListener(new FocusAdapter(){

                    public void focusLost(FocusEvent e) {
                        Line.this.setXYCoordinate((JTextField)e.getSource(), 3);
                    }
                });
            }
            this.makeColorBox(pop, "line", false);
            if (this instanceof Rect) {
                this.makeColorBox(pop, "fill", true);
            }
            if (this instanceof Rect) {
                this.makeFillCheckBox(pop);
            }
            pop.add(this.getOKButton());
            return pop;
        }
    }

    protected abstract class GraphicBase {
        protected float[] llpts = new float[4];
        protected float radius = 4000.0f;
        protected int type = 3;
        protected int nsegs = 360;
        protected int[] xypts = new int[4];
        protected int width;
        protected int height;
        protected int lineColor = NCOLORS - 2;
        protected int fillColor = NCOLORS - 1;
        protected boolean visible = true;
        protected boolean isFilled = false;
        protected int rt = 1;

        protected GraphicBase() {
        }

        protected abstract JPanel getGUI();

        protected void setXYCoordinate(JTextField jtf, int i) {
            try {
                this.xypts[i] = Integer.parseInt(jtf.getText().trim());
            }
            catch (NumberFormatException ex) {
                return;
            }
        }

        protected void setLLCoordinate(JTextField jtf, int i) {
            try {
                this.llpts[i] = Float.valueOf(jtf.getText().trim()).floatValue();
            }
            catch (NumberFormatException ex) {
                return;
            }
        }

        protected void setType(JComboBox jcb) {
            this.type = jcb.getSelectedIndex() + 1;
            TestLayer.this.setList(TestLayer.this.generateGraphics());
            TestLayer.this.repaint();
        }

        protected void setRender(JComboBox jcb) {
            this.rt = jcb.getSelectedIndex() + 1;
            TestLayer.this.setList(TestLayer.this.generateGraphics());
            TestLayer.this.repaint();
        }

        protected void setSegs(JTextField jtf) {
            try {
                this.nsegs = Integer.parseInt(jtf.getText().trim());
            }
            catch (NumberFormatException ex) {
                return;
            }
        }

        protected void makeFillCheckBox(JComponent parent) {
            JPanel pal = PaletteHelper.createCheckbox(null, new String[]{"Filled"}, new boolean[]{this.isFilled}, new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    GraphicBase.this.isFilled = !GraphicBase.this.isFilled;
                    TestLayer.this.setList(TestLayer.this.generateGraphics());
                    TestLayer.this.repaint();
                }
            });
            parent.add(pal);
        }

        protected void makeColorBox(JComponent parent, String title, final boolean isFill) {
            JPanel pal = PaletteHelper.createVerticalPanel(title);
            final JComboBox<String> jcb = new JComboBox<String>();
            for (int i = 0; i < NCOLORS; ++i) {
                jcb.addItem(colorNames[i]);
            }
            jcb.setSelectedIndex(isFill ? this.fillColor : this.lineColor);
            jcb.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (isFill) {
                        GraphicBase.this.fillColor = jcb.getSelectedIndex();
                    } else {
                        GraphicBase.this.lineColor = jcb.getSelectedIndex();
                    }
                    TestLayer.this.setList(TestLayer.this.generateGraphics());
                    TestLayer.this.repaint();
                }
            });
            pal.add(jcb);
            parent.add(pal);
        }

        protected JButton getOKButton() {
            JButton jb = new JButton("OK");
            jb.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    TestLayer.this.setList(TestLayer.this.generateGraphics());
                    TestLayer.this.repaint();
                }
            });
            return jb;
        }
    }
}

