/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.terrain;

import com.bbn.openmap.dataAccess.dted.DTEDFrameCache;
import com.bbn.openmap.event.MapMouseListener;
import com.bbn.openmap.event.SelectMouseMode;
import com.bbn.openmap.layer.OMGraphicHandlerLayer;
import com.bbn.openmap.layer.policy.ListResetPCPolicy;
import com.bbn.openmap.layer.terrain.LOSGenerator;
import com.bbn.openmap.layer.terrain.ProfileGenerator;
import com.bbn.openmap.layer.terrain.TerrainTool;
import com.bbn.openmap.omGraphics.OMGraphicList;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.util.Debug;
import com.bbn.openmap.util.PaletteHelper;
import com.bbn.openmap.util.PropUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.Hashtable;
import java.util.Properties;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class TerrainLayer
extends OMGraphicHandlerLayer
implements ActionListener,
MapMouseListener {
    public DTEDFrameCache frameCache;
    protected int mode;
    public static final int PROFILE = 0;
    public static final int PERSPECTIVE = 1;
    public static final int LOS = 2;
    public TerrainTool currentTool;
    public ProfileGenerator profileTool;
    public LOSGenerator LOSTool;
    public static final String defaultModeProperty = "default.mode";
    public static final String clearCommand = "clearTool";
    public static final String createCommand = "createTool";
    protected Box palette = null;
    private String profileCommand = "setModeToProfile";
    private String losCommand = "setModeToLos";

    public TerrainLayer() {
        this.setName("Terrain");
        this.init();
    }

    public void init() {
        this.profileTool = new ProfileGenerator(this);
        this.LOSTool = new LOSGenerator(this);
        this.setProjectionChangePolicy(new ListResetPCPolicy(this));
    }

    protected void setDefaultValues() {
        this.mode = 0;
    }

    public void setFrameCache(DTEDFrameCache dfc) {
        this.frameCache = dfc;
    }

    public DTEDFrameCache getFrameCache() {
        return this.frameCache;
    }

    public void setProperties(String prefix, Properties properties) {
        super.setProperties(prefix, properties);
        this.setDefaultValues();
        prefix = PropUtils.getScopedPropertyPrefix(prefix);
        try {
            String defaultModeString = properties.getProperty(prefix + defaultModeProperty);
            if (defaultModeString.equalsIgnoreCase("LOS")) {
                this.setMode(2);
            } else {
                this.setMode(0);
            }
        }
        catch (NullPointerException e) {
            System.err.println("TerrainLayer: Caught NullPointerException loading resources.");
            System.err.println("TerrainLayer: Using default resources.");
            this.setDefaultValues();
            this.setMode(this.mode);
        }
    }

    public synchronized OMGraphicList prepare() {
        if (this.isCancelled()) {
            Debug.message("dted", this.getName() + "|TerrainLayer.prepare(): aborted.");
            return null;
        }
        Projection projection = this.getProjection();
        if (projection == null) {
            System.err.println("Terrain Layer needs to be added to the MapBean before it can be used!");
            return new OMGraphicList();
        }
        Debug.message("basic", this.getName() + "|TerrainLayer.prepare(): doing it");
        this.profileTool.setScreenParameters(projection);
        this.LOSTool.setScreenParameters(projection);
        return this.currentTool.getGraphics();
    }

    public Component getGUI() {
        if (this.palette == null) {
            if (Debug.debugging("terrain")) {
                System.out.println("TerrainLayer: creating Terrain Palette.");
            }
            this.palette = Box.createVerticalBox();
            JPanel modePanel = PaletteHelper.createPaletteJPanel("Tool Mode");
            ButtonGroup modes = new ButtonGroup();
            ActionListener al = new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    String ac = e.getActionCommand();
                    if (ac.equalsIgnoreCase(TerrainLayer.this.losCommand)) {
                        TerrainLayer.this.setMode(2);
                    } else {
                        TerrainLayer.this.setMode(0);
                    }
                }
            };
            JRadioButton profileModeButton = new JRadioButton("Profile");
            profileModeButton.addActionListener(al);
            profileModeButton.setActionCommand(this.profileCommand);
            JRadioButton losModeButton = new JRadioButton("LOS");
            losModeButton.addActionListener(al);
            losModeButton.setActionCommand(this.losCommand);
            modes.add(profileModeButton);
            modes.add(losModeButton);
            switch (this.mode) {
                case 2: {
                    losModeButton.setSelected(true);
                    break;
                }
                default: {
                    profileModeButton.setSelected(true);
                }
            }
            modePanel.add(profileModeButton);
            modePanel.add(losModeButton);
            JPanel centerHeightPanel = PaletteHelper.createPaletteJPanel("LOS Center Object Height");
            JSlider centerHeightSlide = new JSlider(0, 0, 500, 0);
            Hashtable<Integer, JLabel> dict = new Hashtable<Integer, JLabel>();
            dict.put(new Integer(0), new JLabel("0 ft"));
            dict.put(new Integer(500), new JLabel("500 ft"));
            centerHeightSlide.setLabelTable(dict);
            centerHeightSlide.setPaintLabels(true);
            centerHeightSlide.setMajorTickSpacing(50);
            centerHeightSlide.setPaintTicks(true);
            centerHeightSlide.setSnapToTicks(false);
            centerHeightSlide.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent ce) {
                    JSlider slider = (JSlider)ce.getSource();
                    if (slider.getValueIsAdjusting()) {
                        TerrainLayer.this.fireRequestInfoLine("TerrainLayer - center height value = " + slider.getValue());
                        TerrainLayer.this.LOSTool.setLOSobjectHeight(slider.getValue());
                    }
                }
            });
            centerHeightPanel.add(centerHeightSlide);
            JPanel profileControlPanel = PaletteHelper.createPaletteJPanel("Tool Commands");
            JButton clearButton = new JButton("Clear/Reset Tool");
            clearButton.setActionCommand(clearCommand);
            clearButton.addActionListener(this);
            JButton createButton = new JButton("Create");
            createButton.setActionCommand(createCommand);
            createButton.addActionListener(this);
            profileControlPanel.add(clearButton);
            profileControlPanel.add(createButton);
            JButton redraw = new JButton("Redraw Terrain Layer");
            redraw.setActionCommand("redrawCmd");
            redraw.addActionListener(this);
            this.palette.add(modePanel);
            this.palette.add(centerHeightPanel);
            this.palette.add(profileControlPanel);
        }
        return this.palette;
    }

    public void actionPerformed(ActionEvent e) {
        super.actionPerformed(e);
        String ac = e.getActionCommand();
        if (ac.equalsIgnoreCase("redrawCmd")) {
            this.doPrepare();
        } else {
            this.currentTool.getState().actionPerformed(e);
        }
    }

    public synchronized MapMouseListener getMapMouseListener() {
        return this;
    }

    public String[] getMouseModeServiceList() {
        String[] services = new String[]{SelectMouseMode.modeID};
        return services;
    }

    public boolean mousePressed(MouseEvent e) {
        return this.currentTool.getState().mousePressed(e);
    }

    public boolean mouseReleased(MouseEvent e) {
        return this.currentTool.getState().mouseReleased(e);
    }

    public boolean mouseClicked(MouseEvent e) {
        return this.currentTool.getState().mouseClicked(e);
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public boolean mouseDragged(MouseEvent e) {
        return this.currentTool.getState().mouseDragged(e);
    }

    public boolean mouseMoved(MouseEvent e) {
        return false;
    }

    public void mouseMoved() {
    }

    public static int numPixelsBetween(int x1, int y1, int x2, int y2) {
        return (int)Math.sqrt(Math.pow(x1 - x2, 2.0) + Math.pow(y1 - y2, 2.0));
    }

    public void setMode(int m) {
        this.mode = m;
        if (this.currentTool != null) {
            this.currentTool.reset();
        }
        if (m == 0) {
            this.currentTool = this.profileTool;
        }
        if (m == 2) {
            this.currentTool = this.LOSTool;
        }
        if (this.currentTool != null) {
            this.currentTool.reset();
            this.setList(this.currentTool.getGraphics());
        }
    }

    public int getMode() {
        return this.mode;
    }

    public void findAndInit(Object someObj) {
        if (someObj instanceof DTEDFrameCache) {
            this.setFrameCache((DTEDFrameCache)someObj);
        }
    }

    public void findAndUndo(Object someObj) {
        if (someObj == this.getFrameCache()) {
            this.setFrameCache(null);
        }
    }
}

