/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.shape.areas;

import com.bbn.openmap.LatLonPoint;
import com.bbn.openmap.layer.shape.ShapeLayer;
import com.bbn.openmap.layer.shape.areas.AreaHandler;
import com.bbn.openmap.layer.shape.areas.PoliticalArea;
import com.bbn.openmap.omGraphics.DrawingAttributes;
import com.bbn.openmap.omGraphics.OMGraphic;
import com.bbn.openmap.omGraphics.OMGraphicList;
import com.bbn.openmap.proj.Projection;
import java.util.Properties;

public class AreaShapeLayer
extends ShapeLayer {
    protected AreaHandler areas;

    public AreaShapeLayer() {
        this.setMouseModeIDsForEvents(new String[]{"Gestures"});
    }

    public void setProperties(String prefix, Properties props) {
        super.setProperties(prefix, props);
        this.areas = new AreaHandler(this.spatialIndex, this.drawingAttributes);
        this.areas.setProperties(prefix, props);
        this.areas.setCoordTransform(super.getCoordTransform());
    }

    public Properties getProperties(Properties props) {
        props = super.getProperties(props);
        if (this.areas != null) {
            this.areas.getProperties(props);
        }
        return props;
    }

    public Properties getPropertyInfo(Properties props) {
        props = super.getPropertyInfo(props);
        if (this.areas != null) {
            this.areas.getPropertyInfo(props);
        }
        return props;
    }

    public void setAreas(AreaHandler a) {
        this.areas = a;
    }

    public AreaHandler getAreas() {
        return this.areas;
    }

    public synchronized OMGraphicList prepare() {
        Projection projection = this.getProjection();
        LatLonPoint ul = projection.getUpperLeft();
        LatLonPoint lr = projection.getLowerRight();
        float ulLat = ul.getLatitude();
        float ulLon = ul.getLongitude();
        float lrLat = lr.getLatitude();
        float lrLon = lr.getLongitude();
        OMGraphicList list = this.areas.getGraphics(ulLat, ulLon, lrLat, lrLon, this.getProjection());
        return list;
    }

    public void setDrawingAttributes(DrawingAttributes da) {
        this.areas.setDrawingAttributes(da);
    }

    public DrawingAttributes getDrawingAttributes() {
        return this.areas.getDrawingAttributes();
    }

    public PoliticalArea findPoliticalArea(String area_abbrev) {
        return this.areas.findPoliticalArea(area_abbrev);
    }

    public boolean isHighlightable(OMGraphic omg) {
        return true;
    }
}

