/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.shape;

import com.bbn.openmap.LatLonPoint;
import com.bbn.openmap.dataAccess.shape.DbfHandler;
import com.bbn.openmap.dataAccess.shape.EsriGraphicFactory;
import com.bbn.openmap.io.BinaryBufferedFile;
import com.bbn.openmap.io.BinaryFile;
import com.bbn.openmap.io.FormatException;
import com.bbn.openmap.layer.shape.ESRIBoundingBox;
import com.bbn.openmap.layer.shape.ESRIPointRecord;
import com.bbn.openmap.layer.shape.ESRIPolygonRecord;
import com.bbn.openmap.layer.shape.ESRIRecord;
import com.bbn.openmap.layer.shape.ShapeUtils;
import com.bbn.openmap.omGraphics.DrawingAttributes;
import com.bbn.openmap.omGraphics.OMGraphic;
import com.bbn.openmap.omGraphics.OMGraphicList;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.proj.coords.GeoCoordTransformation;
import com.bbn.openmap.util.Debug;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.ImageIcon;

public class SpatialIndex
extends ShapeUtils {
    public static final int SHAPE_FILE_HEADER_LENGTH = 100;
    public static final int SHAPE_RECORD_HEADER_LENGTH = 8;
    public static final int SPATIAL_INDEX_HEADER_LENGTH = 100;
    public static final int SPATIAL_INDEX_RECORD_LENGTH = 40;
    public static final int DEFAULT_SHAPE_RECORD_SIZE = 50000;
    protected BinaryBufferedFile shp;
    protected DbfHandler dbf;
    protected ImageIcon pointIcon;
    protected ESRIBoundingBox bounds = null;
    protected String shpFileName;
    protected List entries;
    EsriGraphicFactory factory = new EsriGraphicFactory();

    public SpatialIndex(String shpFilename) throws IOException {
        this.shpFileName = shpFilename;
        if (Debug.debugging("spatialindex")) {
            Debug.output("SpatialIndex(" + shpFilename + ");");
        }
    }

    public SpatialIndex(String ssxFilename, String shpFilename) throws IOException {
        this(shpFilename);
    }

    public static String ssx(String shpFileName) {
        String ret = null;
        if (shpFileName != null) {
            ret = shpFileName.substring(0, shpFileName.indexOf(".shp")) + ".ssx";
        }
        return ret;
    }

    public static String dbf(String shpFileName) {
        String ret = null;
        if (shpFileName != null) {
            ret = shpFileName.substring(0, shpFileName.indexOf(".shp")) + ".dbf";
        }
        return ret;
    }

    public ESRIBoundingBox getBounds() {
        if (this.bounds == null) {
            try {
                this.locateRecords(-180.0, -90.0, 180.0, 90.0);
            }
            catch (IOException ioe) {
                this.bounds = null;
            }
            catch (FormatException fe) {
                this.bounds = null;
            }
        }
        return this.bounds;
    }

    public void resetBounds() {
        this.bounds = null;
    }

    public ESRIRecord makeESRIRecord(int shapeType, byte[] b, int off) throws IOException {
        switch (shapeType) {
            case 0: {
                return null;
            }
            case 1: {
                return new ESRIPointRecord(b, off, this.pointIcon);
            }
            case 3: 
            case 5: {
                return new ESRIPolygonRecord(b, off);
            }
            case 8: {
                Debug.output("SpatialIndex.makeESRIRecord: Arc NYI");
                return null;
            }
        }
        return null;
    }

    public ESRIRecord[] locateRecords(double xmin, double ymin, double xmax, double ymax) throws IOException, FormatException {
        int result;
        boolean gatherBounds = false;
        if (this.bounds == null) {
            this.bounds = new ESRIBoundingBox();
            gatherBounds = true;
        }
        if (Debug.debugging("spatialindex")) {
            Debug.output("locateRecords:");
            Debug.output("\txmin: " + xmin + "; ymin: " + ymin);
            Debug.output("\txmax: " + xmax + "; ymax: " + ymax);
        }
        byte[] ixRecord = new byte[40];
        int recNum = 0;
        Vector<ESRIRecord> v = new Vector<ESRIRecord>();
        int sRecordSize = 50000;
        byte[] sRecord = new byte[sRecordSize];
        if (this.shpFileName == null) {
            return null;
        }
        BinaryBufferedFile ssx = new BinaryBufferedFile(SpatialIndex.ssx(this.shpFileName));
        if (this.shp == null) {
            this.shp = new BinaryBufferedFile(this.shpFileName);
        }
        ssx.seek(32L);
        ssx.byteOrder(false);
        int shapeType = ssx.readInteger();
        ssx.seek(100L);
        while ((result = ssx.read(ixRecord, 0, 40)) > 0) {
            ++recNum;
            double xmin2 = SpatialIndex.readLEDouble(ixRecord, 8);
            double ymin2 = SpatialIndex.readLEDouble(ixRecord, 16);
            double xmax2 = SpatialIndex.readLEDouble(ixRecord, 24);
            double ymax2 = SpatialIndex.readLEDouble(ixRecord, 32);
            if (Debug.debugging("spatialindexdetail")) {
                Debug.output("Looking at rec num " + recNum);
                Debug.output("  " + xmin2 + ", " + ymin2 + "\n  " + xmax2 + ", " + ymax2);
            }
            if (gatherBounds) {
                this.bounds.addPoint(xmin2, ymin2);
                this.bounds.addPoint(xmax2, ymax2);
            }
            if (!SpatialIndex.intersects(xmin, ymin, xmax, ymax, xmin2, ymin2, xmax2, ymax2)) continue;
            int offset = SpatialIndex.readBEInt(ixRecord, 0);
            int byteOffset = offset * 2;
            int contentLength = SpatialIndex.readBEInt(ixRecord, 4);
            int recordSize = contentLength * 2 + 8;
            if (recordSize < 0) {
                Debug.error("SpatialIndex: supposed to read record size of " + recordSize);
                break;
            }
            if (recordSize > sRecordSize) {
                sRecordSize = recordSize;
                if (Debug.debugging("spatialindexdetail")) {
                    Debug.output("Shapefile SpatialIndex record size: " + sRecordSize);
                }
                sRecord = new byte[sRecordSize];
            }
            if (Debug.debugging("spatialindex")) {
                Debug.output("going to shp byteOffset = " + byteOffset + " for record size = " + recordSize + ", offset = " + offset + ", shape type = " + shapeType);
            }
            try {
                this.shp.seek(byteOffset);
                int nBytes = this.shp.read(sRecord, 0, recordSize);
                if (nBytes < recordSize) {
                    Debug.error("Shapefile SpatialIndex expected " + recordSize + " bytes, but got " + nBytes + " bytes instead.");
                }
                ESRIRecord record = this.makeESRIRecord(shapeType, sRecord, 0);
                v.addElement(record);
            }
            catch (IOException ioe) {
                Debug.error("SpatialIndex.locateRecords: IOException. ");
                ioe.printStackTrace();
                break;
            }
        }
        if (Debug.debugging("spatialindex")) {
            Debug.output("Processed " + recNum + " records");
            Debug.output("Selected " + v.size() + " records");
        }
        int nRecords = v.size();
        ssx.close();
        this.shp.close();
        this.shp = null;
        Object[] result2 = new ESRIRecord[nRecords];
        v.copyInto(result2);
        return result2;
    }

    public EsriGraphicFactory getFactory() {
        if (this.factory == null) {
            this.factory = new EsriGraphicFactory();
        }
        return this.factory;
    }

    public void setFactory(EsriGraphicFactory factory) {
        this.factory = factory;
    }

    public OMGraphicList getOMGraphics(double xmin, double ymin, double xmax, double ymax, OMGraphicList list, DrawingAttributes drawingAttributes, Projection mapProj, GeoCoordTransformation dataProj) throws IOException, FormatException {
        if (Debug.debugging("spatialindex")) {
            Debug.output("locateRecords:");
            Debug.output("\txmin: " + xmin + "; ymin: " + ymin);
            Debug.output("\txmax: " + xmax + "; ymax: " + ymax);
        }
        if (list == null) {
            list = new OMGraphicList();
        }
        if (this.shp == null) {
            this.shp = new BinaryBufferedFile(this.shpFileName);
        }
        if (this.shp == null) {
            return list;
        }
        EsriGraphicFactory.ReadByteTracker byteTracker = new EsriGraphicFactory.ReadByteTracker();
        EsriGraphicFactory factory = this.getFactory();
        factory.setDataCoordTransformation(dataProj);
        OMGraphicList labels = new OMGraphicList();
        list.add(labels);
        Iterator it = this.entryIterator(dataProj);
        while (it.hasNext()) {
            Entry entry = (Entry)it.next();
            if (!entry.intersects(xmin, ymin, xmax, ymax)) continue;
            try {
                OMGraphic omg = factory.makeEsriGraphicFromRecord(entry.getByteOffset(), this.shp, drawingAttributes, (Object)this.pointIcon, byteTracker);
                if (omg == null || this.dbf != null && (omg = this.dbf.evaluate(omg, labels, mapProj)) == null) continue;
                if (mapProj != null) {
                    omg.generate(mapProj);
                }
                list.add(omg);
            }
            catch (IOException ioe) {
                Debug.error("SpatialIndex.locateRecords: IOException. ");
                ioe.printStackTrace();
                break;
            }
        }
        if (this.shp != null) {
            this.shp.close();
            this.shp = null;
        }
        if (this.dbf != null) {
            this.dbf.close();
        }
        return list;
    }

    public OMGraphicList getAllOMGraphics(OMGraphicList retList, DrawingAttributes drawingAttributes, Projection mapProj, GeoCoordTransformation dataProj) throws IOException, FormatException {
        if (retList == null) {
            retList = new OMGraphicList();
        }
        if (this.shp == null) {
            this.shp = new BinaryBufferedFile(this.shpFileName);
        }
        if (this.shp == null) {
            return retList;
        }
        EsriGraphicFactory factory = this.getFactory();
        factory.setDataCoordTransformation(dataProj);
        factory.getEsriGraphics(this.shp, drawingAttributes, (Object)this.pointIcon, mapProj, retList);
        this.shp.close();
        return retList;
    }

    public OMGraphicList evaluateDbf(OMGraphicList retList, Projection mapProj) {
        if (this.dbf != null) {
            OMGraphicList labels = new OMGraphicList();
            retList.add(labels);
            OMGraphicList testList = new OMGraphicList();
            Iterator it = retList.iterator();
            while (it.hasNext()) {
                OMGraphic omg = (OMGraphic)it.next();
                if (omg == null) continue;
                omg = this.dbf.evaluate(omg, labels, mapProj);
                if (mapProj != null) {
                    omg.generate(mapProj);
                }
                testList.add(omg);
            }
            retList = testList;
        }
        return retList;
    }

    public OMGraphic evaluate(OMGraphic omg, OMGraphicList labels, Projection mapProj) {
        if (this.dbf != null) {
            omg = this.dbf.evaluate(omg, labels, mapProj);
        }
        return omg;
    }

    public OMGraphic getOMGraphicAtOffset(int byteOffset, DrawingAttributes drawingAttributes) throws IOException, FormatException {
        return this.getFactory().makeEsriGraphicFromRecord(byteOffset, this.shp, drawingAttributes, (Object)this.pointIcon, new EsriGraphicFactory.ReadByteTracker());
    }

    public Iterator entryIterator() throws IOException, FormatException {
        return this.entryIterator(null);
    }

    public Iterator entryIterator(GeoCoordTransformation dataTransform) throws IOException, FormatException {
        if (this.entries == null) {
            boolean gatherBounds = false;
            if (this.bounds == null) {
                this.bounds = new ESRIBoundingBox();
                gatherBounds = true;
            }
            this.entries = this.readIndexFile(gatherBounds ? this.bounds : null, dataTransform);
        }
        return this.entries.iterator();
    }

    protected List readIndexFile(ESRIBoundingBox bounds) throws IOException, FormatException {
        return this.readIndexFile(bounds, null);
    }

    protected List readIndexFile(ESRIBoundingBox bounds, GeoCoordTransformation dataTransform) throws IOException, FormatException {
        int result;
        this.entries = new ArrayList();
        byte[] ixRecord = new byte[40];
        if (this.shpFileName == null) {
            return this.entries;
        }
        String ssxFileName = SpatialIndex.ssx(this.shpFileName);
        if (!BinaryBufferedFile.exists(ssxFileName)) {
            this.entries = MemoryIndex.create(this.shpFileName);
            return this.entries;
        }
        BinaryBufferedFile ssx = new BinaryBufferedFile(ssxFileName);
        ssx.byteOrder(false);
        ssx.seek(100L);
        LatLonPoint llp = null;
        if (dataTransform != null) {
            llp = new LatLonPoint();
        }
        while ((result = ssx.read(ixRecord, 0, 40)) > 0) {
            double xmin = SpatialIndex.readLEDouble(ixRecord, 8);
            double ymin = SpatialIndex.readLEDouble(ixRecord, 16);
            double xmax = SpatialIndex.readLEDouble(ixRecord, 24);
            double ymax = SpatialIndex.readLEDouble(ixRecord, 32);
            int byteOffset = SpatialIndex.readBEInt(ixRecord, 0) * 2;
            if (dataTransform != null) {
                dataTransform.inverse(xmin, ymin, llp);
                xmin = llp.getLongitude();
                ymin = llp.getLatitude();
                dataTransform.inverse(xmax, ymax, llp);
                xmax = llp.getLongitude();
                ymax = llp.getLatitude();
            }
            if (Debug.debugging("spatialindexdetail")) {
                Debug.output("  " + xmin + ", " + ymin + "\n  " + xmax + ", " + ymax);
            }
            Entry entry = new Entry(xmin, ymin, xmax, ymax, byteOffset);
            this.entries.add(entry);
            if (bounds == null) continue;
            bounds.addPoint(xmin, ymin);
            bounds.addPoint(xmax, ymax);
        }
        ssx.close();
        return this.entries;
    }

    protected static final boolean intersects(double xmin1, double ymin1, double xmax1, double ymax1, double xmin2, double ymin2, double xmax2, double ymax2) {
        return !(xmax1 <= xmin2 || ymax1 <= ymin2 || xmin1 >= xmax2 || ymin1 >= ymax2);
    }

    public void dumpIndex(boolean showBounds) throws IOException {
        int result;
        byte[] ixRecord = new byte[40];
        int recNum = 0;
        if (this.shpFileName == null) {
            return;
        }
        BinaryBufferedFile ssx = new BinaryBufferedFile(SpatialIndex.ssx(this.shpFileName));
        ssx.seek(100L);
        while ((result = ssx.read(ixRecord, 0, 40)) > 0) {
            int offset = SpatialIndex.readBEInt(ixRecord, 0);
            int length = SpatialIndex.readBEInt(ixRecord, 4);
            Debug.output("Record " + ++recNum + ": " + offset + ", " + length + (showBounds ? "; " + SpatialIndex.readLEDouble(ixRecord, 8) + ", " + SpatialIndex.readLEDouble(ixRecord, 16) + ", " + SpatialIndex.readLEDouble(ixRecord, 24) + ", " + SpatialIndex.readLEDouble(ixRecord, 32) : ""));
        }
        ssx.close();
    }

    public static void printUsage(PrintStream out) {
        String className = SpatialIndex.class.getName();
        out.println("Usage:");
        out.println();
        out.println("java " + className + " -c file.shp");
        out.println("Creates spatial index <file.ssx> from shape file <file.shp>.");
        out.println();
        out.println("java " + className + " -d file.ssx");
        out.println("Dumps spatial index information, excluding bounding boxes to stdout.  Useful for comparing to a shape index.");
        out.println();
        out.println("java " + className + " -d -b file.ssx");
        out.println("Dumps spatial index information including bounding boxes to stdout.");
        out.println();
    }

    public static String locateFile(String name) {
        String newname;
        File file = new File(name);
        if (file.exists()) {
            return name;
        }
        URL url = ClassLoader.getSystemResource(name);
        if (url != null && (file = new File(newname = url.getFile())).exists()) {
            return newname;
        }
        return null;
    }

    public static SpatialIndex locateAndSetShapeData(String shapeFileName) {
        SpatialIndex spi = null;
        if (shapeFileName == null) {
            return null;
        }
        int appendixIndex = shapeFileName.indexOf(".shp");
        if (Debug.debugging("shape")) {
            Debug.output("SpatialIndex: created with just the shape file " + shapeFileName);
        }
        if (appendixIndex != -1) {
            if (BinaryFile.exists(shapeFileName)) {
                String newShapeFileName;
                String spatialIndexFileName = SpatialIndex.ssx(shapeFileName);
                if (Debug.debugging("shape")) {
                    Debug.output("Trying to locate spatial index file " + spatialIndexFileName);
                }
                if (!BinaryFile.exists(spatialIndexFileName) && (newShapeFileName = SpatialIndex.locateFile(shapeFileName)) != null) {
                    Debug.output("Creating spatial index file: " + spatialIndexFileName);
                }
                try {
                    spi = new SpatialIndex(shapeFileName);
                }
                catch (IOException ioe) {
                    Debug.error(ioe.getMessage());
                    ioe.printStackTrace(Debug.getErrorStream());
                    spi = null;
                }
            } else {
                Debug.error("SpatialIndex: Couldn't locate shape file " + shapeFileName);
            }
        } else if (Debug.debugging("shape")) {
            Debug.output("SpatialIndex: file " + shapeFileName + " doesn't look like a shape file");
        }
        return spi;
    }

    public static void main(String[] argv) throws IOException {
        int argc = argv.length;
        if (argc == 0) {
            SpatialIndex.printUsage(System.out);
            System.exit(0);
        }
        if (argv[0].equals("-d")) {
            if (argc == 2) {
                String name = argv[1];
                SpatialIndex si = new SpatialIndex(name);
                si.dumpIndex(false);
            } else if (argc == 3 && argv[1].equals("-b")) {
                String name = argv[2];
                SpatialIndex si = new SpatialIndex(name);
                si.dumpIndex(true);
            } else {
                SpatialIndex.printUsage(System.err);
                System.exit(1);
            }
        } else if (argc == 3 && argv[0].equals("-c")) {
            String shapeFile = argv[1];
            FileIndex.create(shapeFile);
        } else {
            SpatialIndex.printUsage(System.err);
            System.exit(1);
        }
    }

    public synchronized void setPointIcon(ImageIcon ii) {
        this.pointIcon = ii;
    }

    public synchronized ImageIcon getPointIcon() {
        return this.pointIcon;
    }

    public boolean close(boolean done) {
        try {
            if (this.shp != null) {
                this.shp.close();
            }
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public DbfHandler getDbf() {
        return this.dbf;
    }

    public void setDbf(DbfHandler dbf) {
        this.dbf = dbf;
    }

    public static class MemoryIndex {
        protected MemoryIndex() {
        }

        public static List create(String shpFile) {
            MemoryIndex mi = new MemoryIndex();
            return mi.createIndex(shpFile);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void indexPolygons(InputStream is, long ptr, List entries) {
            boolean moreRecords = true;
            byte[] rHdr = new byte[8];
            int nRecords = 0;
            int recBufSize = 100000;
            byte[] recBuf = new byte[recBufSize];
            try {
                while (moreRecords) {
                    int result = is.read(rHdr, 0, 8);
                    if (result < 0) {
                        moreRecords = false;
                        if (!Debug.debugging("shape")) continue;
                        Debug.output("Shapefile SpatialIndex Found " + nRecords + " records");
                        Debug.output("Shapefile SpatialIndex recBufSize = " + recBufSize);
                        continue;
                    }
                    ++nRecords;
                    long recOffset = ptr;
                    ShapeUtils.readBEInt(rHdr, 0);
                    int recLengthWords = ShapeUtils.readBEInt(rHdr, 4);
                    int recLengthBytes = recLengthWords * 2;
                    if (recLengthBytes > recBufSize) {
                        if (Debug.debugging("shape")) {
                            Debug.output("Shapefile SpatialIndex increasing recBufSize to " + recLengthBytes);
                        }
                        recBufSize = recLengthBytes;
                        recBuf = new byte[recBufSize];
                    }
                    result = is.read(recBuf, 0, recLengthBytes);
                    int shapeType = ShapeUtils.readLEInt(recBuf, 0);
                    ESRIBoundingBox polyBounds = shapeType != 0 ? ShapeUtils.readBox(recBuf, 4) : new ESRIBoundingBox();
                    ptr += (long)(recLengthBytes + 8);
                    Entry entry = new Entry(polyBounds.min.x, polyBounds.min.y, polyBounds.max.x, polyBounds.max.y, (int)recOffset);
                    entries.add(entry);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                try {
                    is.close();
                }
                catch (IOException e) {}
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void indexPoints(InputStream is, long ptr, List entries) {
            boolean moreRecords = true;
            byte[] rHdr = new byte[8];
            int nRecords = 0;
            int recBufSize = 20;
            byte[] recBuf = new byte[recBufSize];
            double x = 0.0;
            double y = 0.0;
            try {
                while (moreRecords) {
                    int result = is.read(rHdr, 0, 8);
                    if (result < 0) {
                        moreRecords = false;
                        if (!Debug.debugging("shape")) continue;
                        Debug.output("Found " + nRecords + " records");
                        Debug.output("recBufSize = " + recBufSize);
                        continue;
                    }
                    ++nRecords;
                    long recOffset = ptr;
                    ShapeUtils.readBEInt(rHdr, 0);
                    int recLengthWords = ShapeUtils.readBEInt(rHdr, 4);
                    int recLengthBytes = recLengthWords * 2;
                    if (recLengthBytes > recBufSize) {
                        if (Debug.debugging("shape")) {
                            Debug.output("Shapefile SpatialIndex increasing recBufSize to " + recLengthBytes);
                        }
                        recBufSize = recLengthBytes;
                        recBuf = new byte[recBufSize];
                    }
                    result = is.read(recBuf, 0, recLengthBytes);
                    int shapeType = ShapeUtils.readLEInt(recBuf, 0);
                    if (shapeType != 0) {
                        x = ShapeUtils.readLEDouble(recBuf, 4);
                        y = ShapeUtils.readLEDouble(recBuf, 12);
                    }
                    ptr += (long)(recLengthBytes + 8);
                    Entry entry = new Entry(x, y, x, y, (int)recOffset);
                    entries.add(entry);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                try {
                    is.close();
                }
                catch (IOException e) {}
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void indexNulls(InputStream is, long ptr, List entries) {
            boolean moreRecords = true;
            byte[] rHdr = new byte[8];
            int nRecords = 0;
            int recBufSize = 20;
            byte[] recBuf = new byte[recBufSize];
            try {
                while (moreRecords) {
                    int result = is.read(rHdr, 0, 8);
                    if (result < 0) {
                        moreRecords = false;
                        if (!Debug.debugging("shape")) continue;
                        Debug.output("Found " + nRecords + " records");
                        Debug.output("recBufSize = " + recBufSize);
                        continue;
                    }
                    ++nRecords;
                    long recOffset = ptr;
                    ShapeUtils.readBEInt(rHdr, 0);
                    int recLengthWords = ShapeUtils.readBEInt(rHdr, 4);
                    int recLengthBytes = recLengthWords * 2;
                    if (recLengthBytes > recBufSize) {
                        if (Debug.debugging("shape")) {
                            Debug.output("Shapefile SpatialIndex increasing recBufSize to " + recLengthBytes);
                        }
                        recBufSize = recLengthBytes;
                        recBuf = new byte[recBufSize];
                    }
                    result = is.read(recBuf, 0, recLengthBytes);
                    double x = 0.0;
                    double y = 0.0;
                    ptr += (long)(recLengthBytes + 8);
                    Entry entry = new Entry(x, y, x, y, (int)recOffset);
                    entries.add(entry);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                try {
                    is.close();
                }
                catch (IOException e) {}
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public List createIndex(String inFile) {
            String shpFile = null;
            ArrayList entries = new ArrayList();
            if (!inFile.endsWith(".shp")) {
                return entries;
            }
            shpFile = inFile;
            byte[] fileHeader = new byte[100];
            FileInputStream shp = null;
            try {
                shp = new FileInputStream(shpFile);
                shp.read(fileHeader, 0, 100);
                int shapeType = ShapeUtils.readLEInt(fileHeader, 32);
                switch (shapeType) {
                    case 0: {
                        this.indexNulls(shp, 100L, entries);
                        return entries;
                    }
                    case 1: 
                    case 11: 
                    case 21: {
                        this.indexPoints(shp, 100L, entries);
                        return entries;
                    }
                    case 3: 
                    case 5: 
                    case 8: 
                    case 13: 
                    case 15: 
                    case 18: 
                    case 23: 
                    case 25: 
                    case 28: {
                        this.indexPolygons(shp, 100L, entries);
                        return entries;
                    }
                    default: {
                        Debug.error("Shapefile SpatialIndex.createIndex:  Unknown shape type: " + shapeType);
                        return entries;
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                return entries;
            }
            finally {
                try {
                    shp.close();
                }
                catch (IOException e) {}
            }
        }
    }

    public static class FileIndex {
        protected FileIndex() {
        }

        public static void create(String shpFile) {
            FileIndex fi = new FileIndex();
            fi.createIndex(shpFile);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void indexPolygons(InputStream is, long ptr, OutputStream os) {
            boolean moreRecords = true;
            byte[] rHdr = new byte[8];
            byte[] outBuf = new byte[40];
            int nRecords = 0;
            int recBufSize = 100000;
            byte[] recBuf = new byte[recBufSize];
            try {
                while (moreRecords) {
                    int result = is.read(rHdr, 0, 8);
                    if (result < 0) {
                        moreRecords = false;
                        if (!Debug.debugging("shape")) continue;
                        Debug.output("Shapefile SpatialIndex Found " + nRecords + " records");
                        Debug.output("Shapefile SpatialIndex recBufSize = " + recBufSize);
                        continue;
                    }
                    ++nRecords;
                    long recOffset = ptr;
                    ShapeUtils.readBEInt(rHdr, 0);
                    int recLengthWords = ShapeUtils.readBEInt(rHdr, 4);
                    int recLengthBytes = recLengthWords * 2;
                    if (recLengthBytes > recBufSize) {
                        if (Debug.debugging("shape")) {
                            Debug.output("Shapefile SpatialIndex increasing recBufSize to " + recLengthBytes);
                        }
                        recBufSize = recLengthBytes;
                        recBuf = new byte[recBufSize];
                    }
                    result = is.read(recBuf, 0, recLengthBytes);
                    int shapeType = ShapeUtils.readLEInt(recBuf, 0);
                    ESRIBoundingBox polyBounds = shapeType != 0 ? ShapeUtils.readBox(recBuf, 4) : new ESRIBoundingBox();
                    ptr += (long)(recLengthBytes + 8);
                    ShapeUtils.writeBEInt(outBuf, 0, (int)(recOffset / 2L));
                    ShapeUtils.writeBEInt(outBuf, 4, recLengthWords);
                    ShapeUtils.writeLEDouble(outBuf, 8, polyBounds.min.x);
                    ShapeUtils.writeLEDouble(outBuf, 16, polyBounds.min.y);
                    ShapeUtils.writeLEDouble(outBuf, 24, polyBounds.max.x);
                    ShapeUtils.writeLEDouble(outBuf, 32, polyBounds.max.y);
                    os.write(outBuf, 0, 40);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                try {
                    is.close();
                }
                catch (IOException e) {}
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void indexPoints(InputStream is, long ptr, OutputStream os) {
            boolean moreRecords = true;
            byte[] rHdr = new byte[8];
            byte[] outBuf = new byte[40];
            int nRecords = 0;
            int recBufSize = 20;
            byte[] recBuf = new byte[recBufSize];
            double x = 0.0;
            double y = 0.0;
            try {
                while (moreRecords) {
                    int result = is.read(rHdr, 0, 8);
                    if (result < 0) {
                        moreRecords = false;
                        if (!Debug.debugging("shape")) continue;
                        Debug.output("Found " + nRecords + " records");
                        Debug.output("recBufSize = " + recBufSize);
                        continue;
                    }
                    ++nRecords;
                    long recOffset = ptr;
                    ShapeUtils.readBEInt(rHdr, 0);
                    int recLengthWords = ShapeUtils.readBEInt(rHdr, 4);
                    int recLengthBytes = recLengthWords * 2;
                    if (recLengthBytes > recBufSize) {
                        if (Debug.debugging("shape")) {
                            Debug.output("Shapefile SpatialIndex increasing recBufSize to " + recLengthBytes);
                        }
                        recBufSize = recLengthBytes;
                        recBuf = new byte[recBufSize];
                    }
                    result = is.read(recBuf, 0, recLengthBytes);
                    int shapeType = ShapeUtils.readLEInt(recBuf, 0);
                    if (shapeType != 0) {
                        x = ShapeUtils.readLEDouble(recBuf, 4);
                        y = ShapeUtils.readLEDouble(recBuf, 12);
                    }
                    ptr += (long)(recLengthBytes + 8);
                    ShapeUtils.writeBEInt(outBuf, 0, (int)(recOffset / 2L));
                    ShapeUtils.writeBEInt(outBuf, 4, recLengthWords);
                    ShapeUtils.writeLEDouble(outBuf, 8, x);
                    ShapeUtils.writeLEDouble(outBuf, 16, y);
                    ShapeUtils.writeLEDouble(outBuf, 24, x);
                    ShapeUtils.writeLEDouble(outBuf, 32, y);
                    os.write(outBuf, 0, 40);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                try {
                    is.close();
                }
                catch (IOException e) {}
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void indexNulls(InputStream is, long ptr, OutputStream os) {
            boolean moreRecords = true;
            byte[] rHdr = new byte[8];
            byte[] outBuf = new byte[40];
            int nRecords = 0;
            int recBufSize = 20;
            byte[] recBuf = new byte[recBufSize];
            try {
                while (moreRecords) {
                    int result = is.read(rHdr, 0, 8);
                    if (result < 0) {
                        moreRecords = false;
                        if (!Debug.debugging("shape")) continue;
                        Debug.output("Found " + nRecords + " records");
                        Debug.output("recBufSize = " + recBufSize);
                        continue;
                    }
                    ++nRecords;
                    long recOffset = ptr;
                    ShapeUtils.readBEInt(rHdr, 0);
                    int recLengthWords = ShapeUtils.readBEInt(rHdr, 4);
                    int recLengthBytes = recLengthWords * 2;
                    if (recLengthBytes > recBufSize) {
                        if (Debug.debugging("shape")) {
                            Debug.output("Shapefile SpatialIndex increasing recBufSize to " + recLengthBytes);
                        }
                        recBufSize = recLengthBytes;
                        recBuf = new byte[recBufSize];
                    }
                    result = is.read(recBuf, 0, recLengthBytes);
                    double x = 0.0;
                    double y = 0.0;
                    ptr += (long)(recLengthBytes + 8);
                    ShapeUtils.writeBEInt(outBuf, 0, (int)(recOffset / 2L));
                    ShapeUtils.writeBEInt(outBuf, 4, recLengthWords);
                    ShapeUtils.writeLEDouble(outBuf, 8, x);
                    ShapeUtils.writeLEDouble(outBuf, 16, y);
                    ShapeUtils.writeLEDouble(outBuf, 24, x);
                    ShapeUtils.writeLEDouble(outBuf, 32, y);
                    os.write(outBuf, 0, 40);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                try {
                    is.close();
                }
                catch (IOException e) {}
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void createIndex(String inFile) {
            String ssxFile = null;
            String shpFile = null;
            if (inFile.endsWith(".shp")) {
                shpFile = inFile;
                ssxFile = SpatialIndex.ssx(shpFile);
            } else {
                if (!inFile.endsWith(".ssx")) return;
                ssxFile = inFile;
                shpFile = ssxFile.substring(0, ssxFile.indexOf(".ssx")) + ".shp";
            }
            byte[] fileHeader = new byte[100];
            FileInputStream shp = null;
            FileOutputStream ssx = null;
            try {
                shp = new FileInputStream(shpFile);
                ssx = new FileOutputStream(ssxFile);
                shp.read(fileHeader, 0, 100);
                ssx.write(fileHeader, 0, 100);
                int shapeType = ShapeUtils.readLEInt(fileHeader, 32);
                switch (shapeType) {
                    case 0: {
                        this.indexNulls(shp, 100L, ssx);
                        return;
                    }
                    case 1: 
                    case 11: 
                    case 21: {
                        this.indexPoints(shp, 100L, ssx);
                        return;
                    }
                    case 3: 
                    case 5: 
                    case 8: 
                    case 13: 
                    case 15: 
                    case 18: 
                    case 23: 
                    case 25: 
                    case 28: {
                        this.indexPolygons(shp, 100L, ssx);
                        return;
                    }
                    default: {
                        Debug.error("Shapefile SpatialIndex.createIndex:  Unknown shape type: " + shapeType);
                        return;
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                return;
            }
            finally {
                try {
                    shp.close();
                    ssx.close();
                }
                catch (IOException e) {}
            }
        }
    }

    public static class Entry {
        double xMin;
        double yMin;
        double xMax;
        double yMax;
        int byteOffset;

        public Entry(double xMin, double yMin, double xMax, double yMax, int byteOffset) {
            this.xMin = xMin;
            this.yMin = yMin;
            this.xMax = xMax;
            this.yMax = yMax;
            this.byteOffset = byteOffset;
        }

        public boolean intersects(double xmin, double ymin, double xmax, double ymax) {
            return SpatialIndex.intersects(xmin, ymin, xmax, ymax, this.xMin, this.yMin, this.xMax, this.yMax);
        }

        public int getByteOffset() {
            return this.byteOffset;
        }

        public void addToBounds(ESRIBoundingBox bounds) {
            bounds.addPoint(this.xMin, this.yMin);
            bounds.addPoint(this.xMax, this.yMax);
        }
    }
}

