/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.policy;

import com.bbn.openmap.OMComponent;
import com.bbn.openmap.layer.OMGraphicHandlerLayer;
import com.bbn.openmap.layer.policy.RenderPolicy;
import com.bbn.openmap.omGraphics.OMGraphicList;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.util.Debug;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;

public class StandardRenderPolicy
extends OMComponent
implements RenderPolicy {
    protected OMGraphicHandlerLayer layer;
    protected boolean DEBUG = Debug.debugging("layer") || Debug.debugging("policy");
    protected Composite composite;

    public StandardRenderPolicy() {
    }

    public StandardRenderPolicy(OMGraphicHandlerLayer layer) {
        this();
        this.setLayer(layer);
    }

    public void setLayer(OMGraphicHandlerLayer l) {
        this.layer = l;
    }

    public OMGraphicHandlerLayer getLayer() {
        return this.layer;
    }

    public Composite getComposite() {
        return this.composite;
    }

    public void setComposite(Composite composite) {
        this.composite = composite;
    }

    protected void setCompositeOnGraphics(Graphics2D g) {
        if (this.composite != null) {
            g.setComposite(this.composite);
        }
    }

    public OMGraphicList prepare() {
        if (this.layer != null) {
            return this.layer.prepare();
        }
        return null;
    }

    public void paint(Graphics g) {
        if (this.layer != null) {
            OMGraphicList list = this.layer.getList();
            Projection proj = this.layer.getProjection();
            if (list != null && this.layer.isProjectionOK(proj)) {
                if (proj != null) {
                    g.setClip(0, 0, proj.getWidth(), proj.getHeight());
                }
                this.setCompositeOnGraphics((Graphics2D)g);
                list.render(g);
            } else if (this.DEBUG) {
                Debug.output(this.layer.getName() + ".paint(): " + (list == null ? "NULL list, skipping..." : " skipping due to projection."));
            }
        } else {
            Debug.error("RenderPolicy.paint():  NULL layer, skipping...");
        }
    }
}

