/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.plotLayer;

import com.bbn.openmap.omGraphics.OMCircle;
import com.bbn.openmap.omGraphics.OMGraphic;
import java.awt.Color;
import java.util.Enumeration;
import java.util.Hashtable;

public class GLOBESite {
    private float longitude_;
    private float latitude_;
    private float max_year_ = -9999.0f;
    private float min_year_ = 99999.0f;
    private float max_temp_ = -99999.0f;
    private float min_temp_ = 99999.0f;
    private Hashtable temp_table_ = null;
    private String name_;
    private OMGraphic graphic_;

    public GLOBESite(float lat, float lon) {
        this.longitude_ = lon;
        this.latitude_ = lat;
        this.name_ = "(" + this.latitude_ + ", " + this.longitude_ + ")";
        this.graphic_ = new OMCircle(lat, lon, 5, 5);
        this.graphic_.setLinePaint(Color.red);
        this.graphic_.setFillPaint(Color.red);
        this.graphic_.setSelectPaint(Color.yellow);
        this.graphic_.setAppObject(this);
        this.temp_table_ = new Hashtable();
    }

    public String hash() {
        return this.name_;
    }

    public void addCurrentTemp(float year, float temp) {
        this.temp_table_.put(new Float(year), new Float(temp));
    }

    public float getCurrentTemp(float year) {
        return ((Number)this.temp_table_.get(new Float(year))).floatValue();
    }

    public float getLatitude() {
        return this.latitude_;
    }

    public float getLongitude() {
        return this.longitude_;
    }

    public final OMGraphic getGraphic() {
        return this.graphic_;
    }

    public String getName() {
        return this.name_;
    }

    public Enumeration getAllYears() {
        return this.temp_table_.keys();
    }

    public float getMaxTemp() {
        return this.max_temp_;
    }

    public float getMinTemp() {
        return this.min_temp_;
    }

    public float getMaxYear() {
        return this.max_year_;
    }

    public float getMinYear() {
        return this.min_year_;
    }

    public float getValueForYear(float year) {
        if (this.temp_table_.containsKey(new Float(year))) {
            return ((Float)this.temp_table_.get(new Float(year))).floatValue();
        }
        return -99.0f;
    }

    protected void recalcLimits() {
        Enumeration all_years = this.temp_table_.keys();
        while (all_years.hasMoreElements()) {
            float year = ((Float)all_years.nextElement()).floatValue();
            float temp = ((Float)this.temp_table_.get(new Float(year))).floatValue();
            if (year > this.max_year_) {
                this.max_year_ = year;
            }
            if (year < this.min_year_) {
                this.min_year_ = year;
            }
            if (temp > this.max_temp_) {
                this.max_temp_ = temp;
            }
            if (!(temp < this.min_temp_)) continue;
            this.max_temp_ = temp;
        }
    }

    public String getInfo() {
        int numpoints = this.temp_table_.size();
        return this.name_ + " -- " + numpoints + " datapoints available";
    }
}

