/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.location.csv;

import com.bbn.openmap.layer.location.Link;
import com.bbn.openmap.layer.location.csv.CSVLocationHandler;
import com.bbn.openmap.util.ColorFactory;
import com.bbn.openmap.util.DataOrganizer;
import com.bbn.openmap.util.Debug;
import com.bbn.openmap.util.PropUtils;
import java.awt.Color;
import java.awt.Component;
import java.util.Properties;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;

public class CSVLinkHandler
extends CSVLocationHandler {
    public static final String Lat1IndexProperty = "lat1Index";
    public static final String Lon1IndexProperty = "lon1Index";
    public static final String Lat2IndexProperty = "lat2Index";
    public static final String Lon2IndexProperty = "lon2Index";
    public static final String LinkTypeIndexProperty = "linkTypeIndex";
    public static final String DashIndexProperty = "dashIndex";
    public static final String ColorIndexProperty = "colorIndex";
    public static final String ThicknessIndexProperty = "thicknessIndex";
    public static final String GeoStyleIndexProperty = "geoStyleIndex";
    protected int lat1Index = -1;
    protected int lon1Index = -1;
    protected int lat2Index = -1;
    protected int lon2Index = -1;
    protected int geoStyleIndex = -1;
    protected int dashIndex = -1;
    protected int colorIndex = -1;
    protected int thicknessIndex = -1;

    public void setProperties(String prefix, Properties properties) {
        super.setProperties(prefix, properties);
        String realPrefix = PropUtils.getScopedPropertyPrefix(this);
        this.lat1Index = PropUtils.intFromProperties(properties, realPrefix + Lat1IndexProperty, this.lat1Index);
        this.lon1Index = PropUtils.intFromProperties(properties, realPrefix + Lon1IndexProperty, this.lon1Index);
        this.lat2Index = PropUtils.intFromProperties(properties, realPrefix + Lat2IndexProperty, this.lat2Index);
        this.lon2Index = PropUtils.intFromProperties(properties, realPrefix + Lon2IndexProperty, this.lon2Index);
        this.geoStyleIndex = PropUtils.intFromProperties(properties, realPrefix + GeoStyleIndexProperty, this.geoStyleIndex);
        this.colorIndex = PropUtils.intFromProperties(properties, realPrefix + ColorIndexProperty, this.colorIndex);
        this.dashIndex = PropUtils.intFromProperties(properties, realPrefix + DashIndexProperty, this.dashIndex);
        this.thicknessIndex = PropUtils.intFromProperties(properties, realPrefix + ThicknessIndexProperty, this.thicknessIndex);
    }

    public Properties getProperties(Properties props) {
        props = super.getProperties(props);
        String prefix = PropUtils.getScopedPropertyPrefix(this);
        props.put(prefix + "class", this.getClass().getName());
        props.put(prefix + "locationFile", PropUtils.unnull(this.locationFile));
        props.put(prefix + "csvFileHasHeader", new Boolean(this.csvHasHeader).toString());
        props.put(prefix + Lat1IndexProperty, Integer.toString(this.lat1Index));
        props.put(prefix + Lon1IndexProperty, Integer.toString(this.lon1Index));
        props.put(prefix + Lat2IndexProperty, Integer.toString(this.lat2Index));
        props.put(prefix + Lon2IndexProperty, Integer.toString(this.lon2Index));
        props.put(prefix + DashIndexProperty, Integer.toString(this.dashIndex));
        props.put(prefix + ColorIndexProperty, Integer.toString(this.colorIndex));
        props.put(prefix + ThicknessIndexProperty, Integer.toString(this.thicknessIndex));
        props.put(prefix + GeoStyleIndexProperty, Integer.toString(this.geoStyleIndex));
        return props;
    }

    public Properties getPropertyInfo(Properties list) {
        list = super.getPropertyInfo(list);
        list.remove("latIndex");
        list.remove("lonIndex");
        list.put(Lat1IndexProperty, "The column index, in the location file, of the first node latitude.");
        list.put(Lon1IndexProperty, "The column index, in the location file, of the first node longitude.");
        list.put(Lat2IndexProperty, "The column index, in the location file, of the second node latitude.");
        list.put(Lon2IndexProperty, "The column index, in the location file, of the second node longitude.");
        list.put(DashIndexProperty, "The column index, in the location file, of the true/false dash indicator.");
        list.put(ColorIndexProperty, "The column index, in the location file, of the color string.");
        list.put(ThicknessIndexProperty, "The column index, in the location file, of the pixel thickness of the link.");
        list.put(GeoStyleIndexProperty, "The column index, in the location file, of the render type of the link.");
        return list;
    }

    protected boolean checkIndexSettings() {
        if (this.lat1Index == -1 || this.lon1Index == -1 || this.lat2Index == -1 || this.lon2Index == -1) {
            Debug.error("CSVLocationHandler: createData(): Index properties for Lat/Lon/Name are not set properly! lat index:" + this.latIndex + ", lon index:" + this.lonIndex);
            return false;
        }
        if (Debug.debugging("csvlocation")) {
            Debug.output("CSVLinkHandler: Reading File:" + this.locationFile + " lat1Index: " + this.lat1Index + " lon1Index: " + this.lon1Index + " lat2Index: " + this.lat2Index + " lon2Index: " + this.lon2Index + " geoStyleIndex: " + this.geoStyleIndex + " dashIndex: " + this.dashIndex + " colorIndex: " + this.colorIndex + " thicknessIndex: " + this.thicknessIndex);
        }
        return true;
    }

    protected CSVLocationHandler.TokenDecoder getTokenDecoder() {
        return new LinkDecoder();
    }

    public Component getGUI() {
        JCheckBox showCSVLinkCheck = new JCheckBox("Show Links", this.isShowLocations());
        showCSVLinkCheck.setActionCommand("showLocations");
        showCSVLinkCheck.addActionListener(this);
        JButton rereadFilesButton = new JButton("Re-Read Data File");
        rereadFilesButton.setActionCommand("readData");
        rereadFilesButton.addActionListener(this);
        Box box = Box.createVerticalBox();
        box.add(showCSVLinkCheck);
        box.add(rereadFilesButton);
        return box;
    }

    protected int getLineTypeFromToken(Object token) {
        int default_lintetype = 1;
        String tokstring = ((String)token).trim().toLowerCase();
        if (Debug.debugging("csvlocation")) {
            Debug.output("CSVLinkHandler:getLineTypeFromToken(" + tokstring + ")");
        }
        if (tokstring.startsWith("s")) {
            return 1;
        }
        if (tokstring.startsWith("g")) {
            return 3;
        }
        if (tokstring.startsWith("r")) {
            return 2;
        }
        Debug.error("Don't understand Linetype " + tokstring + ", using default (STRAIGHT)");
        return default_lintetype;
    }

    protected Color getColorFromToken(Object token) {
        Color c;
        String tokstring = (String)token;
        if (Debug.debugging("csvlocation")) {
            Debug.output("CSVLinkHandler: getColorFromToken(" + tokstring + ")");
        }
        if ((c = ColorFactory.getNamedColor(tokstring, null)) == null && (c = Color.decode(tokstring)) == null) {
            c = Color.BLACK;
        }
        if (Debug.debugging("csvlocation")) {
            Debug.output("CSVLinkHandler: getColorFromToken returns (" + c + ")");
        }
        return c;
    }

    public class LinkDecoder
    implements CSVLocationHandler.TokenDecoder {
        float lat1;
        float lon1;
        float lat2;
        float lon2;
        int linetype;
        Color color;
        boolean dashed;
        float thickness;

        public LinkDecoder() {
            this.reset();
        }

        public void reset() {
            this.lat1 = 0.0f;
            this.lon1 = 0.0f;
            this.lat2 = 0.0f;
            this.lon2 = 0.0f;
            this.linetype = 3;
            this.color = (Color)CSVLinkHandler.this.getLocationDrawingAttributes().getLinePaint();
            this.dashed = false;
            this.thickness = 1.0f;
        }

        public void handleToken(Object token, int i) {
            try {
                if (i == CSVLinkHandler.this.lat1Index) {
                    this.lat1 = ((Double)token).floatValue();
                } else if (i == CSVLinkHandler.this.lon1Index) {
                    this.lon1 = ((Double)token).floatValue();
                } else if (i == CSVLinkHandler.this.lat2Index) {
                    this.lat2 = ((Double)token).floatValue();
                } else if (i == CSVLinkHandler.this.lon2Index) {
                    this.lon2 = ((Double)token).floatValue();
                } else if (i == CSVLinkHandler.this.geoStyleIndex) {
                    this.linetype = CSVLinkHandler.this.getLineTypeFromToken(token);
                } else if (i == CSVLinkHandler.this.colorIndex) {
                    this.color = CSVLinkHandler.this.getColorFromToken(token);
                } else if (i == CSVLinkHandler.this.thicknessIndex) {
                    this.thickness = ((Double)token).floatValue();
                } else if (i == CSVLinkHandler.this.dashIndex) {
                    this.dashed = Boolean.valueOf((String)token);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }

        public void createAndAddObjectFromTokens(DataOrganizer organizer) {
            Link link = new Link(this.lat1, this.lon1, this.lat2, this.lon2, "No details", this.color, this.dashed, this.thickness, this.linetype);
            link.setLocationHandler(CSVLinkHandler.this);
            Debug.message("csvlocation", "CSVLinkHandler: " + link.getDetails());
            organizer.put(this.lat1, this.lon1, link);
            organizer.put(this.lat2, this.lon2, link);
            this.reset();
        }
    }
}

