/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.link;

import com.bbn.openmap.Layer;
import com.bbn.openmap.layer.link.GraphicUpdate;
import com.bbn.openmap.layer.link.Link;
import com.bbn.openmap.layer.link.LinkActionConstants;
import com.bbn.openmap.layer.link.LinkArc;
import com.bbn.openmap.layer.link.LinkBitmap;
import com.bbn.openmap.layer.link.LinkCircle;
import com.bbn.openmap.layer.link.LinkEllipse;
import com.bbn.openmap.layer.link.LinkGrid;
import com.bbn.openmap.layer.link.LinkLine;
import com.bbn.openmap.layer.link.LinkPoint;
import com.bbn.openmap.layer.link.LinkPoly;
import com.bbn.openmap.layer.link.LinkProperties;
import com.bbn.openmap.layer.link.LinkPropertiesConstants;
import com.bbn.openmap.layer.link.LinkRaster;
import com.bbn.openmap.layer.link.LinkRectangle;
import com.bbn.openmap.layer.link.LinkText;
import com.bbn.openmap.layer.link.LinkUtil;
import com.bbn.openmap.omGraphics.OMGraphic;
import com.bbn.openmap.omGraphics.OMGrid;
import com.bbn.openmap.omGraphics.grid.OMGridGenerator;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.util.Debug;
import java.awt.Color;
import java.awt.Image;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.util.Vector;
import javax.swing.ImageIcon;

public class LinkActionList
implements LinkActionConstants,
LinkPropertiesConstants {
    protected Link link = null;
    protected String linkStatus = "\r";
    protected boolean reacted = false;
    protected boolean mapUpdate = false;
    protected LinkProperties mapProperties;
    protected static Vector emptyGraphicUpdates = new Vector();
    protected Vector updates = null;
    protected static float version = 0.6f;
    protected LinkProperties properties;

    public LinkActionList(Link link, LinkProperties properties) throws IOException {
        this.link = link;
        link.start("<A>");
        link.dos.writeFloat(version);
        properties.write(link);
    }

    public LinkActionList(Link link, Layer layer, Projection proj, OMGridGenerator generator) throws IOException, EOFException {
        this.link = link;
        this.linkStatus = this.readGestureResponses(layer, proj, generator);
    }

    public String getLinkStatus() {
        return this.linkStatus;
    }

    public LinkProperties getProperties() {
        return this.properties;
    }

    public LinkProperties getMapProperties() {
        return this.mapProperties;
    }

    public Vector getGraphicUpdates() {
        if (this.updates == null) {
            return emptyGraphicUpdates;
        }
        return this.updates;
    }

    public void end(String endType) throws IOException {
        this.link.end(endType);
    }

    protected String readGestureResponses(Layer layer, Projection proj, OMGridGenerator generator) throws IOException, EOFException {
        long startTime = System.currentTimeMillis();
        String header = null;
        float ver = this.link.dis.readFloat();
        if (ver != version) {
            if ((double)ver == 0.1) {
                throw new IOException("LinkActionList: Versions do not match! DANGER!");
            }
            Debug.message("link", "LinkActionList: Versions do not match");
        }
        if (this.properties != null) {
            this.properties.clear();
        }
        this.properties = LinkProperties.read(this.link.dis, this.properties);
        LinkProperties graphicProperties = new LinkProperties();
        Debug.message("link", "LinkActionList: reading actions:");
        block5: while (true) {
            if ((header = this.link.readDelimiter(false)) == "\r" || header == "\n") {
                long endTime = System.currentTimeMillis();
                if (Debug.debugging("link")) {
                    Debug.output("LinkActionList: received in " + (float)(endTime - startTime) / 1000.0f + " seconds");
                }
                return header;
            }
            byte gestureType = this.link.dis.readByte();
            switch (gestureType) {
                case 0: {
                    int graphicAction = this.link.dis.readInt();
                    if (this.updates == null) {
                        this.updates = new Vector();
                    }
                    if (LinkUtil.isMask(graphicAction, 64) || LinkUtil.isMask(graphicAction, 128)) {
                        this.updates.addElement(this.readGraphic(graphicAction, graphicProperties, proj, generator));
                    } else {
                        graphicProperties = LinkProperties.read(this.link.dis, graphicProperties);
                        this.updates.addElement(new GraphicUpdate(graphicAction, graphicProperties.getProperty("gid")));
                    }
                    this.reacted = true;
                    continue block5;
                }
                case 1: {
                    continue block5;
                }
                case 2: {
                    this.mapUpdate = true;
                    if (this.mapProperties != null) {
                        this.mapProperties.clear();
                    }
                    this.mapProperties = LinkProperties.read(this.link.dis, this.mapProperties);
                    continue block5;
                }
            }
            System.err.println("LinkActionList: received unknown gesture type.");
        }
    }

    protected GraphicUpdate readGraphic(int graphicAction, LinkProperties graphicProperties, Projection proj, OMGridGenerator generator) throws IOException {
        OMGraphic graphic = null;
        String header = this.link.readDelimiter(false);
        if (header == "\r" || header == "\n") {
            return null;
        }
        byte graphicType = this.link.dis.readByte();
        switch (graphicType) {
            case 4: {
                graphic = LinkLine.read(this.link.dis, graphicProperties);
                break;
            }
            case 3: {
                graphic = LinkPoly.read(this.link.dis, graphicProperties);
                break;
            }
            case 5: {
                graphic = LinkRectangle.read(this.link.dis, graphicProperties);
                break;
            }
            case 9: {
                graphic = LinkPoint.read(this.link.dis, graphicProperties);
                break;
            }
            case 6: {
                graphic = LinkCircle.read(this.link.dis, graphicProperties);
                break;
            }
            case 11: {
                graphic = LinkEllipse.read(this.link.dis, graphicProperties);
                break;
            }
            case 7: {
                graphic = LinkRaster.read(this.link.dis, graphicProperties);
                break;
            }
            case 1: {
                graphic = LinkBitmap.read(this.link.dis, graphicProperties);
                break;
            }
            case 2: {
                graphic = LinkText.read(this.link.dis, graphicProperties);
                break;
            }
            case 8: {
                graphic = LinkGrid.read(this.link.dis, graphicProperties);
                break;
            }
            case 10: {
                graphic = LinkArc.read(this.link.dis, graphicProperties);
                break;
            }
            default: {
                System.err.println("LinkActionList: received unknown graphic type.");
            }
        }
        if (graphic != null && proj != null) {
            if (graphic instanceof OMGrid) {
                ((OMGrid)graphic).setGenerator(generator);
            }
            graphic.generate(proj);
        }
        return new GraphicUpdate(graphicAction, graphic);
    }

    public boolean consumedGesture() {
        return this.reacted;
    }

    public boolean getNeedMapUpdate() {
        return this.mapUpdate;
    }

    public void setNeedMapUpdate(boolean value) {
        this.mapUpdate = value;
    }

    public void deselectGraphics() throws IOException {
        this.link.dos.write("<UG>".getBytes());
        this.link.dos.writeByte(0);
        this.link.dos.writeInt(32);
        LinkProperties.EMPTY_PROPERTIES.write(this.link.dos);
    }

    public void modifyGraphic(int maskDescription, LinkProperties props) throws IOException {
        this.link.dos.write("<UG>".getBytes());
        this.link.dos.writeByte(0);
        this.link.dos.writeInt(maskDescription);
        props.write(this.link.dos);
    }

    public void writeGraphicGestureHeader(int graphicUpdateMask) throws IOException {
        this.link.dos.write("<UG>".getBytes());
        this.link.dos.writeByte(0);
        this.link.dos.writeInt(graphicUpdateMask);
    }

    public void updateArc(float latPoint, float lonPoint, int w, int h, float s, float e, LinkProperties properties, int graphicUpdateMask) throws IOException {
        this.writeGraphicGestureHeader(graphicUpdateMask);
        LinkArc.write(latPoint, lonPoint, 0, 0, w, h, s, e, properties, this.link.dos);
    }

    public void updateArc(int x1, int y1, int w, int h, float s, float e, LinkProperties properties, int graphicUpdateMask) throws IOException {
        this.writeGraphicGestureHeader(graphicUpdateMask);
        LinkArc.write(x1, y1, w, h, s, e, properties, (DataOutputStream)this.link.dos);
    }

    public void updateArc(float latPoint, float lonPoint, int offset_x1, int offset_y1, int w, int h, float s, float e, LinkProperties properties, int graphicUpdateMask) throws IOException {
        this.writeGraphicGestureHeader(graphicUpdateMask);
        LinkArc.write(latPoint, lonPoint, offset_x1, offset_y1, w, h, s, e, properties, this.link.dos);
    }

    public void updateArc(float latPoint, float lonPoint, float radius, float s, float e, LinkProperties properties, int graphicUpdateMask) throws IOException {
        this.writeGraphicGestureHeader(graphicUpdateMask);
        LinkArc.write(latPoint, lonPoint, radius, -1, -1, s, e, properties, this.link.dos);
    }

    public void updateArc(float latPoint, float lonPoint, float radius, int units, float s, float e, LinkProperties properties, int graphicUpdateMask) throws IOException {
        this.writeGraphicGestureHeader(graphicUpdateMask);
        LinkArc.write(latPoint, lonPoint, radius, units, -1, s, e, properties, this.link.dos);
    }

    public void updateArc(float latPoint, float lonPoint, float radius, int units, int nverts, float s, float e, LinkProperties properties, int graphicUpdateMask) throws IOException {
        this.writeGraphicGestureHeader(graphicUpdateMask);
        LinkArc.write(latPoint, lonPoint, radius, units, nverts, s, e, properties, this.link.dos);
    }

    public void updateBitmap(float lt, float ln, int w, int h, byte[] bytes, LinkProperties properties, int graphicUpdateMask) throws IOException {
        this.writeGraphicGestureHeader(graphicUpdateMask);
        LinkBitmap.write(lt, ln, w, h, bytes, properties, (DataOutputStream)this.link.dos);
    }

    public void updateBitmap(int x1, int y1, int w, int h, byte[] bytes, LinkProperties properties, int graphicUpdateMask) throws IOException {
        this.writeGraphicGestureHeader(graphicUpdateMask);
        LinkBitmap.write(x1, y1, w, h, bytes, properties, (DataOutputStream)this.link.dos);
    }

    public void updateBitmap(float lt, float ln, int offset_x1, int offset_y1, int w, int h, byte[] bytes, LinkProperties properties, int graphicUpdateMask) throws IOException {
        this.writeGraphicGestureHeader(graphicUpdateMask);
        LinkBitmap.write(lt, ln, offset_x1, offset_y1, w, h, bytes, properties, this.link.dos);
    }

    public void updateCircle(float latPoint, float lonPoint, int w, int h, LinkProperties properties, int graphicUpdateMask) throws IOException {
        this.writeGraphicGestureHeader(graphicUpdateMask);
        LinkCircle.write(latPoint, lonPoint, w, h, properties, (DataOutputStream)this.link.dos);
    }

    public void updateCircle(int x1, int y1, int w, int h, LinkProperties properties, int graphicUpdateMask) throws IOException {
        this.writeGraphicGestureHeader(graphicUpdateMask);
        LinkCircle.write(x1, y1, w, h, properties, (DataOutputStream)this.link.dos);
    }

    public void updateCircle(float latPoint, float lonPoint, int offset_x1, int offset_y1, int w, int h, LinkProperties properties, int graphicUpdateMask) throws IOException {
        this.writeGraphicGestureHeader(graphicUpdateMask);
        LinkCircle.write(latPoint, lonPoint, offset_x1, offset_y1, w, h, properties, this.link.dos);
    }

    public void updateCircle(float latPoint, float lonPoint, float radius, LinkProperties properties, int graphicUpdateMask) throws IOException {
        this.writeGraphicGestureHeader(graphicUpdateMask);
        LinkCircle.write(latPoint, lonPoint, radius, -1, -1, properties, this.link.dos);
    }

    public void updateCircle(float latPoint, float lonPoint, float radius, int units, LinkProperties properties, int graphicUpdateMask) throws IOException {
        this.writeGraphicGestureHeader(graphicUpdateMask);
        LinkCircle.write(latPoint, lonPoint, radius, units, -1, properties, this.link.dos);
    }

    public void updateCircle(float latPoint, float lonPoint, float radius, int units, int nverts, LinkProperties properties, int graphicUpdateMask) throws IOException {
        this.writeGraphicGestureHeader(graphicUpdateMask);
        LinkCircle.write(latPoint, lonPoint, radius, units, nverts, properties, this.link.dos);
    }

    public void updateEllipse(float latPoint, float lonPoint, float majorAxisSpan, float minorAxisSpan, int units, float rotationAngle, LinkProperties properties, int graphicUpdateMask) throws IOException {
        this.writeGraphicGestureHeader(graphicUpdateMask);
        LinkEllipse.write(latPoint, lonPoint, majorAxisSpan, minorAxisSpan, units, rotationAngle, properties, this.link.dos);
    }

    public void updateEllipse(int x1, int y1, int majorAxisSpan, int minorAxisSpan, float rotateAngle, LinkProperties properties, int graphicUpdateMask) throws IOException {
        this.writeGraphicGestureHeader(graphicUpdateMask);
        LinkEllipse.write(x1, y1, majorAxisSpan, minorAxisSpan, rotateAngle, properties, (DataOutputStream)this.link.dos);
    }

    public void updateEllipse(float latPoint, float lonPoint, int w, int h, float rotateAngle, LinkProperties properties, int graphicUpdateMask) throws IOException {
        this.writeGraphicGestureHeader(graphicUpdateMask);
        LinkEllipse.write(latPoint, lonPoint, w, h, rotateAngle, properties, (DataOutputStream)this.link.dos);
    }

    public void updateEllipse(float latPoint, float lonPoint, int offset_x1, int offset_y1, int w, int h, float rotateAngle, LinkProperties properties, int graphicUpdateMask) throws IOException {
        this.writeGraphicGestureHeader(graphicUpdateMask);
        LinkEllipse.write(latPoint, lonPoint, offset_x1, offset_y1, w, h, rotateAngle, properties, this.link.dos);
    }

    public void updateGrid(float lt, float ln, int rows, int columns, float orientation, float vResolution, float hResolution, int major, int[] data, LinkProperties properties, int graphicUpdateMask) throws IOException {
        this.writeGraphicGestureHeader(graphicUpdateMask);
        LinkGrid.write(lt, ln, rows, columns, orientation, vResolution, hResolution, major, data, properties, (DataOutputStream)this.link.dos);
    }

    public void updateGrid(int x1, int y1, int rows, int columns, float orientation, float vResolution, float hResolution, int major, int[] data, LinkProperties properties, int graphicUpdateMask) throws IOException {
        this.writeGraphicGestureHeader(graphicUpdateMask);
        LinkGrid.write(x1, y1, rows, columns, orientation, vResolution, hResolution, major, data, properties, (DataOutputStream)this.link.dos);
    }

    public void updateGrid(float lt, float ln, int offset_x1, int offset_y1, int rows, int columns, float orientation, float vResolution, float hResolution, int major, int[] data, LinkProperties properties, int graphicUpdateMask) throws IOException {
        this.writeGraphicGestureHeader(graphicUpdateMask);
        LinkGrid.write(lt, ln, offset_x1, offset_y1, rows, columns, orientation, vResolution, hResolution, major, data, properties, this.link.dos);
    }

    public void updateLine(float lat_1, float lon_1, float lat_2, float lon_2, int lineType, LinkProperties properties, int graphicUpdateMask) throws IOException {
        this.writeGraphicGestureHeader(graphicUpdateMask);
        LinkLine.write(lat_1, lon_1, lat_2, lon_2, lineType, properties, this.link.dos);
    }

    public void updateLine(float lat_1, float lon_1, float lat_2, float lon_2, int lineType, int nsegs, LinkProperties properties, int graphicUpdateMask) throws IOException {
        this.writeGraphicGestureHeader(graphicUpdateMask);
        LinkLine.write(lat_1, lon_1, lat_2, lon_2, lineType, nsegs, properties, (DataOutputStream)this.link.dos);
    }

    public void updateLine(int x1, int y1, int x2, int y2, LinkProperties properties, int graphicUpdateMask) throws IOException {
        this.writeGraphicGestureHeader(graphicUpdateMask);
        LinkLine.write(x1, y1, x2, y2, properties, this.link.dos);
    }

    public void updateLine(float lat_1, float lon_1, int x1, int y1, int x2, int y2, LinkProperties properties, int graphicUpdateMask) throws IOException {
        this.writeGraphicGestureHeader(graphicUpdateMask);
        LinkLine.write(lat_1, lon_1, x1, y1, x2, y2, properties, (DataOutputStream)this.link.dos);
    }

    public void updateRaster(float lt, float ln, ImageIcon ii, LinkProperties properties, int graphicUpdateMask) throws IOException, InterruptedException {
        this.writeGraphicGestureHeader(graphicUpdateMask);
        LinkRaster.write(lt, ln, ii, properties, (DataOutputStream)this.link.dos);
    }

    public void updateRaster(int x1, int y1, ImageIcon ii, LinkProperties properties, int graphicUpdateMask) throws IOException, InterruptedException {
        this.writeGraphicGestureHeader(graphicUpdateMask);
        LinkRaster.write(x1, y1, ii, properties, (DataOutputStream)this.link.dos);
    }

    public void updateRaster(float lt, float ln, int offset_x1, int offset_y1, ImageIcon ii, LinkProperties properties, int graphicUpdateMask) throws IOException, InterruptedException {
        this.writeGraphicGestureHeader(graphicUpdateMask);
        LinkRaster.write(lt, ln, offset_x1, offset_y1, ii, properties, (DataOutputStream)this.link.dos);
    }

    public void updateRaster(float lt, float ln, Image image, int image_width, int image_height, LinkProperties properties, int graphicUpdateMask) throws IOException, InterruptedException {
        this.writeGraphicGestureHeader(graphicUpdateMask);
        LinkRaster.write(lt, ln, image, image_width, image_height, properties, (DataOutputStream)this.link.dos);
    }

    public void updateRaster(int x1, int y1, Image image, int image_width, int image_height, LinkProperties properties, int graphicUpdateMask) throws IOException, InterruptedException {
        this.writeGraphicGestureHeader(graphicUpdateMask);
        LinkRaster.write(x1, y1, image, image_width, image_height, properties, (DataOutputStream)this.link.dos);
    }

    public void updateRaster(float lt, float ln, int offset_x1, int offset_y1, Image image, int image_width, int image_height, LinkProperties properties, int graphicUpdateMask) throws IOException, InterruptedException {
        this.writeGraphicGestureHeader(graphicUpdateMask);
        LinkRaster.write(lt, ln, offset_x1, offset_y1, image, image_width, image_height, properties, (DataOutputStream)this.link.dos);
    }

    public void updateRaster(float lt, float ln, int w, int h, int[] pix, LinkProperties properties, int graphicUpdateMask) throws IOException {
        this.writeGraphicGestureHeader(graphicUpdateMask);
        LinkRaster.write(lt, ln, w, h, pix, properties, (DataOutputStream)this.link.dos);
    }

    public void updateRaster(int x1, int y1, int w, int h, int[] pix, LinkProperties properties, int graphicUpdateMask) throws IOException {
        this.writeGraphicGestureHeader(graphicUpdateMask);
        LinkRaster.write(x1, y1, w, h, pix, properties, (DataOutputStream)this.link.dos);
    }

    public void updateRaster(float lt, float ln, int offset_x1, int offset_y1, int w, int h, int[] pix, LinkProperties properties, int graphicUpdateMask) throws IOException {
        this.writeGraphicGestureHeader(graphicUpdateMask);
        LinkRaster.write(lt, ln, offset_x1, offset_y1, w, h, pix, properties, (DataOutputStream)this.link.dos);
    }

    public void updateRaster(float lt, float ln, String url, LinkProperties properties, int graphicUpdateMask) throws IOException {
        this.writeGraphicGestureHeader(graphicUpdateMask);
        LinkRaster.write(lt, ln, url, properties, (DataOutputStream)this.link.dos);
    }

    public void updateRaster(int x1, int y1, String url, LinkProperties properties, int graphicUpdateMask) throws IOException {
        this.writeGraphicGestureHeader(graphicUpdateMask);
        LinkRaster.write(x1, y1, url, properties, (DataOutputStream)this.link.dos);
    }

    public void updateRaster(float lt, float ln, int offset_x1, int offset_y1, String url, LinkProperties properties, int graphicUpdateMask) throws IOException {
        this.writeGraphicGestureHeader(graphicUpdateMask);
        LinkRaster.write(lt, ln, offset_x1, offset_y1, url, properties, (DataOutputStream)this.link.dos);
    }

    public void updateRaster(float lt, float ln, int w, int h, byte[] bytes, Color[] colorTable, int trans, LinkProperties properties, int graphicUpdateMask) throws IOException {
        this.writeGraphicGestureHeader(graphicUpdateMask);
        LinkRaster.write(lt, ln, w, h, bytes, colorTable, trans, properties, (DataOutputStream)this.link.dos);
    }

    public void updateRaster(int x1, int y1, int w, int h, byte[] bytes, Color[] colorTable, int trans, LinkProperties properties, int graphicUpdateMask) throws IOException {
        this.writeGraphicGestureHeader(graphicUpdateMask);
        LinkRaster.write(x1, y1, w, h, bytes, colorTable, trans, properties, (DataOutputStream)this.link.dos);
    }

    public void updateRaster(float lt, float ln, int offset_x1, int offset_y1, int w, int h, byte[] bytes, Color[] colorTable, int trans, LinkProperties properties, int graphicUpdateMask) throws IOException {
        this.writeGraphicGestureHeader(graphicUpdateMask);
        LinkRaster.write(lt, ln, offset_x1, offset_y1, w, h, bytes, colorTable, trans, properties, this.link.dos);
    }

    public void updateRectangle(float lt1, float ln1, float lt2, float ln2, int lType, LinkProperties properties, int graphicUpdateMask) throws IOException {
        this.writeGraphicGestureHeader(graphicUpdateMask);
        LinkRectangle.write(lt1, ln1, lt2, ln2, lType, properties, this.link.dos);
    }

    public void updateRectangle(float lt1, float ln1, float lt2, float ln2, int lType, int nsegs, LinkProperties properties, int graphicUpdateMask) throws IOException {
        this.writeGraphicGestureHeader(graphicUpdateMask);
        LinkRectangle.write(lt1, ln1, lt2, ln2, lType, nsegs, properties, (DataOutputStream)this.link.dos);
    }

    public void updateRectangle(int x1, int y1, int x2, int y2, LinkProperties properties, int graphicUpdateMask) throws IOException {
        this.writeGraphicGestureHeader(graphicUpdateMask);
        LinkRectangle.write(x1, y1, x2, y2, properties, this.link.dos);
    }

    public void updateRectangle(float lt1, float ln1, int x1, int y1, int x2, int y2, LinkProperties properties, int graphicUpdateMask) throws IOException {
        this.writeGraphicGestureHeader(graphicUpdateMask);
        LinkRectangle.write(lt1, ln1, x1, y1, x2, y2, properties, (DataOutputStream)this.link.dos);
    }

    public void updatePoint(float lt1, float ln1, int radius, LinkProperties properties, int graphicUpdateMask) throws IOException {
        this.writeGraphicGestureHeader(graphicUpdateMask);
        LinkPoint.write(lt1, ln1, radius, properties, (DataOutputStream)this.link.dos);
    }

    public void updatePoint(int x1, int y1, int radius, LinkProperties properties, int graphicUpdateMask) throws IOException {
        this.writeGraphicGestureHeader(graphicUpdateMask);
        LinkPoint.write(x1, y1, radius, properties, (DataOutputStream)this.link.dos);
    }

    public void updatePoint(float lt1, float ln1, int x1, int y1, int radius, LinkProperties properties, int graphicUpdateMask) throws IOException {
        this.writeGraphicGestureHeader(graphicUpdateMask);
        LinkPoint.write(lt1, ln1, x1, y1, radius, properties, this.link.dos);
    }

    public void updatePoly(float[] llPoints, int units, int lType, LinkProperties properties, int graphicUpdateMask) throws IOException {
        this.writeGraphicGestureHeader(graphicUpdateMask);
        LinkPoly.write(llPoints, units, lType, properties, this.link.dos);
    }

    public void updatePoly(float[] llpoints, int units, int lType, int nsegs, LinkProperties properties, int graphicUpdateMask) throws IOException {
        this.writeGraphicGestureHeader(graphicUpdateMask);
        LinkPoly.write(llpoints, units, lType, nsegs, properties, (DataOutputStream)this.link.dos);
    }

    public void updatePoly(int[] xypoints, LinkProperties properties, int graphicUpdateMask) throws IOException {
        this.writeGraphicGestureHeader(graphicUpdateMask);
        LinkPoly.write(xypoints, properties, this.link.dos);
    }

    public void updatePoly(int[] xpoints, int[] ypoints, LinkProperties properties, int graphicUpdateMask) throws IOException {
        this.writeGraphicGestureHeader(graphicUpdateMask);
        LinkPoly.write(xpoints, ypoints, properties, this.link.dos);
    }

    public void updatePoly(float latPoint, float lonPoint, int[] xypoints, int cMode, LinkProperties properties, int graphicUpdateMask) throws IOException {
        this.writeGraphicGestureHeader(graphicUpdateMask);
        LinkPoly.write(latPoint, lonPoint, xypoints, cMode, properties, (DataOutputStream)this.link.dos);
    }

    public void updatePoly(float latPoint, float lonPoint, int[] xpoints, int[] ypoints, int cMode, LinkProperties properties, int graphicUpdateMask) throws IOException {
        this.writeGraphicGestureHeader(graphicUpdateMask);
        LinkPoly.write(latPoint, lonPoint, xpoints, ypoints, cMode, properties, (DataOutputStream)this.link.dos);
    }

    public void updateText(float latPoint, float lonPoint, String stuff, int justify, LinkProperties properties, int graphicUpdateMask) throws IOException {
        this.writeGraphicGestureHeader(graphicUpdateMask);
        LinkText.write(latPoint, lonPoint, stuff, LinkText.DEFAULT_FONT, justify, properties, (DataOutputStream)this.link.dos);
    }

    public void updateText(int x, int y, String stuff, int justify, LinkProperties properties, int graphicUpdateMask) throws IOException {
        this.writeGraphicGestureHeader(graphicUpdateMask);
        LinkText.write(x, y, stuff, LinkText.DEFAULT_FONT, justify, properties, (DataOutputStream)this.link.dos);
    }

    public void updateText(float latPoint, float lonPoint, int offset_x, int offset_y, String stuff, int justify, LinkProperties properties, int graphicUpdateMask) throws IOException {
        this.writeGraphicGestureHeader(graphicUpdateMask);
        LinkText.write(latPoint, lonPoint, offset_x, offset_y, stuff, LinkText.DEFAULT_FONT, justify, properties, this.link.dos);
    }

    public void updateText(float latPoint, float lonPoint, String stuff, String font, int justify, LinkProperties properties, int graphicUpdateMask) throws IOException {
        this.writeGraphicGestureHeader(graphicUpdateMask);
        LinkText.write(latPoint, lonPoint, stuff, font, justify, properties, (DataOutputStream)this.link.dos);
    }

    public void updateText(int x, int y, String stuff, String font, int justify, LinkProperties properties, int graphicUpdateMask) throws IOException {
        this.writeGraphicGestureHeader(graphicUpdateMask);
        LinkText.write(x, y, stuff, font, justify, properties, (DataOutputStream)this.link.dos);
    }

    public void updateText(float latPoint, float lonPoint, int offset_x, int offset_y, String stuff, String font, int justify, LinkProperties properties, int graphicUpdateMask) throws IOException {
        this.writeGraphicGestureHeader(graphicUpdateMask);
        LinkText.write(latPoint, lonPoint, offset_x, offset_y, stuff, font, justify, properties, this.link.dos);
    }

    public void updateGraphic(OMGraphic omGraphic, int graphicUpdateMask) throws IOException {
    }
}

