/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.imageTile;

import com.bbn.openmap.Environment;
import com.bbn.openmap.LatLonPoint;
import com.bbn.openmap.MapBean;
import com.bbn.openmap.MapHandler;
import com.bbn.openmap.dataAccess.image.ErrImageTile;
import com.bbn.openmap.dataAccess.image.ImageReader;
import com.bbn.openmap.dataAccess.image.ImageReaderLoader;
import com.bbn.openmap.dataAccess.image.ImageTile;
import com.bbn.openmap.gui.LayerControlButtonPanel;
import com.bbn.openmap.layer.OMGraphicHandlerLayer;
import com.bbn.openmap.omGraphics.DrawingAttributes;
import com.bbn.openmap.omGraphics.OMColor;
import com.bbn.openmap.omGraphics.OMGraphic;
import com.bbn.openmap.omGraphics.OMGraphicList;
import com.bbn.openmap.proj.Proj;
import com.bbn.openmap.proj.ProjMath;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.tools.icon.BasicIconPart;
import com.bbn.openmap.tools.icon.IconPartList;
import com.bbn.openmap.tools.icon.OMIconFactory;
import com.bbn.openmap.util.ComponentFactory;
import com.bbn.openmap.util.PropUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;

public class ImageTileLayer
extends OMGraphicHandlerLayer {
    public static Logger logger = Logger.getLogger("com.bbn.openmap.layer.imageTile.ImageTileLayer");
    public static final String ImageFilePathProperty = "imageFilePath";
    public static final String ImageReaderLoadersProperty = "imageReaderLoaders";
    public static final String ImageCacheSizeProperty = "imageCacheSize";
    public static final String ImageCutoffRatioProperty = "imageCutoffRatio";
    protected String SHOW_TILES_TITLE;
    protected String HIDE_TILES_TITLE;
    protected Vector filePaths;
    protected Vector imageReaderLoaders;
    protected ImageTile.Cache imageCache;
    protected DrawingAttributes selectedDrawingAttributes = DrawingAttributes.getDefaultClone();
    public static final String NAME_ATTRIBUTE = "NAME";
    public static final String FILE_PATH_ATTRIBUTE = "FILE_PATH";
    protected JPanel itPanel;
    protected JList resultsList;
    protected DefaultListModel listModel;
    protected ListManager listManager;
    JButton showHideButton;
    JButton gotoButton;
    JToggleButton locateButton;
    ImageControlButtonPanel icbp;
    protected MapBean mapBean;
    protected ImageTile[] selectedTiles;
    public static int buttonSize = 16;
    public static ImageIcon warningImage;
    public static ImageIcon invisibleImage;

    public ImageTileLayer() {
        this.configureImageReaderLoaders();
        this.imageCache = new ImageTile.Cache();
        this.SHOW_TILES_TITLE = this.i18n.get(ImageTileLayer.class, "showTilesButton", "Show");
        this.HIDE_TILES_TITLE = this.i18n.get(ImageTileLayer.class, "hideTilesButton", "Hide");
    }

    public void setProperties(String prefix, Properties props) {
        super.setProperties(prefix, props);
        this.selectedDrawingAttributes.setProperties(prefix, props);
        prefix = PropUtils.getScopedPropertyPrefix(prefix);
        this.filePaths = PropUtils.parseMarkers(props.getProperty(prefix + ImageFilePathProperty), ";");
        this.imageCache.resetCache(PropUtils.intFromProperties(props, prefix + ImageCacheSizeProperty, this.imageCache.getCacheSize()));
        this.imageCache.setCutoffScaleRatio(PropUtils.floatFromProperties(props, prefix + ImageCutoffRatioProperty, this.imageCache.getCutoffScaleRatio()));
        String imageReaderLoaderString = props.getProperty(prefix + ImageReaderLoadersProperty);
        if (this.imageReaderLoaders == null) {
            this.imageReaderLoaders = new Vector();
        }
        if (imageReaderLoaderString != null) {
            this.imageReaderLoaders.clear();
            Vector idls = PropUtils.parseSpacedMarkers(imageReaderLoaderString);
            Iterator it = idls.iterator();
            while (it.hasNext()) {
                String idlMarkerName = (String)it.next();
                String idlClassName = props.getProperty(prefix + idlMarkerName);
                Object obj = ComponentFactory.create(idlClassName);
                if (obj == null || !(obj instanceof ImageReaderLoader)) continue;
                this.imageReaderLoaders.add((ImageReaderLoader)obj);
            }
        }
    }

    protected void configureImageReaderLoaders() {
        this.imageReaderLoaders = new Vector();
        ImageReaderLoader idl = (ImageReaderLoader)ComponentFactory.create("com.bbn.openmap.dataAccess.image.geotiff.GeoTIFFImageReaderLoader");
        if (idl != null) {
            this.imageReaderLoaders.add(idl);
        } else {
            logger.warning("ImageTileLayer needs JAI installed in order to use GeoTIFF Image Reader.");
        }
        idl = (ImageReaderLoader)ComponentFactory.create("com.bbn.openmap.dataAccess.image.WorldFileImageReaderLoader");
        if (idl != null) {
            this.imageReaderLoaders.add(idl);
        } else {
            logger.warning("ImageTileLayer needs JAI installed in order to use World File Image Reader.");
        }
    }

    public Properties getProperties(Properties props) {
        props = super.getProperties(props);
        this.selectedDrawingAttributes.getProperties(props);
        String prefix = PropUtils.getScopedPropertyPrefix(this);
        OMGraphicList list = this.getList();
        if (list != null) {
            StringBuffer buf = null;
            Iterator it = list.iterator();
            while (it.hasNext()) {
                ImageTile imageTile;
                String filePath;
                if (buf == null) {
                    buf = new StringBuffer();
                } else {
                    buf.append(";");
                }
                if ((filePath = (String)(imageTile = (ImageTile)it.next()).getAttribute(FILE_PATH_ATTRIBUTE)) == null) continue;
                buf.append(filePath);
            }
            props.put(prefix + ImageFilePathProperty, buf.toString());
        }
        if (this.imageReaderLoaders != null) {
            int count = 0;
            StringBuffer sbuf = null;
            Iterator it = this.imageReaderLoaders.iterator();
            while (it.hasNext()) {
                ImageReaderLoader idl = (ImageReaderLoader)it.next();
                props.put(prefix + "idl" + count, idl.getClass().getName());
                if (sbuf == null) {
                    sbuf = new StringBuffer("idl" + count);
                } else {
                    sbuf.append(" idl" + count);
                }
                ++count;
            }
            if (sbuf != null) {
                props.put(prefix + ImageReaderLoadersProperty, sbuf.toString());
            }
        }
        props.put(prefix + ImageCacheSizeProperty, Integer.toString(this.imageCache.getCacheSize()));
        props.put(prefix + ImageCutoffRatioProperty, Float.toString(this.imageCache.getCutoffScaleRatio()));
        return props;
    }

    public Properties getPropertyInfo(Properties props) {
        props = super.getPropertyInfo(props);
        this.selectedDrawingAttributes.getPropertyInfo(props);
        PropUtils.setI18NPropertyInfo(this.i18n, props, ImageTileLayer.class, ImageFilePathProperty, "Images", "A list of images or directories to display (separated by ;).", "com.bbn.openmap.util.propertyEditor.MultiDirFilePropertyEditor");
        PropUtils.setI18NPropertyInfo(this.i18n, props, ImageTileLayer.class, ImageCacheSizeProperty, "Cache Size", "Number of images to keep in cache.", null);
        PropUtils.setI18NPropertyInfo(this.i18n, props, ImageTileLayer.class, ImageCutoffRatioProperty, "Cutoff Scale", "Projection scale where larger values won't cause images to be loaded and displayed.", null);
        String dummyMarker = PropUtils.getDummyMarkerForPropertyInfo(this.getPropertyPrefix(), null);
        PropUtils.setI18NPropertyInfo(this.i18n, props, ImageTileLayer.class, dummyMarker, "Highlight Settings", "Settings for annototations on highlighted images.", "com.bbn.openmap.omGraphics.DrawingAttributesPropertyEditor");
        props.put("initProperties", "imageFilePath imageCacheSize imageCutoffRatio " + dummyMarker);
        return props;
    }

    public synchronized OMGraphicList prepare() {
        OMGraphicList list = this.getList();
        if (list == null) {
            list = new OMGraphicList();
            this.setList(list);
            Thread loadThread = new Thread(){

                public void run() {
                    ImageTileLayer.this.loadImages();
                    ImageTileLayer.this.fireStatusUpdate(8359);
                }
            };
            loadThread.start();
        } else {
            list.generate(this.getProjection());
        }
        return list;
    }

    protected OMGraphicList loadImages() {
        this.clearImageTileList();
        OMGraphicList ret = this.getList();
        if (ret == null) {
            ret = new OMGraphicList();
            this.setList(ret);
        } else {
            ret.clear();
        }
        if (this.filePaths != null) {
            Iterator it = this.filePaths.iterator();
            while (it.hasNext()) {
                this.loadImage((String)it.next(), ret);
            }
        }
        return ret;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void loadImage(String filePath, OMGraphicList ret) {
        File file = new File(filePath);
        if (file.exists() && file.isDirectory()) {
            String[] files = file.list();
            for (int i = 0; i < files.length; ++i) {
                this.loadImage(filePath + "/" + files[i], ret);
            }
            return;
        } else {
            this.fireStatusUpdate(8342);
            try {
                URL fileURL = PropUtils.getResourceOrFileOrURL(filePath);
                if (fileURL != null) {
                    if (this.imageReaderLoaders != null) {
                        ImageTile imageTile = null;
                        Iterator it = this.imageReaderLoaders.iterator();
                        while (it.hasNext()) {
                            ImageReaderLoader idl = (ImageReaderLoader)it.next();
                            if (!idl.isLoadable(filePath)) continue;
                            ImageReader id = idl.getImageReader(fileURL);
                            ImageTile tmpImageTile = id.getImageTile(this.imageCache);
                            if (imageTile == null) {
                                imageTile = tmpImageTile;
                            } else if (tmpImageTile != null && imageTile instanceof ErrImageTile) {
                                imageTile = tmpImageTile;
                            }
                            if (imageTile == null || imageTile instanceof ErrImageTile) continue;
                            break;
                        }
                        if (imageTile == null) return;
                        this.addImageToLists(imageTile, ret, fileURL);
                        return;
                    }
                    logger.warning("ImageReaders not configured in " + this.getName() + " ImageTileLayer.");
                    return;
                }
                logger.warning("Can't get URL from " + filePath);
                return;
            }
            catch (MalformedURLException murle) {
                // empty catch block
            }
        }
    }

    protected void addImageToLists(ImageTile imageTile, OMGraphicList ret, URL fileURL) {
        imageTile.generate(this.getProjection());
        ret.add(imageTile);
        this.addImageTileToList(imageTile);
        imageTile.putAttribute(FILE_PATH_ATTRIBUTE, fileURL.getPath());
        imageTile.putAttribute(NAME_ATTRIBUTE, fileURL.getFile());
        this.selectedDrawingAttributes.setTo(imageTile);
        this.repaint();
        if (this.resultsList != null) {
            this.resultsList.repaint();
        }
    }

    public Component getGUI() {
        if (this.itPanel == null) {
            this.itPanel = new JPanel();
            GridBagConstraints c = new GridBagConstraints();
            GridBagLayout gridbag = new GridBagLayout();
            this.itPanel.setLayout(gridbag);
            this.icbp = new ImageControlButtonPanel();
            gridbag.setConstraints(this.icbp, c);
            this.itPanel.add(this.icbp);
            this.resultsList = new JList(this.getListModel());
            this.resultsList.setSelectionMode(2);
            this.listManager = new ListManager();
            this.resultsList.addListSelectionListener(this.listManager);
            this.resultsList.addMouseListener(this.listManager);
            this.resultsList.addMouseMotionListener(this.listManager);
            this.resultsList.setCellRenderer(new ImageListCellRenderer());
            JScrollPane listScrollPane = new JScrollPane(this.resultsList);
            listScrollPane.setHorizontalScrollBarPolicy(30);
            listScrollPane.setVerticalScrollBarPolicy(20);
            c.fill = 1;
            c.weightx = 1.0;
            c.weighty = 1.0;
            c.insets = new Insets(5, 5, 5, 5);
            c.gridwidth = 0;
            gridbag.setConstraints(listScrollPane, c);
            this.itPanel.add(listScrollPane);
            JPanel buttonPanel = new JPanel();
            GridBagLayout bGridbag = new GridBagLayout();
            GridBagConstraints bc = new GridBagConstraints();
            this.showHideButton = new JButton(this.HIDE_TILES_TITLE);
            this.showHideButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ae) {
                    ImageTileLayer.this.showHideTiles(((JButton)ae.getSource()).getText(), ImageTileLayer.this.getSelectedTiles());
                }
            });
            bGridbag.setConstraints(this.showHideButton, bc);
            buttonPanel.add(this.showHideButton);
            this.gotoButton = new JButton(this.i18n.get(ImageTileLayer.class, "gotoButton", "Go To"));
            this.gotoButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ae) {
                    ImageTileLayer.this.goTo(ImageTileLayer.this.getSelectedTiles());
                }
            });
            bGridbag.setConstraints(this.gotoButton, bc);
            buttonPanel.add(this.gotoButton);
            this.locateButton = new JToggleButton(this.i18n.get(ImageTileLayer.class, "locateButton", "Highlight"));
            this.locateButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ae) {
                    JToggleButton jtb = (JToggleButton)ae.getSource();
                    ImageTileLayer.this.setSelection(ImageTileLayer.this.getSelectedTiles(), jtb.isSelected());
                }
            });
            bGridbag.setConstraints(this.locateButton, bc);
            buttonPanel.add(this.locateButton);
            c.fill = 2;
            c.weightx = 1.0;
            c.weighty = 0.0;
            c.insets = new Insets(0, 5, 5, 5);
            gridbag.setConstraints(buttonPanel, c);
            this.itPanel.add(buttonPanel);
            this.setGUIButtonEnableState(false);
        }
        return this.itPanel;
    }

    protected void setVisibilityOnAllTiles(boolean visible) {
        OMGraphicList list = this.getList();
        if (list != null) {
            Iterator it = list.iterator();
            while (it.hasNext()) {
                ((OMGraphic)it.next()).setVisible(visible);
            }
            this.repaint();
        }
    }

    protected void showHideTiles(String text, ImageTile[] selectedTiles2) {
        boolean isVisible = text == this.SHOW_TILES_TITLE;
        for (int i = 0; i < selectedTiles2.length; ++i) {
            selectedTiles2[i].setVisible(isVisible);
        }
        this.checkShowHideStatus();
        this.repaint();
        if (this.resultsList != null) {
            this.resultsList.repaint();
        }
    }

    protected void moveOneSlotToBottom(ImageTile[] selectedTiles2) {
        OMGraphicList list = this.getList();
        if (list != null && this.selectedTiles != null && this.selectedTiles.length > 0) {
            for (int i = selectedTiles2.length - 1; i >= 0; --i) {
                ImageTile tile = selectedTiles2[i];
                list.moveIndexedOneToBottom(list.indexOf(tile));
            }
            this.rebuildListModel();
        }
    }

    protected void moveToBottom(ImageTile[] selectedTiles2) {
        OMGraphicList list = this.getList();
        if (list != null && this.selectedTiles != null && this.selectedTiles.length > 0) {
            for (int i = 0; i < selectedTiles2.length; ++i) {
                ImageTile tile = selectedTiles2[i];
                list.moveIndexedToBottom(list.indexOf(tile));
            }
            this.rebuildListModel();
        }
    }

    protected void moveOneSlotToTop(ImageTile[] selectedTiles2) {
        OMGraphicList list = this.getList();
        if (list != null && this.selectedTiles != null && this.selectedTiles.length > 0) {
            for (int i = 0; i < selectedTiles2.length; ++i) {
                ImageTile tile = selectedTiles2[i];
                list.moveIndexedOneToTop(list.indexOf(tile));
            }
            this.rebuildListModel();
        }
    }

    protected void moveToTop(ImageTile[] selectedTiles2) {
        OMGraphicList list = this.getList();
        if (list != null && this.selectedTiles != null && this.selectedTiles.length > 0) {
            for (int i = selectedTiles2.length - 1; i >= 0; --i) {
                ImageTile tile = selectedTiles2[i];
                list.moveIndexedToTop(list.indexOf(tile));
            }
            this.rebuildListModel();
        }
    }

    protected void goTo(ImageTile[] selectedTiles2) {
        MapHandler bc;
        if (this.mapBean == null && (bc = (MapHandler)this.getBeanContext()) != null) {
            this.mapBean = (MapBean)bc.get(MapBean.class);
        }
        if (this.mapBean != null && this.selectedTiles != null && this.selectedTiles.length > 0) {
            RectangularShape rec = null;
            for (int i = selectedTiles2.length - 1; i >= 0; --i) {
                ImageTile tile = selectedTiles2[i];
                if (rec == null) {
                    rec = new Rectangle2D.Float(tile.getLRLon(), tile.getLRLat(), 0.0f, 0.0f);
                    ((Rectangle2D)rec).add(tile.getULLon(), tile.getULLat());
                    continue;
                }
                ((Rectangle2D)rec).add(tile.getULLon(), tile.getULLat());
                ((Rectangle2D)rec).add(tile.getLRLon(), tile.getLRLat());
            }
            if (rec != null) {
                LatLonPoint center = new LatLonPoint(rec.getCenterY(), rec.getCenterX());
                LatLonPoint anchor1 = new LatLonPoint(rec.getMaxY(), rec.getMinX());
                LatLonPoint anchor2 = new LatLonPoint(rec.getMinY(), rec.getMaxX());
                Proj proj = (Proj)this.mapBean.getProjection();
                float scale = ProjMath.getScale(anchor1, anchor2, (Projection)proj);
                if (logger.isLoggable(Level.FINE)) {
                    logger.info("Images cover " + anchor1 + " to " + anchor2 + ", scale adjusted to " + scale);
                }
                proj.setCenter(center);
                proj.setScale(scale);
                this.mapBean.setProjection(proj);
            }
        }
    }

    protected void select(ImageTile[] selectedTiles2) {
        this.setSelection(selectedTiles2, true);
    }

    protected void setSelection(ImageTile[] selectedTiles2, boolean isSelected) {
        for (int i = 0; i < selectedTiles2.length; ++i) {
            selectedTiles2[i].setSelected(isSelected);
        }
        this.repaint();
    }

    public void deselect() {
        OMGraphicList list = this.getList();
        if (list != null) {
            Iterator it = list.iterator();
            while (it.hasNext()) {
                ((OMGraphic)it.next()).setSelected(false);
            }
            this.repaint();
        }
    }

    public void resetSelectAttributes() {
        OMGraphicList list = this.getList();
        if (list != null) {
            Iterator it = list.iterator();
            while (it.hasNext()) {
                this.selectedDrawingAttributes.setTo((OMGraphic)it.next());
            }
            this.repaint();
        }
    }

    protected void removeImages(ImageTile[] selectedTiles2) {
        ImageTile[] selectedTiles = this.getSelectedTiles();
        if (selectedTiles != null && selectedTiles.length > 0) {
            OMGraphicList list;
            String confirmTitleString;
            String confirmStringMulti = this.i18n.get(ImageTileLayer.class, "removeConfirmMultiple", "Are you sure you want to remove these images from the layer?");
            String confirmStringSolo = this.i18n.get(ImageTileLayer.class, "removeConfirmSolo", "Are you sure you want to remove this image from the layer?");
            int answer = JOptionPane.showConfirmDialog(this, selectedTiles.length == 1 ? confirmStringSolo : confirmStringMulti, confirmTitleString = this.i18n.get(ImageTileLayer.class, "removeConfirmTitle", "Remove Images?"), 0);
            if (answer == 0 && (list = this.getList()) != null) {
                for (int i = 0; i < selectedTiles.length; ++i) {
                    ImageTile selectedTile = selectedTiles[i];
                    list.remove(selectedTile);
                    ((DefaultListModel)this.getListModel()).removeElement(selectedTile);
                }
                if (this.resultsList != null) {
                    this.resultsList.repaint();
                }
                this.repaint();
            }
        }
    }

    protected void addNewImagesWithFileChooser() {
        File startingPoint = new File(Environment.get("lastchosendirectory", System.getProperty("user.home")));
        JFileChooser chooser = new JFileChooser(startingPoint);
        String title = this.i18n.get(ImageTileLayer.class, "addImagesWindowTitle", "Add Images");
        chooser.setDialogTitle(title);
        chooser.setFileSelectionMode(2);
        chooser.setFileFilter(new ImageLoaderFileFilter(this.imageReaderLoaders));
        String acceptButtonText = this.i18n.get(ImageTileLayer.class, "acceptButtonText", "Add");
        int state = chooser.showDialog(null, acceptButtonText);
        try {
            if (state != 1 && state != -1) {
                OMGraphicList list;
                String newFile = chooser.getSelectedFile().getCanonicalPath();
                int dirIndex = newFile.lastIndexOf(File.separator);
                if (dirIndex >= 0) {
                    Environment.set("lastchosendirectory", newFile.substring(0, dirIndex));
                }
                if ((list = this.getList()) == null) {
                    list = new OMGraphicList();
                    this.setList(list);
                }
                LoadImageThread lit = new LoadImageThread(newFile, list);
                lit.start();
            }
        }
        catch (IOException ioe) {
            JOptionPane.showMessageDialog(null, ioe.getMessage(), "Error picking file", 0);
            ioe.printStackTrace();
        }
    }

    protected void setGUIButtonEnableState(boolean somethingSelected) {
        if (this.icbp != null) {
            this.icbp.setGUIButtonEnableState(somethingSelected);
            this.showHideButton.setEnabled(somethingSelected);
            this.gotoButton.setEnabled(somethingSelected);
            this.locateButton.setEnabled(somethingSelected);
        }
    }

    protected synchronized ListModel getListModel() {
        if (this.listModel == null) {
            this.listModel = new DefaultListModel();
        }
        return this.listModel;
    }

    protected void addImageTileToList(ImageTile tile) {
        ((DefaultListModel)this.getListModel()).addElement(tile);
    }

    protected void clearImageTileList() {
        ((DefaultListModel)this.getListModel()).clear();
    }

    protected boolean removeImageTileFromList(ImageTile tile) {
        return ((DefaultListModel)this.getListModel()).removeElement(tile);
    }

    protected void rebuildListModel() {
        DefaultListModel dlm = (DefaultListModel)this.getListModel();
        OMGraphicList list = this.getList();
        int[] selectedIndicies = null;
        boolean checkForIndicies = false;
        if (list != null) {
            if (this.selectedTiles != null && this.selectedTiles.length > 0) {
                selectedIndicies = new int[this.selectedTiles.length];
                checkForIndicies = true;
            }
            int tileCount = 0;
            Iterator it = list.iterator();
            while (it.hasNext()) {
                ImageTile imageTile = (ImageTile)it.next();
                if (checkForIndicies) {
                    for (int i = 0; i < this.selectedTiles.length; ++i) {
                        if (imageTile != this.selectedTiles[i]) continue;
                        for (int j = 0; j < selectedIndicies.length; ++j) {
                            selectedIndicies[j] = tileCount + j;
                        }
                        checkForIndicies = false;
                    }
                }
                ++tileCount;
            }
            dlm.clear();
            it = list.iterator();
            while (it.hasNext()) {
                dlm.addElement(it.next());
                ++tileCount;
            }
        }
        if (this.resultsList != null) {
            if (selectedIndicies != null) {
                this.resultsList.setSelectedIndices(selectedIndicies);
            }
            this.resultsList.repaint();
        }
    }

    protected ImageTile[] getSelectedTiles() {
        return this.selectedTiles;
    }

    protected void setSelectedTiles(ImageTile[] sTiles) {
        this.selectedTiles = sTiles;
        boolean allTilesDefective = this.areAllTilesDefective(sTiles);
        this.setGUIButtonEnableState(sTiles != null && sTiles.length > 0 && !allTilesDefective);
        if (allTilesDefective && this.icbp != null) {
            this.icbp.setGUIDeleteButtonEnableState(allTilesDefective);
        }
        this.checkShowHideStatus();
    }

    protected boolean areAllTilesDefective(ImageTile[] sTiles) {
        boolean allTilesDefective = false;
        if (sTiles != null && sTiles.length > 0) {
            allTilesDefective = true;
            for (int i = 0; i < sTiles.length; ++i) {
                if (sTiles[i] instanceof ErrImageTile) continue;
                allTilesDefective = false;
                break;
            }
        }
        return allTilesDefective;
    }

    public void checkShowHideStatus() {
        boolean anyTilesVisible;
        ImageTile[] sTiles = this.getSelectedTiles();
        boolean bl = anyTilesVisible = sTiles == null || sTiles.length == 0;
        if (sTiles != null) {
            for (int i = 0; i < sTiles.length; ++i) {
                anyTilesVisible = sTiles[i].isVisible() || anyTilesVisible;
            }
        }
        this.showHideButton.setText(anyTilesVisible ? this.HIDE_TILES_TITLE : this.SHOW_TILES_TITLE);
    }

    protected int getResultListIndex(MouseEvent e) {
        int index = -1;
        if (this.resultsList != null) {
            double height = this.getResultsListCellHeight();
            if (height == 0.0) {
                return index;
            }
            int nIndex = e.getY() / (int)height;
            if (nIndex < this.getListModel().getSize()) {
                index = nIndex;
            }
        }
        return index;
    }

    protected double getResultsListCellHeight() {
        int rlFVI;
        Rectangle bounds;
        double height = 0.0;
        if (this.resultsList != null && (bounds = this.resultsList.getCellBounds(rlFVI = this.resultsList.getFirstVisibleIndex(), rlFVI)) != null) {
            height = bounds.getHeight();
        }
        return height;
    }

    protected static void initIcons() {
        DrawingAttributes blackDa = new DrawingAttributes();
        DrawingAttributes invisDa = new DrawingAttributes();
        invisDa.setLinePaint(OMColor.clear);
        invisDa.setFillPaint(OMColor.clear);
        DrawingAttributes yellowDa = new DrawingAttributes();
        yellowDa.setLinePaint(OMColor.yellow);
        yellowDa.setFillPaint(OMColor.yellow);
        BasicIconPart ip = new BasicIconPart(new Rectangle2D.Double(0.0, 0.0, 100.0, 100.0));
        ip.setRenderingAttributes(invisDa);
        invisibleImage = OMIconFactory.getIcon(buttonSize, buttonSize, ip);
        IconPartList ipl = new IconPartList();
        Polygon triangle = new Polygon(new int[]{50, 90, 10, 50}, new int[]{10, 90, 90, 10}, 4);
        BasicIconPart bip = new BasicIconPart(triangle);
        bip.setRenderingAttributes(yellowDa);
        ipl.add(bip);
        bip = new BasicIconPart(triangle);
        bip.setRenderingAttributes(yellowDa);
        ipl.add(bip);
        bip = new BasicIconPart(triangle);
        bip.setRenderingAttributes(blackDa);
        ipl.add(bip);
        bip = new BasicIconPart(new Line2D.Double(49.0, 35.0, 49.0, 65.0));
        bip.setRenderingAttributes(blackDa);
        ipl.add(bip);
        bip = new BasicIconPart(new Line2D.Double(49.0, 75.0, 49.0, 77.0));
        bip.setRenderingAttributes(blackDa);
        ipl.add(bip);
        bip = new BasicIconPart(new Line2D.Double(51.0, 35.0, 51.0, 65.0));
        bip.setRenderingAttributes(blackDa);
        ipl.add(bip);
        bip = new BasicIconPart(new Line2D.Double(51.0, 75.0, 51.0, 77.0));
        bip.setRenderingAttributes(blackDa);
        ipl.add(bip);
        warningImage = OMIconFactory.getIcon(buttonSize, buttonSize, ipl);
    }

    class ImageLoaderFileFilter
    extends FileFilter {
        Vector imageReaderLoaders;

        public ImageLoaderFileFilter(Vector imgDcdrLdrs) {
            this.imageReaderLoaders = imgDcdrLdrs;
        }

        public boolean accept(File f) {
            if (f.isDirectory()) {
                return true;
            }
            if (this.imageReaderLoaders != null) {
                Iterator it = this.imageReaderLoaders.iterator();
                while (it.hasNext()) {
                    if (!((ImageReaderLoader)it.next()).isLoadable(f.getName())) continue;
                    return true;
                }
            }
            return false;
        }

        public String getDescription() {
            String description = ImageTileLayer.this.i18n.get(class$com$bbn$openmap$layer$imageTile$ImageTileLayer == null ? (class$com$bbn$openmap$layer$imageTile$ImageTileLayer = ImageTileLayer.class$("com.bbn.openmap.layer.imageTile.ImageTileLayer")) : class$com$bbn$openmap$layer$imageTile$ImageTileLayer, "fileFilterDescription", "Image File Formats Supported by Layer");
            return description;
        }
    }

    public static class ImageListCellRenderer
    extends JPanel
    implements ListCellRenderer {
        protected int buttonSize = 16;
        protected JLabel label = new JLabel();
        protected JLabel statusMark = new JLabel();
        public static Color fontColor = Color.BLACK;
        public static Color altFontColor = Color.BLACK;
        public static Color selectColor = Color.GRAY;
        public static Color notVisibleColor = new Color(100, 100, 100);
        public static Color regularBackgroundColor = Color.WHITE;

        public ImageListCellRenderer() {
            if (warningImage == null) {
                ImageTileLayer.initIcons();
            }
            this.setOpaque(true);
            GridBagLayout gridbag = new GridBagLayout();
            GridBagConstraints c = new GridBagConstraints();
            this.setLayout(gridbag);
            c.fill = 2;
            c.weightx = 1.0;
            gridbag.setConstraints(this.label, c);
            this.add(this.label);
            c.fill = 0;
            c.weightx = 0.0;
            gridbag.setConstraints(this.statusMark, c);
            this.add(this.statusMark);
            Font f = this.label.getFont();
            f = new Font(f.getName(), f.getStyle(), f.getSize() - 1);
            this.label.setFont(f);
            this.setPreferredSize(new Dimension(20, this.buttonSize));
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value instanceof ImageTile) {
                ImageTile imageTile = (ImageTile)value;
                this.label.setText((String)imageTile.getAttribute(ImageTileLayer.NAME_ATTRIBUTE));
                if (!isSelected) {
                    this.label.setForeground(imageTile.isVisible() ? fontColor : notVisibleColor);
                }
                if (value instanceof ErrImageTile) {
                    this.statusMark.setIcon(warningImage);
                } else {
                    this.statusMark.setIcon(invisibleImage);
                }
            }
            this.setBackground(isSelected ? selectColor : regularBackgroundColor);
            return this;
        }
    }

    class ListManager
    implements ListSelectionListener,
    MouseListener,
    MouseMotionListener {
        public void valueChanged(ListSelectionEvent e) {
            if (!e.getValueIsAdjusting() && ImageTileLayer.this.resultsList != null) {
                ImageTileLayer.this.locateButton.setSelected(false);
                ImageTileLayer.this.deselect();
                int[] indicies = ImageTileLayer.this.resultsList.getSelectedIndices();
                ImageTile[] selectedTiles = new ImageTile[indicies.length];
                if (indicies.length > 0) {
                    ListModel listModel = ImageTileLayer.this.getListModel();
                    for (int i = 0; i < indicies.length; ++i) {
                        selectedTiles[i] = (ImageTile)listModel.getElementAt(indicies[i]);
                    }
                }
                ImageTileLayer.this.setSelectedTiles(selectedTiles);
            }
        }

        public void mouseClicked(MouseEvent e) {
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }

        public void mousePressed(MouseEvent e) {
            this.checkMouseSelection(e);
        }

        public void mouseReleased(MouseEvent e) {
            this.checkMouseSelection(e);
        }

        protected void checkMouseSelection(MouseEvent e) {
            int selectedIndex = ImageTileLayer.this.getResultListIndex(e);
            if (selectedIndex < 0) {
                ImageTileLayer.this.resultsList.clearSelection();
            }
        }

        public void mouseDragged(MouseEvent e) {
        }

        public void mouseMoved(MouseEvent e) {
            Object it;
            int selectedIndex = ImageTileLayer.this.getResultListIndex(e);
            if (selectedIndex >= 0 && (it = ImageTileLayer.this.getListModel().getElementAt(selectedIndex)) instanceof ErrImageTile) {
                ImageTileLayer.this.resultsList.setToolTipText(((ErrImageTile)it).getProblemMessage());
                return;
            }
            ImageTileLayer.this.resultsList.setToolTipText(null);
        }
    }

    class LoadImageThread
    extends Thread {
        String fileToOpen;
        OMGraphicList listToAddTo;

        public LoadImageThread(String fto, OMGraphicList ltat) {
            this.fileToOpen = fto;
            this.listToAddTo = ltat;
        }

        public void run() {
            ImageTileLayer.this.loadImage(this.fileToOpen, this.listToAddTo);
            ImageTileLayer.this.fireStatusUpdate(8359);
        }
    }

    class ImageControlButtonPanel
    extends LayerControlButtonPanel {
        public ImageControlButtonPanel() {
            this.add = new JButton(addgif);
            this.add.setActionCommand("LayerAddCmd");
            this.add.setToolTipText(this.i18n.get(class$com$bbn$openmap$layer$imageTile$ImageTileLayer == null ? (class$com$bbn$openmap$layer$imageTile$ImageTileLayer = ImageTileLayer.class$("com.bbn.openmap.layer.imageTile.ImageTileLayer")) : class$com$bbn$openmap$layer$imageTile$ImageTileLayer, "addImage", 3, "Add images(s)"));
            this.add.addActionListener(this);
            this.add(this.add);
            this.delete.setToolTipText(this.i18n.get(class$com$bbn$openmap$layer$imageTile$ImageTileLayer == null ? (class$com$bbn$openmap$layer$imageTile$ImageTileLayer = ImageTileLayer.class$("com.bbn.openmap.layer.imageTile.ImageTileLayer")) : class$com$bbn$openmap$layer$imageTile$ImageTileLayer, "deleteImage", 3, "Remove image(s)"));
            this.delete.setEnabled(true);
            this.top.setToolTipText(this.i18n.get(class$com$bbn$openmap$layer$imageTile$ImageTileLayer == null ? (class$com$bbn$openmap$layer$imageTile$ImageTileLayer = ImageTileLayer.class$("com.bbn.openmap.layer.imageTile.ImageTileLayer")) : class$com$bbn$openmap$layer$imageTile$ImageTileLayer, "moveImageToTop", 3, "Move selected image(s) to top"));
            this.up.setToolTipText(this.i18n.get(class$com$bbn$openmap$layer$imageTile$ImageTileLayer == null ? (class$com$bbn$openmap$layer$imageTile$ImageTileLayer = ImageTileLayer.class$("com.bbn.openmap.layer.imageTile.ImageTileLayer")) : class$com$bbn$openmap$layer$imageTile$ImageTileLayer, "moveImageUp", 3, "Move selected image(s) up"));
            this.down.setToolTipText(this.i18n.get(class$com$bbn$openmap$layer$imageTile$ImageTileLayer == null ? (class$com$bbn$openmap$layer$imageTile$ImageTileLayer = ImageTileLayer.class$("com.bbn.openmap.layer.imageTile.ImageTileLayer")) : class$com$bbn$openmap$layer$imageTile$ImageTileLayer, "moveImageDown", "Move selected image(s) down"));
            this.bottom.setToolTipText(this.i18n.get(class$com$bbn$openmap$layer$imageTile$ImageTileLayer == null ? (class$com$bbn$openmap$layer$imageTile$ImageTileLayer = ImageTileLayer.class$("com.bbn.openmap.layer.imageTile.ImageTileLayer")) : class$com$bbn$openmap$layer$imageTile$ImageTileLayer, "moveImageToBottom", 3, "Move selected image(s) to bottom"));
        }

        public void actionPerformed(ActionEvent ae) {
            String cmd = ae.getActionCommand();
            if (cmd == "LayerAddCmd") {
                ImageTileLayer.this.addNewImagesWithFileChooser();
            } else if (cmd == "LayerRemoveCmd") {
                ImageTileLayer.this.removeImages(ImageTileLayer.this.getSelectedTiles());
            } else if (cmd == "LayerDownCmd") {
                ImageTileLayer.this.moveOneSlotToBottom(ImageTileLayer.this.getSelectedTiles());
                ImageTileLayer.this.repaint();
            } else if (cmd == "LayerBottomCmd") {
                ImageTileLayer.this.moveToBottom(ImageTileLayer.this.getSelectedTiles());
                ImageTileLayer.this.repaint();
            } else if (cmd == "LayerTopCmd") {
                ImageTileLayer.this.moveToTop(ImageTileLayer.this.getSelectedTiles());
                ImageTileLayer.this.repaint();
            } else if (cmd == "LayerUpCmd") {
                ImageTileLayer.this.moveOneSlotToTop(ImageTileLayer.this.getSelectedTiles());
                ImageTileLayer.this.repaint();
            }
        }

        public void setGUIButtonEnableState(boolean somethingSelected) {
            this.delete.setEnabled(somethingSelected);
            this.top.setEnabled(somethingSelected);
            this.up.setEnabled(somethingSelected);
            this.down.setEnabled(somethingSelected);
            this.bottom.setEnabled(somethingSelected);
        }

        public void setGUIDeleteButtonEnableState(boolean state) {
            this.delete.setEnabled(state);
        }
    }
}

