/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.dted;

import com.bbn.openmap.layer.OMGraphicHandlerLayer;
import com.bbn.openmap.layer.dted.DTEDCoverageManager;
import com.bbn.openmap.layer.policy.ListResetPCPolicy;
import com.bbn.openmap.omGraphics.OMGraphicList;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.util.Debug;
import com.bbn.openmap.util.PropUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Properties;
import javax.swing.Box;
import javax.swing.JCheckBox;

public class DTEDCoverageLayer
extends OMGraphicHandlerLayer
implements ActionListener {
    protected OMGraphicList[] omGraphics;
    protected String[] paths;
    protected String[] paths2;
    protected boolean showDTEDLevel0;
    protected boolean showDTEDLevel1;
    protected boolean showDTEDLevel2;
    protected Color level0Color;
    protected Color level1Color;
    protected Color level2Color;
    protected int opaqueness;
    protected boolean fillRects;
    protected String coverageFile = null;
    protected String coverageURL = null;
    protected DTEDCoverageManager coverageManager = null;
    private static final String showLevel0Command = "showLevel0";
    private static final String showLevel1Command = "showLevel1";
    private static final String showLevel2Command = "showLevel2";
    public static final String DTEDPathsProperty = "paths";
    public static final String DTED2PathsProperty = "level2.paths";
    public static final String ShowLevel0Property = "level0.showcov";
    public static final String Level0ColorProperty = "level0.color";
    public static final String ShowLevel1Property = "level1.showcov";
    public static final String Level1ColorProperty = "level1.color";
    public static final String ShowLevel2Property = "level2.showcov";
    public static final String Level2ColorProperty = "level2.color";
    public static final String OpaquenessProperty = "opaque";
    public static final String FillProperty = "fill";
    public static final String CoverageFileProperty = "coverageFile";
    public static final String CoverageURLProperty = "coverageURL";

    public DTEDCoverageLayer() {
        this.setProjectionChangePolicy(new ListResetPCPolicy(this));
    }

    protected void setDefaultValues() {
        this.paths = null;
        this.paths2 = null;
        this.showDTEDLevel0 = true;
        this.showDTEDLevel1 = true;
        this.showDTEDLevel2 = true;
        this.opaqueness = 255;
        this.fillRects = false;
    }

    public void setProperties(String prefix, Properties properties) {
        super.setProperties(prefix, properties);
        this.setDefaultValues();
        prefix = PropUtils.getScopedPropertyPrefix(prefix);
        this.paths = PropUtils.initPathsFromProperties(properties, prefix + DTEDPathsProperty);
        this.paths2 = PropUtils.initPathsFromProperties(properties, prefix + DTED2PathsProperty);
        this.coverageFile = properties.getProperty(prefix + CoverageFileProperty);
        this.coverageURL = properties.getProperty(prefix + CoverageURLProperty);
        this.fillRects = PropUtils.booleanFromProperties(properties, prefix + FillProperty, false);
        this.opaqueness = PropUtils.intFromProperties(properties, prefix + OpaquenessProperty, 255);
        this.level0Color = PropUtils.parseColorFromProperties(properties, prefix + Level0ColorProperty, "CE4F3F");
        this.level1Color = PropUtils.parseColorFromProperties(properties, prefix + Level1ColorProperty, "339159");
        this.level2Color = PropUtils.parseColorFromProperties(properties, prefix + Level2ColorProperty, "0C75D3");
        this.showDTEDLevel0 = PropUtils.booleanFromProperties(properties, prefix + ShowLevel0Property, true);
        this.showDTEDLevel1 = PropUtils.booleanFromProperties(properties, prefix + ShowLevel1Property, true);
        this.showDTEDLevel2 = PropUtils.booleanFromProperties(properties, prefix + ShowLevel2Property, true);
    }

    public synchronized void setGraphicLists(OMGraphicList[] aList) {
        this.omGraphics = aList;
    }

    public synchronized OMGraphicList[] getGraphicLists() {
        return this.omGraphics;
    }

    public synchronized OMGraphicList prepare() {
        if (this.isCancelled()) {
            Debug.message("dtedcov", this.getName() + "|DTEDCoverageLayer.prepare(): aborted.");
            return null;
        }
        Debug.message("basic", this.getName() + "|DTEDCoverageLayer.prepare(): doing it");
        Projection projection = this.getProjection();
        if (Debug.debugging("dtedcov")) {
            Debug.output(this.getName() + "|DTEDCoverageLayer.prepare(): " + "calling prepare with projection: " + projection + " ul = " + projection.getUpperLeft() + " lr = " + projection.getLowerRight());
        }
        if (this.coverageManager == null) {
            this.coverageManager = new DTEDCoverageManager(this.paths, this.paths2, this.coverageURL, this.coverageFile);
            this.coverageManager.setPaint(this.level0Color, this.level1Color, this.level2Color, this.opaqueness, this.fillRects);
            if (Debug.debugging("dtedcov")) {
                Debug.output(this.getName() + "|DTEDCoverageLayer.prepare(): created DTEDCoverageManager");
            }
        }
        OMGraphicList[] omGraphicLists = this.coverageManager.getCoverageRects(projection);
        this.setGraphicLists(omGraphicLists);
        int size = 0;
        if (omGraphicLists != null) {
            for (int j = 0; j < omGraphicLists.length; ++j) {
                size = omGraphicLists[j].size();
                Debug.message("basic", this.getName() + "|DTEDCoverageLayer.prepare(): finished with " + size + " level " + j + " graphics");
            }
        } else {
            Debug.message("basic", this.getName() + "|DTEDCoverageLayer.prepare(): finished with null graphics list");
        }
        OMGraphicList mainList = new OMGraphicList();
        for (int k = 0; k < omGraphicLists.length; ++k) {
            omGraphicLists[k].project(projection, true);
            mainList.add(omGraphicLists[k]);
        }
        return mainList;
    }

    public synchronized void checkVisibilities() {
        OMGraphicList[] lists = this.getGraphicLists();
        if (lists != null) {
            int length = lists.length;
            if (length > 0) {
                lists[0].setVisible(this.showDTEDLevel0);
            }
            if (length > 1) {
                lists[1].setVisible(this.showDTEDLevel1);
            }
            if (length > 2) {
                lists[2].setVisible(this.showDTEDLevel2);
            }
        }
    }

    public void paint(Graphics g) {
        this.checkVisibilities();
        super.paint(g);
    }

    public Component getGUI() {
        JCheckBox showLevel0Check = new JCheckBox("Show Level 0 Coverage", this.showDTEDLevel0);
        showLevel0Check.setActionCommand(showLevel0Command);
        showLevel0Check.addActionListener(this);
        JCheckBox showLevel1Check = new JCheckBox("Show Level 1 Coverage", this.showDTEDLevel1);
        showLevel1Check.setActionCommand(showLevel1Command);
        showLevel1Check.addActionListener(this);
        JCheckBox showLevel2Check = new JCheckBox("Show Level 2 Coverage", this.showDTEDLevel2);
        showLevel2Check.setActionCommand(showLevel2Command);
        showLevel2Check.addActionListener(this);
        Box box = Box.createVerticalBox();
        box.add(showLevel0Check);
        box.add(showLevel1Check);
        box.add(showLevel2Check);
        return box;
    }

    public void actionPerformed(ActionEvent e) {
        super.actionPerformed(e);
        String cmd = e.getActionCommand();
        if (cmd == showLevel0Command) {
            JCheckBox level0Check = (JCheckBox)e.getSource();
            this.showDTEDLevel0 = level0Check.isSelected();
            this.repaint();
        } else if (cmd == showLevel1Command) {
            JCheckBox level1Check = (JCheckBox)e.getSource();
            this.showDTEDLevel1 = level1Check.isSelected();
            this.repaint();
        } else if (cmd == showLevel2Command) {
            JCheckBox level2Check = (JCheckBox)e.getSource();
            this.showDTEDLevel2 = level2Check.isSelected();
            this.repaint();
        }
    }
}

