/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer;

import com.bbn.openmap.dataAccess.shape.DbfTableModel;
import com.bbn.openmap.dataAccess.shape.EsriGraphicList;
import com.bbn.openmap.dataAccess.shape.EsriShapeExport;
import com.bbn.openmap.event.MapMouseEvent;
import com.bbn.openmap.event.MapMouseMode;
import com.bbn.openmap.event.SelectMouseMode;
import com.bbn.openmap.layer.OMGraphicHandlerLayer;
import com.bbn.openmap.omGraphics.OMAction;
import com.bbn.openmap.omGraphics.OMGraphic;
import com.bbn.openmap.omGraphics.OMGraphicList;
import com.bbn.openmap.omGraphics.event.MapMouseInterpreter;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.tools.drawing.DrawingTool;
import com.bbn.openmap.tools.drawing.DrawingToolRequestor;
import com.bbn.openmap.tools.drawing.OMDrawingTool;
import com.bbn.openmap.tools.drawing.OMDrawingToolMouseMode;
import com.bbn.openmap.util.Debug;
import com.bbn.openmap.util.FileUtils;
import com.bbn.openmap.util.PaletteHelper;
import com.bbn.openmap.util.PropUtils;
import com.bbn.openmap.util.propertyEditor.Inspector;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.StreamCorruptedException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Properties;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;

public class DrawingToolLayer
extends OMGraphicHandlerLayer
implements DrawingToolRequestor {
    protected OMDrawingTool drawingTool;
    protected boolean showHints = true;
    public static final String ShowHintsProperty = "showHints";
    public static final String SerializedURLNameProperty = "file";
    protected String[] fileName;
    protected boolean DTL_DEBUG = false;
    protected MapMouseMode proxyMMM = null;
    JPanel box;
    JComboBox jcb;
    String editInstruction = this.i18n.get(DrawingToolLayer.class, "CLICK_TO_EDIT", "Click to edit.");

    public DrawingToolLayer() {
        this.setAddToBeanContext(true);
        this.DTL_DEBUG = Debug.debugging("dtl");
    }

    public void setProperties(String prefix, Properties props) {
        String fileList;
        super.setProperties(prefix, props);
        String realPrefix = PropUtils.getScopedPropertyPrefix(prefix);
        this.showHints = PropUtils.booleanFromProperties(props, realPrefix + ShowHintsProperty, this.showHints);
        if (this.getMouseModeIDsForEvents() == null) {
            this.setMouseModeIDsForEvents(new String[]{SelectMouseMode.modeID});
        }
        if ((fileList = props.getProperty(realPrefix + SerializedURLNameProperty)) != null && fileList.trim().length() > 0) {
            this.fileName = fileList.split(" ");
        }
    }

    public Properties getProperties(Properties props) {
        props = super.getProperties(props);
        String prefix = PropUtils.getScopedPropertyPrefix(this);
        props.put(prefix + ShowHintsProperty, new Boolean(this.showHints).toString());
        if (this.fileName != null && this.fileName.length > 0) {
            for (int i = 0; i < this.fileName.length; ++i) {
                props.put(prefix + SerializedURLNameProperty, PropUtils.unnull(this.fileName[i]));
            }
        }
        return props;
    }

    public Properties getPropertyInfo(Properties props) {
        props = super.getPropertyInfo(props);
        String interString = this.i18n.get(DrawingToolLayer.class, ShowHintsProperty, 3, "Display tooltips over layer's map objects.");
        props.put(ShowHintsProperty, interString);
        props.put("showHints.editor", "com.bbn.openmap.util.propertyEditor.YesNoPropertyEditor");
        interString = this.i18n.get(DrawingToolLayer.class, ShowHintsProperty, "Show Hints");
        props.put("showHints.label", interString);
        interString = this.i18n.get(DrawingToolLayer.class, SerializedURLNameProperty, 3, "File to use for reading and saving map objects.");
        props.put(SerializedURLNameProperty, interString);
        props.put("file.editor", "com.bbn.openmap.util.propertyEditor.FUPropertyEditor");
        interString = this.i18n.get(DrawingToolLayer.class, ShowHintsProperty, "File Name for Saving");
        props.put("file.label", interString);
        props.put("initProperties", "file showHints");
        return props;
    }

    public OMGraphicList prepare() {
        OMGraphicList list = this.getList();
        Projection proj = this.getProjection();
        if (list == null) {
            list = this.load();
        }
        if (list != null && proj != null) {
            list.generate(proj);
        }
        return list;
    }

    public OMDrawingTool getDrawingTool() {
        return this.drawingTool;
    }

    public void setDrawingTool(OMDrawingTool dt) {
        this.drawingTool = dt;
    }

    public void drawingComplete(OMGraphic omg, OMAction action) {
        if (this.DTL_DEBUG) {
            String cname = omg.getClass().getName();
            int lastPeriod = cname.lastIndexOf(46);
            if (lastPeriod != -1) {
                cname = cname.substring(lastPeriod + 1);
            }
            Debug.output("DrawingToolLayer: DrawingTool complete for " + cname + " > " + action);
        }
        this.releaseProxyMouseMode();
        OMGraphicList omgl = new OMGraphicList();
        omgl.add(omg);
        this.deselect(omgl);
        OMGraphicList list = this.getList();
        if (list == null) {
            list = this.load();
            this.setList(list);
        }
        if (list != null) {
            this.doAction(omg, action);
            this.repaint();
        } else {
            Debug.error("Layer " + this.getName() + " received " + omg + " and " + action + " with no list ready");
        }
    }

    public void releaseProxyMouseMode() {
        MapMouseMode pmmm = this.getProxyMouseMode();
        OMDrawingTool dt = this.getDrawingTool();
        if (pmmm != null && dt != null) {
            if (pmmm.isProxyFor(dt.getMouseMode())) {
                if (this.DTL_DEBUG) {
                    Debug.output("DTL: releasing proxy on " + pmmm.getID());
                }
                pmmm.releaseProxy();
                this.setProxyMouseMode(null);
                this.fireRequestInfoLine("");
            }
            if (dt.isActivated()) {
                dt.deactivate();
            }
        }
    }

    public void findAndInit(Object someObj) {
        if (someObj instanceof OMDrawingTool) {
            Debug.message("dtl", "DrawingToolLayer: found a drawing tool");
            this.setDrawingTool((OMDrawingTool)someObj);
        }
    }

    public void findAndUndo(Object someObj) {
        if (someObj instanceof DrawingTool && this.getDrawingTool() == someObj) {
            this.setDrawingTool(null);
        }
    }

    protected synchronized void setProxyMouseMode(MapMouseMode mmm) {
        this.proxyMMM = mmm;
    }

    protected synchronized MapMouseMode getProxyMouseMode() {
        return this.proxyMMM;
    }

    public boolean shouldEdit(OMGraphic omgr) {
        return true;
    }

    public Component getGUI() {
        if (this.box == null) {
            String interString = this.i18n.get(DrawingToolLayer.class, "QUERY_HEADER", "What would you like to do?");
            this.box = PaletteHelper.createVerticalPanel(interString);
            GridBagLayout gridbag = new GridBagLayout();
            GridBagConstraints c = new GridBagConstraints();
            this.box.setLayout(gridbag);
            this.jcb = new JComboBox(this.getActions());
            c.gridx = 0;
            gridbag.setConstraints(this.jcb, c);
            this.box.add(this.jcb);
            JPanel goPanel = new JPanel();
            gridbag.setConstraints(goPanel, c);
            this.box.add(goPanel);
            interString = this.i18n.get(DrawingToolLayer.class, "OK", "OK");
            JButton button = new JButton(interString);
            interString = this.i18n.get(DrawingToolLayer.class, "OK", 3, "Do action and dismiss window.");
            button.setToolTipText(interString);
            button.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent event) {
                    DrawingToolLayer.this.doIt();
                    DrawingToolLayer.this.hidePalette();
                }
            });
            goPanel.add(button);
            interString = this.i18n.get(DrawingToolLayer.class, "Apply", "Apply");
            button = new JButton(interString);
            interString = this.i18n.get(DrawingToolLayer.class, "Apply", 3, "Do action and leave window up.");
            button.setToolTipText(interString);
            button.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent event) {
                    DrawingToolLayer.this.doIt();
                }
            });
            goPanel.add(button);
            interString = this.i18n.get(DrawingToolLayer.class, "Cancel", "Cancel");
            button = new JButton(interString);
            interString = this.i18n.get(DrawingToolLayer.class, "Cancel", 3, "Do nothing and dismiss window.");
            button.setToolTipText(interString);
            button.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent event) {
                    DrawingToolLayer.this.hidePalette();
                }
            });
            goPanel.add(button);
        }
        return this.box;
    }

    protected void doIt() {
        if (this.jcb != null) {
            ((Action)this.jcb.getSelectedItem()).actionPerformed(null);
        }
    }

    protected Vector getActions() {
        Vector<AbstractAction> actions = new Vector<AbstractAction>();
        actions.add(new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                DrawingToolLayer.this.saveOMGraphics();
            }

            public String toString() {
                return DrawingToolLayer.this.i18n.get(class$com$bbn$openmap$layer$DrawingToolLayer == null ? (class$com$bbn$openmap$layer$DrawingToolLayer = DrawingToolLayer.class$("com.bbn.openmap.layer.DrawingToolLayer")) : class$com$bbn$openmap$layer$DrawingToolLayer, "SAVE_MAP", "Save map");
            }
        });
        actions.add(new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                OMGraphicList list = DrawingToolLayer.this.getList();
                if (list != null && list.size() > 0) {
                    EsriShapeExport ese = new EsriShapeExport(list, DrawingToolLayer.this.getProjection(), null);
                    ese.export();
                } else {
                    String message = DrawingToolLayer.this.i18n.get(class$com$bbn$openmap$layer$DrawingToolLayer == null ? (class$com$bbn$openmap$layer$DrawingToolLayer = DrawingToolLayer.class$("com.bbn.openmap.layer.DrawingToolLayer")) : class$com$bbn$openmap$layer$DrawingToolLayer, "SHAPE_ERROR_MESSAGE", "There's nothing on the map for this layer to save.");
                    DrawingToolLayer.this.fireRequestMessage(message);
                }
            }

            public String toString() {
                return DrawingToolLayer.this.i18n.get(class$com$bbn$openmap$layer$DrawingToolLayer == null ? (class$com$bbn$openmap$layer$DrawingToolLayer = DrawingToolLayer.class$("com.bbn.openmap.layer.DrawingToolLayer")) : class$com$bbn$openmap$layer$DrawingToolLayer, "SHAPE_SAVE_MAP", "Save map as Shape file(s)");
            }
        });
        actions.add(new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                DrawingToolLayer.this.setList(DrawingToolLayer.this.load());
                DrawingToolLayer.this.doPrepare();
            }

            public String toString() {
                return DrawingToolLayer.this.i18n.get(class$com$bbn$openmap$layer$DrawingToolLayer == null ? (class$com$bbn$openmap$layer$DrawingToolLayer = DrawingToolLayer.class$("com.bbn.openmap.layer.DrawingToolLayer")) : class$com$bbn$openmap$layer$DrawingToolLayer, "RELOAD", "Re-load map from file");
            }
        });
        actions.add(new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                Inspector inspector = new Inspector();
                inspector.inspectPropertyConsumer(DrawingToolLayer.this);
            }

            public String toString() {
                return DrawingToolLayer.this.i18n.get(class$com$bbn$openmap$layer$DrawingToolLayer == null ? (class$com$bbn$openmap$layer$DrawingToolLayer = DrawingToolLayer.class$("com.bbn.openmap.layer.DrawingToolLayer")) : class$com$bbn$openmap$layer$DrawingToolLayer, "PREFERENCES", "Change preferences");
            }
        });
        return actions;
    }

    public void saveOMGraphics() {
        OMGraphicList list;
        if (this.fileName == null) {
            this.fileName = new String[1];
        }
        if (this.fileName[0] == null) {
            this.fileName[0] = FileUtils.getFilePathToSaveFromUser(this.i18n.get(DrawingToolLayer.class, "CHOOSE_SAVE", "Choose file to use to save layer:"));
        }
        if (this.fileName[0] != null && (list = this.getList()) != null) {
            try {
                FileOutputStream fos = new FileOutputStream(new File(this.fileName[0]));
                ObjectOutputStream oos = new ObjectOutputStream(fos);
                oos.writeObject(list);
                oos.close();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public OMGraphicList load() {
        block14: {
            OMGraphicList list = null;
            if (this.fileName != null) {
                try {
                    ArrayList<OMGraphic> graphicList = new ArrayList<OMGraphic>();
                    for (int i = 0; i < this.fileName.length; ++i) {
                        URL url = PropUtils.getResourceOrFileOrURL(this.fileName[i]);
                        if (url == null) continue;
                        if (this.fileName[i].endsWith("shp")) {
                            DbfTableModel dbf = DbfTableModel.getDbfTableModel(PropUtils.getResourceOrFileOrURL(this.fileName[i].replaceAll(".shp", ".dbf")));
                            list = EsriGraphicList.getEsriGraphicList(url, null, dbf);
                        } else {
                            ObjectInputStream ois = new ObjectInputStream(url.openStream());
                            list = (OMGraphicList)ois.readObject();
                            ois.close();
                        }
                        for (int j = 0; j < list.size(); ++j) {
                            graphicList.add(list.getOMGraphicAt(j));
                        }
                    }
                    OMGraphicList fullList = new OMGraphicList(graphicList);
                    return fullList;
                }
                catch (FileNotFoundException e) {
                    if (this.DTL_DEBUG) {
                        e.printStackTrace();
                    }
                }
                catch (StreamCorruptedException sce) {
                    sce.printStackTrace();
                    this.fireRequestMessage(this.i18n.get(DrawingToolLayer.class, "LOAD_ERROR", "The file doesn't appear to be a valid map file"));
                }
                catch (IOException e) {
                    if (this.DTL_DEBUG) {
                        e.printStackTrace();
                    }
                }
                catch (ClassNotFoundException e) {
                    if (this.DTL_DEBUG) {
                        e.printStackTrace();
                    }
                }
                catch (ClassCastException cce) {
                    if (!this.DTL_DEBUG) break block14;
                    cce.printStackTrace();
                }
            }
        }
        this.fileName = null;
        return new OMGraphicList();
    }

    public void setShowHints(boolean show) {
        this.showHints = show;
    }

    public boolean getShowHints() {
        return this.showHints;
    }

    public boolean isHighlightable(OMGraphic omg) {
        return this.showHints;
    }

    public boolean isSelectable(OMGraphic omg) {
        OMDrawingTool dt = this.getDrawingTool();
        return this.shouldEdit(omg) && dt != null && dt.canEdit(omg.getClass());
    }

    public String getInfoText(OMGraphic omg) {
        OMDrawingTool dt = this.getDrawingTool();
        if (dt != null && dt.canEdit(omg.getClass())) {
            return this.editInstruction;
        }
        return null;
    }

    public String getToolTipTextFor(OMGraphic omgr) {
        OMDrawingTool dt = this.getDrawingTool();
        if (this.shouldEdit(omgr) && dt.canEdit(omgr.getClass()) && !dt.isActivated()) {
            return this.editInstruction;
        }
        return null;
    }

    public void select(OMGraphicList omgl) {
        super.select(omgl);
        if (omgl != null && omgl.size() > 0) {
            if (omgl.size() == 1) {
                this.edit(omgl.getOMGraphicAt(0));
            } else {
                this.edit(omgl);
            }
        }
    }

    public void edit(OMGraphic omg) {
        OMDrawingTool dt = this.getDrawingTool();
        if (dt != null && dt.canEdit(omg.getClass())) {
            dt.resetBehaviorMask();
            OMDrawingToolMouseMode omdtmm = dt.getMouseMode();
            if (!omdtmm.isVisible()) {
                dt.setMask(16);
            }
            MapMouseInterpreter mmi = (MapMouseInterpreter)this.getMapMouseListener();
            MouseEvent mevent = null;
            if (mmi != null) {
                mevent = mmi.getCurrentMouseEvent();
            }
            if (omg.isSelected()) {
                omg.deselect();
            }
            if (dt.select(omg, this, mevent)) {
                if (this.DTL_DEBUG) {
                    Debug.output("DTL: starting edit of OMGraphic...");
                }
                if (!omdtmm.isVisible() && mevent instanceof MapMouseEvent) {
                    MapMouseMode mmm = ((MapMouseEvent)mevent).getMapMouseMode();
                    if (mmm.actAsProxyFor(omdtmm, 0)) {
                        if (this.DTL_DEBUG) {
                            Debug.output("DTL: Setting " + mmm.getID() + " as proxy for drawing tool");
                        }
                        this.setProxyMouseMode(mmm);
                    } else {
                        if (this.DTL_DEBUG) {
                            Debug.output("DTL: couldn't get proxy lock on " + mmm.getID() + " deactivating internal drawing tool");
                        }
                        dt.deactivate();
                    }
                } else if (this.DTL_DEBUG) {
                    Debug.output("DTL: MouseMode wants to be visible(" + omdtmm.isVisible() + "), or MouseEvent is not a MapMouseEvent(" + !(mevent instanceof MapMouseEvent) + ")");
                }
            } else if (this.DTL_DEBUG) {
                Debug.output("DTL.edit: dt.select returns false, avoiding modification over " + omg.getClass().getName());
            }
        }
    }

    public String getFileName() {
        return this.fileName[0];
    }

    public void setSFileName(String serializedFile) {
        this.fileName[0] = serializedFile;
    }
}

