/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer;

import com.bbn.openmap.util.Debug;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.image.BufferedImage;

public class DeclutterMatrix {
    protected int height = 0;
    protected int width = 0;
    protected int x_pix_interval = 1;
    protected int y_pix_interval = 1;
    protected boolean[][] matrix = new boolean[0][0];
    protected int maxx;
    protected int maxy;
    protected boolean allowPartials = true;
    protected MatrixIndexes indexes = new MatrixIndexes();
    protected boolean needToRecreate = false;
    public static final int DCP_MIDDLE = 20875;
    public static final int DCP_EAST = 20876;
    public static final int DCP_NORTH = 20877;
    public static final int DCP_SOUTH = 20878;
    public static final int DCP_WEST = 20879;
    public static final int DCP_NEAST = 20880;
    public static final int DCP_SEAST = 20881;
    public static final int DCP_SWEST = 20882;
    public static final int DCP_NWEST = 20883;
    public static final int DCD_NS = 20884;
    public static final int DCD_EW = 20885;
    public static final int DCD_NONE = 20886;
    public static final PositionParameters[] dcPos = new PositionParameters[9];
    private static ThreadGraphicsDispenser graphicsDispencer;

    public void setAllowPartials(boolean value) {
        this.allowPartials = value;
    }

    public boolean isAllowPartials() {
        return this.allowPartials;
    }

    public DeclutterMatrix(int width, int height, int x_pix_interval, int y_pix_interval) {
        this.width = width;
        this.height = height;
        if (x_pix_interval != 0) {
            this.x_pix_interval = x_pix_interval;
        } else {
            x_pix_interval = 1;
        }
        if (y_pix_interval != 0) {
            this.y_pix_interval = y_pix_interval;
        } else {
            y_pix_interval = 1;
        }
        this.matrix = null;
        this.maxx = this.width / this.x_pix_interval - 1;
        this.maxy = this.height / this.y_pix_interval - 1;
        this.create();
        Debug.message("declutter", "Decluttering matrix created.  Width = " + width + " Height = " + height);
    }

    public DeclutterMatrix(int width, int height) {
        this(width, height, 1, 1);
    }

    public DeclutterMatrix() {
        this(0, 0);
    }

    public void setXInterval(int x_pix_interval) {
        this.x_pix_interval = x_pix_interval != 0 ? x_pix_interval : 1;
        this.maxx = this.width / this.x_pix_interval - 1;
        this.needToRecreate = true;
        Debug.message("declutter", "Decluttering matrix: x_pix_interval changed to " + x_pix_interval);
    }

    public void setYInterval(int y_pix_interval) {
        this.y_pix_interval = y_pix_interval != 0 ? y_pix_interval : 1;
        this.maxy = this.height / this.y_pix_interval - 1;
        this.needToRecreate = true;
        Debug.message("declutter", "Decluttering matrix: y_pix_interval changed to " + y_pix_interval);
    }

    public void setWidth(int width) {
        this.width = width;
        this.maxx = this.width / this.x_pix_interval - 1;
        this.needToRecreate = true;
        Debug.message("declutter", "Decluttering matrix: Width reset to " + width);
    }

    public void setHeight(int height) {
        this.height = height;
        this.maxy = this.height / this.y_pix_interval - 1;
        this.needToRecreate = true;
        Debug.message("declutter", "Decluttering matrix: height reset to " + height);
    }

    public boolean create() {
        if (this.height > 0 && this.width > 0) {
            this.matrix = new boolean[this.maxx + 1][this.maxy + 1];
            this.needToRecreate = false;
            return true;
        }
        this.needToRecreate = true;
        return false;
    }

    protected boolean isClear(MatrixIndexes indexes, boolean markAsTaken) {
        Debug.message("declutterdetail", "DeclutterMatrix: Checking space for clear.");
        if (this.matrix == null) {
            return false;
        }
        if (!indexes.withinMatrix) {
            return true;
        }
        if (!this.allowPartials && indexes.partial) {
            return false;
        }
        boolean notClear = false;
        for (int taken = 0; taken < 2; ++taken) {
            for (int i = indexes.xStart; i <= indexes.xEnd; ++i) {
                if (taken == 0) {
                    notClear = this.isMatrixLocationTaken(i, indexes.yStart, indexes.yEnd - indexes.yStart + 1);
                    if (!notClear) continue;
                    return false;
                }
                this.setTaken(i, indexes.yStart, indexes.yEnd - indexes.yStart + 1);
            }
            if (markAsTaken) continue;
            return true;
        }
        return true;
    }

    protected boolean isMatrixLocationTaken(int horizontalIndex, int verticalIndex, int numCellsToCheck) {
        try {
            for (int i = numCellsToCheck - 1; i >= 0; --i) {
                if (!this.matrix[horizontalIndex][verticalIndex + i]) continue;
                return true;
            }
        }
        catch (ArrayIndexOutOfBoundsException aioobe) {
            return this.allowPartials;
        }
        return false;
    }

    protected void setTaken(int horizontalIndex, int verticalIndex, int numCellsToMark) {
        try {
            for (int i = numCellsToMark - 1; i >= 0; --i) {
                this.matrix[horizontalIndex][verticalIndex + i] = true;
            }
        }
        catch (ArrayIndexOutOfBoundsException aioobe) {
            // empty catch block
        }
    }

    protected boolean setTaken(MatrixIndexes indexes) {
        if (this.matrix == null) {
            return false;
        }
        if (!indexes.withinMatrix) {
            return this.allowPartials;
        }
        for (int i = indexes.xStart; i < indexes.xEnd; ++i) {
            this.setTaken(i, indexes.yStart, indexes.yEnd - indexes.yStart + 1);
        }
        return true;
    }

    public boolean setTaken(Point point, int pixelLength) {
        return this.setTaken(point, pixelLength, this.y_pix_interval);
    }

    public boolean setTaken(Point point, int pixelLength, int pixelHeight) {
        if (this.needToRecreate) {
            this.create();
        }
        this.indexes.setFromPixels(point.x, point.y, pixelLength, pixelHeight);
        return this.setTaken(this.indexes);
    }

    public Point setNextOpen(Point point, int pixelLength, int pixelHeight) {
        return this.setNextOpen(point, pixelLength, pixelHeight, -1);
    }

    public Point setNextOpen(Point point, int pixelLength, int pixelHeight, int pixelAwayLimit) {
        Debug.message("declutterdetail", "DeclutterMatrix: Trying to find an open space.");
        if (this.needToRecreate) {
            this.create();
        }
        boolean set = false;
        int windex = point.x / this.x_pix_interval;
        int hindex = point.y / this.y_pix_interval;
        Point ret = null;
        Point testPoint = new Point();
        int round = 0;
        this.indexes.setFromPixels(point.x, point.y, pixelLength, pixelHeight);
        if (this.matrix == null || !this.indexes.withinMatrix) {
            return point;
        }
        ret = this.isAreaClearR(windex, hindex, testPoint);
        int round_limit = pixelAwayLimit < 0 ? Math.abs(this.maxy / 2 - this.indexes.yStart) + this.maxy / 2 : pixelAwayLimit;
        while (ret == null) {
            Debug.message("declutterdetail", "DeclutterMatrix: round " + round + "\n");
            ++round;
            int pos = 0;
            while (DeclutterMatrix.dcPos[pos].position != 20875 && ret == null) {
                int xpoint = windex + round * DeclutterMatrix.dcPos[pos].ewindex;
                int ypoint = hindex + round * DeclutterMatrix.dcPos[pos].nsindex;
                if (xpoint <= this.maxx && ypoint <= this.maxy && xpoint >= 0 && ypoint >= 0) {
                    int i;
                    if (DeclutterMatrix.dcPos[pos].direction == 20884) {
                        for (i = -1 * (round - 1); i < round - 1 && !set && (ret = this.isAreaClearBW(xpoint, ypoint + i, testPoint)) == null; ++i) {
                        }
                    } else if (DeclutterMatrix.dcPos[pos].direction == 20885) {
                        for (i = round - 1; i >= -1 * (round - 1) && !set && (ret = this.isAreaClearBW(xpoint + i, ypoint, testPoint)) == null; --i) {
                        }
                    } else {
                        ret = this.isAreaClearBW(xpoint, ypoint, testPoint);
                    }
                }
                ++pos;
            }
            if (round <= round_limit) continue;
        }
        if (ret != null) {
            if (Debug.debugging("declutter")) {
                Debug.output("Placing object at " + ret.x + " | " + ret.y);
            }
        } else {
            Debug.message("declutter", "Decluttering: No space for entry.");
            ret = testPoint;
            ret.x = -1 * windex;
            ret.y = -1 * hindex;
        }
        return ret;
    }

    protected Point isAreaClearR(int xPoint, int yPoint, Point point) {
        Debug.message("declutterdetail", "Decluttering: Checking to the right...");
        if (!this.indexes.setFromPixels(xPoint, yPoint)) {
            return null;
        }
        if (this.isClear(this.indexes, true)) {
            point.x = xPoint;
            point.y = yPoint;
            Debug.message("declutterdetail", "*******Decluttering: found a spot");
            return point;
        }
        return null;
    }

    protected Point isAreaClearBWT(int xPoint, int yPoint, Point point) {
        Debug.message("declutterdetail", "Decluttering: Checking both ways...");
        if (!this.indexes.setFromPixels(xPoint, yPoint)) {
            return null;
        }
        if (this.isClear(this.indexes, true)) {
            point.x = xPoint;
            point.y = yPoint;
            Debug.message("declutterdetail", "*******Decluttering: found a spot");
            return point;
        }
        int leftMostIndex = this.indexes.origXIndex - this.indexes.origIndexLength;
        if (!this.indexes.set(leftMostIndex, this.indexes.origYIndex)) {
            return null;
        }
        if (this.isClear(this.indexes, true)) {
            point.x = leftMostIndex * this.x_pix_interval;
            point.y = yPoint;
            Debug.message("declutterdetail", "*******Decluttering: found a spot");
            return point;
        }
        return null;
    }

    protected Point isAreaClearBW(int xPoint, int yPoint, Point point) {
        Debug.message("declutterdetail", "Decluttering: Checking both ways...");
        if (!this.indexes.setFromPixels(xPoint, yPoint) || this.isClear(this.indexes, true)) {
            point.x = xPoint;
            point.y = yPoint;
            return point;
        }
        int leftMostIndex = this.indexes.origXIndex - this.indexes.origIndexLength;
        int count = 0;
        int currentXIndex = this.indexes.origXIndex + this.indexes.origIndexLength;
        while (count < this.indexes.origIndexLength && currentXIndex > leftMostIndex) {
            if (!this.indexes.set(currentXIndex, this.indexes.origYIndex)) {
                count = 0;
                --currentXIndex;
                continue;
            }
            count = currentXIndex >= 0 && currentXIndex <= this.maxx ? (!this.isMatrixLocationTaken(currentXIndex, this.indexes.yStart, this.indexes.yEnd - this.indexes.yStart + 1) ? ++count : 0) : (this.allowPartials ? ++count : 0);
            if (count >= this.indexes.origIndexLength) continue;
            --currentXIndex;
        }
        if (count >= this.indexes.origIndexLength) {
            point.x = currentXIndex * this.x_pix_interval;
            point.y = yPoint;
            this.indexes.xStart = currentXIndex;
            this.setTaken(this.indexes);
            Debug.message("declutterdetail", "Decluttering: found a spot");
            return point;
        }
        return null;
    }

    public static Graphics2D getGraphics() {
        return (Graphics2D)graphicsDispencer.get();
    }

    static {
        DeclutterMatrix.dcPos[0] = new PositionParameters(20876, 1, 0, 20884);
        DeclutterMatrix.dcPos[1] = new PositionParameters(20877, 0, -1, 20885);
        DeclutterMatrix.dcPos[2] = new PositionParameters(20878, 0, 1, 20885);
        DeclutterMatrix.dcPos[3] = new PositionParameters(20879, -1, 0, 20884);
        DeclutterMatrix.dcPos[4] = new PositionParameters(20880, 1, -1, 20886);
        DeclutterMatrix.dcPos[5] = new PositionParameters(20881, 1, 1, 20886);
        DeclutterMatrix.dcPos[6] = new PositionParameters(20882, -1, 1, 20886);
        DeclutterMatrix.dcPos[7] = new PositionParameters(20883, -1, -1, 20886);
        DeclutterMatrix.dcPos[8] = new PositionParameters(20875, 0, 0, 20886);
        graphicsDispencer = new ThreadGraphicsDispenser();
    }

    private static class ThreadGraphicsDispenser
    extends ThreadLocal {
        private ThreadGraphicsDispenser() {
        }

        public Object initialValue() {
            BufferedImage bi = new BufferedImage(1, 1, 1);
            GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
            Graphics2D workingGraphics = ge.createGraphics(bi);
            return workingGraphics;
        }
    }

    public class MatrixIndexes {
        public boolean withinMatrix = false;
        public boolean partial = false;
        public int xStart = 0;
        public int yStart = 0;
        public int xEnd = 0;
        public int yEnd = 0;
        public int origXIndex = -1;
        public int origYIndex = -1;
        public int origIndexLength = 1;
        public int origIndexHeight = 1;

        public boolean setFromPixels(int pixelXLocation, int pixelYLocation, int pixelLength, int pixelHeight) {
            int objXIndex = pixelXLocation / DeclutterMatrix.this.x_pix_interval;
            int objYIndex = pixelYLocation / DeclutterMatrix.this.y_pix_interval;
            int objLength = (int)Math.ceil((double)pixelLength / (double)DeclutterMatrix.this.x_pix_interval);
            int objHeight = (int)Math.ceil((double)pixelHeight / (double)DeclutterMatrix.this.y_pix_interval);
            return this.set(objXIndex, objYIndex, objLength, objHeight);
        }

        public boolean setFromPixels(int pixelXLocation, int pixelYLocation) {
            int objXIndex = pixelXLocation / DeclutterMatrix.this.x_pix_interval;
            int objYIndex = pixelYLocation / DeclutterMatrix.this.y_pix_interval;
            return this.set(objXIndex, objYIndex, this.origIndexLength, this.origIndexHeight);
        }

        public boolean set(int objXIndex, int objYIndex) {
            return this.set(objXIndex, objYIndex, this.origIndexLength, this.origIndexHeight);
        }

        public boolean set(int objXIndex, int objYIndex, int objIndexLength, int objIndexHeight) {
            this.origXIndex = objXIndex;
            this.origYIndex = objYIndex;
            this.origIndexLength = objIndexLength;
            this.origIndexHeight = objIndexHeight;
            this.withinMatrix = this.objOnMatrix(objXIndex, objYIndex, objIndexLength, objIndexHeight);
            if (!this.withinMatrix) {
                return false;
            }
            this.partial = false;
            if (objXIndex + objIndexLength <= DeclutterMatrix.this.maxx) {
                this.xEnd = objXIndex + objIndexLength;
            } else {
                this.xEnd = DeclutterMatrix.this.maxx;
                this.partial = true;
            }
            if (this.xEnd < 0) {
                this.xEnd = 0;
            }
            if (objYIndex + objIndexHeight <= DeclutterMatrix.this.maxy) {
                this.yEnd = objYIndex + objIndexHeight;
            } else {
                this.yEnd = DeclutterMatrix.this.maxy;
                this.partial = true;
            }
            if (this.yEnd < 0) {
                this.yEnd = 0;
            }
            if (objYIndex >= 0) {
                this.yStart = objYIndex;
            } else {
                objYIndex = 0;
                this.partial = true;
            }
            if (objXIndex >= 0) {
                this.xStart = objXIndex;
            } else {
                this.xStart = 0;
                this.partial = true;
            }
            return true;
        }

        public boolean objOnMatrix(int objXIndex, int objYIndex, int objIndexLength, int objIndexHeight) {
            return objXIndex + objIndexLength >= 0 && objYIndex + objIndexHeight >= 0 && objXIndex <= DeclutterMatrix.this.maxx && objYIndex <= DeclutterMatrix.this.maxy;
        }
    }

    public static class PositionParameters {
        public int position;
        public int ewindex;
        public int nsindex;
        public int direction;

        public PositionParameters(int pos, int ewindx, int nsindx, int direc) {
            this.position = pos;
            this.ewindex = ewindx;
            this.nsindex = nsindx;
            this.direction = direc;
        }
    }
}

