/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.io;

import com.bbn.openmap.MoreMath;
import com.bbn.openmap.io.BinaryFile;
import com.bbn.openmap.io.FormatException;
import com.bbn.openmap.io.InputReader;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;

public class BinaryBufferedFile
extends BinaryFile {
    private byte[] buffer;
    private int curptr = 0;
    private int bytesinbuffer = 0;
    private long firstbyteoffset = 0L;

    public BinaryBufferedFile(File f, int buffersize) throws IOException {
        super(f);
        this.buffer = new byte[buffersize];
    }

    public BinaryBufferedFile(File f) throws IOException {
        this(f, 4096);
    }

    public BinaryBufferedFile(String name, int buffersize) throws IOException {
        super(name);
        this.buffer = new byte[buffersize];
    }

    public BinaryBufferedFile(String name) throws IOException {
        this(name, 4096);
    }

    public static BinaryBufferedFile create(String name) {
        return BinaryBufferedFile.create(name, 4096);
    }

    public static BinaryBufferedFile create(String name, int buffersize) {
        BinaryBufferedFile bf = null;
        try {
            bf = new BinaryBufferedFile(name, buffersize);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return bf;
    }

    public void setInputReader(InputReader reader) {
        super.setInputReader(reader);
        this.firstbyteoffset = 0L;
        this.bytesinbuffer = 0;
        this.curptr = 0;
    }

    private void refillBuffer() throws IOException, EOFException {
        this.firstbyteoffset += (long)(this.curptr + this.bytesinbuffer);
        int err = super.read(this.buffer, 0, this.buffer.length);
        this.curptr = 0;
        if (err == -1) {
            throw new EOFException();
        }
        this.bytesinbuffer = err;
    }

    private void assertSize(int minlength) throws FormatException, EOFException {
        try {
            if (this.bytesinbuffer < minlength) {
                int err;
                if (this.curptr != 0) {
                    this.firstbyteoffset += (long)this.curptr;
                    System.arraycopy(this.buffer, this.curptr, this.buffer, 0, this.bytesinbuffer);
                    this.curptr = 0;
                }
                if ((err = super.read(this.buffer, this.bytesinbuffer, this.buffer.length - this.bytesinbuffer)) == -1) {
                    if (this.available() <= 0L) {
                        throw new EOFException("BinaryBufferedFile, no bytes at all, trying to read " + minlength);
                    }
                    throw new FormatException("BinaryBufferedFile: failed to read " + minlength + " bytes, with " + this.bytesinbuffer + " bytes in the buffer and " + this.available() + " bytes available, have read " + this.curptr + " bytes.");
                }
                this.bytesinbuffer += err;
                this.assertSize(minlength);
            }
        }
        catch (EOFException e) {
            throw e;
        }
        catch (IOException i) {
            throw new FormatException("assertSize IOException: " + i.getMessage());
        }
    }

    public long skipBytes(long n) throws IOException {
        if (n < (long)this.bytesinbuffer) {
            this.bytesinbuffer = (int)((long)this.bytesinbuffer - n);
            this.curptr = (int)((long)this.curptr + n);
            return n;
        }
        long oldbinb = this.bytesinbuffer;
        this.bytesinbuffer = 0;
        this.curptr = 0;
        int skipcnt = (int)super.skipBytes(n - oldbinb);
        this.firstbyteoffset += (long)skipcnt;
        return oldbinb + (long)skipcnt;
    }

    public long getFilePointer() throws IOException {
        return this.firstbyteoffset + (long)this.curptr;
    }

    public void seek(long pos) throws IOException {
        long relpos = pos - this.firstbyteoffset;
        if (relpos >= 0L && relpos < (long)(this.curptr + this.bytesinbuffer)) {
            int relcur = (int)relpos - this.curptr;
            if (relcur != 0) {
                this.bytesinbuffer -= relcur;
                this.curptr = (int)relpos;
            }
        } else {
            super.seek(pos);
            this.firstbyteoffset = pos;
            this.bytesinbuffer = 0;
            this.curptr = 0;
        }
    }

    public long length() throws IOException {
        return super.length();
    }

    public long available() throws IOException {
        return this.length() - this.firstbyteoffset - (long)this.curptr;
    }

    public void dispose() throws IOException {
        this.buffer = null;
        super.dispose();
    }

    public int read() throws IOException {
        try {
            if (this.bytesinbuffer == 0) {
                this.refillBuffer();
            }
        }
        catch (EOFException e) {
            return -1;
        }
        --this.bytesinbuffer;
        return MoreMath.signedToInt(this.buffer[this.curptr++]);
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int numread = 0;
        int copy = len < this.bytesinbuffer ? len : this.bytesinbuffer;
        numread += copy;
        this.bytesinbuffer -= copy;
        System.arraycopy(this.buffer, this.curptr, b, off, copy);
        this.curptr += copy;
        off += copy;
        if (len == copy) {
            return numread;
        }
        if ((len -= copy) > 512) {
            int bcnt = super.read(b, off, len);
            this.firstbyteoffset += (long)(this.curptr + bcnt);
            this.curptr = 0;
            return numread + bcnt;
        }
        try {
            this.refillBuffer();
        }
        catch (EOFException e) {
            if (numread == 0) {
                numread = -1;
            }
            return numread;
        }
        return numread + this.read(b, off, len);
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    public byte[] readBytes(int howmany, boolean allowless) throws EOFException, FormatException {
        byte[] foo = new byte[howmany];
        try {
            int err;
            for (int gotsofar = 0; gotsofar < howmany; gotsofar += err) {
                err = this.read(foo, gotsofar, howmany - gotsofar);
                if (err != -1) continue;
                if (allowless) {
                    byte[] retval = new byte[gotsofar];
                    System.arraycopy(foo, 0, retval, 0, gotsofar);
                    return retval;
                }
                if (gotsofar > 0) {
                    throw new FormatException("EOF while reading");
                }
                throw new EOFException();
            }
        }
        catch (IOException i) {
            throw new FormatException("IOException reading file: " + i.getMessage());
        }
        return foo;
    }

    public char readChar() throws EOFException, FormatException {
        try {
            int retv = this.read();
            if (retv == -1) {
                throw new EOFException("Error in ReadChar, EOF reached");
            }
            return (char)retv;
        }
        catch (IOException i) {
            throw new FormatException("IOException in ReadChar: " + i.getMessage());
        }
    }

    public short readShort() throws EOFException, FormatException {
        this.assertSize(2);
        this.curptr += 2;
        this.bytesinbuffer -= 2;
        return MoreMath.BuildShort(this.buffer, this.curptr - 2, this.MSBFirst);
    }

    public int readUnsignedShort() throws EOFException, FormatException {
        return MoreMath.signedToInt(this.readShort());
    }

    public void readShortArray(short[] vec, int offset, int len) throws EOFException, FormatException {
        while (len > 0) {
            int i;
            int reallyread;
            int shortsleft = this.bytesinbuffer / 2;
            if (shortsleft == 0) {
                this.assertSize(2);
                continue;
            }
            int n = reallyread = len < shortsleft ? len : shortsleft;
            if (this.MSBFirst) {
                for (i = 0; i < reallyread; ++i) {
                    vec[offset++] = MoreMath.BuildShortBE(this.buffer, this.curptr);
                    this.curptr += 2;
                }
            } else {
                for (i = 0; i < reallyread; ++i) {
                    vec[offset++] = MoreMath.BuildShortLE(this.buffer, this.curptr);
                    this.curptr += 2;
                }
            }
            len -= reallyread;
            this.bytesinbuffer -= 2 * reallyread;
        }
    }

    public int readInteger() throws EOFException, FormatException {
        this.assertSize(4);
        this.curptr += 4;
        this.bytesinbuffer -= 4;
        return MoreMath.BuildInteger(this.buffer, this.curptr - 4, this.MSBFirst);
    }

    public void readIntegerArray(int[] vec, int offset, int len) throws EOFException, FormatException {
        while (len > 0) {
            int i;
            int intsleft = this.bytesinbuffer / 4;
            if (intsleft == 0) {
                this.assertSize(4);
                continue;
            }
            int reallyread = len < intsleft ? len : intsleft;
            int cursor = this.curptr;
            if (this.MSBFirst) {
                for (i = 0; i < reallyread; ++i) {
                    vec[offset++] = MoreMath.BuildIntegerBE(this.buffer, cursor);
                    cursor += 4;
                }
            } else {
                for (i = 0; i < reallyread; ++i) {
                    vec[offset++] = MoreMath.BuildIntegerLE(this.buffer, cursor);
                    cursor += 4;
                }
            }
            len -= reallyread;
            this.bytesinbuffer -= 4 * reallyread;
            this.curptr = cursor;
        }
    }

    public void readFloatArray(float[] vec, int offset, int len) throws EOFException, FormatException {
        while (len > 0) {
            int floatasint;
            int i;
            int floatsleft = this.bytesinbuffer / 4;
            if (floatsleft == 0) {
                this.assertSize(4);
                continue;
            }
            int reallyread = len < floatsleft ? len : floatsleft;
            int cursor = this.curptr;
            if (this.MSBFirst) {
                for (i = 0; i < reallyread; ++i) {
                    floatasint = MoreMath.BuildIntegerBE(this.buffer, cursor);
                    vec[offset++] = Float.intBitsToFloat(floatasint);
                    cursor += 4;
                }
            } else {
                for (i = 0; i < reallyread; ++i) {
                    floatasint = MoreMath.BuildIntegerLE(this.buffer, cursor);
                    vec[offset++] = Float.intBitsToFloat(floatasint);
                    cursor += 4;
                }
            }
            len -= reallyread;
            this.bytesinbuffer -= 4 * reallyread;
            this.curptr = cursor;
        }
    }

    public long readLong() throws EOFException, FormatException {
        this.assertSize(8);
        this.curptr += 8;
        this.bytesinbuffer -= 8;
        return MoreMath.BuildLong(this.buffer, this.curptr - 8, this.MSBFirst);
    }

    public String readFixedLengthString(int length) throws EOFException, FormatException {
        String retstring;
        if (length < this.buffer.length) {
            this.assertSize(length);
            retstring = new String(this.buffer, this.curptr, length);
            this.curptr += length;
            this.bytesinbuffer -= length;
        } else {
            byte[] foo = this.readBytes(length, false);
            retstring = new String(foo, 0, length);
        }
        return retstring;
    }
}

