/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.image;

import com.bbn.openmap.image.AbstractImageFormatter;
import com.bbn.openmap.image.ImageFormatter;
import com.bbn.openmap.image.JPEGHelper;
import com.bbn.openmap.util.Debug;
import com.bbn.openmap.util.PropUtils;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.Properties;

public class SunJPEGFormatter
extends AbstractImageFormatter {
    public static final String QualityProperty = "imagequality";
    protected float imageQuality = 0.8f;

    public void setProperties(String prefix, Properties props) {
        this.imageQuality = PropUtils.floatFromProperties(props, (prefix == null ? "" : prefix) + QualityProperty, this.imageQuality);
        if (Debug.debugging("image")) {
            Debug.output("SunJPEGFormatter setting image quality to: " + this.imageQuality);
        }
    }

    public ImageFormatter makeClone() {
        SunJPEGFormatter formatter = new SunJPEGFormatter();
        formatter.setImageQuality(this.getImageQuality());
        return formatter;
    }

    public float getImageQuality() {
        return this.imageQuality;
    }

    public void setImageQuality(float quality) {
        this.imageQuality = quality;
    }

    public byte[] formatImage(BufferedImage bi) {
        try {
            return JPEGHelper.encodeJPEG(bi, this.imageQuality);
        }
        catch (IOException ioe) {
            Debug.error("SunJPEGFormatter caught IOException formatting image!");
            return new byte[0];
        }
    }

    public String getFormatLabel() {
        return "JPEG";
    }

    public String getContentType() {
        return "image/jpeg";
    }
}

