/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.image;

import com.bbn.openmap.Layer;
import com.bbn.openmap.MapBean;
import com.bbn.openmap.PropertyConsumer;
import com.bbn.openmap.image.ImageFormatter;
import com.bbn.openmap.image.SunJPEGFormatter;
import com.bbn.openmap.plugin.PlugIn;
import com.bbn.openmap.plugin.PlugInLayer;
import com.bbn.openmap.proj.Mercator;
import com.bbn.openmap.proj.Proj;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.proj.ProjectionFactory;
import com.bbn.openmap.util.ArgParser;
import com.bbn.openmap.util.ComponentFactory;
import com.bbn.openmap.util.Debug;
import com.bbn.openmap.util.PropUtils;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import java.util.Vector;

public class ImageServer
implements PropertyConsumer {
    protected ImageFormatter formatter;
    protected Hashtable imageFormatters;
    protected Layer[] layers;
    public static final String ImageServerLayersProperty = "layers";
    public static final String OpenMapPrefix = "openmap.";
    public static final String ImageFormattersProperty = "formatters";
    public static final String AntiAliasingProperty = "antialiasing";
    public static final String BackgroundProperty = "background";
    protected boolean doAntiAliasing = false;
    protected String propertiesPrefix = null;
    protected Paint background;

    protected ImageServer() {
    }

    public ImageServer(Properties props) {
        this.setProperties(props);
    }

    public ImageServer(String prefix, Properties props) {
        this(prefix, props, null);
    }

    public ImageServer(String prefix, Properties props, Hashtable instantiatedLayers) {
        this.setProperties(prefix, props, instantiatedLayers);
    }

    public ImageServer(Layer[] layers, ImageFormatter formatter) {
        this.layers = layers;
        this.formatter = formatter;
    }

    public void setDoAntiAliasing(boolean set) {
        this.doAntiAliasing = set;
    }

    public boolean getDoAntiAliasing() {
        return this.doAntiAliasing;
    }

    public synchronized void setLayers(Layer[] newLayers) {
        this.layers = newLayers == null ? new Layer[0] : newLayers;
    }

    public synchronized Layer[] getLayers() {
        return this.layers;
    }

    public byte[] createImage(Projection proj) {
        return this.createImage(proj, -1, -1, -1);
    }

    public byte[] createImage(Projection proj, int scaledWidth, int scaledHeight) {
        return this.createImage(proj, scaledWidth, scaledHeight, -1);
    }

    public byte[] createImage(Projection proj, int scaledWidth, int scaledHeight, List showLayers) {
        return this.createImage(proj, scaledWidth, scaledHeight, showLayers, this.getBackground());
    }

    public byte[] createImage(Projection proj, int scaledWidth, int scaledHeight, List showLayers, Paint background) {
        Debug.message("imageserver", "ImageServer: using the new ProjectionPainter interface!  createImage with layer string array. ");
        if (this.formatter == null) {
            Debug.error("ImageServer.createImage: no formatter set! Can't create image.");
            return new byte[0];
        }
        ImageFormatter imageFormatter = this.formatter.makeClone();
        Graphics graphics = this.createGraphics(imageFormatter, proj.getWidth(), proj.getHeight());
        if (graphics == null) {
            return new byte[0];
        }
        ((Proj)proj).drawBackground((Graphics2D)graphics, background);
        int size = showLayers.size();
        if (showLayers != null) {
            for (int j = size - 1; j >= 0; --j) {
                for (int i = this.layers.length - 1; i >= 0; --i) {
                    Layer layer;
                    String layerName = (String)showLayers.get(j);
                    if (!layerName.equals((layer = this.layers[i]).getPropertyPrefix())) continue;
                    layer.renderDataForProjection(proj, graphics);
                    if (!Debug.debugging("imageserver")) continue;
                    Debug.output("ImageServer: image request adding layer graphics from : " + layer.getName());
                }
            }
        } else if (Debug.debugging("imageserver")) {
            Debug.output("ImageServer: no layers available for image");
        }
        byte[] formattedImage = this.getFormattedImage(imageFormatter, scaledWidth, scaledHeight);
        graphics.dispose();
        return formattedImage;
    }

    public int calculateVisibleLayerMask() {
        int ret = 0;
        for (int i = this.layers.length - 1; i >= 0; --i) {
            if (!this.layers[i].isVisible()) continue;
            ret |= 1 << i;
        }
        return ret;
    }

    public byte[] createImage(Projection proj, int scaledWidth, int scaledHeight, int includedLayerMask) {
        return this.createImage(proj, scaledWidth, scaledHeight, includedLayerMask, this.getBackground());
    }

    public byte[] createImage(Projection proj, int scaledWidth, int scaledHeight, int includedLayerMask, Paint background) {
        Debug.message("imageserver", "ImageServer: using the new ProjectionPainter interface!  createImage with layer mask.");
        if (this.formatter == null) {
            Debug.error("ImageServer.createImage: no formatter set! Can't create image.");
            return new byte[0];
        }
        ImageFormatter imageFormatter = this.formatter.makeClone();
        Graphics graphics = this.createGraphics(imageFormatter, proj.getWidth(), proj.getHeight());
        if (graphics == null) {
            return new byte[0];
        }
        ((Proj)proj).drawBackground((Graphics2D)graphics, background);
        if (Debug.debugging("imageserver")) {
            Debug.output("ImageServer: considering " + this.layers.length + " for image...");
        }
        if (this.layers != null) {
            for (int i = this.layers.length - 1; i >= 0; --i) {
                if ((includedLayerMask & 1 << i) != 0) {
                    if (Debug.debugging("imageserver")) {
                        Debug.output("ImageServer: image request adding layer graphics from : " + this.layers[i].getName());
                    }
                    this.layers[i].renderDataForProjection(proj, graphics);
                    continue;
                }
                if (!Debug.debugging("imageserver")) continue;
                Debug.output("ImageServer: skipping layer graphics from : " + this.layers[i].getName());
            }
        } else if (Debug.debugging("imageserver")) {
            Debug.output("ImageServer: no layers available");
        }
        byte[] formattedImage = this.getFormattedImage(imageFormatter, scaledWidth, scaledHeight);
        graphics.dispose();
        return formattedImage;
    }

    protected Graphics createGraphics(ImageFormatter formatter, int width, int height) {
        Graphics graphics = null;
        if (formatter == null) {
            Debug.error("ImageServer.createGraphics: Formatter is null, returning null graphics.");
            return null;
        }
        graphics = formatter.getGraphics(width, height);
        if (graphics == null) {
            Debug.error("ImageServer.createGraphics: NOT able to create Graphics!");
            return null;
        }
        if (Debug.debugging("imageserver")) {
            Debug.output("ImageServer.createGraphics: graphics is cool");
        }
        if (this.doAntiAliasing && graphics instanceof Graphics2D) {
            Graphics2D g2d = (Graphics2D)graphics;
            g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        return graphics;
    }

    protected byte[] getFormattedImage(ImageFormatter formatter, int scaledWidth, int scaledHeight) {
        if (Debug.debugging("imageserver")) {
            Debug.output("ImageServer: ready to create formatted image.");
        }
        byte[] formattedImage = null;
        if (scaledWidth > 0 && scaledHeight > 0) {
            formattedImage = formatter.getScaledImageBytes(scaledWidth, scaledHeight);
        } else {
            Debug.message("imageserver", "ImageServer: using full scale image (unscaled).");
            formattedImage = formatter.getImageBytes();
        }
        return formattedImage;
    }

    public void setProperties(Properties props) {
        this.setProperties(null, props);
    }

    public void setProperties(String prefix, Properties props) {
        this.setProperties(prefix, props, null);
    }

    public void setProperties(String prefix, Properties props, Hashtable instantiatedLayers) {
        this.setPropertyPrefix(prefix);
        prefix = PropUtils.getScopedPropertyPrefix(prefix);
        this.layers = this.getLayers(props, instantiatedLayers);
        this.formatter = this.getFormatters(props);
        this.doAntiAliasing = PropUtils.booleanFromProperties(props, prefix + AntiAliasingProperty, false);
        this.background = this.getBackground(props, prefix + BackgroundProperty);
    }

    public Paint getBackground(Properties props, String propertyKey) {
        String paintString = props.getProperty(propertyKey);
        if (paintString == null) {
            paintString = props.getProperty("openmap.BackgroundColor");
        }
        Color ret = null;
        if (paintString != null) {
            try {
                ret = PropUtils.parseColor(paintString);
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
        }
        if (ret == null) {
            ret = Color.white;
        }
        return ret;
    }

    public Properties getProperties(Properties props) {
        if (props == null) {
            props = new Properties();
        }
        return props;
    }

    public Properties getPropertyInfo(Properties list) {
        if (list == null) {
            list = new Properties();
        }
        list.put(ImageServerLayersProperty, "A list of marker names (space-separated) for layer definitions");
        list.put(ImageFormattersProperty, "A list of marker names (space-separated) for ImageFormatter definitions");
        list.put(AntiAliasingProperty, "Whether to use anti-aliasing for the image");
        return list;
    }

    public void setPropertyPrefix(String prefix) {
        this.propertiesPrefix = prefix;
    }

    public String getPropertyPrefix() {
        return this.propertiesPrefix;
    }

    protected synchronized Layer[] getMaskedLayers(int layerMask) {
        if (layerMask == -1 || this.layers == null) {
            Debug.message("imageserver", this.layers != null ? "ImageServer: image request adding all layers." : "ImageServer.getMaskedLayers() null layers");
            return this.layers;
        }
        Vector<Layer> layerVector = new Vector<Layer>(this.layers.length);
        for (int i = 0; i < this.layers.length; ++i) {
            if ((layerMask & 1 << i) == 0) continue;
            layerVector.add(this.layers[i]);
            if (!Debug.debugging("imageserver")) continue;
            Debug.output("ImageServer: image request adding layer: " + this.layers[i].getName());
        }
        Layer[] imageLayers = new Layer[layerVector.size()];
        return layerVector.toArray(imageLayers);
    }

    public synchronized ImageFormatter getFormatter() {
        return this.formatter;
    }

    public synchronized void setFormatter(ImageFormatter f) {
        this.formatter = f;
    }

    public synchronized boolean setFormatter(String formatterLabel) {
        ImageFormatter tmpFormatter = (ImageFormatter)this.imageFormatters.get(formatterLabel.intern());
        if (tmpFormatter != null) {
            this.setFormatter(tmpFormatter);
            return true;
        }
        return false;
    }

    public synchronized Hashtable getFormatters() {
        return this.imageFormatters;
    }

    public synchronized void setFormatters(Hashtable iFormatters, String defaultFormatterKey) {
        this.imageFormatters = iFormatters;
        this.formatter = (ImageFormatter)this.imageFormatters.get(defaultFormatterKey.intern());
    }

    protected ImageFormatter getFormatters(Properties p) {
        ImageFormatter iFormatter = null;
        String prefix = PropUtils.getScopedPropertyPrefix(this);
        String formattersString = p.getProperty(prefix + ImageFormattersProperty);
        if (formattersString != null) {
            Vector markerNames = PropUtils.parseSpacedMarkers(formattersString);
            Vector formatters = ComponentFactory.create(markerNames, p);
            int size = formatters.size();
            if (this.imageFormatters == null) {
                this.imageFormatters = new Hashtable(size);
            }
            for (int i = 0; i < size; ++i) {
                ImageFormatter formatter = (ImageFormatter)formatters.get(i);
                this.imageFormatters.put(formatter.getFormatLabel(), formatter);
                if (i != 0) continue;
                iFormatter = formatter;
            }
        } else {
            Debug.message("imageserver", "ImageServer.getFormatters: no formatters specified");
        }
        return iFormatter;
    }

    protected Layer[] getLayers(Properties p) {
        return this.getLayers(p, null);
    }

    protected Layer[] getLayers(Properties p, Hashtable instantiatedLayers) {
        String prefix = PropUtils.getScopedPropertyPrefix(this);
        String layersValue = p.getProperty(prefix + ImageServerLayersProperty);
        if (layersValue == null && (layersValue = p.getProperty("openmap.layers")) == null) {
            Debug.error("ImageServer: No property \"layers\" found in ImageServer properties.");
            return new Layer[0];
        }
        Vector layerNames = PropUtils.parseSpacedMarkers(layersValue);
        if (Debug.debugging("imageserver")) {
            Debug.output("OpenMap.getLayers(): " + layerNames);
        }
        int nLayerNames = layerNames.size();
        Vector<Layer> layers = new Vector<Layer>(nLayerNames);
        for (int i = 0; i < nLayerNames; ++i) {
            Layer iLayer;
            String layerName = (String)layerNames.elementAt(i);
            if (instantiatedLayers != null && (iLayer = (Layer)instantiatedLayers.get(layerName)) != null) {
                layers.add(iLayer);
                if (!Debug.debugging("imageserver")) continue;
                Debug.output("ImageServer: adding instantiated layer /" + layerName + "/");
                continue;
            }
            String classProperty = layerName + ".class";
            String className = p.getProperty(classProperty);
            if (className == null) {
                Debug.error("Failed to locate property \"" + classProperty + "\"");
                Debug.error("Skipping layer \"" + layerName + "\"");
                continue;
            }
            Object obj = ComponentFactory.create(className, layerName, p);
            if (!(obj instanceof Layer) && !(obj instanceof PlugIn)) continue;
            Layer l = null;
            if (obj instanceof PlugIn) {
                PlugIn pi = (PlugIn)obj;
                PlugInLayer pil = new PlugInLayer();
                pil.setPlugIn(pi);
                pil.setName(p.getProperty(PropUtils.getScopedPropertyPrefix(pi) + "prettyName"));
                l = pil;
            } else {
                l = (Layer)obj;
            }
            layers.addElement(l);
            if (instantiatedLayers == null) continue;
            instantiatedLayers.put(layerName, l);
            if (!Debug.debugging("imageserver")) continue;
            Debug.output("ImageServer: Saving /" + layerName + "/ to instantiated layers hashtable.");
        }
        int nLayers = layers.size();
        if (nLayers == 0) {
            return new Layer[0];
        }
        Object[] value = new Layer[nLayers];
        layers.copyInto(value);
        return value;
    }

    public static String createImageFile(String prefix, Properties props, Projection proj, String outputPath) throws MalformedURLException, IOException {
        String appendix = "";
        ImageServer is = new ImageServer(props);
        ImageFormatter formatter = is.getFormatter();
        if (formatter == null) {
            is.setFormatter(new SunJPEGFormatter());
            appendix = ".jpg";
        } else {
            String fileType = formatter.getFormatLabel();
            appendix = fileType.equals("JPEG") ? ".jpg" : "." + fileType.toLowerCase();
        }
        Color background = MapBean.DEFAULT_BACKGROUND_COLOR;
        background = (Color)PropUtils.parseColorFromProperties(props, "openmap.BackgroundColor", background);
        is.setBackground(background);
        if (proj == null) {
            String projName = props.getProperty("openmap.Projection");
            Class projClass = ProjectionFactory.getProjClassForName(projName);
            if (projClass == null) {
                projClass = Mercator.class;
            }
            proj = ProjectionFactory.makeProjection(projClass, PropUtils.floatFromProperties(props, "openmap.Latitude", 0.0f), PropUtils.floatFromProperties(props, "openmap.Longitude", 0.0f), PropUtils.floatFromProperties(props, "openmap.Scale", Float.MAX_VALUE), PropUtils.intFromProperties(props, "openmap.Width", 640), PropUtils.intFromProperties(props, "openmap.Height", 480));
        }
        if (Debug.debugging("imageserver")) {
            Debug.output("ImageServer: creating image with projection " + proj);
        }
        byte[] imageBytes = is.createImage(proj);
        String finalOutputPath = outputPath + appendix;
        FileOutputStream fos = new FileOutputStream(finalOutputPath);
        fos.write(imageBytes);
        fos.flush();
        fos.close();
        return finalOutputPath;
    }

    public void setBackground(Paint bg) {
        this.background = bg;
    }

    public Paint getBackground() {
        return this.background;
    }

    public static void main(String[] argv) {
        Debug.init();
        Debug.put("imageserver");
        Debug.put("image");
        ArgParser ap = new ArgParser("ImageServer");
        ap.add("properties", "The properties file to use for the image.", 1);
        ap.add("file", "The output image file, without appendix (default is 'image').", 1);
        if (!ap.parse(argv)) {
            ap.printUsage();
            System.exit(0);
        }
        String imagefile = "image";
        String[] arg = ap.getArgValues("file");
        if (arg != null) {
            imagefile = arg[0];
        }
        Properties props = null;
        arg = ap.getArgValues("properties");
        if (arg != null) {
            String ps = arg[0];
            try {
                ProjectionFactory.loadDefaultProjections();
                URL url = PropUtils.getResourceOrFileOrURL(null, ps);
                InputStream inputStream = url.openStream();
                props = new Properties();
                props.load(inputStream);
                Projection proj = null;
                String finalOutputPath = ImageServer.createImageFile(null, props, proj, imagefile);
                if (Debug.debugging("imageserver")) {
                    Debug.output("Writing image file to: " + finalOutputPath);
                }
            }
            catch (MalformedURLException murle) {
                Debug.error("ImageServer can't find properties file: " + arg[0]);
            }
            catch (IOException ioe) {
                Debug.error("ImageServer can't write output image: IOException");
            }
        }
        System.exit(0);
    }
}

