/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.gui.time;

import com.bbn.openmap.gui.OMComponentPanel;
import com.bbn.openmap.gui.time.RealTimeHandler;
import com.bbn.openmap.gui.time.TimeConstants;
import com.bbn.openmap.util.Debug;
import com.bbn.openmap.util.PropUtils;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JToolBar;

public class TimerControlButtonPanel
extends OMComponentPanel
implements PropertyChangeListener,
ActionListener,
TimeConstants {
    protected ImageIcon backwardStepIcon;
    protected ImageIcon backwardIcon;
    protected ImageIcon forwardIcon;
    protected ImageIcon forwardStepIcon;
    protected ImageIcon pauseIcon;
    protected String DefaultBackwardStepIconURL = "stepbackward.png";
    protected String DefaultBackwardIconURL = "playbackward.png";
    protected String DefaultForwardIconURL = "playforward.png";
    protected String DefaultForwardStepIconURL = "stepforward.png";
    protected String DefaultPauseIconURL = "pause.png";
    protected String backwardStepIconURL = this.DefaultBackwardStepIconURL;
    protected String backwardIconURL = this.DefaultBackwardIconURL;
    protected String forwardIconURL = this.DefaultForwardIconURL;
    protected String forwardStepIconURL = this.DefaultForwardStepIconURL;
    protected String pauseIconURL = this.DefaultPauseIconURL;
    protected RealTimeHandler timeHandler;
    protected JButton forwardButton;
    protected JButton backwardButton;
    public static final String BackwardStepIconProperty = "backwardStepIcon";
    public static final String BackwardIconProperty = "backwardIcon";
    public static final String ForwardStepIconProperty = "forwardStepIcon";
    public static final String ForwardIconProperty = "forwardIcon";
    public static final String PauseIconProperty = "pauseIcon";

    public TimerControlButtonPanel(RealTimeHandler rth) {
        this.setTimeHandler(rth);
        this.initGUI();
    }

    public void setTimeHandler(RealTimeHandler rth) {
        this.timeHandler = rth;
    }

    public RealTimeHandler getTimeHandler() {
        return this.timeHandler;
    }

    public void initGUI() {
        this.removeAll();
        try {
            URL url = PropUtils.getResourceOrFileOrURL(this, this.forwardIconURL);
            this.forwardIcon = new ImageIcon(url);
            url = PropUtils.getResourceOrFileOrURL(this, this.forwardStepIconURL);
            this.forwardStepIcon = new ImageIcon(url);
            url = PropUtils.getResourceOrFileOrURL(this, this.backwardIconURL);
            this.backwardIcon = new ImageIcon(url);
            url = PropUtils.getResourceOrFileOrURL(this, this.backwardStepIconURL);
            this.backwardStepIcon = new ImageIcon(url);
            url = PropUtils.getResourceOrFileOrURL(this, this.pauseIconURL);
            this.pauseIcon = new ImageIcon(url);
        }
        catch (MalformedURLException murle) {
            Debug.error("TimerToggleButton: initGUI() bad icon.");
        }
        catch (NullPointerException npe) {
            Debug.error("TimerToggleButton: initGUI() bad icon.");
            npe.printStackTrace();
        }
        JToolBar jtb = new JToolBar();
        jtb.setFloatable(false);
        this.backwardButton = new JButton(this.backwardIcon);
        this.backwardButton.setToolTipText("Run Timer Backwards");
        this.backwardButton.setActionCommand("TIMER_BACKWARD");
        this.backwardButton.addActionListener(this);
        jtb.add(this.backwardButton);
        JButton button = new JButton(this.backwardStepIcon);
        button.setToolTipText("Step Timer Backward");
        button.setActionCommand("TIMER_STEP_BACKWARD");
        button.addActionListener(this);
        jtb.add(button);
        button = new JButton(this.forwardStepIcon);
        button.setToolTipText("Step Timer Forward");
        button.setActionCommand("TIMER_STEP_FORWARD");
        button.addActionListener(this);
        jtb.add(button);
        this.forwardButton = new JButton(this.forwardIcon);
        this.forwardButton.setToolTipText("Run Timer Forward");
        this.forwardButton.setActionCommand("TIMER_FORWARD");
        this.forwardButton.addActionListener(this);
        jtb.add(this.forwardButton);
        this.add(jtb);
    }

    public void propertyChange(PropertyChangeEvent pce) {
        String propName = pce.getPropertyName();
        Object obj = pce.getNewValue();
        if (propName == "TIMER_RUNNING_STATUS" && obj instanceof String) {
            this.update((String)obj);
        }
    }

    protected void update(String newStatus) {
        if (newStatus == "TIMER_FORWARD") {
            if (Debug.debugging("timedetail")) {
                Debug.output("TimerControlButtonPanel: TIMER_FORWARD");
            }
            this.backwardButton.setIcon(this.backwardIcon);
            this.backwardButton.setActionCommand("TIMER_BACKWARD");
            this.forwardButton.setIcon(this.pauseIcon);
            this.forwardButton.setActionCommand("TIMER_STOPPED");
        } else if (newStatus == "TIMER_BACKWARD") {
            if (Debug.debugging("timedetail")) {
                Debug.output("TimerControlButtonPanel: TIMER_BACKWARD");
            }
            this.forwardButton.setIcon(this.forwardIcon);
            this.forwardButton.setActionCommand("TIMER_FORWARD");
            this.backwardButton.setIcon(this.pauseIcon);
            this.backwardButton.setActionCommand("TIMER_STOPPED");
        } else if (newStatus == "TIMER_STOPPED") {
            if (Debug.debugging("timedetail")) {
                Debug.output("TimerControlButtonPanel: TIMER_STOPPED");
            }
            this.forwardButton.setIcon(this.forwardIcon);
            this.forwardButton.setActionCommand("TIMER_FORWARD");
            this.backwardButton.setIcon(this.backwardIcon);
            this.backwardButton.setActionCommand("TIMER_BACKWARD");
        }
    }

    public void actionPerformed(ActionEvent ae) {
        String cmd = ae.getActionCommand();
        if (cmd == "TIMER_FORWARD") {
            this.timeHandler.setClockDirection(1);
            this.timeHandler.startClock();
        } else if (cmd == "TIMER_BACKWARD") {
            this.timeHandler.setClockDirection(-1);
            this.timeHandler.startClock();
        } else if (cmd == "TIMER_STEP_BACKWARD") {
            this.timeHandler.stepBackward();
        } else if (cmd == "TIMER_STEP_FORWARD") {
            this.timeHandler.stepForward();
        } else if (cmd == "TIMER_STOPPED") {
            this.timeHandler.stopClock();
        }
    }
}

